<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Destination StructType
 * @subpackage Structs
 */
class Destination extends AbstractStructBase
{
    /**
     * The code
     * @var string
     */
    public $code;
    /**
     * The name
     * @var string
     */
    public $name;
    /**
     * The regions
     * @var string
     */
    public $regions;
    /**
     * Constructor method for Destination
     * @uses Destination::setCode()
     * @uses Destination::setName()
     * @uses Destination::setRegions()
     * @param string $code
     * @param string $name
     * @param string $regions
     */
    public function __construct($code = null, $name = null, $regions = null)
    {
        $this
            ->setCode($code)
            ->setName($name)
            ->setRegions($regions);
    }
    /**
     * Get code value
     * @return string|null
     */
    public function getCode()
    {
        return $this->code;
    }
    /**
     * Set code value
     * @param string $code
     * @return \StructType\Destination
     */
    public function setCode($code = null)
    {
        // validation for constraint: string
        if (!is_null($code) && !is_string($code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($code, true), gettype($code)), __LINE__);
        }
        $this->code = $code;
        return $this;
    }
    /**
     * Get name value
     * @return string|null
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \StructType\Destination
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get regions value
     * @return string|null
     */
    public function getRegions()
    {
        return $this->regions;
    }
    /**
     * Set regions value
     * @param string $regions
     * @return \StructType\Destination
     */
    public function setRegions($regions = null)
    {
        // validation for constraint: string
        if (!is_null($regions) && !is_string($regions)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($regions, true), gettype($regions)), __LINE__);
        }
        $this->regions = $regions;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Destination
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
