<?php
/**
 * This file aims to show you how to use this generated package.
 * In addition, the goal is to show which methods are available and the fist needed parameter(s)
 * You have to use an associative array such as:
 * - the key must be a constant beginning with WSDL_ from AbstractSoapClientbase class each generated ServiceType class extends this class
 * - the value must be the corresponding key value (each option matches a {@link http://www.php.net/manual/en/soapclient.soapclient.php} option)
 * $options = array(
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'http://vzr.paritet-sk.com:7444/Test-Web/hs/InsuranceService?wsdl',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_TRACE => true,
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_LOGIN => 'you_secret_login',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_PASSWORD => 'you_secret_password',
 * );
 * etc....
 */
require_once __DIR__ . '/vendor/autoload.php';
/**
 * Minimal options
 */
$options = array(
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'http://vzr.paritet-sk.com:7444/Test-Web/hs/InsuranceService?wsdl',
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_CLASSMAP => ClassMap::get(),
);
/**
 * Samples for Cancel ServiceType
 */
$cancel = new \ServiceType\Cancel($options);
/**
 * Sample call for cancelPolicy operation/method
 */
if ($cancel->cancelPolicy(new \StructType\CancelPolicy()) !== false) {
    print_r($cancel->getResult());
} else {
    print_r($cancel->getLastError());
}
/**
 * Samples for Send ServiceType
 */
$send = new \ServiceType\Send($options);
/**
 * Sample call for sendPolicyAgreement operation/method
 */
if ($send->sendPolicyAgreement(new \StructType\SendPolicyAgreement()) !== false) {
    print_r($send->getResult());
} else {
    print_r($send->getLastError());
}
/**
 * Samples for Get ServiceType
 */
$get = new \ServiceType\Get($options);
/**
 * Sample call for getPolicyInfo operation/method
 */
if ($get->getPolicyInfo(new \StructType\GetPolicyInfo()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getSuitableProductsOffer operation/method
 */
if ($get->getSuitableProductsOffer(new \StructType\GetSuitableProductsOffer()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getCheapestProduct operation/method
 */
if ($get->getCheapestProduct(new \StructType\GetCheapestProduct()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getPolicyAgreement operation/method
 */
if ($get->getPolicyAgreement(new \StructType\GetPolicyAgreement()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getCompleteProductsOffer operation/method
 */
if ($get->getCompleteProductsOffer(new \StructType\GetCompleteProductsOffer()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getSupplementariesOffer operation/method
 */
if ($get->getSupplementariesOffer(new \StructType\GetSupplementariesOffer()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getPolicyList operation/method
 */
if ($get->getPolicyList(new \StructType\GetPolicyList()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getProductsOffer operation/method
 */
if ($get->getProductsOffer(new \StructType\GetProductsOffer()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getProducts operation/method
 */
if ($get->getProducts(new \StructType\GetProducts()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getRegions operation/method
 */
if ($get->getRegions(new \StructType\GetRegions()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Samples for Create ServiceType
 */
$create = new \ServiceType\Create($options);
/**
 * Sample call for createPolicy operation/method
 */
if ($create->createPolicy(new \StructType\CreatePolicy()) !== false) {
    print_r($create->getResult());
} else {
    print_r($create->getLastError());
}
/**
 * Samples for Calculate ServiceType
 */
$calculate = new \ServiceType\Calculate($options);
/**
 * Sample call for calculatePolicyPremium operation/method
 */
if ($calculate->calculatePolicyPremium(new \StructType\CalculatePolicyPremium()) !== false) {
    print_r($calculate->getResult());
} else {
    print_r($calculate->getLastError());
}
/**
 * Samples for User ServiceType
 */
$user = new \ServiceType\User($options);
/**
 * Sample call for userLogin operation/method
 */
if ($user->userLogin(new \StructType\UserLogin()) !== false) {
    print_r($user->getResult());
} else {
    print_r($user->getLastError());
}
/**
 * Samples for Activate ServiceType
 */
$activate = new \ServiceType\Activate($options);
/**
 * Sample call for activatePolicy operation/method
 */
if ($activate->activatePolicy(new \StructType\ActivatePolicy()) !== false) {
    print_r($activate->getResult());
} else {
    print_r($activate->getLastError());
}
