<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for sendPolicyAgreement StructType
 * Meta information extracted from the WSDL
 * - type: tns:sendPolicyAgreement
 * @subpackage Structs
 */
class SendPolicyAgreement extends AbstractStructBase
{
    /**
     * The uniqueId
     * @var string
     */
    public $uniqueId;
    /**
     * The policyNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $policyNumber;
    /**
     * The policyRecId
     * @var string
     */
    public $policyRecId;
    /**
     * The language
     * @var string
     */
    public $language;
    /**
     * The specTemplateCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $specTemplateCode;
    /**
     * The emailAddress
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var string[]
     */
    public $emailAddress;
    /**
     * The electronicSignature
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $electronicSignature;
    /**
     * Constructor method for sendPolicyAgreement
     * @uses SendPolicyAgreement::setUniqueId()
     * @uses SendPolicyAgreement::setPolicyNumber()
     * @uses SendPolicyAgreement::setPolicyRecId()
     * @uses SendPolicyAgreement::setLanguage()
     * @uses SendPolicyAgreement::setSpecTemplateCode()
     * @uses SendPolicyAgreement::setEmailAddress()
     * @uses SendPolicyAgreement::setElectronicSignature()
     * @param string $uniqueId
     * @param int $policyNumber
     * @param string $policyRecId
     * @param string $language
     * @param string $specTemplateCode
     * @param string[] $emailAddress
     * @param bool $electronicSignature
     */
    public function __construct($uniqueId = null, $policyNumber = null, $policyRecId = null, $language = null, $specTemplateCode = null, array $emailAddress = array(), $electronicSignature = null)
    {
        $this
            ->setUniqueId($uniqueId)
            ->setPolicyNumber($policyNumber)
            ->setPolicyRecId($policyRecId)
            ->setLanguage($language)
            ->setSpecTemplateCode($specTemplateCode)
            ->setEmailAddress($emailAddress)
            ->setElectronicSignature($electronicSignature);
    }
    /**
     * Get uniqueId value
     * @return string|null
     */
    public function getUniqueId()
    {
        return $this->uniqueId;
    }
    /**
     * Set uniqueId value
     * @param string $uniqueId
     * @return \StructType\SendPolicyAgreement
     */
    public function setUniqueId($uniqueId = null)
    {
        // validation for constraint: string
        if (!is_null($uniqueId) && !is_string($uniqueId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($uniqueId, true), gettype($uniqueId)), __LINE__);
        }
        $this->uniqueId = $uniqueId;
        return $this;
    }
    /**
     * Get policyNumber value
     * @return int|null
     */
    public function getPolicyNumber()
    {
        return $this->policyNumber;
    }
    /**
     * Set policyNumber value
     * @param int $policyNumber
     * @return \StructType\SendPolicyAgreement
     */
    public function setPolicyNumber($policyNumber = null)
    {
        // validation for constraint: int
        if (!is_null($policyNumber) && !(is_int($policyNumber) || ctype_digit($policyNumber))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($policyNumber, true), gettype($policyNumber)), __LINE__);
        }
        $this->policyNumber = $policyNumber;
        return $this;
    }
    /**
     * Get policyRecId value
     * @return string|null
     */
    public function getPolicyRecId()
    {
        return $this->policyRecId;
    }
    /**
     * Set policyRecId value
     * @param string $policyRecId
     * @return \StructType\SendPolicyAgreement
     */
    public function setPolicyRecId($policyRecId = null)
    {
        // validation for constraint: string
        if (!is_null($policyRecId) && !is_string($policyRecId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($policyRecId, true), gettype($policyRecId)), __LINE__);
        }
        $this->policyRecId = $policyRecId;
        return $this;
    }
    /**
     * Get language value
     * @return string|null
     */
    public function getLanguage()
    {
        return $this->language;
    }
    /**
     * Set language value
     * @param string $language
     * @return \StructType\SendPolicyAgreement
     */
    public function setLanguage($language = null)
    {
        // validation for constraint: string
        if (!is_null($language) && !is_string($language)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($language, true), gettype($language)), __LINE__);
        }
        $this->language = $language;
        return $this;
    }
    /**
     * Get specTemplateCode value
     * @return string|null
     */
    public function getSpecTemplateCode()
    {
        return $this->specTemplateCode;
    }
    /**
     * Set specTemplateCode value
     * @param string $specTemplateCode
     * @return \StructType\SendPolicyAgreement
     */
    public function setSpecTemplateCode($specTemplateCode = null)
    {
        // validation for constraint: string
        if (!is_null($specTemplateCode) && !is_string($specTemplateCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($specTemplateCode, true), gettype($specTemplateCode)), __LINE__);
        }
        $this->specTemplateCode = $specTemplateCode;
        return $this;
    }
    /**
     * Get emailAddress value
     * @return string[]|null
     */
    public function getEmailAddress()
    {
        return $this->emailAddress;
    }
    /**
     * This method is responsible for validating the values passed to the setEmailAddress method
     * This method is willingly generated in order to preserve the one-line inline validation within the setEmailAddress method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateEmailAddressForArrayConstraintsFromSetEmailAddress(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $sendPolicyAgreementEmailAddressItem) {
            // validation for constraint: itemType
            if (!is_string($sendPolicyAgreementEmailAddressItem)) {
                $invalidValues[] = is_object($sendPolicyAgreementEmailAddressItem) ? get_class($sendPolicyAgreementEmailAddressItem) : sprintf('%s(%s)', gettype($sendPolicyAgreementEmailAddressItem), var_export($sendPolicyAgreementEmailAddressItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The emailAddress property can only contain items of type string, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set emailAddress value
     * @throws \InvalidArgumentException
     * @param string[] $emailAddress
     * @return \StructType\SendPolicyAgreement
     */
    public function setEmailAddress(array $emailAddress = array())
    {
        // validation for constraint: array
        if ('' !== ($emailAddressArrayErrorMessage = self::validateEmailAddressForArrayConstraintsFromSetEmailAddress($emailAddress))) {
            throw new \InvalidArgumentException($emailAddressArrayErrorMessage, __LINE__);
        }
        $this->emailAddress = $emailAddress;
        return $this;
    }
    /**
     * Add item to emailAddress value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \StructType\SendPolicyAgreement
     */
    public function addToEmailAddress($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The emailAddress property can only contain items of type string, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->emailAddress[] = $item;
        return $this;
    }
    /**
     * Get electronicSignature value
     * @return bool|null
     */
    public function getElectronicSignature()
    {
        return $this->electronicSignature;
    }
    /**
     * Set electronicSignature value
     * @param bool $electronicSignature
     * @return \StructType\SendPolicyAgreement
     */
    public function setElectronicSignature($electronicSignature = null)
    {
        // validation for constraint: boolean
        if (!is_null($electronicSignature) && !is_bool($electronicSignature)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($electronicSignature, true), gettype($electronicSignature)), __LINE__);
        }
        $this->electronicSignature = $electronicSignature;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\SendPolicyAgreement
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
