<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RegionsResp StructType
 * @subpackage Structs
 */
class RegionsResp extends AbstractStructBase
{
    /**
     * The error
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RespError
     */
    public $error;
    /**
     * The region
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Region[]
     */
    public $region;
    /**
     * The destination
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Destination[]
     */
    public $destination;
    /**
     * Constructor method for RegionsResp
     * @uses RegionsResp::setError()
     * @uses RegionsResp::setRegion()
     * @uses RegionsResp::setDestination()
     * @param \StructType\RespError $error
     * @param \StructType\Region[] $region
     * @param \StructType\Destination[] $destination
     */
    public function __construct(\StructType\RespError $error = null, array $region = array(), array $destination = array())
    {
        $this
            ->setError($error)
            ->setRegion($region)
            ->setDestination($destination);
    }
    /**
     * Get error value
     * @return \StructType\RespError|null
     */
    public function getError()
    {
        return $this->error;
    }
    /**
     * Set error value
     * @param \StructType\RespError $error
     * @return \StructType\RegionsResp
     */
    public function setError(\StructType\RespError $error = null)
    {
        $this->error = $error;
        return $this;
    }
    /**
     * Get region value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Region[]|null
     */
    public function getRegion()
    {
        return isset($this->region) ? $this->region : null;
    }
    /**
     * This method is responsible for validating the values passed to the setRegion method
     * This method is willingly generated in order to preserve the one-line inline validation within the setRegion method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateRegionForArrayConstraintsFromSetRegion(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $regionsRespRegionItem) {
            // validation for constraint: itemType
            if (!$regionsRespRegionItem instanceof \StructType\Region) {
                $invalidValues[] = is_object($regionsRespRegionItem) ? get_class($regionsRespRegionItem) : sprintf('%s(%s)', gettype($regionsRespRegionItem), var_export($regionsRespRegionItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The region property can only contain items of type \StructType\Region, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set region value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\Region[] $region
     * @return \StructType\RegionsResp
     */
    public function setRegion(array $region = array())
    {
        // validation for constraint: array
        if ('' !== ($regionArrayErrorMessage = self::validateRegionForArrayConstraintsFromSetRegion($region))) {
            throw new \InvalidArgumentException($regionArrayErrorMessage, __LINE__);
        }
        if (is_null($region) || (is_array($region) && empty($region))) {
            unset($this->region);
        } else {
            $this->region = $region;
        }
        return $this;
    }
    /**
     * Add item to region value
     * @throws \InvalidArgumentException
     * @param \StructType\Region $item
     * @return \StructType\RegionsResp
     */
    public function addToRegion(\StructType\Region $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Region) {
            throw new \InvalidArgumentException(sprintf('The region property can only contain items of type \StructType\Region, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->region[] = $item;
        return $this;
    }
    /**
     * Get destination value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Destination[]|null
     */
    public function getDestination()
    {
        return isset($this->destination) ? $this->destination : null;
    }
    /**
     * This method is responsible for validating the values passed to the setDestination method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDestination method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateDestinationForArrayConstraintsFromSetDestination(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $regionsRespDestinationItem) {
            // validation for constraint: itemType
            if (!$regionsRespDestinationItem instanceof \StructType\Destination) {
                $invalidValues[] = is_object($regionsRespDestinationItem) ? get_class($regionsRespDestinationItem) : sprintf('%s(%s)', gettype($regionsRespDestinationItem), var_export($regionsRespDestinationItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The destination property can only contain items of type \StructType\Destination, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set destination value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\Destination[] $destination
     * @return \StructType\RegionsResp
     */
    public function setDestination(array $destination = array())
    {
        // validation for constraint: array
        if ('' !== ($destinationArrayErrorMessage = self::validateDestinationForArrayConstraintsFromSetDestination($destination))) {
            throw new \InvalidArgumentException($destinationArrayErrorMessage, __LINE__);
        }
        if (is_null($destination) || (is_array($destination) && empty($destination))) {
            unset($this->destination);
        } else {
            $this->destination = $destination;
        }
        return $this;
    }
    /**
     * Add item to destination value
     * @throws \InvalidArgumentException
     * @param \StructType\Destination $item
     * @return \StructType\RegionsResp
     */
    public function addToDestination(\StructType\Destination $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Destination) {
            throw new \InvalidArgumentException(sprintf('The destination property can only contain items of type \StructType\Destination, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->destination[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\RegionsResp
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
