<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ProductsOfferResp StructType
 * @subpackage Structs
 */
class ProductsOfferResp extends AbstractStructBase
{
    /**
     * The error
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RespError
     */
    public $error;
    /**
     * The products
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\ProductOffer[]
     */
    public $products;
    /**
     * Constructor method for ProductsOfferResp
     * @uses ProductsOfferResp::setError()
     * @uses ProductsOfferResp::setProducts()
     * @param \StructType\RespError $error
     * @param \StructType\ProductOffer[] $products
     */
    public function __construct(\StructType\RespError $error = null, array $products = array())
    {
        $this
            ->setError($error)
            ->setProducts($products);
    }
    /**
     * Get error value
     * @return \StructType\RespError|null
     */
    public function getError()
    {
        return $this->error;
    }
    /**
     * Set error value
     * @param \StructType\RespError $error
     * @return \StructType\ProductsOfferResp
     */
    public function setError(\StructType\RespError $error = null)
    {
        $this->error = $error;
        return $this;
    }
    /**
     * Get products value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\ProductOffer[]|null
     */
    public function getProducts()
    {
        return isset($this->products) ? $this->products : null;
    }
    /**
     * This method is responsible for validating the values passed to the setProducts method
     * This method is willingly generated in order to preserve the one-line inline validation within the setProducts method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateProductsForArrayConstraintsFromSetProducts(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $productsOfferRespProductsItem) {
            // validation for constraint: itemType
            if (!$productsOfferRespProductsItem instanceof \StructType\ProductOffer) {
                $invalidValues[] = is_object($productsOfferRespProductsItem) ? get_class($productsOfferRespProductsItem) : sprintf('%s(%s)', gettype($productsOfferRespProductsItem), var_export($productsOfferRespProductsItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The products property can only contain items of type \StructType\ProductOffer, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set products value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\ProductOffer[] $products
     * @return \StructType\ProductsOfferResp
     */
    public function setProducts(array $products = array())
    {
        // validation for constraint: array
        if ('' !== ($productsArrayErrorMessage = self::validateProductsForArrayConstraintsFromSetProducts($products))) {
            throw new \InvalidArgumentException($productsArrayErrorMessage, __LINE__);
        }
        if (is_null($products) || (is_array($products) && empty($products))) {
            unset($this->products);
        } else {
            $this->products = $products;
        }
        return $this;
    }
    /**
     * Add item to products value
     * @throws \InvalidArgumentException
     * @param \StructType\ProductOffer $item
     * @return \StructType\ProductsOfferResp
     */
    public function addToProducts(\StructType\ProductOffer $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ProductOffer) {
            throw new \InvalidArgumentException(sprintf('The products property can only contain items of type \StructType\ProductOffer, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->products[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ProductsOfferResp
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
