<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Product StructType
 * @subpackage Structs
 */
class Product extends AbstractStructBase
{
    /**
     * The code
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $code;
    /**
     * The description
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $description;
    /**
     * The duration
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $duration;
    /**
     * The name
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $name;
    /**
     * The productType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $productType;
    /**
     * The regionCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $regionCode;
    /**
     * The repeat
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $repeat;
    /**
     * The shortcut
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $shortcut;
    /**
     * The usageInfo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $usageInfo;
    /**
     * Constructor method for Product
     * @uses Product::setCode()
     * @uses Product::setDescription()
     * @uses Product::setDuration()
     * @uses Product::setName()
     * @uses Product::setProductType()
     * @uses Product::setRegionCode()
     * @uses Product::setRepeat()
     * @uses Product::setShortcut()
     * @uses Product::setUsageInfo()
     * @param string $code
     * @param string $description
     * @param string $duration
     * @param string $name
     * @param string $productType
     * @param string $regionCode
     * @param string $repeat
     * @param string $shortcut
     * @param string $usageInfo
     */
    public function __construct($code = null, $description = null, $duration = null, $name = null, $productType = null, $regionCode = null, $repeat = null, $shortcut = null, $usageInfo = null)
    {
        $this
            ->setCode($code)
            ->setDescription($description)
            ->setDuration($duration)
            ->setName($name)
            ->setProductType($productType)
            ->setRegionCode($regionCode)
            ->setRepeat($repeat)
            ->setShortcut($shortcut)
            ->setUsageInfo($usageInfo);
    }
    /**
     * Get code value
     * @return string|null
     */
    public function getCode()
    {
        return $this->code;
    }
    /**
     * Set code value
     * @param string $code
     * @return \StructType\Product
     */
    public function setCode($code = null)
    {
        // validation for constraint: string
        if (!is_null($code) && !is_string($code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($code, true), gettype($code)), __LINE__);
        }
        $this->code = $code;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return \StructType\Product
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        $this->description = $description;
        return $this;
    }
    /**
     * Get duration value
     * @return string|null
     */
    public function getDuration()
    {
        return $this->duration;
    }
    /**
     * Set duration value
     * @param string $duration
     * @return \StructType\Product
     */
    public function setDuration($duration = null)
    {
        // validation for constraint: string
        if (!is_null($duration) && !is_string($duration)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($duration, true), gettype($duration)), __LINE__);
        }
        $this->duration = $duration;
        return $this;
    }
    /**
     * Get name value
     * @return string|null
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \StructType\Product
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get productType value
     * @return string|null
     */
    public function getProductType()
    {
        return $this->productType;
    }
    /**
     * Set productType value
     * @param string $productType
     * @return \StructType\Product
     */
    public function setProductType($productType = null)
    {
        // validation for constraint: string
        if (!is_null($productType) && !is_string($productType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($productType, true), gettype($productType)), __LINE__);
        }
        $this->productType = $productType;
        return $this;
    }
    /**
     * Get regionCode value
     * @return string|null
     */
    public function getRegionCode()
    {
        return $this->regionCode;
    }
    /**
     * Set regionCode value
     * @param string $regionCode
     * @return \StructType\Product
     */
    public function setRegionCode($regionCode = null)
    {
        // validation for constraint: string
        if (!is_null($regionCode) && !is_string($regionCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($regionCode, true), gettype($regionCode)), __LINE__);
        }
        $this->regionCode = $regionCode;
        return $this;
    }
    /**
     * Get repeat value
     * @return string|null
     */
    public function getRepeat()
    {
        return $this->repeat;
    }
    /**
     * Set repeat value
     * @param string $repeat
     * @return \StructType\Product
     */
    public function setRepeat($repeat = null)
    {
        // validation for constraint: string
        if (!is_null($repeat) && !is_string($repeat)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($repeat, true), gettype($repeat)), __LINE__);
        }
        $this->repeat = $repeat;
        return $this;
    }
    /**
     * Get shortcut value
     * @return string|null
     */
    public function getShortcut()
    {
        return $this->shortcut;
    }
    /**
     * Set shortcut value
     * @param string $shortcut
     * @return \StructType\Product
     */
    public function setShortcut($shortcut = null)
    {
        // validation for constraint: string
        if (!is_null($shortcut) && !is_string($shortcut)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($shortcut, true), gettype($shortcut)), __LINE__);
        }
        $this->shortcut = $shortcut;
        return $this;
    }
    /**
     * Get usageInfo value
     * @return string|null
     */
    public function getUsageInfo()
    {
        return $this->usageInfo;
    }
    /**
     * Set usageInfo value
     * @param string $usageInfo
     * @return \StructType\Product
     */
    public function setUsageInfo($usageInfo = null)
    {
        // validation for constraint: string
        if (!is_null($usageInfo) && !is_string($usageInfo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($usageInfo, true), gettype($usageInfo)), __LINE__);
        }
        $this->usageInfo = $usageInfo;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Product
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
