<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PolicyResp StructType
 * @subpackage Structs
 */
class PolicyResp extends AbstractStructBase
{
    /**
     * The error
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RespError
     */
    public $error;
    /**
     * The currency
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $currency;
    /**
     * The policyNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $policyNumber;
    /**
     * The policyRecId
     * @var string
     */
    public $policyRecId;
    /**
     * The policyStatus
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $policyStatus;
    /**
     * The price
     * @var float
     */
    public $price;
    /**
     * The prices
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\PriceInfo
     */
    public $prices;
    /**
     * Constructor method for PolicyResp
     * @uses PolicyResp::setError()
     * @uses PolicyResp::setCurrency()
     * @uses PolicyResp::setPolicyNumber()
     * @uses PolicyResp::setPolicyRecId()
     * @uses PolicyResp::setPolicyStatus()
     * @uses PolicyResp::setPrice()
     * @uses PolicyResp::setPrices()
     * @param \StructType\RespError $error
     * @param string $currency
     * @param string $policyNumber
     * @param string $policyRecId
     * @param string $policyStatus
     * @param float $price
     * @param \StructType\PriceInfo $prices
     */
    public function __construct(\StructType\RespError $error = null, $currency = null, $policyNumber = null, $policyRecId = null, $policyStatus = null, $price = null, \StructType\PriceInfo $prices = null)
    {
        $this
            ->setError($error)
            ->setCurrency($currency)
            ->setPolicyNumber($policyNumber)
            ->setPolicyRecId($policyRecId)
            ->setPolicyStatus($policyStatus)
            ->setPrice($price)
            ->setPrices($prices);
    }
    /**
     * Get error value
     * @return \StructType\RespError|null
     */
    public function getError()
    {
        return $this->error;
    }
    /**
     * Set error value
     * @param \StructType\RespError $error
     * @return \StructType\PolicyResp
     */
    public function setError(\StructType\RespError $error = null)
    {
        $this->error = $error;
        return $this;
    }
    /**
     * Get currency value
     * @return string|null
     */
    public function getCurrency()
    {
        return $this->currency;
    }
    /**
     * Set currency value
     * @param string $currency
     * @return \StructType\PolicyResp
     */
    public function setCurrency($currency = null)
    {
        // validation for constraint: string
        if (!is_null($currency) && !is_string($currency)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($currency, true), gettype($currency)), __LINE__);
        }
        $this->currency = $currency;
        return $this;
    }
    /**
     * Get policyNumber value
     * @return string|null
     */
    public function getPolicyNumber()
    {
        return $this->policyNumber;
    }
    /**
     * Set policyNumber value
     * @param string $policyNumber
     * @return \StructType\PolicyResp
     */
    public function setPolicyNumber($policyNumber = null)
    {
        // validation for constraint: string
        if (!is_null($policyNumber) && !is_string($policyNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($policyNumber, true), gettype($policyNumber)), __LINE__);
        }
        $this->policyNumber = $policyNumber;
        return $this;
    }
    /**
     * Get policyRecId value
     * @return string|null
     */
    public function getPolicyRecId()
    {
        return $this->policyRecId;
    }
    /**
     * Set policyRecId value
     * @param string $policyRecId
     * @return \StructType\PolicyResp
     */
    public function setPolicyRecId($policyRecId = null)
    {
        // validation for constraint: string
        if (!is_null($policyRecId) && !is_string($policyRecId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($policyRecId, true), gettype($policyRecId)), __LINE__);
        }
        $this->policyRecId = $policyRecId;
        return $this;
    }
    /**
     * Get policyStatus value
     * @return string|null
     */
    public function getPolicyStatus()
    {
        return $this->policyStatus;
    }
    /**
     * Set policyStatus value
     * @param string $policyStatus
     * @return \StructType\PolicyResp
     */
    public function setPolicyStatus($policyStatus = null)
    {
        // validation for constraint: string
        if (!is_null($policyStatus) && !is_string($policyStatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($policyStatus, true), gettype($policyStatus)), __LINE__);
        }
        $this->policyStatus = $policyStatus;
        return $this;
    }
    /**
     * Get price value
     * @return float|null
     */
    public function getPrice()
    {
        return $this->price;
    }
    /**
     * Set price value
     * @param float $price
     * @return \StructType\PolicyResp
     */
    public function setPrice($price = null)
    {
        // validation for constraint: float
        if (!is_null($price) && !(is_float($price) || is_numeric($price))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($price, true), gettype($price)), __LINE__);
        }
        $this->price = $price;
        return $this;
    }
    /**
     * Get prices value
     * @return \StructType\PriceInfo|null
     */
    public function getPrices()
    {
        return $this->prices;
    }
    /**
     * Set prices value
     * @param \StructType\PriceInfo $prices
     * @return \StructType\PolicyResp
     */
    public function setPrices(\StructType\PriceInfo $prices = null)
    {
        $this->prices = $prices;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\PolicyResp
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
