<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PolicyPremiumResp StructType
 * @subpackage Structs
 */
class PolicyPremiumResp extends AbstractStructBase
{
    /**
     * The error
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RespError
     */
    public $error;
    /**
     * The currency
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $currency;
    /**
     * The price
     * @var float
     */
    public $price;
    /**
     * The prices
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\PriceInfo
     */
    public $prices;
    /**
     * Constructor method for PolicyPremiumResp
     * @uses PolicyPremiumResp::setError()
     * @uses PolicyPremiumResp::setCurrency()
     * @uses PolicyPremiumResp::setPrice()
     * @uses PolicyPremiumResp::setPrices()
     * @param \StructType\RespError $error
     * @param string $currency
     * @param float $price
     * @param \StructType\PriceInfo $prices
     */
    public function __construct(\StructType\RespError $error = null, $currency = null, $price = null, \StructType\PriceInfo $prices = null)
    {
        $this
            ->setError($error)
            ->setCurrency($currency)
            ->setPrice($price)
            ->setPrices($prices);
    }
    /**
     * Get error value
     * @return \StructType\RespError|null
     */
    public function getError()
    {
        return $this->error;
    }
    /**
     * Set error value
     * @param \StructType\RespError $error
     * @return \StructType\PolicyPremiumResp
     */
    public function setError(\StructType\RespError $error = null)
    {
        $this->error = $error;
        return $this;
    }
    /**
     * Get currency value
     * @return string|null
     */
    public function getCurrency()
    {
        return $this->currency;
    }
    /**
     * Set currency value
     * @param string $currency
     * @return \StructType\PolicyPremiumResp
     */
    public function setCurrency($currency = null)
    {
        // validation for constraint: string
        if (!is_null($currency) && !is_string($currency)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($currency, true), gettype($currency)), __LINE__);
        }
        $this->currency = $currency;
        return $this;
    }
    /**
     * Get price value
     * @return float|null
     */
    public function getPrice()
    {
        return $this->price;
    }
    /**
     * Set price value
     * @param float $price
     * @return \StructType\PolicyPremiumResp
     */
    public function setPrice($price = null)
    {
        // validation for constraint: float
        if (!is_null($price) && !(is_float($price) || is_numeric($price))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($price, true), gettype($price)), __LINE__);
        }
        $this->price = $price;
        return $this;
    }
    /**
     * Get prices value
     * @return \StructType\PriceInfo|null
     */
    public function getPrices()
    {
        return $this->prices;
    }
    /**
     * Set prices value
     * @param \StructType\PriceInfo $prices
     * @return \StructType\PolicyPremiumResp
     */
    public function setPrices(\StructType\PriceInfo $prices = null)
    {
        $this->prices = $prices;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\PolicyPremiumResp
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
