<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PolicyParms StructType
 * @subpackage Structs
 */
class PolicyParms extends AbstractStructBase
{
    /**
     * The destination
     * Meta information extracted from the WSDL
     * - choice: destination | insureds | issuedOn | lastDay | officeID | organized | policyHolder | productCode | regionCode | seller | startDay | totalDays | transport
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * @var string
     */
    public $destination;
    /**
     * The insureds
     * Meta information extracted from the WSDL
     * - choice: destination | insureds | issuedOn | lastDay | officeID | organized | policyHolder | productCode | regionCode | seller | startDay | totalDays | transport
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * @var \StructType\Insureds
     */
    public $insureds;
    /**
     * The issuedOn
     * Meta information extracted from the WSDL
     * - choice: destination | insureds | issuedOn | lastDay | officeID | organized | policyHolder | productCode | regionCode | seller | startDay | totalDays | transport
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $issuedOn;
    /**
     * The lastDay
     * Meta information extracted from the WSDL
     * - choice: destination | insureds | issuedOn | lastDay | officeID | organized | policyHolder | productCode | regionCode | seller | startDay | totalDays | transport
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * @var string
     */
    public $lastDay;
    /**
     * The officeID
     * Meta information extracted from the WSDL
     * - choice: destination | insureds | issuedOn | lastDay | officeID | organized | policyHolder | productCode | regionCode | seller | startDay | totalDays | transport
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $officeID;
    /**
     * The organized
     * Meta information extracted from the WSDL
     * - choice: destination | insureds | issuedOn | lastDay | officeID | organized | policyHolder | productCode | regionCode | seller | startDay | totalDays | transport
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $organized;
    /**
     * The policyHolder
     * Meta information extracted from the WSDL
     * - choice: destination | insureds | issuedOn | lastDay | officeID | organized | policyHolder | productCode | regionCode | seller | startDay | totalDays | transport
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * @var \StructType\PolicyHolderParms
     */
    public $policyHolder;
    /**
     * The productCode
     * Meta information extracted from the WSDL
     * - choice: destination | insureds | issuedOn | lastDay | officeID | organized | policyHolder | productCode | regionCode | seller | startDay | totalDays | transport
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * @var string
     */
    public $productCode;
    /**
     * The regionCode
     * Meta information extracted from the WSDL
     * - choice: destination | insureds | issuedOn | lastDay | officeID | organized | policyHolder | productCode | regionCode | seller | startDay | totalDays | transport
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * @var string
     */
    public $regionCode;
    /**
     * The seller
     * Meta information extracted from the WSDL
     * - choice: destination | insureds | issuedOn | lastDay | officeID | organized | policyHolder | productCode | regionCode | seller | startDay | totalDays | transport
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $seller;
    /**
     * The startDay
     * Meta information extracted from the WSDL
     * - choice: destination | insureds | issuedOn | lastDay | officeID | organized | policyHolder | productCode | regionCode | seller | startDay | totalDays | transport
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * @var string
     */
    public $startDay;
    /**
     * The totalDays
     * Meta information extracted from the WSDL
     * - choice: destination | insureds | issuedOn | lastDay | officeID | organized | policyHolder | productCode | regionCode | seller | startDay | totalDays | transport
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * @var int
     */
    public $totalDays;
    /**
     * The transport
     * Meta information extracted from the WSDL
     * - choice: destination | insureds | issuedOn | lastDay | officeID | organized | policyHolder | productCode | regionCode | seller | startDay | totalDays | transport
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $transport;
    /**
     * Constructor method for PolicyParms
     * @uses PolicyParms::setDestination()
     * @uses PolicyParms::setInsureds()
     * @uses PolicyParms::setIssuedOn()
     * @uses PolicyParms::setLastDay()
     * @uses PolicyParms::setOfficeID()
     * @uses PolicyParms::setOrganized()
     * @uses PolicyParms::setPolicyHolder()
     * @uses PolicyParms::setProductCode()
     * @uses PolicyParms::setRegionCode()
     * @uses PolicyParms::setSeller()
     * @uses PolicyParms::setStartDay()
     * @uses PolicyParms::setTotalDays()
     * @uses PolicyParms::setTransport()
     * @param string $destination
     * @param \StructType\Insureds $insureds
     * @param string $issuedOn
     * @param string $lastDay
     * @param string $officeID
     * @param bool $organized
     * @param \StructType\PolicyHolderParms $policyHolder
     * @param string $productCode
     * @param string $regionCode
     * @param string $seller
     * @param string $startDay
     * @param int $totalDays
     * @param string $transport
     */
    public function __construct($destination = null, \StructType\Insureds $insureds = null, $issuedOn = null, $lastDay = null, $officeID = null, $organized = null, \StructType\PolicyHolderParms $policyHolder = null, $productCode = null, $regionCode = null, $seller = null, $startDay = null, $totalDays = null, $transport = null)
    {
        $this
            ->setDestination($destination)
            ->setInsureds($insureds)
            ->setIssuedOn($issuedOn)
            ->setLastDay($lastDay)
            ->setOfficeID($officeID)
            ->setOrganized($organized)
            ->setPolicyHolder($policyHolder)
            ->setProductCode($productCode)
            ->setRegionCode($regionCode)
            ->setSeller($seller)
            ->setStartDay($startDay)
            ->setTotalDays($totalDays)
            ->setTransport($transport);
    }
    /**
     * Get destination value
     * @return string|null
     */
    public function getDestination()
    {
        return isset($this->destination) ? $this->destination : null;
    }
    /**
     * This method is responsible for validating the value passed to the setDestination method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDestination method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateDestinationForChoiceConstraintsFromSetDestination($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'insureds',
            'issuedOn',
            'lastDay',
            'officeID',
            'organized',
            'policyHolder',
            'productCode',
            'regionCode',
            'seller',
            'startDay',
            'totalDays',
            'transport',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property destination can\'t be set as the property %s is already set. Only one property must be set among these properties: destination, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set destination value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param string $destination
     * @return \StructType\PolicyParms
     */
    public function setDestination($destination = null)
    {
        // validation for constraint: string
        if (!is_null($destination) && !is_string($destination)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($destination, true), gettype($destination)), __LINE__);
        }
        // validation for constraint: choice(destination, insureds, issuedOn, lastDay, officeID, organized, policyHolder, productCode, regionCode, seller, startDay, totalDays, transport)
        if ('' !== ($destinationChoiceErrorMessage = self::validateDestinationForChoiceConstraintsFromSetDestination($destination))) {
            throw new \InvalidArgumentException($destinationChoiceErrorMessage, __LINE__);
        }
        if (is_null($destination) || (is_array($destination) && empty($destination))) {
            unset($this->destination);
        } else {
            $this->destination = $destination;
        }
        return $this;
    }
    /**
     * Get insureds value
     * @return \StructType\Insureds|null
     */
    public function getInsureds()
    {
        return isset($this->insureds) ? $this->insureds : null;
    }
    /**
     * This method is responsible for validating the value passed to the setInsureds method
     * This method is willingly generated in order to preserve the one-line inline validation within the setInsureds method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateInsuredsForChoiceConstraintsFromSetInsureds($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'destination',
            'issuedOn',
            'lastDay',
            'officeID',
            'organized',
            'policyHolder',
            'productCode',
            'regionCode',
            'seller',
            'startDay',
            'totalDays',
            'transport',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property insureds can\'t be set as the property %s is already set. Only one property must be set among these properties: insureds, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set insureds value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\Insureds $insureds
     * @return \StructType\PolicyParms
     */
    public function setInsureds(\StructType\Insureds $insureds = null)
    {
        // validation for constraint: choice(destination, insureds, issuedOn, lastDay, officeID, organized, policyHolder, productCode, regionCode, seller, startDay, totalDays, transport)
        if ('' !== ($insuredsChoiceErrorMessage = self::validateInsuredsForChoiceConstraintsFromSetInsureds($insureds))) {
            throw new \InvalidArgumentException($insuredsChoiceErrorMessage, __LINE__);
        }
        if (is_null($insureds) || (is_array($insureds) && empty($insureds))) {
            unset($this->insureds);
        } else {
            $this->insureds = $insureds;
        }
        return $this;
    }
    /**
     * Get issuedOn value
     * @return string|null
     */
    public function getIssuedOn()
    {
        return isset($this->issuedOn) ? $this->issuedOn : null;
    }
    /**
     * This method is responsible for validating the value passed to the setIssuedOn method
     * This method is willingly generated in order to preserve the one-line inline validation within the setIssuedOn method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateIssuedOnForChoiceConstraintsFromSetIssuedOn($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'destination',
            'insureds',
            'lastDay',
            'officeID',
            'organized',
            'policyHolder',
            'productCode',
            'regionCode',
            'seller',
            'startDay',
            'totalDays',
            'transport',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property issuedOn can\'t be set as the property %s is already set. Only one property must be set among these properties: issuedOn, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set issuedOn value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param string $issuedOn
     * @return \StructType\PolicyParms
     */
    public function setIssuedOn($issuedOn = null)
    {
        // validation for constraint: string
        if (!is_null($issuedOn) && !is_string($issuedOn)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($issuedOn, true), gettype($issuedOn)), __LINE__);
        }
        // validation for constraint: choice(destination, insureds, issuedOn, lastDay, officeID, organized, policyHolder, productCode, regionCode, seller, startDay, totalDays, transport)
        if ('' !== ($issuedOnChoiceErrorMessage = self::validateIssuedOnForChoiceConstraintsFromSetIssuedOn($issuedOn))) {
            throw new \InvalidArgumentException($issuedOnChoiceErrorMessage, __LINE__);
        }
        if (is_null($issuedOn) || (is_array($issuedOn) && empty($issuedOn))) {
            unset($this->issuedOn);
        } else {
            $this->issuedOn = $issuedOn;
        }
        return $this;
    }
    /**
     * Get lastDay value
     * @return string|null
     */
    public function getLastDay()
    {
        return isset($this->lastDay) ? $this->lastDay : null;
    }
    /**
     * This method is responsible for validating the value passed to the setLastDay method
     * This method is willingly generated in order to preserve the one-line inline validation within the setLastDay method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateLastDayForChoiceConstraintsFromSetLastDay($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'destination',
            'insureds',
            'issuedOn',
            'officeID',
            'organized',
            'policyHolder',
            'productCode',
            'regionCode',
            'seller',
            'startDay',
            'totalDays',
            'transport',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property lastDay can\'t be set as the property %s is already set. Only one property must be set among these properties: lastDay, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set lastDay value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param string $lastDay
     * @return \StructType\PolicyParms
     */
    public function setLastDay($lastDay = null)
    {
        // validation for constraint: string
        if (!is_null($lastDay) && !is_string($lastDay)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastDay, true), gettype($lastDay)), __LINE__);
        }
        // validation for constraint: choice(destination, insureds, issuedOn, lastDay, officeID, organized, policyHolder, productCode, regionCode, seller, startDay, totalDays, transport)
        if ('' !== ($lastDayChoiceErrorMessage = self::validateLastDayForChoiceConstraintsFromSetLastDay($lastDay))) {
            throw new \InvalidArgumentException($lastDayChoiceErrorMessage, __LINE__);
        }
        if (is_null($lastDay) || (is_array($lastDay) && empty($lastDay))) {
            unset($this->lastDay);
        } else {
            $this->lastDay = $lastDay;
        }
        return $this;
    }
    /**
     * Get officeID value
     * @return string|null
     */
    public function getOfficeID()
    {
        return isset($this->officeID) ? $this->officeID : null;
    }
    /**
     * This method is responsible for validating the value passed to the setOfficeID method
     * This method is willingly generated in order to preserve the one-line inline validation within the setOfficeID method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateOfficeIDForChoiceConstraintsFromSetOfficeID($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'destination',
            'insureds',
            'issuedOn',
            'lastDay',
            'organized',
            'policyHolder',
            'productCode',
            'regionCode',
            'seller',
            'startDay',
            'totalDays',
            'transport',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property officeID can\'t be set as the property %s is already set. Only one property must be set among these properties: officeID, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set officeID value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param string $officeID
     * @return \StructType\PolicyParms
     */
    public function setOfficeID($officeID = null)
    {
        // validation for constraint: string
        if (!is_null($officeID) && !is_string($officeID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($officeID, true), gettype($officeID)), __LINE__);
        }
        // validation for constraint: choice(destination, insureds, issuedOn, lastDay, officeID, organized, policyHolder, productCode, regionCode, seller, startDay, totalDays, transport)
        if ('' !== ($officeIDChoiceErrorMessage = self::validateOfficeIDForChoiceConstraintsFromSetOfficeID($officeID))) {
            throw new \InvalidArgumentException($officeIDChoiceErrorMessage, __LINE__);
        }
        if (is_null($officeID) || (is_array($officeID) && empty($officeID))) {
            unset($this->officeID);
        } else {
            $this->officeID = $officeID;
        }
        return $this;
    }
    /**
     * Get organized value
     * @return bool|null
     */
    public function getOrganized()
    {
        return isset($this->organized) ? $this->organized : null;
    }
    /**
     * This method is responsible for validating the value passed to the setOrganized method
     * This method is willingly generated in order to preserve the one-line inline validation within the setOrganized method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateOrganizedForChoiceConstraintsFromSetOrganized($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'destination',
            'insureds',
            'issuedOn',
            'lastDay',
            'officeID',
            'policyHolder',
            'productCode',
            'regionCode',
            'seller',
            'startDay',
            'totalDays',
            'transport',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property organized can\'t be set as the property %s is already set. Only one property must be set among these properties: organized, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set organized value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param bool $organized
     * @return \StructType\PolicyParms
     */
    public function setOrganized($organized = null)
    {
        // validation for constraint: boolean
        if (!is_null($organized) && !is_bool($organized)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($organized, true), gettype($organized)), __LINE__);
        }
        // validation for constraint: choice(destination, insureds, issuedOn, lastDay, officeID, organized, policyHolder, productCode, regionCode, seller, startDay, totalDays, transport)
        if ('' !== ($organizedChoiceErrorMessage = self::validateOrganizedForChoiceConstraintsFromSetOrganized($organized))) {
            throw new \InvalidArgumentException($organizedChoiceErrorMessage, __LINE__);
        }
        if (is_null($organized) || (is_array($organized) && empty($organized))) {
            unset($this->organized);
        } else {
            $this->organized = $organized;
        }
        return $this;
    }
    /**
     * Get policyHolder value
     * @return \StructType\PolicyHolderParms|null
     */
    public function getPolicyHolder()
    {
        return isset($this->policyHolder) ? $this->policyHolder : null;
    }
    /**
     * This method is responsible for validating the value passed to the setPolicyHolder method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPolicyHolder method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validatePolicyHolderForChoiceConstraintsFromSetPolicyHolder($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'destination',
            'insureds',
            'issuedOn',
            'lastDay',
            'officeID',
            'organized',
            'productCode',
            'regionCode',
            'seller',
            'startDay',
            'totalDays',
            'transport',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property policyHolder can\'t be set as the property %s is already set. Only one property must be set among these properties: policyHolder, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set policyHolder value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\PolicyHolderParms $policyHolder
     * @return \StructType\PolicyParms
     */
    public function setPolicyHolder(\StructType\PolicyHolderParms $policyHolder = null)
    {
        // validation for constraint: choice(destination, insureds, issuedOn, lastDay, officeID, organized, policyHolder, productCode, regionCode, seller, startDay, totalDays, transport)
        if ('' !== ($policyHolderChoiceErrorMessage = self::validatePolicyHolderForChoiceConstraintsFromSetPolicyHolder($policyHolder))) {
            throw new \InvalidArgumentException($policyHolderChoiceErrorMessage, __LINE__);
        }
        if (is_null($policyHolder) || (is_array($policyHolder) && empty($policyHolder))) {
            unset($this->policyHolder);
        } else {
            $this->policyHolder = $policyHolder;
        }
        return $this;
    }
    /**
     * Get productCode value
     * @return string|null
     */
    public function getProductCode()
    {
        return isset($this->productCode) ? $this->productCode : null;
    }
    /**
     * This method is responsible for validating the value passed to the setProductCode method
     * This method is willingly generated in order to preserve the one-line inline validation within the setProductCode method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateProductCodeForChoiceConstraintsFromSetProductCode($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'destination',
            'insureds',
            'issuedOn',
            'lastDay',
            'officeID',
            'organized',
            'policyHolder',
            'regionCode',
            'seller',
            'startDay',
            'totalDays',
            'transport',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property productCode can\'t be set as the property %s is already set. Only one property must be set among these properties: productCode, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set productCode value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param string $productCode
     * @return \StructType\PolicyParms
     */
    public function setProductCode($productCode = null)
    {
        // validation for constraint: string
        if (!is_null($productCode) && !is_string($productCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($productCode, true), gettype($productCode)), __LINE__);
        }
        // validation for constraint: choice(destination, insureds, issuedOn, lastDay, officeID, organized, policyHolder, productCode, regionCode, seller, startDay, totalDays, transport)
        if ('' !== ($productCodeChoiceErrorMessage = self::validateProductCodeForChoiceConstraintsFromSetProductCode($productCode))) {
            throw new \InvalidArgumentException($productCodeChoiceErrorMessage, __LINE__);
        }
        if (is_null($productCode) || (is_array($productCode) && empty($productCode))) {
            unset($this->productCode);
        } else {
            $this->productCode = $productCode;
        }
        return $this;
    }
    /**
     * Get regionCode value
     * @return string|null
     */
    public function getRegionCode()
    {
        return isset($this->regionCode) ? $this->regionCode : null;
    }
    /**
     * This method is responsible for validating the value passed to the setRegionCode method
     * This method is willingly generated in order to preserve the one-line inline validation within the setRegionCode method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateRegionCodeForChoiceConstraintsFromSetRegionCode($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'destination',
            'insureds',
            'issuedOn',
            'lastDay',
            'officeID',
            'organized',
            'policyHolder',
            'productCode',
            'seller',
            'startDay',
            'totalDays',
            'transport',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property regionCode can\'t be set as the property %s is already set. Only one property must be set among these properties: regionCode, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set regionCode value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param string $regionCode
     * @return \StructType\PolicyParms
     */
    public function setRegionCode($regionCode = null)
    {
        // validation for constraint: string
        if (!is_null($regionCode) && !is_string($regionCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($regionCode, true), gettype($regionCode)), __LINE__);
        }
        // validation for constraint: choice(destination, insureds, issuedOn, lastDay, officeID, organized, policyHolder, productCode, regionCode, seller, startDay, totalDays, transport)
        if ('' !== ($regionCodeChoiceErrorMessage = self::validateRegionCodeForChoiceConstraintsFromSetRegionCode($regionCode))) {
            throw new \InvalidArgumentException($regionCodeChoiceErrorMessage, __LINE__);
        }
        if (is_null($regionCode) || (is_array($regionCode) && empty($regionCode))) {
            unset($this->regionCode);
        } else {
            $this->regionCode = $regionCode;
        }
        return $this;
    }
    /**
     * Get seller value
     * @return string|null
     */
    public function getSeller()
    {
        return isset($this->seller) ? $this->seller : null;
    }
    /**
     * This method is responsible for validating the value passed to the setSeller method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSeller method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateSellerForChoiceConstraintsFromSetSeller($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'destination',
            'insureds',
            'issuedOn',
            'lastDay',
            'officeID',
            'organized',
            'policyHolder',
            'productCode',
            'regionCode',
            'startDay',
            'totalDays',
            'transport',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property seller can\'t be set as the property %s is already set. Only one property must be set among these properties: seller, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set seller value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param string $seller
     * @return \StructType\PolicyParms
     */
    public function setSeller($seller = null)
    {
        // validation for constraint: string
        if (!is_null($seller) && !is_string($seller)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($seller, true), gettype($seller)), __LINE__);
        }
        // validation for constraint: choice(destination, insureds, issuedOn, lastDay, officeID, organized, policyHolder, productCode, regionCode, seller, startDay, totalDays, transport)
        if ('' !== ($sellerChoiceErrorMessage = self::validateSellerForChoiceConstraintsFromSetSeller($seller))) {
            throw new \InvalidArgumentException($sellerChoiceErrorMessage, __LINE__);
        }
        if (is_null($seller) || (is_array($seller) && empty($seller))) {
            unset($this->seller);
        } else {
            $this->seller = $seller;
        }
        return $this;
    }
    /**
     * Get startDay value
     * @return string|null
     */
    public function getStartDay()
    {
        return isset($this->startDay) ? $this->startDay : null;
    }
    /**
     * This method is responsible for validating the value passed to the setStartDay method
     * This method is willingly generated in order to preserve the one-line inline validation within the setStartDay method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateStartDayForChoiceConstraintsFromSetStartDay($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'destination',
            'insureds',
            'issuedOn',
            'lastDay',
            'officeID',
            'organized',
            'policyHolder',
            'productCode',
            'regionCode',
            'seller',
            'totalDays',
            'transport',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property startDay can\'t be set as the property %s is already set. Only one property must be set among these properties: startDay, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set startDay value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param string $startDay
     * @return \StructType\PolicyParms
     */
    public function setStartDay($startDay = null)
    {
        // validation for constraint: string
        if (!is_null($startDay) && !is_string($startDay)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($startDay, true), gettype($startDay)), __LINE__);
        }
        // validation for constraint: choice(destination, insureds, issuedOn, lastDay, officeID, organized, policyHolder, productCode, regionCode, seller, startDay, totalDays, transport)
        if ('' !== ($startDayChoiceErrorMessage = self::validateStartDayForChoiceConstraintsFromSetStartDay($startDay))) {
            throw new \InvalidArgumentException($startDayChoiceErrorMessage, __LINE__);
        }
        if (is_null($startDay) || (is_array($startDay) && empty($startDay))) {
            unset($this->startDay);
        } else {
            $this->startDay = $startDay;
        }
        return $this;
    }
    /**
     * Get totalDays value
     * @return int|null
     */
    public function getTotalDays()
    {
        return isset($this->totalDays) ? $this->totalDays : null;
    }
    /**
     * This method is responsible for validating the value passed to the setTotalDays method
     * This method is willingly generated in order to preserve the one-line inline validation within the setTotalDays method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateTotalDaysForChoiceConstraintsFromSetTotalDays($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'destination',
            'insureds',
            'issuedOn',
            'lastDay',
            'officeID',
            'organized',
            'policyHolder',
            'productCode',
            'regionCode',
            'seller',
            'startDay',
            'transport',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property totalDays can\'t be set as the property %s is already set. Only one property must be set among these properties: totalDays, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set totalDays value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param int $totalDays
     * @return \StructType\PolicyParms
     */
    public function setTotalDays($totalDays = null)
    {
        // validation for constraint: int
        if (!is_null($totalDays) && !(is_int($totalDays) || ctype_digit($totalDays))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($totalDays, true), gettype($totalDays)), __LINE__);
        }
        // validation for constraint: choice(destination, insureds, issuedOn, lastDay, officeID, organized, policyHolder, productCode, regionCode, seller, startDay, totalDays, transport)
        if ('' !== ($totalDaysChoiceErrorMessage = self::validateTotalDaysForChoiceConstraintsFromSetTotalDays($totalDays))) {
            throw new \InvalidArgumentException($totalDaysChoiceErrorMessage, __LINE__);
        }
        if (is_null($totalDays) || (is_array($totalDays) && empty($totalDays))) {
            unset($this->totalDays);
        } else {
            $this->totalDays = $totalDays;
        }
        return $this;
    }
    /**
     * Get transport value
     * @return string|null
     */
    public function getTransport()
    {
        return isset($this->transport) ? $this->transport : null;
    }
    /**
     * This method is responsible for validating the value passed to the setTransport method
     * This method is willingly generated in order to preserve the one-line inline validation within the setTransport method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateTransportForChoiceConstraintsFromSetTransport($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'destination',
            'insureds',
            'issuedOn',
            'lastDay',
            'officeID',
            'organized',
            'policyHolder',
            'productCode',
            'regionCode',
            'seller',
            'startDay',
            'totalDays',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property transport can\'t be set as the property %s is already set. Only one property must be set among these properties: transport, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set transport value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param string $transport
     * @return \StructType\PolicyParms
     */
    public function setTransport($transport = null)
    {
        // validation for constraint: string
        if (!is_null($transport) && !is_string($transport)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($transport, true), gettype($transport)), __LINE__);
        }
        // validation for constraint: choice(destination, insureds, issuedOn, lastDay, officeID, organized, policyHolder, productCode, regionCode, seller, startDay, totalDays, transport)
        if ('' !== ($transportChoiceErrorMessage = self::validateTransportForChoiceConstraintsFromSetTransport($transport))) {
            throw new \InvalidArgumentException($transportChoiceErrorMessage, __LINE__);
        }
        if (is_null($transport) || (is_array($transport) && empty($transport))) {
            unset($this->transport);
        } else {
            $this->transport = $transport;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\PolicyParms
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
