<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PolicyListItem StructType
 * @subpackage Structs
 */
class PolicyListItem extends AbstractStructBase
{
    /**
     * The agentCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $agentCode;
    /**
     * The channelType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $channelType;
    /**
     * The policyNumber
     * @var int
     */
    public $policyNumber;
    /**
     * The policyNumberExt
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $policyNumberExt;
    /**
     * The issuedOn
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $issuedOn;
    /**
     * The startDay
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $startDay;
    /**
     * The lastDay
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $lastDay;
    /**
     * The totalDays
     * @var int
     */
    public $totalDays;
    /**
     * The totalInsureds
     * @var int
     */
    public $totalInsureds;
    /**
     * The productCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $productCode;
    /**
     * The productName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $productName;
    /**
     * The priceCur
     * @var float
     */
    public $priceCur;
    /**
     * The currency
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $currency;
    /**
     * The priceLoc
     * @var float
     */
    public $priceLoc;
    /**
     * The commissionCur
     * @var float
     */
    public $commissionCur;
    /**
     * The commissionLoc
     * @var float
     */
    public $commissionLoc;
    /**
     * The commissionStatus
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $commissionStatus;
    /**
     * The cmStatusDescription
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $cmStatusDescription;
    /**
     * The acntYearMonth
     * @var int
     */
    public $acntYearMonth;
    /**
     * The policyHolderName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $policyHolderName;
    /**
     * The policyPeriodStatus
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $policyPeriodStatus;
    /**
     * The ppStatusDescription
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $ppStatusDescription;
    /**
     * Constructor method for PolicyListItem
     * @uses PolicyListItem::setAgentCode()
     * @uses PolicyListItem::setChannelType()
     * @uses PolicyListItem::setPolicyNumber()
     * @uses PolicyListItem::setPolicyNumberExt()
     * @uses PolicyListItem::setIssuedOn()
     * @uses PolicyListItem::setStartDay()
     * @uses PolicyListItem::setLastDay()
     * @uses PolicyListItem::setTotalDays()
     * @uses PolicyListItem::setTotalInsureds()
     * @uses PolicyListItem::setProductCode()
     * @uses PolicyListItem::setProductName()
     * @uses PolicyListItem::setPriceCur()
     * @uses PolicyListItem::setCurrency()
     * @uses PolicyListItem::setPriceLoc()
     * @uses PolicyListItem::setCommissionCur()
     * @uses PolicyListItem::setCommissionLoc()
     * @uses PolicyListItem::setCommissionStatus()
     * @uses PolicyListItem::setCmStatusDescription()
     * @uses PolicyListItem::setAcntYearMonth()
     * @uses PolicyListItem::setPolicyHolderName()
     * @uses PolicyListItem::setPolicyPeriodStatus()
     * @uses PolicyListItem::setPpStatusDescription()
     * @param string $agentCode
     * @param string $channelType
     * @param int $policyNumber
     * @param string $policyNumberExt
     * @param string $issuedOn
     * @param string $startDay
     * @param string $lastDay
     * @param int $totalDays
     * @param int $totalInsureds
     * @param string $productCode
     * @param string $productName
     * @param float $priceCur
     * @param string $currency
     * @param float $priceLoc
     * @param float $commissionCur
     * @param float $commissionLoc
     * @param string $commissionStatus
     * @param string $cmStatusDescription
     * @param int $acntYearMonth
     * @param string $policyHolderName
     * @param string $policyPeriodStatus
     * @param string $ppStatusDescription
     */
    public function __construct($agentCode = null, $channelType = null, $policyNumber = null, $policyNumberExt = null, $issuedOn = null, $startDay = null, $lastDay = null, $totalDays = null, $totalInsureds = null, $productCode = null, $productName = null, $priceCur = null, $currency = null, $priceLoc = null, $commissionCur = null, $commissionLoc = null, $commissionStatus = null, $cmStatusDescription = null, $acntYearMonth = null, $policyHolderName = null, $policyPeriodStatus = null, $ppStatusDescription = null)
    {
        $this
            ->setAgentCode($agentCode)
            ->setChannelType($channelType)
            ->setPolicyNumber($policyNumber)
            ->setPolicyNumberExt($policyNumberExt)
            ->setIssuedOn($issuedOn)
            ->setStartDay($startDay)
            ->setLastDay($lastDay)
            ->setTotalDays($totalDays)
            ->setTotalInsureds($totalInsureds)
            ->setProductCode($productCode)
            ->setProductName($productName)
            ->setPriceCur($priceCur)
            ->setCurrency($currency)
            ->setPriceLoc($priceLoc)
            ->setCommissionCur($commissionCur)
            ->setCommissionLoc($commissionLoc)
            ->setCommissionStatus($commissionStatus)
            ->setCmStatusDescription($cmStatusDescription)
            ->setAcntYearMonth($acntYearMonth)
            ->setPolicyHolderName($policyHolderName)
            ->setPolicyPeriodStatus($policyPeriodStatus)
            ->setPpStatusDescription($ppStatusDescription);
    }
    /**
     * Get agentCode value
     * @return string|null
     */
    public function getAgentCode()
    {
        return $this->agentCode;
    }
    /**
     * Set agentCode value
     * @param string $agentCode
     * @return \StructType\PolicyListItem
     */
    public function setAgentCode($agentCode = null)
    {
        // validation for constraint: string
        if (!is_null($agentCode) && !is_string($agentCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($agentCode, true), gettype($agentCode)), __LINE__);
        }
        $this->agentCode = $agentCode;
        return $this;
    }
    /**
     * Get channelType value
     * @return string|null
     */
    public function getChannelType()
    {
        return $this->channelType;
    }
    /**
     * Set channelType value
     * @param string $channelType
     * @return \StructType\PolicyListItem
     */
    public function setChannelType($channelType = null)
    {
        // validation for constraint: string
        if (!is_null($channelType) && !is_string($channelType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($channelType, true), gettype($channelType)), __LINE__);
        }
        $this->channelType = $channelType;
        return $this;
    }
    /**
     * Get policyNumber value
     * @return int|null
     */
    public function getPolicyNumber()
    {
        return $this->policyNumber;
    }
    /**
     * Set policyNumber value
     * @param int $policyNumber
     * @return \StructType\PolicyListItem
     */
    public function setPolicyNumber($policyNumber = null)
    {
        // validation for constraint: int
        if (!is_null($policyNumber) && !(is_int($policyNumber) || ctype_digit($policyNumber))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($policyNumber, true), gettype($policyNumber)), __LINE__);
        }
        $this->policyNumber = $policyNumber;
        return $this;
    }
    /**
     * Get policyNumberExt value
     * @return string|null
     */
    public function getPolicyNumberExt()
    {
        return $this->policyNumberExt;
    }
    /**
     * Set policyNumberExt value
     * @param string $policyNumberExt
     * @return \StructType\PolicyListItem
     */
    public function setPolicyNumberExt($policyNumberExt = null)
    {
        // validation for constraint: string
        if (!is_null($policyNumberExt) && !is_string($policyNumberExt)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($policyNumberExt, true), gettype($policyNumberExt)), __LINE__);
        }
        $this->policyNumberExt = $policyNumberExt;
        return $this;
    }
    /**
     * Get issuedOn value
     * @return string|null
     */
    public function getIssuedOn()
    {
        return $this->issuedOn;
    }
    /**
     * Set issuedOn value
     * @param string $issuedOn
     * @return \StructType\PolicyListItem
     */
    public function setIssuedOn($issuedOn = null)
    {
        // validation for constraint: string
        if (!is_null($issuedOn) && !is_string($issuedOn)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($issuedOn, true), gettype($issuedOn)), __LINE__);
        }
        $this->issuedOn = $issuedOn;
        return $this;
    }
    /**
     * Get startDay value
     * @return string|null
     */
    public function getStartDay()
    {
        return $this->startDay;
    }
    /**
     * Set startDay value
     * @param string $startDay
     * @return \StructType\PolicyListItem
     */
    public function setStartDay($startDay = null)
    {
        // validation for constraint: string
        if (!is_null($startDay) && !is_string($startDay)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($startDay, true), gettype($startDay)), __LINE__);
        }
        $this->startDay = $startDay;
        return $this;
    }
    /**
     * Get lastDay value
     * @return string|null
     */
    public function getLastDay()
    {
        return $this->lastDay;
    }
    /**
     * Set lastDay value
     * @param string $lastDay
     * @return \StructType\PolicyListItem
     */
    public function setLastDay($lastDay = null)
    {
        // validation for constraint: string
        if (!is_null($lastDay) && !is_string($lastDay)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastDay, true), gettype($lastDay)), __LINE__);
        }
        $this->lastDay = $lastDay;
        return $this;
    }
    /**
     * Get totalDays value
     * @return int|null
     */
    public function getTotalDays()
    {
        return $this->totalDays;
    }
    /**
     * Set totalDays value
     * @param int $totalDays
     * @return \StructType\PolicyListItem
     */
    public function setTotalDays($totalDays = null)
    {
        // validation for constraint: int
        if (!is_null($totalDays) && !(is_int($totalDays) || ctype_digit($totalDays))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($totalDays, true), gettype($totalDays)), __LINE__);
        }
        $this->totalDays = $totalDays;
        return $this;
    }
    /**
     * Get totalInsureds value
     * @return int|null
     */
    public function getTotalInsureds()
    {
        return $this->totalInsureds;
    }
    /**
     * Set totalInsureds value
     * @param int $totalInsureds
     * @return \StructType\PolicyListItem
     */
    public function setTotalInsureds($totalInsureds = null)
    {
        // validation for constraint: int
        if (!is_null($totalInsureds) && !(is_int($totalInsureds) || ctype_digit($totalInsureds))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($totalInsureds, true), gettype($totalInsureds)), __LINE__);
        }
        $this->totalInsureds = $totalInsureds;
        return $this;
    }
    /**
     * Get productCode value
     * @return string|null
     */
    public function getProductCode()
    {
        return $this->productCode;
    }
    /**
     * Set productCode value
     * @param string $productCode
     * @return \StructType\PolicyListItem
     */
    public function setProductCode($productCode = null)
    {
        // validation for constraint: string
        if (!is_null($productCode) && !is_string($productCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($productCode, true), gettype($productCode)), __LINE__);
        }
        $this->productCode = $productCode;
        return $this;
    }
    /**
     * Get productName value
     * @return string|null
     */
    public function getProductName()
    {
        return $this->productName;
    }
    /**
     * Set productName value
     * @param string $productName
     * @return \StructType\PolicyListItem
     */
    public function setProductName($productName = null)
    {
        // validation for constraint: string
        if (!is_null($productName) && !is_string($productName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($productName, true), gettype($productName)), __LINE__);
        }
        $this->productName = $productName;
        return $this;
    }
    /**
     * Get priceCur value
     * @return float|null
     */
    public function getPriceCur()
    {
        return $this->priceCur;
    }
    /**
     * Set priceCur value
     * @param float $priceCur
     * @return \StructType\PolicyListItem
     */
    public function setPriceCur($priceCur = null)
    {
        // validation for constraint: float
        if (!is_null($priceCur) && !(is_float($priceCur) || is_numeric($priceCur))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($priceCur, true), gettype($priceCur)), __LINE__);
        }
        $this->priceCur = $priceCur;
        return $this;
    }
    /**
     * Get currency value
     * @return string|null
     */
    public function getCurrency()
    {
        return $this->currency;
    }
    /**
     * Set currency value
     * @param string $currency
     * @return \StructType\PolicyListItem
     */
    public function setCurrency($currency = null)
    {
        // validation for constraint: string
        if (!is_null($currency) && !is_string($currency)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($currency, true), gettype($currency)), __LINE__);
        }
        $this->currency = $currency;
        return $this;
    }
    /**
     * Get priceLoc value
     * @return float|null
     */
    public function getPriceLoc()
    {
        return $this->priceLoc;
    }
    /**
     * Set priceLoc value
     * @param float $priceLoc
     * @return \StructType\PolicyListItem
     */
    public function setPriceLoc($priceLoc = null)
    {
        // validation for constraint: float
        if (!is_null($priceLoc) && !(is_float($priceLoc) || is_numeric($priceLoc))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($priceLoc, true), gettype($priceLoc)), __LINE__);
        }
        $this->priceLoc = $priceLoc;
        return $this;
    }
    /**
     * Get commissionCur value
     * @return float|null
     */
    public function getCommissionCur()
    {
        return $this->commissionCur;
    }
    /**
     * Set commissionCur value
     * @param float $commissionCur
     * @return \StructType\PolicyListItem
     */
    public function setCommissionCur($commissionCur = null)
    {
        // validation for constraint: float
        if (!is_null($commissionCur) && !(is_float($commissionCur) || is_numeric($commissionCur))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($commissionCur, true), gettype($commissionCur)), __LINE__);
        }
        $this->commissionCur = $commissionCur;
        return $this;
    }
    /**
     * Get commissionLoc value
     * @return float|null
     */
    public function getCommissionLoc()
    {
        return $this->commissionLoc;
    }
    /**
     * Set commissionLoc value
     * @param float $commissionLoc
     * @return \StructType\PolicyListItem
     */
    public function setCommissionLoc($commissionLoc = null)
    {
        // validation for constraint: float
        if (!is_null($commissionLoc) && !(is_float($commissionLoc) || is_numeric($commissionLoc))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($commissionLoc, true), gettype($commissionLoc)), __LINE__);
        }
        $this->commissionLoc = $commissionLoc;
        return $this;
    }
    /**
     * Get commissionStatus value
     * @return string|null
     */
    public function getCommissionStatus()
    {
        return $this->commissionStatus;
    }
    /**
     * Set commissionStatus value
     * @param string $commissionStatus
     * @return \StructType\PolicyListItem
     */
    public function setCommissionStatus($commissionStatus = null)
    {
        // validation for constraint: string
        if (!is_null($commissionStatus) && !is_string($commissionStatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($commissionStatus, true), gettype($commissionStatus)), __LINE__);
        }
        $this->commissionStatus = $commissionStatus;
        return $this;
    }
    /**
     * Get cmStatusDescription value
     * @return string|null
     */
    public function getCmStatusDescription()
    {
        return $this->cmStatusDescription;
    }
    /**
     * Set cmStatusDescription value
     * @param string $cmStatusDescription
     * @return \StructType\PolicyListItem
     */
    public function setCmStatusDescription($cmStatusDescription = null)
    {
        // validation for constraint: string
        if (!is_null($cmStatusDescription) && !is_string($cmStatusDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cmStatusDescription, true), gettype($cmStatusDescription)), __LINE__);
        }
        $this->cmStatusDescription = $cmStatusDescription;
        return $this;
    }
    /**
     * Get acntYearMonth value
     * @return int|null
     */
    public function getAcntYearMonth()
    {
        return $this->acntYearMonth;
    }
    /**
     * Set acntYearMonth value
     * @param int $acntYearMonth
     * @return \StructType\PolicyListItem
     */
    public function setAcntYearMonth($acntYearMonth = null)
    {
        // validation for constraint: int
        if (!is_null($acntYearMonth) && !(is_int($acntYearMonth) || ctype_digit($acntYearMonth))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($acntYearMonth, true), gettype($acntYearMonth)), __LINE__);
        }
        $this->acntYearMonth = $acntYearMonth;
        return $this;
    }
    /**
     * Get policyHolderName value
     * @return string|null
     */
    public function getPolicyHolderName()
    {
        return $this->policyHolderName;
    }
    /**
     * Set policyHolderName value
     * @param string $policyHolderName
     * @return \StructType\PolicyListItem
     */
    public function setPolicyHolderName($policyHolderName = null)
    {
        // validation for constraint: string
        if (!is_null($policyHolderName) && !is_string($policyHolderName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($policyHolderName, true), gettype($policyHolderName)), __LINE__);
        }
        $this->policyHolderName = $policyHolderName;
        return $this;
    }
    /**
     * Get policyPeriodStatus value
     * @return string|null
     */
    public function getPolicyPeriodStatus()
    {
        return $this->policyPeriodStatus;
    }
    /**
     * Set policyPeriodStatus value
     * @param string $policyPeriodStatus
     * @return \StructType\PolicyListItem
     */
    public function setPolicyPeriodStatus($policyPeriodStatus = null)
    {
        // validation for constraint: string
        if (!is_null($policyPeriodStatus) && !is_string($policyPeriodStatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($policyPeriodStatus, true), gettype($policyPeriodStatus)), __LINE__);
        }
        $this->policyPeriodStatus = $policyPeriodStatus;
        return $this;
    }
    /**
     * Get ppStatusDescription value
     * @return string|null
     */
    public function getPpStatusDescription()
    {
        return $this->ppStatusDescription;
    }
    /**
     * Set ppStatusDescription value
     * @param string $ppStatusDescription
     * @return \StructType\PolicyListItem
     */
    public function setPpStatusDescription($ppStatusDescription = null)
    {
        // validation for constraint: string
        if (!is_null($ppStatusDescription) && !is_string($ppStatusDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ppStatusDescription, true), gettype($ppStatusDescription)), __LINE__);
        }
        $this->ppStatusDescription = $ppStatusDescription;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\PolicyListItem
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
