<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PersonAddParms StructType
 * @subpackage Structs
 */
class PersonAddParms extends AbstractStructBase
{
    /**
     * The surname
     * Meta information extracted from the WSDL
     * - choice: surname | firstName | middleName | birthPlace | taxId | insuranceId | address | citizenship | passport | otherDocument
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $surname;
    /**
     * The firstName
     * Meta information extracted from the WSDL
     * - choice: surname | firstName | middleName | birthPlace | taxId | insuranceId | address | citizenship | passport | otherDocument
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $firstName;
    /**
     * The middleName
     * Meta information extracted from the WSDL
     * - choice: surname | firstName | middleName | birthPlace | taxId | insuranceId | address | citizenship | passport | otherDocument
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $middleName;
    /**
     * The birthPlace
     * Meta information extracted from the WSDL
     * - choice: surname | firstName | middleName | birthPlace | taxId | insuranceId | address | citizenship | passport | otherDocument
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $birthPlace;
    /**
     * The taxId
     * Meta information extracted from the WSDL
     * - choice: surname | firstName | middleName | birthPlace | taxId | insuranceId | address | citizenship | passport | otherDocument
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $taxId;
    /**
     * The insuranceId
     * Meta information extracted from the WSDL
     * - choice: surname | firstName | middleName | birthPlace | taxId | insuranceId | address | citizenship | passport | otherDocument
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $insuranceId;
    /**
     * The address
     * Meta information extracted from the WSDL
     * - choice: surname | firstName | middleName | birthPlace | taxId | insuranceId | address | citizenship | passport | otherDocument
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * @var string
     */
    public $address;
    /**
     * The citizenship
     * Meta information extracted from the WSDL
     * - choice: surname | firstName | middleName | birthPlace | taxId | insuranceId | address | citizenship | passport | otherDocument
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $citizenship;
    /**
     * The passport
     * Meta information extracted from the WSDL
     * - choice: surname | firstName | middleName | birthPlace | taxId | insuranceId | address | citizenship | passport | otherDocument
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Passport
     */
    public $passport;
    /**
     * The otherDocument
     * Meta information extracted from the WSDL
     * - choice: surname | firstName | middleName | birthPlace | taxId | insuranceId | address | citizenship | passport | otherDocument
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - minOccurs: 0
     * @var \StructType\OtherDocument
     */
    public $otherDocument;
    /**
     * Constructor method for PersonAddParms
     * @uses PersonAddParms::setSurname()
     * @uses PersonAddParms::setFirstName()
     * @uses PersonAddParms::setMiddleName()
     * @uses PersonAddParms::setBirthPlace()
     * @uses PersonAddParms::setTaxId()
     * @uses PersonAddParms::setInsuranceId()
     * @uses PersonAddParms::setAddress()
     * @uses PersonAddParms::setCitizenship()
     * @uses PersonAddParms::setPassport()
     * @uses PersonAddParms::setOtherDocument()
     * @param string $surname
     * @param string $firstName
     * @param string $middleName
     * @param string $birthPlace
     * @param string $taxId
     * @param string $insuranceId
     * @param string $address
     * @param string $citizenship
     * @param \StructType\Passport $passport
     * @param \StructType\OtherDocument $otherDocument
     */
    public function __construct($surname = null, $firstName = null, $middleName = null, $birthPlace = null, $taxId = null, $insuranceId = null, $address = null, $citizenship = null, \StructType\Passport $passport = null, \StructType\OtherDocument $otherDocument = null)
    {
        $this
            ->setSurname($surname)
            ->setFirstName($firstName)
            ->setMiddleName($middleName)
            ->setBirthPlace($birthPlace)
            ->setTaxId($taxId)
            ->setInsuranceId($insuranceId)
            ->setAddress($address)
            ->setCitizenship($citizenship)
            ->setPassport($passport)
            ->setOtherDocument($otherDocument);
    }
    /**
     * Get surname value
     * @return string|null
     */
    public function getSurname()
    {
        return isset($this->surname) ? $this->surname : null;
    }
    /**
     * This method is responsible for validating the value passed to the setSurname method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSurname method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateSurnameForChoiceConstraintsFromSetSurname($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'firstName',
            'middleName',
            'birthPlace',
            'taxId',
            'insuranceId',
            'address',
            'citizenship',
            'passport',
            'otherDocument',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property surname can\'t be set as the property %s is already set. Only one property must be set among these properties: surname, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set surname value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param string $surname
     * @return \StructType\PersonAddParms
     */
    public function setSurname($surname = null)
    {
        // validation for constraint: string
        if (!is_null($surname) && !is_string($surname)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($surname, true), gettype($surname)), __LINE__);
        }
        // validation for constraint: choice(surname, firstName, middleName, birthPlace, taxId, insuranceId, address, citizenship, passport, otherDocument)
        if ('' !== ($surnameChoiceErrorMessage = self::validateSurnameForChoiceConstraintsFromSetSurname($surname))) {
            throw new \InvalidArgumentException($surnameChoiceErrorMessage, __LINE__);
        }
        if (is_null($surname) || (is_array($surname) && empty($surname))) {
            unset($this->surname);
        } else {
            $this->surname = $surname;
        }
        return $this;
    }
    /**
     * Get firstName value
     * @return string|null
     */
    public function getFirstName()
    {
        return isset($this->firstName) ? $this->firstName : null;
    }
    /**
     * This method is responsible for validating the value passed to the setFirstName method
     * This method is willingly generated in order to preserve the one-line inline validation within the setFirstName method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateFirstNameForChoiceConstraintsFromSetFirstName($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'surname',
            'middleName',
            'birthPlace',
            'taxId',
            'insuranceId',
            'address',
            'citizenship',
            'passport',
            'otherDocument',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property firstName can\'t be set as the property %s is already set. Only one property must be set among these properties: firstName, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set firstName value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param string $firstName
     * @return \StructType\PersonAddParms
     */
    public function setFirstName($firstName = null)
    {
        // validation for constraint: string
        if (!is_null($firstName) && !is_string($firstName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($firstName, true), gettype($firstName)), __LINE__);
        }
        // validation for constraint: choice(surname, firstName, middleName, birthPlace, taxId, insuranceId, address, citizenship, passport, otherDocument)
        if ('' !== ($firstNameChoiceErrorMessage = self::validateFirstNameForChoiceConstraintsFromSetFirstName($firstName))) {
            throw new \InvalidArgumentException($firstNameChoiceErrorMessage, __LINE__);
        }
        if (is_null($firstName) || (is_array($firstName) && empty($firstName))) {
            unset($this->firstName);
        } else {
            $this->firstName = $firstName;
        }
        return $this;
    }
    /**
     * Get middleName value
     * @return string|null
     */
    public function getMiddleName()
    {
        return isset($this->middleName) ? $this->middleName : null;
    }
    /**
     * This method is responsible for validating the value passed to the setMiddleName method
     * This method is willingly generated in order to preserve the one-line inline validation within the setMiddleName method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateMiddleNameForChoiceConstraintsFromSetMiddleName($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'surname',
            'firstName',
            'birthPlace',
            'taxId',
            'insuranceId',
            'address',
            'citizenship',
            'passport',
            'otherDocument',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property middleName can\'t be set as the property %s is already set. Only one property must be set among these properties: middleName, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set middleName value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param string $middleName
     * @return \StructType\PersonAddParms
     */
    public function setMiddleName($middleName = null)
    {
        // validation for constraint: string
        if (!is_null($middleName) && !is_string($middleName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($middleName, true), gettype($middleName)), __LINE__);
        }
        // validation for constraint: choice(surname, firstName, middleName, birthPlace, taxId, insuranceId, address, citizenship, passport, otherDocument)
        if ('' !== ($middleNameChoiceErrorMessage = self::validateMiddleNameForChoiceConstraintsFromSetMiddleName($middleName))) {
            throw new \InvalidArgumentException($middleNameChoiceErrorMessage, __LINE__);
        }
        if (is_null($middleName) || (is_array($middleName) && empty($middleName))) {
            unset($this->middleName);
        } else {
            $this->middleName = $middleName;
        }
        return $this;
    }
    /**
     * Get birthPlace value
     * @return string|null
     */
    public function getBirthPlace()
    {
        return isset($this->birthPlace) ? $this->birthPlace : null;
    }
    /**
     * This method is responsible for validating the value passed to the setBirthPlace method
     * This method is willingly generated in order to preserve the one-line inline validation within the setBirthPlace method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateBirthPlaceForChoiceConstraintsFromSetBirthPlace($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'surname',
            'firstName',
            'middleName',
            'taxId',
            'insuranceId',
            'address',
            'citizenship',
            'passport',
            'otherDocument',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property birthPlace can\'t be set as the property %s is already set. Only one property must be set among these properties: birthPlace, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set birthPlace value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param string $birthPlace
     * @return \StructType\PersonAddParms
     */
    public function setBirthPlace($birthPlace = null)
    {
        // validation for constraint: string
        if (!is_null($birthPlace) && !is_string($birthPlace)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($birthPlace, true), gettype($birthPlace)), __LINE__);
        }
        // validation for constraint: choice(surname, firstName, middleName, birthPlace, taxId, insuranceId, address, citizenship, passport, otherDocument)
        if ('' !== ($birthPlaceChoiceErrorMessage = self::validateBirthPlaceForChoiceConstraintsFromSetBirthPlace($birthPlace))) {
            throw new \InvalidArgumentException($birthPlaceChoiceErrorMessage, __LINE__);
        }
        if (is_null($birthPlace) || (is_array($birthPlace) && empty($birthPlace))) {
            unset($this->birthPlace);
        } else {
            $this->birthPlace = $birthPlace;
        }
        return $this;
    }
    /**
     * Get taxId value
     * @return string|null
     */
    public function getTaxId()
    {
        return isset($this->taxId) ? $this->taxId : null;
    }
    /**
     * This method is responsible for validating the value passed to the setTaxId method
     * This method is willingly generated in order to preserve the one-line inline validation within the setTaxId method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateTaxIdForChoiceConstraintsFromSetTaxId($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'surname',
            'firstName',
            'middleName',
            'birthPlace',
            'insuranceId',
            'address',
            'citizenship',
            'passport',
            'otherDocument',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property taxId can\'t be set as the property %s is already set. Only one property must be set among these properties: taxId, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set taxId value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param string $taxId
     * @return \StructType\PersonAddParms
     */
    public function setTaxId($taxId = null)
    {
        // validation for constraint: string
        if (!is_null($taxId) && !is_string($taxId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($taxId, true), gettype($taxId)), __LINE__);
        }
        // validation for constraint: choice(surname, firstName, middleName, birthPlace, taxId, insuranceId, address, citizenship, passport, otherDocument)
        if ('' !== ($taxIdChoiceErrorMessage = self::validateTaxIdForChoiceConstraintsFromSetTaxId($taxId))) {
            throw new \InvalidArgumentException($taxIdChoiceErrorMessage, __LINE__);
        }
        if (is_null($taxId) || (is_array($taxId) && empty($taxId))) {
            unset($this->taxId);
        } else {
            $this->taxId = $taxId;
        }
        return $this;
    }
    /**
     * Get insuranceId value
     * @return string|null
     */
    public function getInsuranceId()
    {
        return isset($this->insuranceId) ? $this->insuranceId : null;
    }
    /**
     * This method is responsible for validating the value passed to the setInsuranceId method
     * This method is willingly generated in order to preserve the one-line inline validation within the setInsuranceId method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateInsuranceIdForChoiceConstraintsFromSetInsuranceId($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'surname',
            'firstName',
            'middleName',
            'birthPlace',
            'taxId',
            'address',
            'citizenship',
            'passport',
            'otherDocument',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property insuranceId can\'t be set as the property %s is already set. Only one property must be set among these properties: insuranceId, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set insuranceId value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param string $insuranceId
     * @return \StructType\PersonAddParms
     */
    public function setInsuranceId($insuranceId = null)
    {
        // validation for constraint: string
        if (!is_null($insuranceId) && !is_string($insuranceId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($insuranceId, true), gettype($insuranceId)), __LINE__);
        }
        // validation for constraint: choice(surname, firstName, middleName, birthPlace, taxId, insuranceId, address, citizenship, passport, otherDocument)
        if ('' !== ($insuranceIdChoiceErrorMessage = self::validateInsuranceIdForChoiceConstraintsFromSetInsuranceId($insuranceId))) {
            throw new \InvalidArgumentException($insuranceIdChoiceErrorMessage, __LINE__);
        }
        if (is_null($insuranceId) || (is_array($insuranceId) && empty($insuranceId))) {
            unset($this->insuranceId);
        } else {
            $this->insuranceId = $insuranceId;
        }
        return $this;
    }
    /**
     * Get address value
     * @return string|null
     */
    public function getAddress()
    {
        return isset($this->address) ? $this->address : null;
    }
    /**
     * This method is responsible for validating the value passed to the setAddress method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAddress method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateAddressForChoiceConstraintsFromSetAddress($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'surname',
            'firstName',
            'middleName',
            'birthPlace',
            'taxId',
            'insuranceId',
            'citizenship',
            'passport',
            'otherDocument',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property address can\'t be set as the property %s is already set. Only one property must be set among these properties: address, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set address value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param string $address
     * @return \StructType\PersonAddParms
     */
    public function setAddress($address = null)
    {
        // validation for constraint: string
        if (!is_null($address) && !is_string($address)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($address, true), gettype($address)), __LINE__);
        }
        // validation for constraint: choice(surname, firstName, middleName, birthPlace, taxId, insuranceId, address, citizenship, passport, otherDocument)
        if ('' !== ($addressChoiceErrorMessage = self::validateAddressForChoiceConstraintsFromSetAddress($address))) {
            throw new \InvalidArgumentException($addressChoiceErrorMessage, __LINE__);
        }
        if (is_null($address) || (is_array($address) && empty($address))) {
            unset($this->address);
        } else {
            $this->address = $address;
        }
        return $this;
    }
    /**
     * Get citizenship value
     * @return string|null
     */
    public function getCitizenship()
    {
        return isset($this->citizenship) ? $this->citizenship : null;
    }
    /**
     * This method is responsible for validating the value passed to the setCitizenship method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCitizenship method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateCitizenshipForChoiceConstraintsFromSetCitizenship($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'surname',
            'firstName',
            'middleName',
            'birthPlace',
            'taxId',
            'insuranceId',
            'address',
            'passport',
            'otherDocument',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property citizenship can\'t be set as the property %s is already set. Only one property must be set among these properties: citizenship, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set citizenship value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param string $citizenship
     * @return \StructType\PersonAddParms
     */
    public function setCitizenship($citizenship = null)
    {
        // validation for constraint: string
        if (!is_null($citizenship) && !is_string($citizenship)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($citizenship, true), gettype($citizenship)), __LINE__);
        }
        // validation for constraint: choice(surname, firstName, middleName, birthPlace, taxId, insuranceId, address, citizenship, passport, otherDocument)
        if ('' !== ($citizenshipChoiceErrorMessage = self::validateCitizenshipForChoiceConstraintsFromSetCitizenship($citizenship))) {
            throw new \InvalidArgumentException($citizenshipChoiceErrorMessage, __LINE__);
        }
        if (is_null($citizenship) || (is_array($citizenship) && empty($citizenship))) {
            unset($this->citizenship);
        } else {
            $this->citizenship = $citizenship;
        }
        return $this;
    }
    /**
     * Get passport value
     * @return \StructType\Passport|null
     */
    public function getPassport()
    {
        return isset($this->passport) ? $this->passport : null;
    }
    /**
     * This method is responsible for validating the value passed to the setPassport method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPassport method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validatePassportForChoiceConstraintsFromSetPassport($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'surname',
            'firstName',
            'middleName',
            'birthPlace',
            'taxId',
            'insuranceId',
            'address',
            'citizenship',
            'otherDocument',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property passport can\'t be set as the property %s is already set. Only one property must be set among these properties: passport, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set passport value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\Passport $passport
     * @return \StructType\PersonAddParms
     */
    public function setPassport(\StructType\Passport $passport = null)
    {
        // validation for constraint: choice(surname, firstName, middleName, birthPlace, taxId, insuranceId, address, citizenship, passport, otherDocument)
        if ('' !== ($passportChoiceErrorMessage = self::validatePassportForChoiceConstraintsFromSetPassport($passport))) {
            throw new \InvalidArgumentException($passportChoiceErrorMessage, __LINE__);
        }
        if (is_null($passport) || (is_array($passport) && empty($passport))) {
            unset($this->passport);
        } else {
            $this->passport = $passport;
        }
        return $this;
    }
    /**
     * Get otherDocument value
     * @return \StructType\OtherDocument|null
     */
    public function getOtherDocument()
    {
        return isset($this->otherDocument) ? $this->otherDocument : null;
    }
    /**
     * This method is responsible for validating the value passed to the setOtherDocument method
     * This method is willingly generated in order to preserve the one-line inline validation within the setOtherDocument method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateOtherDocumentForChoiceConstraintsFromSetOtherDocument($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'surname',
            'firstName',
            'middleName',
            'birthPlace',
            'taxId',
            'insuranceId',
            'address',
            'citizenship',
            'passport',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property otherDocument can\'t be set as the property %s is already set. Only one property must be set among these properties: otherDocument, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set otherDocument value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\OtherDocument $otherDocument
     * @return \StructType\PersonAddParms
     */
    public function setOtherDocument(\StructType\OtherDocument $otherDocument = null)
    {
        // validation for constraint: choice(surname, firstName, middleName, birthPlace, taxId, insuranceId, address, citizenship, passport, otherDocument)
        if ('' !== ($otherDocumentChoiceErrorMessage = self::validateOtherDocumentForChoiceConstraintsFromSetOtherDocument($otherDocument))) {
            throw new \InvalidArgumentException($otherDocumentChoiceErrorMessage, __LINE__);
        }
        if (is_null($otherDocument) || (is_array($otherDocument) && empty($otherDocument))) {
            unset($this->otherDocument);
        } else {
            $this->otherDocument = $otherDocument;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\PersonAddParms
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
