<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Passport StructType
 * @subpackage Structs
 */
class Passport extends AbstractStructBase
{
    /**
     * The series
     * Meta information extracted from the WSDL
     * - choice: series | number | subcode | issuePlace | issueDate
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * @var string
     */
    public $series;
    /**
     * The number
     * Meta information extracted from the WSDL
     * - choice: series | number | subcode | issuePlace | issueDate
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * @var string
     */
    public $number;
    /**
     * The subcode
     * Meta information extracted from the WSDL
     * - choice: series | number | subcode | issuePlace | issueDate
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $subcode;
    /**
     * The issuePlace
     * Meta information extracted from the WSDL
     * - choice: series | number | subcode | issuePlace | issueDate
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $issuePlace;
    /**
     * The issueDate
     * Meta information extracted from the WSDL
     * - choice: series | number | subcode | issuePlace | issueDate
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $issueDate;
    /**
     * Constructor method for Passport
     * @uses Passport::setSeries()
     * @uses Passport::setNumber()
     * @uses Passport::setSubcode()
     * @uses Passport::setIssuePlace()
     * @uses Passport::setIssueDate()
     * @param string $series
     * @param string $number
     * @param string $subcode
     * @param string $issuePlace
     * @param string $issueDate
     */
    public function __construct($series = null, $number = null, $subcode = null, $issuePlace = null, $issueDate = null)
    {
        $this
            ->setSeries($series)
            ->setNumber($number)
            ->setSubcode($subcode)
            ->setIssuePlace($issuePlace)
            ->setIssueDate($issueDate);
    }
    /**
     * Get series value
     * @return string|null
     */
    public function getSeries()
    {
        return isset($this->series) ? $this->series : null;
    }
    /**
     * This method is responsible for validating the value passed to the setSeries method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSeries method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateSeriesForChoiceConstraintsFromSetSeries($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'number',
            'subcode',
            'issuePlace',
            'issueDate',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property series can\'t be set as the property %s is already set. Only one property must be set among these properties: series, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set series value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param string $series
     * @return \StructType\Passport
     */
    public function setSeries($series = null)
    {
        // validation for constraint: string
        if (!is_null($series) && !is_string($series)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($series, true), gettype($series)), __LINE__);
        }
        // validation for constraint: choice(series, number, subcode, issuePlace, issueDate)
        if ('' !== ($seriesChoiceErrorMessage = self::validateSeriesForChoiceConstraintsFromSetSeries($series))) {
            throw new \InvalidArgumentException($seriesChoiceErrorMessage, __LINE__);
        }
        if (is_null($series) || (is_array($series) && empty($series))) {
            unset($this->series);
        } else {
            $this->series = $series;
        }
        return $this;
    }
    /**
     * Get number value
     * @return string|null
     */
    public function getNumber()
    {
        return isset($this->number) ? $this->number : null;
    }
    /**
     * This method is responsible for validating the value passed to the setNumber method
     * This method is willingly generated in order to preserve the one-line inline validation within the setNumber method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateNumberForChoiceConstraintsFromSetNumber($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'series',
            'subcode',
            'issuePlace',
            'issueDate',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property number can\'t be set as the property %s is already set. Only one property must be set among these properties: number, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set number value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param string $number
     * @return \StructType\Passport
     */
    public function setNumber($number = null)
    {
        // validation for constraint: string
        if (!is_null($number) && !is_string($number)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($number, true), gettype($number)), __LINE__);
        }
        // validation for constraint: choice(series, number, subcode, issuePlace, issueDate)
        if ('' !== ($numberChoiceErrorMessage = self::validateNumberForChoiceConstraintsFromSetNumber($number))) {
            throw new \InvalidArgumentException($numberChoiceErrorMessage, __LINE__);
        }
        if (is_null($number) || (is_array($number) && empty($number))) {
            unset($this->number);
        } else {
            $this->number = $number;
        }
        return $this;
    }
    /**
     * Get subcode value
     * @return string|null
     */
    public function getSubcode()
    {
        return isset($this->subcode) ? $this->subcode : null;
    }
    /**
     * This method is responsible for validating the value passed to the setSubcode method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSubcode method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateSubcodeForChoiceConstraintsFromSetSubcode($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'series',
            'number',
            'issuePlace',
            'issueDate',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property subcode can\'t be set as the property %s is already set. Only one property must be set among these properties: subcode, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set subcode value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param string $subcode
     * @return \StructType\Passport
     */
    public function setSubcode($subcode = null)
    {
        // validation for constraint: string
        if (!is_null($subcode) && !is_string($subcode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($subcode, true), gettype($subcode)), __LINE__);
        }
        // validation for constraint: choice(series, number, subcode, issuePlace, issueDate)
        if ('' !== ($subcodeChoiceErrorMessage = self::validateSubcodeForChoiceConstraintsFromSetSubcode($subcode))) {
            throw new \InvalidArgumentException($subcodeChoiceErrorMessage, __LINE__);
        }
        if (is_null($subcode) || (is_array($subcode) && empty($subcode))) {
            unset($this->subcode);
        } else {
            $this->subcode = $subcode;
        }
        return $this;
    }
    /**
     * Get issuePlace value
     * @return string|null
     */
    public function getIssuePlace()
    {
        return isset($this->issuePlace) ? $this->issuePlace : null;
    }
    /**
     * This method is responsible for validating the value passed to the setIssuePlace method
     * This method is willingly generated in order to preserve the one-line inline validation within the setIssuePlace method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateIssuePlaceForChoiceConstraintsFromSetIssuePlace($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'series',
            'number',
            'subcode',
            'issueDate',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property issuePlace can\'t be set as the property %s is already set. Only one property must be set among these properties: issuePlace, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set issuePlace value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param string $issuePlace
     * @return \StructType\Passport
     */
    public function setIssuePlace($issuePlace = null)
    {
        // validation for constraint: string
        if (!is_null($issuePlace) && !is_string($issuePlace)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($issuePlace, true), gettype($issuePlace)), __LINE__);
        }
        // validation for constraint: choice(series, number, subcode, issuePlace, issueDate)
        if ('' !== ($issuePlaceChoiceErrorMessage = self::validateIssuePlaceForChoiceConstraintsFromSetIssuePlace($issuePlace))) {
            throw new \InvalidArgumentException($issuePlaceChoiceErrorMessage, __LINE__);
        }
        if (is_null($issuePlace) || (is_array($issuePlace) && empty($issuePlace))) {
            unset($this->issuePlace);
        } else {
            $this->issuePlace = $issuePlace;
        }
        return $this;
    }
    /**
     * Get issueDate value
     * @return string|null
     */
    public function getIssueDate()
    {
        return isset($this->issueDate) ? $this->issueDate : null;
    }
    /**
     * This method is responsible for validating the value passed to the setIssueDate method
     * This method is willingly generated in order to preserve the one-line inline validation within the setIssueDate method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateIssueDateForChoiceConstraintsFromSetIssueDate($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'series',
            'number',
            'subcode',
            'issuePlace',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property issueDate can\'t be set as the property %s is already set. Only one property must be set among these properties: issueDate, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set issueDate value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param string $issueDate
     * @return \StructType\Passport
     */
    public function setIssueDate($issueDate = null)
    {
        // validation for constraint: string
        if (!is_null($issueDate) && !is_string($issueDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($issueDate, true), gettype($issueDate)), __LINE__);
        }
        // validation for constraint: choice(series, number, subcode, issuePlace, issueDate)
        if ('' !== ($issueDateChoiceErrorMessage = self::validateIssueDateForChoiceConstraintsFromSetIssueDate($issueDate))) {
            throw new \InvalidArgumentException($issueDateChoiceErrorMessage, __LINE__);
        }
        if (is_null($issueDate) || (is_array($issueDate) && empty($issueDate))) {
            unset($this->issueDate);
        } else {
            $this->issueDate = $issueDate;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Passport
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
