<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for InsuredPersonParms StructType
 * @subpackage Structs
 */
class InsuredPersonParms extends AbstractStructBase
{
    /**
     * The birthDate
     * Meta information extracted from the WSDL
     * - choice: birthDate | cancellationAmount | currency | itemDescription | itemId | itemName | name | personAdd | pin | sex | supplementaries | surname | tariff
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * @var string
     */
    public $birthDate;
    /**
     * The cancellationAmount
     * Meta information extracted from the WSDL
     * - choice: birthDate | cancellationAmount | currency | itemDescription | itemId | itemName | name | personAdd | pin | sex | supplementaries | surname | tariff
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - minOccurs: 0
     * @var float
     */
    public $cancellationAmount;
    /**
     * The currency
     * Meta information extracted from the WSDL
     * - choice: birthDate | cancellationAmount | currency | itemDescription | itemId | itemName | name | personAdd | pin | sex | supplementaries | surname | tariff
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $currency;
    /**
     * The itemDescription
     * Meta information extracted from the WSDL
     * - choice: birthDate | cancellationAmount | currency | itemDescription | itemId | itemName | name | personAdd | pin | sex | supplementaries | surname | tariff
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $itemDescription;
    /**
     * The itemId
     * Meta information extracted from the WSDL
     * - choice: birthDate | cancellationAmount | currency | itemDescription | itemId | itemName | name | personAdd | pin | sex | supplementaries | surname | tariff
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $itemId;
    /**
     * The itemName
     * Meta information extracted from the WSDL
     * - choice: birthDate | cancellationAmount | currency | itemDescription | itemId | itemName | name | personAdd | pin | sex | supplementaries | surname | tariff
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $itemName;
    /**
     * The name
     * Meta information extracted from the WSDL
     * - choice: birthDate | cancellationAmount | currency | itemDescription | itemId | itemName | name | personAdd | pin | sex | supplementaries | surname | tariff
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $name;
    /**
     * The personAdd
     * Meta information extracted from the WSDL
     * - choice: birthDate | cancellationAmount | currency | itemDescription | itemId | itemName | name | personAdd | pin | sex | supplementaries | surname | tariff
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - minOccurs: 0
     * @var \StructType\PersonAddParms
     */
    public $personAdd;
    /**
     * The pin
     * Meta information extracted from the WSDL
     * - choice: birthDate | cancellationAmount | currency | itemDescription | itemId | itemName | name | personAdd | pin | sex | supplementaries | surname | tariff
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $pin;
    /**
     * The sex
     * Meta information extracted from the WSDL
     * - choice: birthDate | cancellationAmount | currency | itemDescription | itemId | itemName | name | personAdd | pin | sex | supplementaries | surname | tariff
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $sex;
    /**
     * The supplementaries
     * Meta information extracted from the WSDL
     * - choice: birthDate | cancellationAmount | currency | itemDescription | itemId | itemName | name | personAdd | pin | sex | supplementaries | surname | tariff
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Supplementaries
     */
    public $supplementaries;
    /**
     * The surname
     * Meta information extracted from the WSDL
     * - choice: birthDate | cancellationAmount | currency | itemDescription | itemId | itemName | name | personAdd | pin | sex | supplementaries | surname | tariff
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * @var string
     */
    public $surname;
    /**
     * The tariff
     * Meta information extracted from the WSDL
     * - choice: birthDate | cancellationAmount | currency | itemDescription | itemId | itemName | name | personAdd | pin | sex | supplementaries | surname | tariff
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * @var string
     */
    public $tariff;
    /**
     * Constructor method for InsuredPersonParms
     * @uses InsuredPersonParms::setBirthDate()
     * @uses InsuredPersonParms::setCancellationAmount()
     * @uses InsuredPersonParms::setCurrency()
     * @uses InsuredPersonParms::setItemDescription()
     * @uses InsuredPersonParms::setItemId()
     * @uses InsuredPersonParms::setItemName()
     * @uses InsuredPersonParms::setName()
     * @uses InsuredPersonParms::setPersonAdd()
     * @uses InsuredPersonParms::setPin()
     * @uses InsuredPersonParms::setSex()
     * @uses InsuredPersonParms::setSupplementaries()
     * @uses InsuredPersonParms::setSurname()
     * @uses InsuredPersonParms::setTariff()
     * @param string $birthDate
     * @param float $cancellationAmount
     * @param string $currency
     * @param string $itemDescription
     * @param string $itemId
     * @param string $itemName
     * @param string $name
     * @param \StructType\PersonAddParms $personAdd
     * @param string $pin
     * @param string $sex
     * @param \StructType\Supplementaries $supplementaries
     * @param string $surname
     * @param string $tariff
     */
    public function __construct($birthDate = null, $cancellationAmount = null, $currency = null, $itemDescription = null, $itemId = null, $itemName = null, $name = null, \StructType\PersonAddParms $personAdd = null, $pin = null, $sex = null, \StructType\Supplementaries $supplementaries = null, $surname = null, $tariff = null)
    {
        $this
            ->setBirthDate($birthDate)
            ->setCancellationAmount($cancellationAmount)
            ->setCurrency($currency)
            ->setItemDescription($itemDescription)
            ->setItemId($itemId)
            ->setItemName($itemName)
            ->setName($name)
            ->setPersonAdd($personAdd)
            ->setPin($pin)
            ->setSex($sex)
            ->setSupplementaries($supplementaries)
            ->setSurname($surname)
            ->setTariff($tariff);
    }
    /**
     * Get birthDate value
     * @return string|null
     */
    public function getBirthDate()
    {
        return isset($this->birthDate) ? $this->birthDate : null;
    }
    /**
     * This method is responsible for validating the value passed to the setBirthDate method
     * This method is willingly generated in order to preserve the one-line inline validation within the setBirthDate method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateBirthDateForChoiceConstraintsFromSetBirthDate($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'cancellationAmount',
            'currency',
            'itemDescription',
            'itemId',
            'itemName',
            'name',
            'personAdd',
            'pin',
            'sex',
            'supplementaries',
            'surname',
            'tariff',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property birthDate can\'t be set as the property %s is already set. Only one property must be set among these properties: birthDate, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set birthDate value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param string $birthDate
     * @return \StructType\InsuredPersonParms
     */
    public function setBirthDate($birthDate = null)
    {
        // validation for constraint: string
        if (!is_null($birthDate) && !is_string($birthDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($birthDate, true), gettype($birthDate)), __LINE__);
        }
        // validation for constraint: choice(birthDate, cancellationAmount, currency, itemDescription, itemId, itemName, name, personAdd, pin, sex, supplementaries, surname, tariff)
        if ('' !== ($birthDateChoiceErrorMessage = self::validateBirthDateForChoiceConstraintsFromSetBirthDate($birthDate))) {
            throw new \InvalidArgumentException($birthDateChoiceErrorMessage, __LINE__);
        }
        if (is_null($birthDate) || (is_array($birthDate) && empty($birthDate))) {
            unset($this->birthDate);
        } else {
            $this->birthDate = $birthDate;
        }
        return $this;
    }
    /**
     * Get cancellationAmount value
     * @return float|null
     */
    public function getCancellationAmount()
    {
        return isset($this->cancellationAmount) ? $this->cancellationAmount : null;
    }
    /**
     * This method is responsible for validating the value passed to the setCancellationAmount method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCancellationAmount method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateCancellationAmountForChoiceConstraintsFromSetCancellationAmount($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'birthDate',
            'currency',
            'itemDescription',
            'itemId',
            'itemName',
            'name',
            'personAdd',
            'pin',
            'sex',
            'supplementaries',
            'surname',
            'tariff',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property cancellationAmount can\'t be set as the property %s is already set. Only one property must be set among these properties: cancellationAmount, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set cancellationAmount value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param float $cancellationAmount
     * @return \StructType\InsuredPersonParms
     */
    public function setCancellationAmount($cancellationAmount = null)
    {
        // validation for constraint: float
        if (!is_null($cancellationAmount) && !(is_float($cancellationAmount) || is_numeric($cancellationAmount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($cancellationAmount, true), gettype($cancellationAmount)), __LINE__);
        }
        // validation for constraint: choice(birthDate, cancellationAmount, currency, itemDescription, itemId, itemName, name, personAdd, pin, sex, supplementaries, surname, tariff)
        if ('' !== ($cancellationAmountChoiceErrorMessage = self::validateCancellationAmountForChoiceConstraintsFromSetCancellationAmount($cancellationAmount))) {
            throw new \InvalidArgumentException($cancellationAmountChoiceErrorMessage, __LINE__);
        }
        if (is_null($cancellationAmount) || (is_array($cancellationAmount) && empty($cancellationAmount))) {
            unset($this->cancellationAmount);
        } else {
            $this->cancellationAmount = $cancellationAmount;
        }
        return $this;
    }
    /**
     * Get currency value
     * @return string|null
     */
    public function getCurrency()
    {
        return isset($this->currency) ? $this->currency : null;
    }
    /**
     * This method is responsible for validating the value passed to the setCurrency method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCurrency method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateCurrencyForChoiceConstraintsFromSetCurrency($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'birthDate',
            'cancellationAmount',
            'itemDescription',
            'itemId',
            'itemName',
            'name',
            'personAdd',
            'pin',
            'sex',
            'supplementaries',
            'surname',
            'tariff',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property currency can\'t be set as the property %s is already set. Only one property must be set among these properties: currency, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set currency value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param string $currency
     * @return \StructType\InsuredPersonParms
     */
    public function setCurrency($currency = null)
    {
        // validation for constraint: string
        if (!is_null($currency) && !is_string($currency)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($currency, true), gettype($currency)), __LINE__);
        }
        // validation for constraint: choice(birthDate, cancellationAmount, currency, itemDescription, itemId, itemName, name, personAdd, pin, sex, supplementaries, surname, tariff)
        if ('' !== ($currencyChoiceErrorMessage = self::validateCurrencyForChoiceConstraintsFromSetCurrency($currency))) {
            throw new \InvalidArgumentException($currencyChoiceErrorMessage, __LINE__);
        }
        if (is_null($currency) || (is_array($currency) && empty($currency))) {
            unset($this->currency);
        } else {
            $this->currency = $currency;
        }
        return $this;
    }
    /**
     * Get itemDescription value
     * @return string|null
     */
    public function getItemDescription()
    {
        return isset($this->itemDescription) ? $this->itemDescription : null;
    }
    /**
     * This method is responsible for validating the value passed to the setItemDescription method
     * This method is willingly generated in order to preserve the one-line inline validation within the setItemDescription method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateItemDescriptionForChoiceConstraintsFromSetItemDescription($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'birthDate',
            'cancellationAmount',
            'currency',
            'itemId',
            'itemName',
            'name',
            'personAdd',
            'pin',
            'sex',
            'supplementaries',
            'surname',
            'tariff',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property itemDescription can\'t be set as the property %s is already set. Only one property must be set among these properties: itemDescription, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set itemDescription value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param string $itemDescription
     * @return \StructType\InsuredPersonParms
     */
    public function setItemDescription($itemDescription = null)
    {
        // validation for constraint: string
        if (!is_null($itemDescription) && !is_string($itemDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($itemDescription, true), gettype($itemDescription)), __LINE__);
        }
        // validation for constraint: choice(birthDate, cancellationAmount, currency, itemDescription, itemId, itemName, name, personAdd, pin, sex, supplementaries, surname, tariff)
        if ('' !== ($itemDescriptionChoiceErrorMessage = self::validateItemDescriptionForChoiceConstraintsFromSetItemDescription($itemDescription))) {
            throw new \InvalidArgumentException($itemDescriptionChoiceErrorMessage, __LINE__);
        }
        if (is_null($itemDescription) || (is_array($itemDescription) && empty($itemDescription))) {
            unset($this->itemDescription);
        } else {
            $this->itemDescription = $itemDescription;
        }
        return $this;
    }
    /**
     * Get itemId value
     * @return string|null
     */
    public function getItemId()
    {
        return isset($this->itemId) ? $this->itemId : null;
    }
    /**
     * This method is responsible for validating the value passed to the setItemId method
     * This method is willingly generated in order to preserve the one-line inline validation within the setItemId method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateItemIdForChoiceConstraintsFromSetItemId($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'birthDate',
            'cancellationAmount',
            'currency',
            'itemDescription',
            'itemName',
            'name',
            'personAdd',
            'pin',
            'sex',
            'supplementaries',
            'surname',
            'tariff',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property itemId can\'t be set as the property %s is already set. Only one property must be set among these properties: itemId, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set itemId value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param string $itemId
     * @return \StructType\InsuredPersonParms
     */
    public function setItemId($itemId = null)
    {
        // validation for constraint: string
        if (!is_null($itemId) && !is_string($itemId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($itemId, true), gettype($itemId)), __LINE__);
        }
        // validation for constraint: choice(birthDate, cancellationAmount, currency, itemDescription, itemId, itemName, name, personAdd, pin, sex, supplementaries, surname, tariff)
        if ('' !== ($itemIdChoiceErrorMessage = self::validateItemIdForChoiceConstraintsFromSetItemId($itemId))) {
            throw new \InvalidArgumentException($itemIdChoiceErrorMessage, __LINE__);
        }
        if (is_null($itemId) || (is_array($itemId) && empty($itemId))) {
            unset($this->itemId);
        } else {
            $this->itemId = $itemId;
        }
        return $this;
    }
    /**
     * Get itemName value
     * @return string|null
     */
    public function getItemName()
    {
        return isset($this->itemName) ? $this->itemName : null;
    }
    /**
     * This method is responsible for validating the value passed to the setItemName method
     * This method is willingly generated in order to preserve the one-line inline validation within the setItemName method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateItemNameForChoiceConstraintsFromSetItemName($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'birthDate',
            'cancellationAmount',
            'currency',
            'itemDescription',
            'itemId',
            'name',
            'personAdd',
            'pin',
            'sex',
            'supplementaries',
            'surname',
            'tariff',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property itemName can\'t be set as the property %s is already set. Only one property must be set among these properties: itemName, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set itemName value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param string $itemName
     * @return \StructType\InsuredPersonParms
     */
    public function setItemName($itemName = null)
    {
        // validation for constraint: string
        if (!is_null($itemName) && !is_string($itemName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($itemName, true), gettype($itemName)), __LINE__);
        }
        // validation for constraint: choice(birthDate, cancellationAmount, currency, itemDescription, itemId, itemName, name, personAdd, pin, sex, supplementaries, surname, tariff)
        if ('' !== ($itemNameChoiceErrorMessage = self::validateItemNameForChoiceConstraintsFromSetItemName($itemName))) {
            throw new \InvalidArgumentException($itemNameChoiceErrorMessage, __LINE__);
        }
        if (is_null($itemName) || (is_array($itemName) && empty($itemName))) {
            unset($this->itemName);
        } else {
            $this->itemName = $itemName;
        }
        return $this;
    }
    /**
     * Get name value
     * @return string|null
     */
    public function getName()
    {
        return isset($this->name) ? $this->name : null;
    }
    /**
     * This method is responsible for validating the value passed to the setName method
     * This method is willingly generated in order to preserve the one-line inline validation within the setName method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateNameForChoiceConstraintsFromSetName($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'birthDate',
            'cancellationAmount',
            'currency',
            'itemDescription',
            'itemId',
            'itemName',
            'personAdd',
            'pin',
            'sex',
            'supplementaries',
            'surname',
            'tariff',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property name can\'t be set as the property %s is already set. Only one property must be set among these properties: name, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set name value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param string $name
     * @return \StructType\InsuredPersonParms
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        // validation for constraint: choice(birthDate, cancellationAmount, currency, itemDescription, itemId, itemName, name, personAdd, pin, sex, supplementaries, surname, tariff)
        if ('' !== ($nameChoiceErrorMessage = self::validateNameForChoiceConstraintsFromSetName($name))) {
            throw new \InvalidArgumentException($nameChoiceErrorMessage, __LINE__);
        }
        if (is_null($name) || (is_array($name) && empty($name))) {
            unset($this->name);
        } else {
            $this->name = $name;
        }
        return $this;
    }
    /**
     * Get personAdd value
     * @return \StructType\PersonAddParms|null
     */
    public function getPersonAdd()
    {
        return isset($this->personAdd) ? $this->personAdd : null;
    }
    /**
     * This method is responsible for validating the value passed to the setPersonAdd method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPersonAdd method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validatePersonAddForChoiceConstraintsFromSetPersonAdd($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'birthDate',
            'cancellationAmount',
            'currency',
            'itemDescription',
            'itemId',
            'itemName',
            'name',
            'pin',
            'sex',
            'supplementaries',
            'surname',
            'tariff',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property personAdd can\'t be set as the property %s is already set. Only one property must be set among these properties: personAdd, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set personAdd value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\PersonAddParms $personAdd
     * @return \StructType\InsuredPersonParms
     */
    public function setPersonAdd(\StructType\PersonAddParms $personAdd = null)
    {
        // validation for constraint: choice(birthDate, cancellationAmount, currency, itemDescription, itemId, itemName, name, personAdd, pin, sex, supplementaries, surname, tariff)
        if ('' !== ($personAddChoiceErrorMessage = self::validatePersonAddForChoiceConstraintsFromSetPersonAdd($personAdd))) {
            throw new \InvalidArgumentException($personAddChoiceErrorMessage, __LINE__);
        }
        if (is_null($personAdd) || (is_array($personAdd) && empty($personAdd))) {
            unset($this->personAdd);
        } else {
            $this->personAdd = $personAdd;
        }
        return $this;
    }
    /**
     * Get pin value
     * @return string|null
     */
    public function getPin()
    {
        return isset($this->pin) ? $this->pin : null;
    }
    /**
     * This method is responsible for validating the value passed to the setPin method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPin method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validatePinForChoiceConstraintsFromSetPin($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'birthDate',
            'cancellationAmount',
            'currency',
            'itemDescription',
            'itemId',
            'itemName',
            'name',
            'personAdd',
            'sex',
            'supplementaries',
            'surname',
            'tariff',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property pin can\'t be set as the property %s is already set. Only one property must be set among these properties: pin, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set pin value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param string $pin
     * @return \StructType\InsuredPersonParms
     */
    public function setPin($pin = null)
    {
        // validation for constraint: string
        if (!is_null($pin) && !is_string($pin)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pin, true), gettype($pin)), __LINE__);
        }
        // validation for constraint: choice(birthDate, cancellationAmount, currency, itemDescription, itemId, itemName, name, personAdd, pin, sex, supplementaries, surname, tariff)
        if ('' !== ($pinChoiceErrorMessage = self::validatePinForChoiceConstraintsFromSetPin($pin))) {
            throw new \InvalidArgumentException($pinChoiceErrorMessage, __LINE__);
        }
        if (is_null($pin) || (is_array($pin) && empty($pin))) {
            unset($this->pin);
        } else {
            $this->pin = $pin;
        }
        return $this;
    }
    /**
     * Get sex value
     * @return string|null
     */
    public function getSex()
    {
        return isset($this->sex) ? $this->sex : null;
    }
    /**
     * This method is responsible for validating the value passed to the setSex method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSex method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateSexForChoiceConstraintsFromSetSex($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'birthDate',
            'cancellationAmount',
            'currency',
            'itemDescription',
            'itemId',
            'itemName',
            'name',
            'personAdd',
            'pin',
            'supplementaries',
            'surname',
            'tariff',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property sex can\'t be set as the property %s is already set. Only one property must be set among these properties: sex, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set sex value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param string $sex
     * @return \StructType\InsuredPersonParms
     */
    public function setSex($sex = null)
    {
        // validation for constraint: string
        if (!is_null($sex) && !is_string($sex)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sex, true), gettype($sex)), __LINE__);
        }
        // validation for constraint: choice(birthDate, cancellationAmount, currency, itemDescription, itemId, itemName, name, personAdd, pin, sex, supplementaries, surname, tariff)
        if ('' !== ($sexChoiceErrorMessage = self::validateSexForChoiceConstraintsFromSetSex($sex))) {
            throw new \InvalidArgumentException($sexChoiceErrorMessage, __LINE__);
        }
        if (is_null($sex) || (is_array($sex) && empty($sex))) {
            unset($this->sex);
        } else {
            $this->sex = $sex;
        }
        return $this;
    }
    /**
     * Get supplementaries value
     * @return \StructType\Supplementaries|null
     */
    public function getSupplementaries()
    {
        return isset($this->supplementaries) ? $this->supplementaries : null;
    }
    /**
     * This method is responsible for validating the value passed to the setSupplementaries method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSupplementaries method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateSupplementariesForChoiceConstraintsFromSetSupplementaries($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'birthDate',
            'cancellationAmount',
            'currency',
            'itemDescription',
            'itemId',
            'itemName',
            'name',
            'personAdd',
            'pin',
            'sex',
            'surname',
            'tariff',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property supplementaries can\'t be set as the property %s is already set. Only one property must be set among these properties: supplementaries, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set supplementaries value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\Supplementaries $supplementaries
     * @return \StructType\InsuredPersonParms
     */
    public function setSupplementaries(\StructType\Supplementaries $supplementaries = null)
    {
        // validation for constraint: choice(birthDate, cancellationAmount, currency, itemDescription, itemId, itemName, name, personAdd, pin, sex, supplementaries, surname, tariff)
        if ('' !== ($supplementariesChoiceErrorMessage = self::validateSupplementariesForChoiceConstraintsFromSetSupplementaries($supplementaries))) {
            throw new \InvalidArgumentException($supplementariesChoiceErrorMessage, __LINE__);
        }
        if (is_null($supplementaries) || (is_array($supplementaries) && empty($supplementaries))) {
            unset($this->supplementaries);
        } else {
            $this->supplementaries = $supplementaries;
        }
        return $this;
    }
    /**
     * Get surname value
     * @return string|null
     */
    public function getSurname()
    {
        return isset($this->surname) ? $this->surname : null;
    }
    /**
     * This method is responsible for validating the value passed to the setSurname method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSurname method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateSurnameForChoiceConstraintsFromSetSurname($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'birthDate',
            'cancellationAmount',
            'currency',
            'itemDescription',
            'itemId',
            'itemName',
            'name',
            'personAdd',
            'pin',
            'sex',
            'supplementaries',
            'tariff',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property surname can\'t be set as the property %s is already set. Only one property must be set among these properties: surname, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set surname value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param string $surname
     * @return \StructType\InsuredPersonParms
     */
    public function setSurname($surname = null)
    {
        // validation for constraint: string
        if (!is_null($surname) && !is_string($surname)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($surname, true), gettype($surname)), __LINE__);
        }
        // validation for constraint: choice(birthDate, cancellationAmount, currency, itemDescription, itemId, itemName, name, personAdd, pin, sex, supplementaries, surname, tariff)
        if ('' !== ($surnameChoiceErrorMessage = self::validateSurnameForChoiceConstraintsFromSetSurname($surname))) {
            throw new \InvalidArgumentException($surnameChoiceErrorMessage, __LINE__);
        }
        if (is_null($surname) || (is_array($surname) && empty($surname))) {
            unset($this->surname);
        } else {
            $this->surname = $surname;
        }
        return $this;
    }
    /**
     * Get tariff value
     * @return string|null
     */
    public function getTariff()
    {
        return isset($this->tariff) ? $this->tariff : null;
    }
    /**
     * This method is responsible for validating the value passed to the setTariff method
     * This method is willingly generated in order to preserve the one-line inline validation within the setTariff method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateTariffForChoiceConstraintsFromSetTariff($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'birthDate',
            'cancellationAmount',
            'currency',
            'itemDescription',
            'itemId',
            'itemName',
            'name',
            'personAdd',
            'pin',
            'sex',
            'supplementaries',
            'surname',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property tariff can\'t be set as the property %s is already set. Only one property must be set among these properties: tariff, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set tariff value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param string $tariff
     * @return \StructType\InsuredPersonParms
     */
    public function setTariff($tariff = null)
    {
        // validation for constraint: string
        if (!is_null($tariff) && !is_string($tariff)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($tariff, true), gettype($tariff)), __LINE__);
        }
        // validation for constraint: choice(birthDate, cancellationAmount, currency, itemDescription, itemId, itemName, name, personAdd, pin, sex, supplementaries, surname, tariff)
        if ('' !== ($tariffChoiceErrorMessage = self::validateTariffForChoiceConstraintsFromSetTariff($tariff))) {
            throw new \InvalidArgumentException($tariffChoiceErrorMessage, __LINE__);
        }
        if (is_null($tariff) || (is_array($tariff) && empty($tariff))) {
            unset($this->tariff);
        } else {
            $this->tariff = $tariff;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\InsuredPersonParms
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
