<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for getProducts StructType
 * Meta information extracted from the WSDL
 * - type: tns:getProducts
 * @subpackage Structs
 */
class GetProducts extends AbstractStructBase
{
    /**
     * The uniqueId
     * @var string
     */
    public $uniqueId;
    /**
     * The productGroups
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $productGroups;
    /**
     * The startDate
     * @var string
     */
    public $startDate;
    /**
     * The insuredDays
     * @var int
     */
    public $insuredDays;
    /**
     * The region
     * @var string
     */
    public $region;
    /**
     * The insuredsCount
     * @var string
     */
    public $insuredsCount;
    /**
     * The tariffTypes
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $tariffTypes;
    /**
     * The cancellationAmount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $cancellationAmount;
    /**
     * The currency
     * @var string
     */
    public $currency;
    /**
     * The language
     * @var string
     */
    public $language;
    /**
     * The strictRegion
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $strictRegion;
    /**
     * Constructor method for getProducts
     * @uses GetProducts::setUniqueId()
     * @uses GetProducts::setProductGroups()
     * @uses GetProducts::setStartDate()
     * @uses GetProducts::setInsuredDays()
     * @uses GetProducts::setRegion()
     * @uses GetProducts::setInsuredsCount()
     * @uses GetProducts::setTariffTypes()
     * @uses GetProducts::setCancellationAmount()
     * @uses GetProducts::setCurrency()
     * @uses GetProducts::setLanguage()
     * @uses GetProducts::setStrictRegion()
     * @param string $uniqueId
     * @param string $productGroups
     * @param string $startDate
     * @param int $insuredDays
     * @param string $region
     * @param string $insuredsCount
     * @param string $tariffTypes
     * @param float $cancellationAmount
     * @param string $currency
     * @param string $language
     * @param bool $strictRegion
     */
    public function __construct($uniqueId = null, $productGroups = null, $startDate = null, $insuredDays = null, $region = null, $insuredsCount = null, $tariffTypes = null, $cancellationAmount = null, $currency = null, $language = null, $strictRegion = null)
    {
        $this
            ->setUniqueId($uniqueId)
            ->setProductGroups($productGroups)
            ->setStartDate($startDate)
            ->setInsuredDays($insuredDays)
            ->setRegion($region)
            ->setInsuredsCount($insuredsCount)
            ->setTariffTypes($tariffTypes)
            ->setCancellationAmount($cancellationAmount)
            ->setCurrency($currency)
            ->setLanguage($language)
            ->setStrictRegion($strictRegion);
    }
    /**
     * Get uniqueId value
     * @return string|null
     */
    public function getUniqueId()
    {
        return $this->uniqueId;
    }
    /**
     * Set uniqueId value
     * @param string $uniqueId
     * @return \StructType\GetProducts
     */
    public function setUniqueId($uniqueId = null)
    {
        // validation for constraint: string
        if (!is_null($uniqueId) && !is_string($uniqueId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($uniqueId, true), gettype($uniqueId)), __LINE__);
        }
        $this->uniqueId = $uniqueId;
        return $this;
    }
    /**
     * Get productGroups value
     * @return string|null
     */
    public function getProductGroups()
    {
        return $this->productGroups;
    }
    /**
     * Set productGroups value
     * @param string $productGroups
     * @return \StructType\GetProducts
     */
    public function setProductGroups($productGroups = null)
    {
        // validation for constraint: string
        if (!is_null($productGroups) && !is_string($productGroups)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($productGroups, true), gettype($productGroups)), __LINE__);
        }
        $this->productGroups = $productGroups;
        return $this;
    }
    /**
     * Get startDate value
     * @return string|null
     */
    public function getStartDate()
    {
        return $this->startDate;
    }
    /**
     * Set startDate value
     * @param string $startDate
     * @return \StructType\GetProducts
     */
    public function setStartDate($startDate = null)
    {
        // validation for constraint: string
        if (!is_null($startDate) && !is_string($startDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($startDate, true), gettype($startDate)), __LINE__);
        }
        $this->startDate = $startDate;
        return $this;
    }
    /**
     * Get insuredDays value
     * @return int|null
     */
    public function getInsuredDays()
    {
        return $this->insuredDays;
    }
    /**
     * Set insuredDays value
     * @param int $insuredDays
     * @return \StructType\GetProducts
     */
    public function setInsuredDays($insuredDays = null)
    {
        // validation for constraint: int
        if (!is_null($insuredDays) && !(is_int($insuredDays) || ctype_digit($insuredDays))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($insuredDays, true), gettype($insuredDays)), __LINE__);
        }
        $this->insuredDays = $insuredDays;
        return $this;
    }
    /**
     * Get region value
     * @return string|null
     */
    public function getRegion()
    {
        return $this->region;
    }
    /**
     * Set region value
     * @param string $region
     * @return \StructType\GetProducts
     */
    public function setRegion($region = null)
    {
        // validation for constraint: string
        if (!is_null($region) && !is_string($region)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($region, true), gettype($region)), __LINE__);
        }
        $this->region = $region;
        return $this;
    }
    /**
     * Get insuredsCount value
     * @return string|null
     */
    public function getInsuredsCount()
    {
        return $this->insuredsCount;
    }
    /**
     * Set insuredsCount value
     * @param string $insuredsCount
     * @return \StructType\GetProducts
     */
    public function setInsuredsCount($insuredsCount = null)
    {
        // validation for constraint: string
        if (!is_null($insuredsCount) && !is_string($insuredsCount)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($insuredsCount, true), gettype($insuredsCount)), __LINE__);
        }
        $this->insuredsCount = $insuredsCount;
        return $this;
    }
    /**
     * Get tariffTypes value
     * @return string|null
     */
    public function getTariffTypes()
    {
        return $this->tariffTypes;
    }
    /**
     * Set tariffTypes value
     * @param string $tariffTypes
     * @return \StructType\GetProducts
     */
    public function setTariffTypes($tariffTypes = null)
    {
        // validation for constraint: string
        if (!is_null($tariffTypes) && !is_string($tariffTypes)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($tariffTypes, true), gettype($tariffTypes)), __LINE__);
        }
        $this->tariffTypes = $tariffTypes;
        return $this;
    }
    /**
     * Get cancellationAmount value
     * @return float|null
     */
    public function getCancellationAmount()
    {
        return $this->cancellationAmount;
    }
    /**
     * Set cancellationAmount value
     * @param float $cancellationAmount
     * @return \StructType\GetProducts
     */
    public function setCancellationAmount($cancellationAmount = null)
    {
        // validation for constraint: float
        if (!is_null($cancellationAmount) && !(is_float($cancellationAmount) || is_numeric($cancellationAmount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($cancellationAmount, true), gettype($cancellationAmount)), __LINE__);
        }
        $this->cancellationAmount = $cancellationAmount;
        return $this;
    }
    /**
     * Get currency value
     * @return string|null
     */
    public function getCurrency()
    {
        return $this->currency;
    }
    /**
     * Set currency value
     * @param string $currency
     * @return \StructType\GetProducts
     */
    public function setCurrency($currency = null)
    {
        // validation for constraint: string
        if (!is_null($currency) && !is_string($currency)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($currency, true), gettype($currency)), __LINE__);
        }
        $this->currency = $currency;
        return $this;
    }
    /**
     * Get language value
     * @return string|null
     */
    public function getLanguage()
    {
        return $this->language;
    }
    /**
     * Set language value
     * @param string $language
     * @return \StructType\GetProducts
     */
    public function setLanguage($language = null)
    {
        // validation for constraint: string
        if (!is_null($language) && !is_string($language)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($language, true), gettype($language)), __LINE__);
        }
        $this->language = $language;
        return $this;
    }
    /**
     * Get strictRegion value
     * @return bool|null
     */
    public function getStrictRegion()
    {
        return $this->strictRegion;
    }
    /**
     * Set strictRegion value
     * @param bool $strictRegion
     * @return \StructType\GetProducts
     */
    public function setStrictRegion($strictRegion = null)
    {
        // validation for constraint: boolean
        if (!is_null($strictRegion) && !is_bool($strictRegion)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($strictRegion, true), gettype($strictRegion)), __LINE__);
        }
        $this->strictRegion = $strictRegion;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GetProducts
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
