<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for getPolicyAgreement StructType
 * Meta information extracted from the WSDL
 * - type: tns:getPolicyAgreement
 * @subpackage Structs
 */
class GetPolicyAgreement extends AbstractStructBase
{
    /**
     * The uniqueId
     * @var string
     */
    public $uniqueId;
    /**
     * The policyNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $policyNumber;
    /**
     * The policyRecId
     * @var string
     */
    public $policyRecId;
    /**
     * The language
     * @var string
     */
    public $language;
    /**
     * The specTemplateCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $specTemplateCode;
    /**
     * Constructor method for getPolicyAgreement
     * @uses GetPolicyAgreement::setUniqueId()
     * @uses GetPolicyAgreement::setPolicyNumber()
     * @uses GetPolicyAgreement::setPolicyRecId()
     * @uses GetPolicyAgreement::setLanguage()
     * @uses GetPolicyAgreement::setSpecTemplateCode()
     * @param string $uniqueId
     * @param int $policyNumber
     * @param string $policyRecId
     * @param string $language
     * @param string $specTemplateCode
     */
    public function __construct($uniqueId = null, $policyNumber = null, $policyRecId = null, $language = null, $specTemplateCode = null)
    {
        $this
            ->setUniqueId($uniqueId)
            ->setPolicyNumber($policyNumber)
            ->setPolicyRecId($policyRecId)
            ->setLanguage($language)
            ->setSpecTemplateCode($specTemplateCode);
    }
    /**
     * Get uniqueId value
     * @return string|null
     */
    public function getUniqueId()
    {
        return $this->uniqueId;
    }
    /**
     * Set uniqueId value
     * @param string $uniqueId
     * @return \StructType\GetPolicyAgreement
     */
    public function setUniqueId($uniqueId = null)
    {
        // validation for constraint: string
        if (!is_null($uniqueId) && !is_string($uniqueId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($uniqueId, true), gettype($uniqueId)), __LINE__);
        }
        $this->uniqueId = $uniqueId;
        return $this;
    }
    /**
     * Get policyNumber value
     * @return int|null
     */
    public function getPolicyNumber()
    {
        return $this->policyNumber;
    }
    /**
     * Set policyNumber value
     * @param int $policyNumber
     * @return \StructType\GetPolicyAgreement
     */
    public function setPolicyNumber($policyNumber = null)
    {
        // validation for constraint: int
        if (!is_null($policyNumber) && !(is_int($policyNumber) || ctype_digit($policyNumber))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($policyNumber, true), gettype($policyNumber)), __LINE__);
        }
        $this->policyNumber = $policyNumber;
        return $this;
    }
    /**
     * Get policyRecId value
     * @return string|null
     */
    public function getPolicyRecId()
    {
        return $this->policyRecId;
    }
    /**
     * Set policyRecId value
     * @param string $policyRecId
     * @return \StructType\GetPolicyAgreement
     */
    public function setPolicyRecId($policyRecId = null)
    {
        // validation for constraint: string
        if (!is_null($policyRecId) && !is_string($policyRecId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($policyRecId, true), gettype($policyRecId)), __LINE__);
        }
        $this->policyRecId = $policyRecId;
        return $this;
    }
    /**
     * Get language value
     * @return string|null
     */
    public function getLanguage()
    {
        return $this->language;
    }
    /**
     * Set language value
     * @param string $language
     * @return \StructType\GetPolicyAgreement
     */
    public function setLanguage($language = null)
    {
        // validation for constraint: string
        if (!is_null($language) && !is_string($language)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($language, true), gettype($language)), __LINE__);
        }
        $this->language = $language;
        return $this;
    }
    /**
     * Get specTemplateCode value
     * @return string|null
     */
    public function getSpecTemplateCode()
    {
        return $this->specTemplateCode;
    }
    /**
     * Set specTemplateCode value
     * @param string $specTemplateCode
     * @return \StructType\GetPolicyAgreement
     */
    public function setSpecTemplateCode($specTemplateCode = null)
    {
        // validation for constraint: string
        if (!is_null($specTemplateCode) && !is_string($specTemplateCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($specTemplateCode, true), gettype($specTemplateCode)), __LINE__);
        }
        $this->specTemplateCode = $specTemplateCode;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GetPolicyAgreement
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
