<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Get ServiceType
 * @subpackage Services
 */
class Get extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named getPolicyInfo
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetPolicyInfo $parameters
     * @return \StructType\GetPolicyInfoResponse|bool
     */
    public function getPolicyInfo(\StructType\GetPolicyInfo $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->getPolicyInfo($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getSuitableProductsOffer
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetSuitableProductsOffer $parameters
     * @return \StructType\GetSuitableProductsOfferResponse|bool
     */
    public function getSuitableProductsOffer(\StructType\GetSuitableProductsOffer $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->getSuitableProductsOffer($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getCheapestProduct
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetCheapestProduct $parameters
     * @return \StructType\GetCheapestProductResponse|bool
     */
    public function getCheapestProduct(\StructType\GetCheapestProduct $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->getCheapestProduct($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getPolicyAgreement
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetPolicyAgreement $parameters
     * @return \StructType\GetPolicyAgreementResponse|bool
     */
    public function getPolicyAgreement(\StructType\GetPolicyAgreement $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->getPolicyAgreement($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getCompleteProductsOffer
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetCompleteProductsOffer $parameters
     * @return \StructType\GetCompleteProductsOfferResponse|bool
     */
    public function getCompleteProductsOffer(\StructType\GetCompleteProductsOffer $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->getCompleteProductsOffer($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getSupplementariesOffer
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetSupplementariesOffer $parameters
     * @return \StructType\GetSupplementariesOfferResponse|bool
     */
    public function getSupplementariesOffer(\StructType\GetSupplementariesOffer $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->getSupplementariesOffer($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getPolicyList
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetPolicyList $parameters
     * @return \StructType\GetPolicyListResponse|bool
     */
    public function getPolicyList(\StructType\GetPolicyList $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->getPolicyList($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getProductsOffer
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetProductsOffer $parameters
     * @return \StructType\GetProductsOfferResponse|bool
     */
    public function getProductsOffer(\StructType\GetProductsOffer $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->getProductsOffer($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getProducts
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetProducts $parameters
     * @return \StructType\GetProductsResponse|bool
     */
    public function getProducts(\StructType\GetProducts $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->getProducts($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getRegions
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetRegions $parameters
     * @return \StructType\GetRegionsResponse|bool
     */
    public function getRegions(\StructType\GetRegions $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->getRegions($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\GetCheapestProductResponse|\StructType\GetCompleteProductsOfferResponse|\StructType\GetPolicyAgreementResponse|\StructType\GetPolicyInfoResponse|\StructType\GetPolicyListResponse|\StructType\GetProductsOfferResponse|\StructType\GetProductsResponse|\StructType\GetRegionsResponse|\StructType\GetSuitableProductsOfferResponse|\StructType\GetSupplementariesOfferResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
