<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Sifre ServiceType
 * @subpackage Services
 */
class Sifre extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named sifreDegistir
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\SifreDegistir $sifreDegistir
     * @return \StructType\SifreDegistirResponse|bool
     */
    public function sifreDegistir(\StructType\SifreDegistir $sifreDegistir)
    {
        try {
            $this->setResult($this->getSoapClient()->sifreDegistir($sifreDegistir));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\SifreDegistirResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
