<?php
/**
 * This file aims to show you how to use this generated package.
 * In addition, the goal is to show which methods are available and the fist needed parameter(s)
 * You have to use an associative array such as:
 * - the key must be a constant beginning with WSDL_ from AbstractSoapClientbase class each generated ServiceType class extends this class
 * - the value must be the corresponding key value (each option matches a {@link http://www.php.net/manual/en/soapclient.soapclient.php} option)
 * $options = array(
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'main.wsdl',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_TRACE => true,
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_LOGIN => 'you_secret_login',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_PASSWORD => 'you_secret_password',
 * );
 * etc....
 */
require_once __DIR__ . '/vendor/autoload.php';
/**
 * Minimal options
 */
$options = array(
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'main.wsdl',
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_CLASSMAP => ClassMap::get(),
);
/**
 * Samples for Giris ServiceType
 */
$giris = new \ServiceType\Giris($options);
/**
 * Sample call for girisWww operation/method
 */
if ($giris->girisWww(new \StructType\GirisWww()) !== false) {
    print_r($giris->getResult());
} else {
    print_r($giris->getLastError());
}
/**
 * Samples for Kare ServiceType
 */
$kare = new \ServiceType\Kare($options);
/**
 * Sample call for kareKodGiris operation/method
 */
if ($kare->kareKodGiris(new \StructType\KareKodGiris()) !== false) {
    print_r($kare->getResult());
} else {
    print_r($kare->getLastError());
}
/**
 * Samples for Sifre ServiceType
 */
$sifre = new \ServiceType\Sifre($options);
/**
 * Sample call for sifreDegistir operation/method
 */
if ($sifre->sifreDegistir(new \StructType\SifreDegistir()) !== false) {
    print_r($sifre->getResult());
} else {
    print_r($sifre->getLastError());
}
/**
 * Samples for Sonuc ServiceType
 */
$sonuc = new \ServiceType\Sonuc($options);
/**
 * Sample call for sonucRaporuAlWww operation/method
 */
if ($sonuc->sonucRaporuAlWww(new \StructType\SonucRaporuAlWww()) !== false) {
    print_r($sonuc->getResult());
} else {
    print_r($sonuc->getLastError());
}
