<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Kare ServiceType
 * @subpackage Services
 */
class Kare extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named kareKodGiris
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\KareKodGiris $kareKodGiris
     * @return \StructType\KareKodGirisResponse|bool
     */
    public function kareKodGiris(\StructType\KareKodGiris $kareKodGiris)
    {
        try {
            $this->setResult($this->getSoapClient()->kareKodGiris($kareKodGiris));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\KareKodGirisResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
