<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Giris ServiceType
 * @subpackage Services
 */
class Giris extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named girisWww
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GirisWww $girisWww
     * @return \StructType\GirisWwwResponse|bool
     */
    public function girisWww(\StructType\GirisWww $girisWww)
    {
        try {
            $this->setResult($this->getSoapClient()->girisWww($girisWww));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\GirisWwwResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
