<?php

namespace MediWayEMRService\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Save ServiceType
 * @subpackage Services
 */
class Save extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named ClinicSBPayInfoSave
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param ClinicSBPayInfoSave $clinicSBPayInfoSave
     * @return ClinicSBPayInfoSaveResponse|bool
     */
    public function ClinicSBPayInfoSave($clinicSBPayInfoSave)
    {
        try {
            $this->setResult($this->getSoapClient()->ClinicSBPayInfoSave($clinicSBPayInfoSave));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return ClinicSBPayInfoSaveResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
