<?php

namespace MediWayEMRService\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Info ServiceType
 * @subpackage Services
 */
class Info extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named ClinicGetSBRegInfo
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param ClinicGetSBRegInfo $clinicGetSBRegInfo
     * @return ClinicGetSBRegInfoResponse|bool
     */
    public function ClinicGetSBRegInfo($clinicGetSBRegInfo)
    {
        try {
            $this->setResult($this->getSoapClient()->ClinicGetSBRegInfo($clinicGetSBRegInfo));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named CancelClinicGetSBRegInfo
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param CancelClinicGetSBRegInfo $cancelClinicGetSBRegInfo
     * @return CancelClinicGetSBRegInfoResponse|bool
     */
    public function CancelClinicGetSBRegInfo($cancelClinicGetSBRegInfo)
    {
        try {
            $this->setResult($this->getSoapClient()->CancelClinicGetSBRegInfo($cancelClinicGetSBRegInfo));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return CancelClinicGetSBRegInfoResponse|ClinicGetSBRegInfoResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
