<?php

namespace MediWayEMRService\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for SBBH ServiceType
 * @subpackage Services
 */
class SBBH extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named GetSBInfoBySBBH
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param GetSBInfoBySBBH $getSBInfoBySBBH
     * @return GetSBInfoBySBBHResponse|bool
     */
    public function GetSBInfoBySBBH($getSBInfoBySBBH)
    {
        try {
            $this->setResult($this->getSoapClient()->GetSBInfoBySBBH($getSBInfoBySBBH));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return GetSBInfoBySBBHResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
