<?php

namespace MediWayEMRService\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Register ServiceType
 * @subpackage Services
 */
class Register extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named ClinicSBRegister
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param ClinicSBRegister $clinicSBRegister
     * @return ClinicSBRegisterResponse|bool
     */
    public function ClinicSBRegister($clinicSBRegister)
    {
        try {
            $this->setResult($this->getSoapClient()->ClinicSBRegister($clinicSBRegister));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named CancelClinicSBRegister
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param CancelClinicSBRegister $cancelClinicSBRegister
     * @return CancelClinicSBRegisterResponse|bool
     */
    public function CancelClinicSBRegister($cancelClinicSBRegister)
    {
        try {
            $this->setResult($this->getSoapClient()->CancelClinicSBRegister($cancelClinicSBRegister));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return CancelClinicSBRegisterResponse|ClinicSBRegisterResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
