<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Test ServiceType
 * @subpackage Services
 */
class Test extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named TestData
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\TestData $parameters
     * @return \StructType\TestDataResponse|bool
     */
    public function TestData(\StructType\TestData $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->TestData($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\TestDataResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
