<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfSample ArrayType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:ArrayOfSample
 * @subpackage Arrays
 */
class ArrayOfSample extends AbstractStructArrayBase
{
    /**
     * The Sample
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Sample[]
     */
    public $Sample;
    /**
     * Constructor method for ArrayOfSample
     * @uses ArrayOfSample::setSample()
     * @param \StructType\Sample[] $sample
     */
    public function __construct(array $sample = array())
    {
        $this
            ->setSample($sample);
    }
    /**
     * Get Sample value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Sample[]|null
     */
    public function getSample()
    {
        return isset($this->Sample) ? $this->Sample : null;
    }
    /**
     * This method is responsible for validating the values passed to the setSample method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSample method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSampleForArrayConstraintsFromSetSample(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfSampleSampleItem) {
            // validation for constraint: itemType
            if (!$arrayOfSampleSampleItem instanceof \StructType\Sample) {
                $invalidValues[] = is_object($arrayOfSampleSampleItem) ? get_class($arrayOfSampleSampleItem) : sprintf('%s(%s)', gettype($arrayOfSampleSampleItem), var_export($arrayOfSampleSampleItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Sample property can only contain items of type \StructType\Sample, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Sample value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\Sample[] $sample
     * @return \ArrayType\ArrayOfSample
     */
    public function setSample(array $sample = array())
    {
        // validation for constraint: array
        if ('' !== ($sampleArrayErrorMessage = self::validateSampleForArrayConstraintsFromSetSample($sample))) {
            throw new \InvalidArgumentException($sampleArrayErrorMessage, __LINE__);
        }
        if (is_null($sample) || (is_array($sample) && empty($sample))) {
            unset($this->Sample);
        } else {
            $this->Sample = $sample;
        }
        return $this;
    }
    /**
     * Add item to Sample value
     * @throws \InvalidArgumentException
     * @param \StructType\Sample $item
     * @return \ArrayType\ArrayOfSample
     */
    public function addToSample(\StructType\Sample $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Sample) {
            throw new \InvalidArgumentException(sprintf('The Sample property can only contain items of type \StructType\Sample, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Sample[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\Sample|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\Sample|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\Sample|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\Sample|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\Sample|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string Sample
     */
    public function getAttributeName()
    {
        return 'Sample';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfSample
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
