<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SampleAnalysis StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:SampleAnalysis
 * @subpackage Structs
 */
class SampleAnalysis extends AbstractStructBase
{
    /**
     * The AccreditamentoStabilimento
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $AccreditamentoStabilimento;
    /**
     * The Accreditato
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $Accreditato;
    /**
     * The AccreditatoFlessibile
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $AccreditatoFlessibile;
    /**
     * The CodiceCampione
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CodiceCampione;
    /**
     * The CodiceCas
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CodiceCas;
    /**
     * The CodiceCommento
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CodiceCommento;
    /**
     * The CodiceCommentoFisso
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CodiceCommentoFisso;
    /**
     * The CodiceDecretoLegge
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CodiceDecretoLegge;
    /**
     * The CodiceGruppo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CodiceGruppo;
    /**
     * The CodiceMacrogruppo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CodiceMacrogruppo;
    /**
     * The CodiceParametro
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CodiceParametro;
    /**
     * The CodiceReparto
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CodiceReparto;
    /**
     * The CodiceStabilimento
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CodiceStabilimento;
    /**
     * The Commento
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Commento;
    /**
     * The CommentoFisso
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CommentoFisso;
    /**
     * The DecretoLegge
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DecretoLegge;
    /**
     * The Esito
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Esito;
    /**
     * The FineAnalisi
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $FineAnalisi;
    /**
     * The Gruppo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Gruppo;
    /**
     * The GruppoRapporto
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $GruppoRapporto;
    /**
     * The IdCampione
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $IdCampione;
    /**
     * The IdDecretoLegge
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $IdDecretoLegge;
    /**
     * The IdGruppo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $IdGruppo;
    /**
     * The IdMetodo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $IdMetodo;
    /**
     * The IdNomeParametro
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $IdNomeParametro;
    /**
     * The IdParametro
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $IdParametro;
    /**
     * The IdReparto
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $IdReparto;
    /**
     * The IdUnitaMisura
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $IdUnitaMisura;
    /**
     * The IncertezzaStampaNumerica
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $IncertezzaStampaNumerica;
    /**
     * The IncertezzaStampaTestuale
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $IncertezzaStampaTestuale;
    /**
     * The IncertezzaStampaTipo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $IncertezzaStampaTipo;
    /**
     * The InizioAnalisi
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $InizioAnalisi;
    /**
     * The LegendaStabilimento
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $LegendaStabilimento;
    /**
     * The LegendaStabilimentoAccreditati
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $LegendaStabilimentoAccreditati;
    /**
     * The LegendaUnitaMisura
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $LegendaUnitaMisura;
    /**
     * The LimiteMinimo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $LimiteMinimo;
    /**
     * The LimiteQuantificazione
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $LimiteQuantificazione;
    /**
     * The LimitiCliente
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $LimitiCliente;
    /**
     * The LimitiDiLegge
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $LimitiDiLegge;
    /**
     * The Macrogruppo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Macrogruppo;
    /**
     * The MetodoCodiceAccreditato
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $MetodoCodiceAccreditato;
    /**
     * The MetodoCodiceISO
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $MetodoCodiceISO;
    /**
     * The MetodoRapporto
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $MetodoRapporto;
    /**
     * The MinimoRilevabile
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $MinimoRilevabile;
    /**
     * The NotaIncertezzaMetodo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $NotaIncertezzaMetodo;
    /**
     * The NotaIncertezzaReparto
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $NotaIncertezzaReparto;
    /**
     * The Parametro
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Parametro;
    /**
     * The ParametroRapporto
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ParametroRapporto;
    /**
     * The Reparto
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Reparto;
    /**
     * The RisultatoPositivo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $RisultatoPositivo;
    /**
     * The RisultatoStampa
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $RisultatoStampa;
    /**
     * The Subappalto
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $Subappalto;
    /**
     * The TipoEsito
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $TipoEsito;
    /**
     * The UnitaMisura
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $UnitaMisura;
    /**
     * The UnitaMisuraRapporto
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $UnitaMisuraRapporto;
    /**
     * Constructor method for SampleAnalysis
     * @uses SampleAnalysis::setAccreditamentoStabilimento()
     * @uses SampleAnalysis::setAccreditato()
     * @uses SampleAnalysis::setAccreditatoFlessibile()
     * @uses SampleAnalysis::setCodiceCampione()
     * @uses SampleAnalysis::setCodiceCas()
     * @uses SampleAnalysis::setCodiceCommento()
     * @uses SampleAnalysis::setCodiceCommentoFisso()
     * @uses SampleAnalysis::setCodiceDecretoLegge()
     * @uses SampleAnalysis::setCodiceGruppo()
     * @uses SampleAnalysis::setCodiceMacrogruppo()
     * @uses SampleAnalysis::setCodiceParametro()
     * @uses SampleAnalysis::setCodiceReparto()
     * @uses SampleAnalysis::setCodiceStabilimento()
     * @uses SampleAnalysis::setCommento()
     * @uses SampleAnalysis::setCommentoFisso()
     * @uses SampleAnalysis::setDecretoLegge()
     * @uses SampleAnalysis::setEsito()
     * @uses SampleAnalysis::setFineAnalisi()
     * @uses SampleAnalysis::setGruppo()
     * @uses SampleAnalysis::setGruppoRapporto()
     * @uses SampleAnalysis::setIdCampione()
     * @uses SampleAnalysis::setIdDecretoLegge()
     * @uses SampleAnalysis::setIdGruppo()
     * @uses SampleAnalysis::setIdMetodo()
     * @uses SampleAnalysis::setIdNomeParametro()
     * @uses SampleAnalysis::setIdParametro()
     * @uses SampleAnalysis::setIdReparto()
     * @uses SampleAnalysis::setIdUnitaMisura()
     * @uses SampleAnalysis::setIncertezzaStampaNumerica()
     * @uses SampleAnalysis::setIncertezzaStampaTestuale()
     * @uses SampleAnalysis::setIncertezzaStampaTipo()
     * @uses SampleAnalysis::setInizioAnalisi()
     * @uses SampleAnalysis::setLegendaStabilimento()
     * @uses SampleAnalysis::setLegendaStabilimentoAccreditati()
     * @uses SampleAnalysis::setLegendaUnitaMisura()
     * @uses SampleAnalysis::setLimiteMinimo()
     * @uses SampleAnalysis::setLimiteQuantificazione()
     * @uses SampleAnalysis::setLimitiCliente()
     * @uses SampleAnalysis::setLimitiDiLegge()
     * @uses SampleAnalysis::setMacrogruppo()
     * @uses SampleAnalysis::setMetodoCodiceAccreditato()
     * @uses SampleAnalysis::setMetodoCodiceISO()
     * @uses SampleAnalysis::setMetodoRapporto()
     * @uses SampleAnalysis::setMinimoRilevabile()
     * @uses SampleAnalysis::setNotaIncertezzaMetodo()
     * @uses SampleAnalysis::setNotaIncertezzaReparto()
     * @uses SampleAnalysis::setParametro()
     * @uses SampleAnalysis::setParametroRapporto()
     * @uses SampleAnalysis::setReparto()
     * @uses SampleAnalysis::setRisultatoPositivo()
     * @uses SampleAnalysis::setRisultatoStampa()
     * @uses SampleAnalysis::setSubappalto()
     * @uses SampleAnalysis::setTipoEsito()
     * @uses SampleAnalysis::setUnitaMisura()
     * @uses SampleAnalysis::setUnitaMisuraRapporto()
     * @param string $accreditamentoStabilimento
     * @param bool $accreditato
     * @param bool $accreditatoFlessibile
     * @param string $codiceCampione
     * @param string $codiceCas
     * @param string $codiceCommento
     * @param string $codiceCommentoFisso
     * @param string $codiceDecretoLegge
     * @param string $codiceGruppo
     * @param string $codiceMacrogruppo
     * @param string $codiceParametro
     * @param string $codiceReparto
     * @param string $codiceStabilimento
     * @param string $commento
     * @param string $commentoFisso
     * @param string $decretoLegge
     * @param string $esito
     * @param string $fineAnalisi
     * @param string $gruppo
     * @param string $gruppoRapporto
     * @param int $idCampione
     * @param int $idDecretoLegge
     * @param int $idGruppo
     * @param int $idMetodo
     * @param int $idNomeParametro
     * @param int $idParametro
     * @param int $idReparto
     * @param int $idUnitaMisura
     * @param float $incertezzaStampaNumerica
     * @param string $incertezzaStampaTestuale
     * @param int $incertezzaStampaTipo
     * @param string $inizioAnalisi
     * @param string $legendaStabilimento
     * @param string $legendaStabilimentoAccreditati
     * @param string $legendaUnitaMisura
     * @param string $limiteMinimo
     * @param string $limiteQuantificazione
     * @param string $limitiCliente
     * @param string $limitiDiLegge
     * @param string $macrogruppo
     * @param string $metodoCodiceAccreditato
     * @param string $metodoCodiceISO
     * @param string $metodoRapporto
     * @param string $minimoRilevabile
     * @param string $notaIncertezzaMetodo
     * @param string $notaIncertezzaReparto
     * @param string $parametro
     * @param string $parametroRapporto
     * @param string $reparto
     * @param bool $risultatoPositivo
     * @param string $risultatoStampa
     * @param bool $subappalto
     * @param string $tipoEsito
     * @param string $unitaMisura
     * @param string $unitaMisuraRapporto
     */
    public function __construct($accreditamentoStabilimento = null, $accreditato = null, $accreditatoFlessibile = null, $codiceCampione = null, $codiceCas = null, $codiceCommento = null, $codiceCommentoFisso = null, $codiceDecretoLegge = null, $codiceGruppo = null, $codiceMacrogruppo = null, $codiceParametro = null, $codiceReparto = null, $codiceStabilimento = null, $commento = null, $commentoFisso = null, $decretoLegge = null, $esito = null, $fineAnalisi = null, $gruppo = null, $gruppoRapporto = null, $idCampione = null, $idDecretoLegge = null, $idGruppo = null, $idMetodo = null, $idNomeParametro = null, $idParametro = null, $idReparto = null, $idUnitaMisura = null, $incertezzaStampaNumerica = null, $incertezzaStampaTestuale = null, $incertezzaStampaTipo = null, $inizioAnalisi = null, $legendaStabilimento = null, $legendaStabilimentoAccreditati = null, $legendaUnitaMisura = null, $limiteMinimo = null, $limiteQuantificazione = null, $limitiCliente = null, $limitiDiLegge = null, $macrogruppo = null, $metodoCodiceAccreditato = null, $metodoCodiceISO = null, $metodoRapporto = null, $minimoRilevabile = null, $notaIncertezzaMetodo = null, $notaIncertezzaReparto = null, $parametro = null, $parametroRapporto = null, $reparto = null, $risultatoPositivo = null, $risultatoStampa = null, $subappalto = null, $tipoEsito = null, $unitaMisura = null, $unitaMisuraRapporto = null)
    {
        $this
            ->setAccreditamentoStabilimento($accreditamentoStabilimento)
            ->setAccreditato($accreditato)
            ->setAccreditatoFlessibile($accreditatoFlessibile)
            ->setCodiceCampione($codiceCampione)
            ->setCodiceCas($codiceCas)
            ->setCodiceCommento($codiceCommento)
            ->setCodiceCommentoFisso($codiceCommentoFisso)
            ->setCodiceDecretoLegge($codiceDecretoLegge)
            ->setCodiceGruppo($codiceGruppo)
            ->setCodiceMacrogruppo($codiceMacrogruppo)
            ->setCodiceParametro($codiceParametro)
            ->setCodiceReparto($codiceReparto)
            ->setCodiceStabilimento($codiceStabilimento)
            ->setCommento($commento)
            ->setCommentoFisso($commentoFisso)
            ->setDecretoLegge($decretoLegge)
            ->setEsito($esito)
            ->setFineAnalisi($fineAnalisi)
            ->setGruppo($gruppo)
            ->setGruppoRapporto($gruppoRapporto)
            ->setIdCampione($idCampione)
            ->setIdDecretoLegge($idDecretoLegge)
            ->setIdGruppo($idGruppo)
            ->setIdMetodo($idMetodo)
            ->setIdNomeParametro($idNomeParametro)
            ->setIdParametro($idParametro)
            ->setIdReparto($idReparto)
            ->setIdUnitaMisura($idUnitaMisura)
            ->setIncertezzaStampaNumerica($incertezzaStampaNumerica)
            ->setIncertezzaStampaTestuale($incertezzaStampaTestuale)
            ->setIncertezzaStampaTipo($incertezzaStampaTipo)
            ->setInizioAnalisi($inizioAnalisi)
            ->setLegendaStabilimento($legendaStabilimento)
            ->setLegendaStabilimentoAccreditati($legendaStabilimentoAccreditati)
            ->setLegendaUnitaMisura($legendaUnitaMisura)
            ->setLimiteMinimo($limiteMinimo)
            ->setLimiteQuantificazione($limiteQuantificazione)
            ->setLimitiCliente($limitiCliente)
            ->setLimitiDiLegge($limitiDiLegge)
            ->setMacrogruppo($macrogruppo)
            ->setMetodoCodiceAccreditato($metodoCodiceAccreditato)
            ->setMetodoCodiceISO($metodoCodiceISO)
            ->setMetodoRapporto($metodoRapporto)
            ->setMinimoRilevabile($minimoRilevabile)
            ->setNotaIncertezzaMetodo($notaIncertezzaMetodo)
            ->setNotaIncertezzaReparto($notaIncertezzaReparto)
            ->setParametro($parametro)
            ->setParametroRapporto($parametroRapporto)
            ->setReparto($reparto)
            ->setRisultatoPositivo($risultatoPositivo)
            ->setRisultatoStampa($risultatoStampa)
            ->setSubappalto($subappalto)
            ->setTipoEsito($tipoEsito)
            ->setUnitaMisura($unitaMisura)
            ->setUnitaMisuraRapporto($unitaMisuraRapporto);
    }
    /**
     * Get AccreditamentoStabilimento value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAccreditamentoStabilimento()
    {
        return isset($this->AccreditamentoStabilimento) ? $this->AccreditamentoStabilimento : null;
    }
    /**
     * Set AccreditamentoStabilimento value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $accreditamentoStabilimento
     * @return \StructType\SampleAnalysis
     */
    public function setAccreditamentoStabilimento($accreditamentoStabilimento = null)
    {
        // validation for constraint: string
        if (!is_null($accreditamentoStabilimento) && !is_string($accreditamentoStabilimento)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($accreditamentoStabilimento, true), gettype($accreditamentoStabilimento)), __LINE__);
        }
        if (is_null($accreditamentoStabilimento) || (is_array($accreditamentoStabilimento) && empty($accreditamentoStabilimento))) {
            unset($this->AccreditamentoStabilimento);
        } else {
            $this->AccreditamentoStabilimento = $accreditamentoStabilimento;
        }
        return $this;
    }
    /**
     * Get Accreditato value
     * @return bool|null
     */
    public function getAccreditato()
    {
        return $this->Accreditato;
    }
    /**
     * Set Accreditato value
     * @param bool $accreditato
     * @return \StructType\SampleAnalysis
     */
    public function setAccreditato($accreditato = null)
    {
        // validation for constraint: boolean
        if (!is_null($accreditato) && !is_bool($accreditato)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($accreditato, true), gettype($accreditato)), __LINE__);
        }
        $this->Accreditato = $accreditato;
        return $this;
    }
    /**
     * Get AccreditatoFlessibile value
     * @return bool|null
     */
    public function getAccreditatoFlessibile()
    {
        return $this->AccreditatoFlessibile;
    }
    /**
     * Set AccreditatoFlessibile value
     * @param bool $accreditatoFlessibile
     * @return \StructType\SampleAnalysis
     */
    public function setAccreditatoFlessibile($accreditatoFlessibile = null)
    {
        // validation for constraint: boolean
        if (!is_null($accreditatoFlessibile) && !is_bool($accreditatoFlessibile)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($accreditatoFlessibile, true), gettype($accreditatoFlessibile)), __LINE__);
        }
        $this->AccreditatoFlessibile = $accreditatoFlessibile;
        return $this;
    }
    /**
     * Get CodiceCampione value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCodiceCampione()
    {
        return isset($this->CodiceCampione) ? $this->CodiceCampione : null;
    }
    /**
     * Set CodiceCampione value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $codiceCampione
     * @return \StructType\SampleAnalysis
     */
    public function setCodiceCampione($codiceCampione = null)
    {
        // validation for constraint: string
        if (!is_null($codiceCampione) && !is_string($codiceCampione)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($codiceCampione, true), gettype($codiceCampione)), __LINE__);
        }
        if (is_null($codiceCampione) || (is_array($codiceCampione) && empty($codiceCampione))) {
            unset($this->CodiceCampione);
        } else {
            $this->CodiceCampione = $codiceCampione;
        }
        return $this;
    }
    /**
     * Get CodiceCas value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCodiceCas()
    {
        return isset($this->CodiceCas) ? $this->CodiceCas : null;
    }
    /**
     * Set CodiceCas value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $codiceCas
     * @return \StructType\SampleAnalysis
     */
    public function setCodiceCas($codiceCas = null)
    {
        // validation for constraint: string
        if (!is_null($codiceCas) && !is_string($codiceCas)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($codiceCas, true), gettype($codiceCas)), __LINE__);
        }
        if (is_null($codiceCas) || (is_array($codiceCas) && empty($codiceCas))) {
            unset($this->CodiceCas);
        } else {
            $this->CodiceCas = $codiceCas;
        }
        return $this;
    }
    /**
     * Get CodiceCommento value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCodiceCommento()
    {
        return isset($this->CodiceCommento) ? $this->CodiceCommento : null;
    }
    /**
     * Set CodiceCommento value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $codiceCommento
     * @return \StructType\SampleAnalysis
     */
    public function setCodiceCommento($codiceCommento = null)
    {
        // validation for constraint: string
        if (!is_null($codiceCommento) && !is_string($codiceCommento)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($codiceCommento, true), gettype($codiceCommento)), __LINE__);
        }
        if (is_null($codiceCommento) || (is_array($codiceCommento) && empty($codiceCommento))) {
            unset($this->CodiceCommento);
        } else {
            $this->CodiceCommento = $codiceCommento;
        }
        return $this;
    }
    /**
     * Get CodiceCommentoFisso value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCodiceCommentoFisso()
    {
        return isset($this->CodiceCommentoFisso) ? $this->CodiceCommentoFisso : null;
    }
    /**
     * Set CodiceCommentoFisso value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $codiceCommentoFisso
     * @return \StructType\SampleAnalysis
     */
    public function setCodiceCommentoFisso($codiceCommentoFisso = null)
    {
        // validation for constraint: string
        if (!is_null($codiceCommentoFisso) && !is_string($codiceCommentoFisso)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($codiceCommentoFisso, true), gettype($codiceCommentoFisso)), __LINE__);
        }
        if (is_null($codiceCommentoFisso) || (is_array($codiceCommentoFisso) && empty($codiceCommentoFisso))) {
            unset($this->CodiceCommentoFisso);
        } else {
            $this->CodiceCommentoFisso = $codiceCommentoFisso;
        }
        return $this;
    }
    /**
     * Get CodiceDecretoLegge value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCodiceDecretoLegge()
    {
        return isset($this->CodiceDecretoLegge) ? $this->CodiceDecretoLegge : null;
    }
    /**
     * Set CodiceDecretoLegge value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $codiceDecretoLegge
     * @return \StructType\SampleAnalysis
     */
    public function setCodiceDecretoLegge($codiceDecretoLegge = null)
    {
        // validation for constraint: string
        if (!is_null($codiceDecretoLegge) && !is_string($codiceDecretoLegge)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($codiceDecretoLegge, true), gettype($codiceDecretoLegge)), __LINE__);
        }
        if (is_null($codiceDecretoLegge) || (is_array($codiceDecretoLegge) && empty($codiceDecretoLegge))) {
            unset($this->CodiceDecretoLegge);
        } else {
            $this->CodiceDecretoLegge = $codiceDecretoLegge;
        }
        return $this;
    }
    /**
     * Get CodiceGruppo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCodiceGruppo()
    {
        return isset($this->CodiceGruppo) ? $this->CodiceGruppo : null;
    }
    /**
     * Set CodiceGruppo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $codiceGruppo
     * @return \StructType\SampleAnalysis
     */
    public function setCodiceGruppo($codiceGruppo = null)
    {
        // validation for constraint: string
        if (!is_null($codiceGruppo) && !is_string($codiceGruppo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($codiceGruppo, true), gettype($codiceGruppo)), __LINE__);
        }
        if (is_null($codiceGruppo) || (is_array($codiceGruppo) && empty($codiceGruppo))) {
            unset($this->CodiceGruppo);
        } else {
            $this->CodiceGruppo = $codiceGruppo;
        }
        return $this;
    }
    /**
     * Get CodiceMacrogruppo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCodiceMacrogruppo()
    {
        return isset($this->CodiceMacrogruppo) ? $this->CodiceMacrogruppo : null;
    }
    /**
     * Set CodiceMacrogruppo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $codiceMacrogruppo
     * @return \StructType\SampleAnalysis
     */
    public function setCodiceMacrogruppo($codiceMacrogruppo = null)
    {
        // validation for constraint: string
        if (!is_null($codiceMacrogruppo) && !is_string($codiceMacrogruppo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($codiceMacrogruppo, true), gettype($codiceMacrogruppo)), __LINE__);
        }
        if (is_null($codiceMacrogruppo) || (is_array($codiceMacrogruppo) && empty($codiceMacrogruppo))) {
            unset($this->CodiceMacrogruppo);
        } else {
            $this->CodiceMacrogruppo = $codiceMacrogruppo;
        }
        return $this;
    }
    /**
     * Get CodiceParametro value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCodiceParametro()
    {
        return isset($this->CodiceParametro) ? $this->CodiceParametro : null;
    }
    /**
     * Set CodiceParametro value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $codiceParametro
     * @return \StructType\SampleAnalysis
     */
    public function setCodiceParametro($codiceParametro = null)
    {
        // validation for constraint: string
        if (!is_null($codiceParametro) && !is_string($codiceParametro)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($codiceParametro, true), gettype($codiceParametro)), __LINE__);
        }
        if (is_null($codiceParametro) || (is_array($codiceParametro) && empty($codiceParametro))) {
            unset($this->CodiceParametro);
        } else {
            $this->CodiceParametro = $codiceParametro;
        }
        return $this;
    }
    /**
     * Get CodiceReparto value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCodiceReparto()
    {
        return isset($this->CodiceReparto) ? $this->CodiceReparto : null;
    }
    /**
     * Set CodiceReparto value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $codiceReparto
     * @return \StructType\SampleAnalysis
     */
    public function setCodiceReparto($codiceReparto = null)
    {
        // validation for constraint: string
        if (!is_null($codiceReparto) && !is_string($codiceReparto)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($codiceReparto, true), gettype($codiceReparto)), __LINE__);
        }
        if (is_null($codiceReparto) || (is_array($codiceReparto) && empty($codiceReparto))) {
            unset($this->CodiceReparto);
        } else {
            $this->CodiceReparto = $codiceReparto;
        }
        return $this;
    }
    /**
     * Get CodiceStabilimento value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCodiceStabilimento()
    {
        return isset($this->CodiceStabilimento) ? $this->CodiceStabilimento : null;
    }
    /**
     * Set CodiceStabilimento value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $codiceStabilimento
     * @return \StructType\SampleAnalysis
     */
    public function setCodiceStabilimento($codiceStabilimento = null)
    {
        // validation for constraint: string
        if (!is_null($codiceStabilimento) && !is_string($codiceStabilimento)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($codiceStabilimento, true), gettype($codiceStabilimento)), __LINE__);
        }
        if (is_null($codiceStabilimento) || (is_array($codiceStabilimento) && empty($codiceStabilimento))) {
            unset($this->CodiceStabilimento);
        } else {
            $this->CodiceStabilimento = $codiceStabilimento;
        }
        return $this;
    }
    /**
     * Get Commento value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCommento()
    {
        return isset($this->Commento) ? $this->Commento : null;
    }
    /**
     * Set Commento value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $commento
     * @return \StructType\SampleAnalysis
     */
    public function setCommento($commento = null)
    {
        // validation for constraint: string
        if (!is_null($commento) && !is_string($commento)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($commento, true), gettype($commento)), __LINE__);
        }
        if (is_null($commento) || (is_array($commento) && empty($commento))) {
            unset($this->Commento);
        } else {
            $this->Commento = $commento;
        }
        return $this;
    }
    /**
     * Get CommentoFisso value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCommentoFisso()
    {
        return isset($this->CommentoFisso) ? $this->CommentoFisso : null;
    }
    /**
     * Set CommentoFisso value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $commentoFisso
     * @return \StructType\SampleAnalysis
     */
    public function setCommentoFisso($commentoFisso = null)
    {
        // validation for constraint: string
        if (!is_null($commentoFisso) && !is_string($commentoFisso)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($commentoFisso, true), gettype($commentoFisso)), __LINE__);
        }
        if (is_null($commentoFisso) || (is_array($commentoFisso) && empty($commentoFisso))) {
            unset($this->CommentoFisso);
        } else {
            $this->CommentoFisso = $commentoFisso;
        }
        return $this;
    }
    /**
     * Get DecretoLegge value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDecretoLegge()
    {
        return isset($this->DecretoLegge) ? $this->DecretoLegge : null;
    }
    /**
     * Set DecretoLegge value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $decretoLegge
     * @return \StructType\SampleAnalysis
     */
    public function setDecretoLegge($decretoLegge = null)
    {
        // validation for constraint: string
        if (!is_null($decretoLegge) && !is_string($decretoLegge)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($decretoLegge, true), gettype($decretoLegge)), __LINE__);
        }
        if (is_null($decretoLegge) || (is_array($decretoLegge) && empty($decretoLegge))) {
            unset($this->DecretoLegge);
        } else {
            $this->DecretoLegge = $decretoLegge;
        }
        return $this;
    }
    /**
     * Get Esito value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEsito()
    {
        return isset($this->Esito) ? $this->Esito : null;
    }
    /**
     * Set Esito value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $esito
     * @return \StructType\SampleAnalysis
     */
    public function setEsito($esito = null)
    {
        // validation for constraint: string
        if (!is_null($esito) && !is_string($esito)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($esito, true), gettype($esito)), __LINE__);
        }
        if (is_null($esito) || (is_array($esito) && empty($esito))) {
            unset($this->Esito);
        } else {
            $this->Esito = $esito;
        }
        return $this;
    }
    /**
     * Get FineAnalisi value
     * @return string|null
     */
    public function getFineAnalisi()
    {
        return $this->FineAnalisi;
    }
    /**
     * Set FineAnalisi value
     * @param string $fineAnalisi
     * @return \StructType\SampleAnalysis
     */
    public function setFineAnalisi($fineAnalisi = null)
    {
        // validation for constraint: string
        if (!is_null($fineAnalisi) && !is_string($fineAnalisi)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fineAnalisi, true), gettype($fineAnalisi)), __LINE__);
        }
        $this->FineAnalisi = $fineAnalisi;
        return $this;
    }
    /**
     * Get Gruppo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getGruppo()
    {
        return isset($this->Gruppo) ? $this->Gruppo : null;
    }
    /**
     * Set Gruppo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $gruppo
     * @return \StructType\SampleAnalysis
     */
    public function setGruppo($gruppo = null)
    {
        // validation for constraint: string
        if (!is_null($gruppo) && !is_string($gruppo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($gruppo, true), gettype($gruppo)), __LINE__);
        }
        if (is_null($gruppo) || (is_array($gruppo) && empty($gruppo))) {
            unset($this->Gruppo);
        } else {
            $this->Gruppo = $gruppo;
        }
        return $this;
    }
    /**
     * Get GruppoRapporto value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getGruppoRapporto()
    {
        return isset($this->GruppoRapporto) ? $this->GruppoRapporto : null;
    }
    /**
     * Set GruppoRapporto value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $gruppoRapporto
     * @return \StructType\SampleAnalysis
     */
    public function setGruppoRapporto($gruppoRapporto = null)
    {
        // validation for constraint: string
        if (!is_null($gruppoRapporto) && !is_string($gruppoRapporto)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($gruppoRapporto, true), gettype($gruppoRapporto)), __LINE__);
        }
        if (is_null($gruppoRapporto) || (is_array($gruppoRapporto) && empty($gruppoRapporto))) {
            unset($this->GruppoRapporto);
        } else {
            $this->GruppoRapporto = $gruppoRapporto;
        }
        return $this;
    }
    /**
     * Get IdCampione value
     * @return int|null
     */
    public function getIdCampione()
    {
        return $this->IdCampione;
    }
    /**
     * Set IdCampione value
     * @param int $idCampione
     * @return \StructType\SampleAnalysis
     */
    public function setIdCampione($idCampione = null)
    {
        // validation for constraint: int
        if (!is_null($idCampione) && !(is_int($idCampione) || ctype_digit($idCampione))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($idCampione, true), gettype($idCampione)), __LINE__);
        }
        $this->IdCampione = $idCampione;
        return $this;
    }
    /**
     * Get IdDecretoLegge value
     * @return int|null
     */
    public function getIdDecretoLegge()
    {
        return $this->IdDecretoLegge;
    }
    /**
     * Set IdDecretoLegge value
     * @param int $idDecretoLegge
     * @return \StructType\SampleAnalysis
     */
    public function setIdDecretoLegge($idDecretoLegge = null)
    {
        // validation for constraint: int
        if (!is_null($idDecretoLegge) && !(is_int($idDecretoLegge) || ctype_digit($idDecretoLegge))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($idDecretoLegge, true), gettype($idDecretoLegge)), __LINE__);
        }
        $this->IdDecretoLegge = $idDecretoLegge;
        return $this;
    }
    /**
     * Get IdGruppo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getIdGruppo()
    {
        return isset($this->IdGruppo) ? $this->IdGruppo : null;
    }
    /**
     * Set IdGruppo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $idGruppo
     * @return \StructType\SampleAnalysis
     */
    public function setIdGruppo($idGruppo = null)
    {
        // validation for constraint: int
        if (!is_null($idGruppo) && !(is_int($idGruppo) || ctype_digit($idGruppo))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($idGruppo, true), gettype($idGruppo)), __LINE__);
        }
        if (is_null($idGruppo) || (is_array($idGruppo) && empty($idGruppo))) {
            unset($this->IdGruppo);
        } else {
            $this->IdGruppo = $idGruppo;
        }
        return $this;
    }
    /**
     * Get IdMetodo value
     * @return int|null
     */
    public function getIdMetodo()
    {
        return $this->IdMetodo;
    }
    /**
     * Set IdMetodo value
     * @param int $idMetodo
     * @return \StructType\SampleAnalysis
     */
    public function setIdMetodo($idMetodo = null)
    {
        // validation for constraint: int
        if (!is_null($idMetodo) && !(is_int($idMetodo) || ctype_digit($idMetodo))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($idMetodo, true), gettype($idMetodo)), __LINE__);
        }
        $this->IdMetodo = $idMetodo;
        return $this;
    }
    /**
     * Get IdNomeParametro value
     * @return int|null
     */
    public function getIdNomeParametro()
    {
        return $this->IdNomeParametro;
    }
    /**
     * Set IdNomeParametro value
     * @param int $idNomeParametro
     * @return \StructType\SampleAnalysis
     */
    public function setIdNomeParametro($idNomeParametro = null)
    {
        // validation for constraint: int
        if (!is_null($idNomeParametro) && !(is_int($idNomeParametro) || ctype_digit($idNomeParametro))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($idNomeParametro, true), gettype($idNomeParametro)), __LINE__);
        }
        $this->IdNomeParametro = $idNomeParametro;
        return $this;
    }
    /**
     * Get IdParametro value
     * @return int|null
     */
    public function getIdParametro()
    {
        return $this->IdParametro;
    }
    /**
     * Set IdParametro value
     * @param int $idParametro
     * @return \StructType\SampleAnalysis
     */
    public function setIdParametro($idParametro = null)
    {
        // validation for constraint: int
        if (!is_null($idParametro) && !(is_int($idParametro) || ctype_digit($idParametro))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($idParametro, true), gettype($idParametro)), __LINE__);
        }
        $this->IdParametro = $idParametro;
        return $this;
    }
    /**
     * Get IdReparto value
     * @return int|null
     */
    public function getIdReparto()
    {
        return $this->IdReparto;
    }
    /**
     * Set IdReparto value
     * @param int $idReparto
     * @return \StructType\SampleAnalysis
     */
    public function setIdReparto($idReparto = null)
    {
        // validation for constraint: int
        if (!is_null($idReparto) && !(is_int($idReparto) || ctype_digit($idReparto))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($idReparto, true), gettype($idReparto)), __LINE__);
        }
        $this->IdReparto = $idReparto;
        return $this;
    }
    /**
     * Get IdUnitaMisura value
     * @return int|null
     */
    public function getIdUnitaMisura()
    {
        return $this->IdUnitaMisura;
    }
    /**
     * Set IdUnitaMisura value
     * @param int $idUnitaMisura
     * @return \StructType\SampleAnalysis
     */
    public function setIdUnitaMisura($idUnitaMisura = null)
    {
        // validation for constraint: int
        if (!is_null($idUnitaMisura) && !(is_int($idUnitaMisura) || ctype_digit($idUnitaMisura))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($idUnitaMisura, true), gettype($idUnitaMisura)), __LINE__);
        }
        $this->IdUnitaMisura = $idUnitaMisura;
        return $this;
    }
    /**
     * Get IncertezzaStampaNumerica value
     * @return float|null
     */
    public function getIncertezzaStampaNumerica()
    {
        return $this->IncertezzaStampaNumerica;
    }
    /**
     * Set IncertezzaStampaNumerica value
     * @param float $incertezzaStampaNumerica
     * @return \StructType\SampleAnalysis
     */
    public function setIncertezzaStampaNumerica($incertezzaStampaNumerica = null)
    {
        // validation for constraint: float
        if (!is_null($incertezzaStampaNumerica) && !(is_float($incertezzaStampaNumerica) || is_numeric($incertezzaStampaNumerica))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($incertezzaStampaNumerica, true), gettype($incertezzaStampaNumerica)), __LINE__);
        }
        $this->IncertezzaStampaNumerica = $incertezzaStampaNumerica;
        return $this;
    }
    /**
     * Get IncertezzaStampaTestuale value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getIncertezzaStampaTestuale()
    {
        return isset($this->IncertezzaStampaTestuale) ? $this->IncertezzaStampaTestuale : null;
    }
    /**
     * Set IncertezzaStampaTestuale value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $incertezzaStampaTestuale
     * @return \StructType\SampleAnalysis
     */
    public function setIncertezzaStampaTestuale($incertezzaStampaTestuale = null)
    {
        // validation for constraint: string
        if (!is_null($incertezzaStampaTestuale) && !is_string($incertezzaStampaTestuale)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($incertezzaStampaTestuale, true), gettype($incertezzaStampaTestuale)), __LINE__);
        }
        if (is_null($incertezzaStampaTestuale) || (is_array($incertezzaStampaTestuale) && empty($incertezzaStampaTestuale))) {
            unset($this->IncertezzaStampaTestuale);
        } else {
            $this->IncertezzaStampaTestuale = $incertezzaStampaTestuale;
        }
        return $this;
    }
    /**
     * Get IncertezzaStampaTipo value
     * @return int|null
     */
    public function getIncertezzaStampaTipo()
    {
        return $this->IncertezzaStampaTipo;
    }
    /**
     * Set IncertezzaStampaTipo value
     * @param int $incertezzaStampaTipo
     * @return \StructType\SampleAnalysis
     */
    public function setIncertezzaStampaTipo($incertezzaStampaTipo = null)
    {
        // validation for constraint: int
        if (!is_null($incertezzaStampaTipo) && !(is_int($incertezzaStampaTipo) || ctype_digit($incertezzaStampaTipo))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($incertezzaStampaTipo, true), gettype($incertezzaStampaTipo)), __LINE__);
        }
        $this->IncertezzaStampaTipo = $incertezzaStampaTipo;
        return $this;
    }
    /**
     * Get InizioAnalisi value
     * @return string|null
     */
    public function getInizioAnalisi()
    {
        return $this->InizioAnalisi;
    }
    /**
     * Set InizioAnalisi value
     * @param string $inizioAnalisi
     * @return \StructType\SampleAnalysis
     */
    public function setInizioAnalisi($inizioAnalisi = null)
    {
        // validation for constraint: string
        if (!is_null($inizioAnalisi) && !is_string($inizioAnalisi)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($inizioAnalisi, true), gettype($inizioAnalisi)), __LINE__);
        }
        $this->InizioAnalisi = $inizioAnalisi;
        return $this;
    }
    /**
     * Get LegendaStabilimento value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLegendaStabilimento()
    {
        return isset($this->LegendaStabilimento) ? $this->LegendaStabilimento : null;
    }
    /**
     * Set LegendaStabilimento value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $legendaStabilimento
     * @return \StructType\SampleAnalysis
     */
    public function setLegendaStabilimento($legendaStabilimento = null)
    {
        // validation for constraint: string
        if (!is_null($legendaStabilimento) && !is_string($legendaStabilimento)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($legendaStabilimento, true), gettype($legendaStabilimento)), __LINE__);
        }
        if (is_null($legendaStabilimento) || (is_array($legendaStabilimento) && empty($legendaStabilimento))) {
            unset($this->LegendaStabilimento);
        } else {
            $this->LegendaStabilimento = $legendaStabilimento;
        }
        return $this;
    }
    /**
     * Get LegendaStabilimentoAccreditati value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLegendaStabilimentoAccreditati()
    {
        return isset($this->LegendaStabilimentoAccreditati) ? $this->LegendaStabilimentoAccreditati : null;
    }
    /**
     * Set LegendaStabilimentoAccreditati value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $legendaStabilimentoAccreditati
     * @return \StructType\SampleAnalysis
     */
    public function setLegendaStabilimentoAccreditati($legendaStabilimentoAccreditati = null)
    {
        // validation for constraint: string
        if (!is_null($legendaStabilimentoAccreditati) && !is_string($legendaStabilimentoAccreditati)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($legendaStabilimentoAccreditati, true), gettype($legendaStabilimentoAccreditati)), __LINE__);
        }
        if (is_null($legendaStabilimentoAccreditati) || (is_array($legendaStabilimentoAccreditati) && empty($legendaStabilimentoAccreditati))) {
            unset($this->LegendaStabilimentoAccreditati);
        } else {
            $this->LegendaStabilimentoAccreditati = $legendaStabilimentoAccreditati;
        }
        return $this;
    }
    /**
     * Get LegendaUnitaMisura value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLegendaUnitaMisura()
    {
        return isset($this->LegendaUnitaMisura) ? $this->LegendaUnitaMisura : null;
    }
    /**
     * Set LegendaUnitaMisura value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $legendaUnitaMisura
     * @return \StructType\SampleAnalysis
     */
    public function setLegendaUnitaMisura($legendaUnitaMisura = null)
    {
        // validation for constraint: string
        if (!is_null($legendaUnitaMisura) && !is_string($legendaUnitaMisura)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($legendaUnitaMisura, true), gettype($legendaUnitaMisura)), __LINE__);
        }
        if (is_null($legendaUnitaMisura) || (is_array($legendaUnitaMisura) && empty($legendaUnitaMisura))) {
            unset($this->LegendaUnitaMisura);
        } else {
            $this->LegendaUnitaMisura = $legendaUnitaMisura;
        }
        return $this;
    }
    /**
     * Get LimiteMinimo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLimiteMinimo()
    {
        return isset($this->LimiteMinimo) ? $this->LimiteMinimo : null;
    }
    /**
     * Set LimiteMinimo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $limiteMinimo
     * @return \StructType\SampleAnalysis
     */
    public function setLimiteMinimo($limiteMinimo = null)
    {
        // validation for constraint: string
        if (!is_null($limiteMinimo) && !is_string($limiteMinimo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($limiteMinimo, true), gettype($limiteMinimo)), __LINE__);
        }
        if (is_null($limiteMinimo) || (is_array($limiteMinimo) && empty($limiteMinimo))) {
            unset($this->LimiteMinimo);
        } else {
            $this->LimiteMinimo = $limiteMinimo;
        }
        return $this;
    }
    /**
     * Get LimiteQuantificazione value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLimiteQuantificazione()
    {
        return isset($this->LimiteQuantificazione) ? $this->LimiteQuantificazione : null;
    }
    /**
     * Set LimiteQuantificazione value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $limiteQuantificazione
     * @return \StructType\SampleAnalysis
     */
    public function setLimiteQuantificazione($limiteQuantificazione = null)
    {
        // validation for constraint: string
        if (!is_null($limiteQuantificazione) && !is_string($limiteQuantificazione)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($limiteQuantificazione, true), gettype($limiteQuantificazione)), __LINE__);
        }
        if (is_null($limiteQuantificazione) || (is_array($limiteQuantificazione) && empty($limiteQuantificazione))) {
            unset($this->LimiteQuantificazione);
        } else {
            $this->LimiteQuantificazione = $limiteQuantificazione;
        }
        return $this;
    }
    /**
     * Get LimitiCliente value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLimitiCliente()
    {
        return isset($this->LimitiCliente) ? $this->LimitiCliente : null;
    }
    /**
     * Set LimitiCliente value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $limitiCliente
     * @return \StructType\SampleAnalysis
     */
    public function setLimitiCliente($limitiCliente = null)
    {
        // validation for constraint: string
        if (!is_null($limitiCliente) && !is_string($limitiCliente)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($limitiCliente, true), gettype($limitiCliente)), __LINE__);
        }
        if (is_null($limitiCliente) || (is_array($limitiCliente) && empty($limitiCliente))) {
            unset($this->LimitiCliente);
        } else {
            $this->LimitiCliente = $limitiCliente;
        }
        return $this;
    }
    /**
     * Get LimitiDiLegge value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLimitiDiLegge()
    {
        return isset($this->LimitiDiLegge) ? $this->LimitiDiLegge : null;
    }
    /**
     * Set LimitiDiLegge value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $limitiDiLegge
     * @return \StructType\SampleAnalysis
     */
    public function setLimitiDiLegge($limitiDiLegge = null)
    {
        // validation for constraint: string
        if (!is_null($limitiDiLegge) && !is_string($limitiDiLegge)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($limitiDiLegge, true), gettype($limitiDiLegge)), __LINE__);
        }
        if (is_null($limitiDiLegge) || (is_array($limitiDiLegge) && empty($limitiDiLegge))) {
            unset($this->LimitiDiLegge);
        } else {
            $this->LimitiDiLegge = $limitiDiLegge;
        }
        return $this;
    }
    /**
     * Get Macrogruppo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMacrogruppo()
    {
        return isset($this->Macrogruppo) ? $this->Macrogruppo : null;
    }
    /**
     * Set Macrogruppo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $macrogruppo
     * @return \StructType\SampleAnalysis
     */
    public function setMacrogruppo($macrogruppo = null)
    {
        // validation for constraint: string
        if (!is_null($macrogruppo) && !is_string($macrogruppo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($macrogruppo, true), gettype($macrogruppo)), __LINE__);
        }
        if (is_null($macrogruppo) || (is_array($macrogruppo) && empty($macrogruppo))) {
            unset($this->Macrogruppo);
        } else {
            $this->Macrogruppo = $macrogruppo;
        }
        return $this;
    }
    /**
     * Get MetodoCodiceAccreditato value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMetodoCodiceAccreditato()
    {
        return isset($this->MetodoCodiceAccreditato) ? $this->MetodoCodiceAccreditato : null;
    }
    /**
     * Set MetodoCodiceAccreditato value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $metodoCodiceAccreditato
     * @return \StructType\SampleAnalysis
     */
    public function setMetodoCodiceAccreditato($metodoCodiceAccreditato = null)
    {
        // validation for constraint: string
        if (!is_null($metodoCodiceAccreditato) && !is_string($metodoCodiceAccreditato)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($metodoCodiceAccreditato, true), gettype($metodoCodiceAccreditato)), __LINE__);
        }
        if (is_null($metodoCodiceAccreditato) || (is_array($metodoCodiceAccreditato) && empty($metodoCodiceAccreditato))) {
            unset($this->MetodoCodiceAccreditato);
        } else {
            $this->MetodoCodiceAccreditato = $metodoCodiceAccreditato;
        }
        return $this;
    }
    /**
     * Get MetodoCodiceISO value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMetodoCodiceISO()
    {
        return isset($this->MetodoCodiceISO) ? $this->MetodoCodiceISO : null;
    }
    /**
     * Set MetodoCodiceISO value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $metodoCodiceISO
     * @return \StructType\SampleAnalysis
     */
    public function setMetodoCodiceISO($metodoCodiceISO = null)
    {
        // validation for constraint: string
        if (!is_null($metodoCodiceISO) && !is_string($metodoCodiceISO)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($metodoCodiceISO, true), gettype($metodoCodiceISO)), __LINE__);
        }
        if (is_null($metodoCodiceISO) || (is_array($metodoCodiceISO) && empty($metodoCodiceISO))) {
            unset($this->MetodoCodiceISO);
        } else {
            $this->MetodoCodiceISO = $metodoCodiceISO;
        }
        return $this;
    }
    /**
     * Get MetodoRapporto value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMetodoRapporto()
    {
        return isset($this->MetodoRapporto) ? $this->MetodoRapporto : null;
    }
    /**
     * Set MetodoRapporto value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $metodoRapporto
     * @return \StructType\SampleAnalysis
     */
    public function setMetodoRapporto($metodoRapporto = null)
    {
        // validation for constraint: string
        if (!is_null($metodoRapporto) && !is_string($metodoRapporto)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($metodoRapporto, true), gettype($metodoRapporto)), __LINE__);
        }
        if (is_null($metodoRapporto) || (is_array($metodoRapporto) && empty($metodoRapporto))) {
            unset($this->MetodoRapporto);
        } else {
            $this->MetodoRapporto = $metodoRapporto;
        }
        return $this;
    }
    /**
     * Get MinimoRilevabile value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMinimoRilevabile()
    {
        return isset($this->MinimoRilevabile) ? $this->MinimoRilevabile : null;
    }
    /**
     * Set MinimoRilevabile value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $minimoRilevabile
     * @return \StructType\SampleAnalysis
     */
    public function setMinimoRilevabile($minimoRilevabile = null)
    {
        // validation for constraint: string
        if (!is_null($minimoRilevabile) && !is_string($minimoRilevabile)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($minimoRilevabile, true), gettype($minimoRilevabile)), __LINE__);
        }
        if (is_null($minimoRilevabile) || (is_array($minimoRilevabile) && empty($minimoRilevabile))) {
            unset($this->MinimoRilevabile);
        } else {
            $this->MinimoRilevabile = $minimoRilevabile;
        }
        return $this;
    }
    /**
     * Get NotaIncertezzaMetodo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNotaIncertezzaMetodo()
    {
        return isset($this->NotaIncertezzaMetodo) ? $this->NotaIncertezzaMetodo : null;
    }
    /**
     * Set NotaIncertezzaMetodo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $notaIncertezzaMetodo
     * @return \StructType\SampleAnalysis
     */
    public function setNotaIncertezzaMetodo($notaIncertezzaMetodo = null)
    {
        // validation for constraint: string
        if (!is_null($notaIncertezzaMetodo) && !is_string($notaIncertezzaMetodo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($notaIncertezzaMetodo, true), gettype($notaIncertezzaMetodo)), __LINE__);
        }
        if (is_null($notaIncertezzaMetodo) || (is_array($notaIncertezzaMetodo) && empty($notaIncertezzaMetodo))) {
            unset($this->NotaIncertezzaMetodo);
        } else {
            $this->NotaIncertezzaMetodo = $notaIncertezzaMetodo;
        }
        return $this;
    }
    /**
     * Get NotaIncertezzaReparto value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNotaIncertezzaReparto()
    {
        return isset($this->NotaIncertezzaReparto) ? $this->NotaIncertezzaReparto : null;
    }
    /**
     * Set NotaIncertezzaReparto value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $notaIncertezzaReparto
     * @return \StructType\SampleAnalysis
     */
    public function setNotaIncertezzaReparto($notaIncertezzaReparto = null)
    {
        // validation for constraint: string
        if (!is_null($notaIncertezzaReparto) && !is_string($notaIncertezzaReparto)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($notaIncertezzaReparto, true), gettype($notaIncertezzaReparto)), __LINE__);
        }
        if (is_null($notaIncertezzaReparto) || (is_array($notaIncertezzaReparto) && empty($notaIncertezzaReparto))) {
            unset($this->NotaIncertezzaReparto);
        } else {
            $this->NotaIncertezzaReparto = $notaIncertezzaReparto;
        }
        return $this;
    }
    /**
     * Get Parametro value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getParametro()
    {
        return isset($this->Parametro) ? $this->Parametro : null;
    }
    /**
     * Set Parametro value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $parametro
     * @return \StructType\SampleAnalysis
     */
    public function setParametro($parametro = null)
    {
        // validation for constraint: string
        if (!is_null($parametro) && !is_string($parametro)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($parametro, true), gettype($parametro)), __LINE__);
        }
        if (is_null($parametro) || (is_array($parametro) && empty($parametro))) {
            unset($this->Parametro);
        } else {
            $this->Parametro = $parametro;
        }
        return $this;
    }
    /**
     * Get ParametroRapporto value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getParametroRapporto()
    {
        return isset($this->ParametroRapporto) ? $this->ParametroRapporto : null;
    }
    /**
     * Set ParametroRapporto value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $parametroRapporto
     * @return \StructType\SampleAnalysis
     */
    public function setParametroRapporto($parametroRapporto = null)
    {
        // validation for constraint: string
        if (!is_null($parametroRapporto) && !is_string($parametroRapporto)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($parametroRapporto, true), gettype($parametroRapporto)), __LINE__);
        }
        if (is_null($parametroRapporto) || (is_array($parametroRapporto) && empty($parametroRapporto))) {
            unset($this->ParametroRapporto);
        } else {
            $this->ParametroRapporto = $parametroRapporto;
        }
        return $this;
    }
    /**
     * Get Reparto value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getReparto()
    {
        return isset($this->Reparto) ? $this->Reparto : null;
    }
    /**
     * Set Reparto value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $reparto
     * @return \StructType\SampleAnalysis
     */
    public function setReparto($reparto = null)
    {
        // validation for constraint: string
        if (!is_null($reparto) && !is_string($reparto)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($reparto, true), gettype($reparto)), __LINE__);
        }
        if (is_null($reparto) || (is_array($reparto) && empty($reparto))) {
            unset($this->Reparto);
        } else {
            $this->Reparto = $reparto;
        }
        return $this;
    }
    /**
     * Get RisultatoPositivo value
     * @return bool|null
     */
    public function getRisultatoPositivo()
    {
        return $this->RisultatoPositivo;
    }
    /**
     * Set RisultatoPositivo value
     * @param bool $risultatoPositivo
     * @return \StructType\SampleAnalysis
     */
    public function setRisultatoPositivo($risultatoPositivo = null)
    {
        // validation for constraint: boolean
        if (!is_null($risultatoPositivo) && !is_bool($risultatoPositivo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($risultatoPositivo, true), gettype($risultatoPositivo)), __LINE__);
        }
        $this->RisultatoPositivo = $risultatoPositivo;
        return $this;
    }
    /**
     * Get RisultatoStampa value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRisultatoStampa()
    {
        return isset($this->RisultatoStampa) ? $this->RisultatoStampa : null;
    }
    /**
     * Set RisultatoStampa value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $risultatoStampa
     * @return \StructType\SampleAnalysis
     */
    public function setRisultatoStampa($risultatoStampa = null)
    {
        // validation for constraint: string
        if (!is_null($risultatoStampa) && !is_string($risultatoStampa)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($risultatoStampa, true), gettype($risultatoStampa)), __LINE__);
        }
        if (is_null($risultatoStampa) || (is_array($risultatoStampa) && empty($risultatoStampa))) {
            unset($this->RisultatoStampa);
        } else {
            $this->RisultatoStampa = $risultatoStampa;
        }
        return $this;
    }
    /**
     * Get Subappalto value
     * @return bool|null
     */
    public function getSubappalto()
    {
        return $this->Subappalto;
    }
    /**
     * Set Subappalto value
     * @param bool $subappalto
     * @return \StructType\SampleAnalysis
     */
    public function setSubappalto($subappalto = null)
    {
        // validation for constraint: boolean
        if (!is_null($subappalto) && !is_bool($subappalto)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($subappalto, true), gettype($subappalto)), __LINE__);
        }
        $this->Subappalto = $subappalto;
        return $this;
    }
    /**
     * Get TipoEsito value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTipoEsito()
    {
        return isset($this->TipoEsito) ? $this->TipoEsito : null;
    }
    /**
     * Set TipoEsito value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $tipoEsito
     * @return \StructType\SampleAnalysis
     */
    public function setTipoEsito($tipoEsito = null)
    {
        // validation for constraint: string
        if (!is_null($tipoEsito) && !is_string($tipoEsito)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($tipoEsito, true), gettype($tipoEsito)), __LINE__);
        }
        if (is_null($tipoEsito) || (is_array($tipoEsito) && empty($tipoEsito))) {
            unset($this->TipoEsito);
        } else {
            $this->TipoEsito = $tipoEsito;
        }
        return $this;
    }
    /**
     * Get UnitaMisura value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getUnitaMisura()
    {
        return isset($this->UnitaMisura) ? $this->UnitaMisura : null;
    }
    /**
     * Set UnitaMisura value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $unitaMisura
     * @return \StructType\SampleAnalysis
     */
    public function setUnitaMisura($unitaMisura = null)
    {
        // validation for constraint: string
        if (!is_null($unitaMisura) && !is_string($unitaMisura)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($unitaMisura, true), gettype($unitaMisura)), __LINE__);
        }
        if (is_null($unitaMisura) || (is_array($unitaMisura) && empty($unitaMisura))) {
            unset($this->UnitaMisura);
        } else {
            $this->UnitaMisura = $unitaMisura;
        }
        return $this;
    }
    /**
     * Get UnitaMisuraRapporto value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getUnitaMisuraRapporto()
    {
        return isset($this->UnitaMisuraRapporto) ? $this->UnitaMisuraRapporto : null;
    }
    /**
     * Set UnitaMisuraRapporto value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $unitaMisuraRapporto
     * @return \StructType\SampleAnalysis
     */
    public function setUnitaMisuraRapporto($unitaMisuraRapporto = null)
    {
        // validation for constraint: string
        if (!is_null($unitaMisuraRapporto) && !is_string($unitaMisuraRapporto)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($unitaMisuraRapporto, true), gettype($unitaMisuraRapporto)), __LINE__);
        }
        if (is_null($unitaMisuraRapporto) || (is_array($unitaMisuraRapporto) && empty($unitaMisuraRapporto))) {
            unset($this->UnitaMisuraRapporto);
        } else {
            $this->UnitaMisuraRapporto = $unitaMisuraRapporto;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\SampleAnalysis
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
