<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TestDataResponse StructType
 * @subpackage Structs
 */
class TestDataResponse extends AbstractStructBase
{
    /**
     * The TestDataResult
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $TestDataResult;
    /**
     * Constructor method for TestDataResponse
     * @uses TestDataResponse::setTestDataResult()
     * @param string $testDataResult
     */
    public function __construct($testDataResult = null)
    {
        $this
            ->setTestDataResult($testDataResult);
    }
    /**
     * Get TestDataResult value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTestDataResult()
    {
        return isset($this->TestDataResult) ? $this->TestDataResult : null;
    }
    /**
     * Set TestDataResult value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $testDataResult
     * @return \StructType\TestDataResponse
     */
    public function setTestDataResult($testDataResult = null)
    {
        // validation for constraint: string
        if (!is_null($testDataResult) && !is_string($testDataResult)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($testDataResult, true), gettype($testDataResult)), __LINE__);
        }
        if (is_null($testDataResult) || (is_array($testDataResult) && empty($testDataResult))) {
            unset($this->TestDataResult);
        } else {
            $this->TestDataResult = $testDataResult;
        }
        return $this;
    }
}
