<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Sample StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:Sample
 * @subpackage Structs
 */
class Sample extends AbstractStructBase
{
    /**
     * The CampioneBiologico
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $CampioneBiologico;
    /**
     * The CertificatoUnico
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $CertificatoUnico;
    /**
     * The CodiceAccettazione
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CodiceAccettazione;
    /**
     * The CodiceCampione
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CodiceCampione;
    /**
     * The CodiceCer
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CodiceCer;
    /**
     * The CodiceCliente
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CodiceCliente;
    /**
     * The CodiceClienteFatturazione
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CodiceClienteFatturazione;
    /**
     * The CodiceClienteRapporto
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CodiceClienteRapporto;
    /**
     * The CodiceCommessa
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CodiceCommessa;
    /**
     * The CodiceMatrice
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CodiceMatrice;
    /**
     * The CodicePrimoRapporto
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CodicePrimoRapporto;
    /**
     * The CodiceRapporto
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CodiceRapporto;
    /**
     * The CodiceRapportoPrecedente
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CodiceRapportoPrecedente;
    /**
     * The CodiceSottomatrice
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CodiceSottomatrice;
    /**
     * The CodiceTipoCommessa
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CodiceTipoCommessa;
    /**
     * The CustomFields
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfSampleCustomField
     */
    public $CustomFields;
    /**
     * The DataAccettazione
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $DataAccettazione;
    /**
     * The DataFineAnalisiCampione
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $DataFineAnalisiCampione;
    /**
     * The DataInizioAnalisiCampione
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $DataInizioAnalisiCampione;
    /**
     * The DataPrimoRapporto
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $DataPrimoRapporto;
    /**
     * The DataRapporto
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $DataRapporto;
    /**
     * The DataRapportoPrecedente
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $DataRapportoPrecedente;
    /**
     * The DataStampa
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $DataStampa;
    /**
     * The Esportato
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $Esportato;
    /**
     * The GiudizioRapporto
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $GiudizioRapporto;
    /**
     * The IdCampione
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $IdCampione;
    /**
     * The IdCommessa
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $IdCommessa;
    /**
     * The IdMatrice
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $IdMatrice;
    /**
     * The IdSottomatrice
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $IdSottomatrice;
    /**
     * The IdStatoCampione
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $IdStatoCampione;
    /**
     * The IdTipoCommessa
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $IdTipoCommessa;
    /**
     * The Matrice
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Matrice;
    /**
     * The NominativoCliente
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $NominativoCliente;
    /**
     * The NominativoClienteFatturazione
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $NominativoClienteFatturazione;
    /**
     * The NominativoClienteRapporto
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $NominativoClienteRapporto;
    /**
     * The NotaEmendamento
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $NotaEmendamento;
    /**
     * The NoteRapporto
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $NoteRapporto;
    /**
     * The Riferimento
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Riferimento;
    /**
     * The RisultatiIrregolari
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $RisultatiIrregolari;
    /**
     * The SampleAnalysis
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfSampleAnalysis
     */
    public $SampleAnalysis;
    /**
     * The Sottomatrice
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Sottomatrice;
    /**
     * The StatoCampione
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $StatoCampione;
    /**
     * The TipoCommessa
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $TipoCommessa;
    /**
     * The VersioneRapporto
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $VersioneRapporto;
    /**
     * The VersioneRapportoPrecedente
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $VersioneRapportoPrecedente;
    /**
     * Constructor method for Sample
     * @uses Sample::setCampioneBiologico()
     * @uses Sample::setCertificatoUnico()
     * @uses Sample::setCodiceAccettazione()
     * @uses Sample::setCodiceCampione()
     * @uses Sample::setCodiceCer()
     * @uses Sample::setCodiceCliente()
     * @uses Sample::setCodiceClienteFatturazione()
     * @uses Sample::setCodiceClienteRapporto()
     * @uses Sample::setCodiceCommessa()
     * @uses Sample::setCodiceMatrice()
     * @uses Sample::setCodicePrimoRapporto()
     * @uses Sample::setCodiceRapporto()
     * @uses Sample::setCodiceRapportoPrecedente()
     * @uses Sample::setCodiceSottomatrice()
     * @uses Sample::setCodiceTipoCommessa()
     * @uses Sample::setCustomFields()
     * @uses Sample::setDataAccettazione()
     * @uses Sample::setDataFineAnalisiCampione()
     * @uses Sample::setDataInizioAnalisiCampione()
     * @uses Sample::setDataPrimoRapporto()
     * @uses Sample::setDataRapporto()
     * @uses Sample::setDataRapportoPrecedente()
     * @uses Sample::setDataStampa()
     * @uses Sample::setEsportato()
     * @uses Sample::setGiudizioRapporto()
     * @uses Sample::setIdCampione()
     * @uses Sample::setIdCommessa()
     * @uses Sample::setIdMatrice()
     * @uses Sample::setIdSottomatrice()
     * @uses Sample::setIdStatoCampione()
     * @uses Sample::setIdTipoCommessa()
     * @uses Sample::setMatrice()
     * @uses Sample::setNominativoCliente()
     * @uses Sample::setNominativoClienteFatturazione()
     * @uses Sample::setNominativoClienteRapporto()
     * @uses Sample::setNotaEmendamento()
     * @uses Sample::setNoteRapporto()
     * @uses Sample::setRiferimento()
     * @uses Sample::setRisultatiIrregolari()
     * @uses Sample::setSampleAnalysis()
     * @uses Sample::setSottomatrice()
     * @uses Sample::setStatoCampione()
     * @uses Sample::setTipoCommessa()
     * @uses Sample::setVersioneRapporto()
     * @uses Sample::setVersioneRapportoPrecedente()
     * @param bool $campioneBiologico
     * @param bool $certificatoUnico
     * @param string $codiceAccettazione
     * @param string $codiceCampione
     * @param string $codiceCer
     * @param string $codiceCliente
     * @param string $codiceClienteFatturazione
     * @param string $codiceClienteRapporto
     * @param string $codiceCommessa
     * @param string $codiceMatrice
     * @param string $codicePrimoRapporto
     * @param string $codiceRapporto
     * @param string $codiceRapportoPrecedente
     * @param string $codiceSottomatrice
     * @param string $codiceTipoCommessa
     * @param \ArrayType\ArrayOfSampleCustomField $customFields
     * @param string $dataAccettazione
     * @param string $dataFineAnalisiCampione
     * @param string $dataInizioAnalisiCampione
     * @param string $dataPrimoRapporto
     * @param string $dataRapporto
     * @param string $dataRapportoPrecedente
     * @param string $dataStampa
     * @param bool $esportato
     * @param string $giudizioRapporto
     * @param int $idCampione
     * @param int $idCommessa
     * @param int $idMatrice
     * @param int $idSottomatrice
     * @param int $idStatoCampione
     * @param int $idTipoCommessa
     * @param string $matrice
     * @param string $nominativoCliente
     * @param string $nominativoClienteFatturazione
     * @param string $nominativoClienteRapporto
     * @param string $notaEmendamento
     * @param string $noteRapporto
     * @param string $riferimento
     * @param bool $risultatiIrregolari
     * @param \ArrayType\ArrayOfSampleAnalysis $sampleAnalysis
     * @param string $sottomatrice
     * @param string $statoCampione
     * @param string $tipoCommessa
     * @param int $versioneRapporto
     * @param int $versioneRapportoPrecedente
     */
    public function __construct($campioneBiologico = null, $certificatoUnico = null, $codiceAccettazione = null, $codiceCampione = null, $codiceCer = null, $codiceCliente = null, $codiceClienteFatturazione = null, $codiceClienteRapporto = null, $codiceCommessa = null, $codiceMatrice = null, $codicePrimoRapporto = null, $codiceRapporto = null, $codiceRapportoPrecedente = null, $codiceSottomatrice = null, $codiceTipoCommessa = null, \ArrayType\ArrayOfSampleCustomField $customFields = null, $dataAccettazione = null, $dataFineAnalisiCampione = null, $dataInizioAnalisiCampione = null, $dataPrimoRapporto = null, $dataRapporto = null, $dataRapportoPrecedente = null, $dataStampa = null, $esportato = null, $giudizioRapporto = null, $idCampione = null, $idCommessa = null, $idMatrice = null, $idSottomatrice = null, $idStatoCampione = null, $idTipoCommessa = null, $matrice = null, $nominativoCliente = null, $nominativoClienteFatturazione = null, $nominativoClienteRapporto = null, $notaEmendamento = null, $noteRapporto = null, $riferimento = null, $risultatiIrregolari = null, \ArrayType\ArrayOfSampleAnalysis $sampleAnalysis = null, $sottomatrice = null, $statoCampione = null, $tipoCommessa = null, $versioneRapporto = null, $versioneRapportoPrecedente = null)
    {
        $this
            ->setCampioneBiologico($campioneBiologico)
            ->setCertificatoUnico($certificatoUnico)
            ->setCodiceAccettazione($codiceAccettazione)
            ->setCodiceCampione($codiceCampione)
            ->setCodiceCer($codiceCer)
            ->setCodiceCliente($codiceCliente)
            ->setCodiceClienteFatturazione($codiceClienteFatturazione)
            ->setCodiceClienteRapporto($codiceClienteRapporto)
            ->setCodiceCommessa($codiceCommessa)
            ->setCodiceMatrice($codiceMatrice)
            ->setCodicePrimoRapporto($codicePrimoRapporto)
            ->setCodiceRapporto($codiceRapporto)
            ->setCodiceRapportoPrecedente($codiceRapportoPrecedente)
            ->setCodiceSottomatrice($codiceSottomatrice)
            ->setCodiceTipoCommessa($codiceTipoCommessa)
            ->setCustomFields($customFields)
            ->setDataAccettazione($dataAccettazione)
            ->setDataFineAnalisiCampione($dataFineAnalisiCampione)
            ->setDataInizioAnalisiCampione($dataInizioAnalisiCampione)
            ->setDataPrimoRapporto($dataPrimoRapporto)
            ->setDataRapporto($dataRapporto)
            ->setDataRapportoPrecedente($dataRapportoPrecedente)
            ->setDataStampa($dataStampa)
            ->setEsportato($esportato)
            ->setGiudizioRapporto($giudizioRapporto)
            ->setIdCampione($idCampione)
            ->setIdCommessa($idCommessa)
            ->setIdMatrice($idMatrice)
            ->setIdSottomatrice($idSottomatrice)
            ->setIdStatoCampione($idStatoCampione)
            ->setIdTipoCommessa($idTipoCommessa)
            ->setMatrice($matrice)
            ->setNominativoCliente($nominativoCliente)
            ->setNominativoClienteFatturazione($nominativoClienteFatturazione)
            ->setNominativoClienteRapporto($nominativoClienteRapporto)
            ->setNotaEmendamento($notaEmendamento)
            ->setNoteRapporto($noteRapporto)
            ->setRiferimento($riferimento)
            ->setRisultatiIrregolari($risultatiIrregolari)
            ->setSampleAnalysis($sampleAnalysis)
            ->setSottomatrice($sottomatrice)
            ->setStatoCampione($statoCampione)
            ->setTipoCommessa($tipoCommessa)
            ->setVersioneRapporto($versioneRapporto)
            ->setVersioneRapportoPrecedente($versioneRapportoPrecedente);
    }
    /**
     * Get CampioneBiologico value
     * @return bool|null
     */
    public function getCampioneBiologico()
    {
        return $this->CampioneBiologico;
    }
    /**
     * Set CampioneBiologico value
     * @param bool $campioneBiologico
     * @return \StructType\Sample
     */
    public function setCampioneBiologico($campioneBiologico = null)
    {
        // validation for constraint: boolean
        if (!is_null($campioneBiologico) && !is_bool($campioneBiologico)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($campioneBiologico, true), gettype($campioneBiologico)), __LINE__);
        }
        $this->CampioneBiologico = $campioneBiologico;
        return $this;
    }
    /**
     * Get CertificatoUnico value
     * @return bool|null
     */
    public function getCertificatoUnico()
    {
        return $this->CertificatoUnico;
    }
    /**
     * Set CertificatoUnico value
     * @param bool $certificatoUnico
     * @return \StructType\Sample
     */
    public function setCertificatoUnico($certificatoUnico = null)
    {
        // validation for constraint: boolean
        if (!is_null($certificatoUnico) && !is_bool($certificatoUnico)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($certificatoUnico, true), gettype($certificatoUnico)), __LINE__);
        }
        $this->CertificatoUnico = $certificatoUnico;
        return $this;
    }
    /**
     * Get CodiceAccettazione value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCodiceAccettazione()
    {
        return isset($this->CodiceAccettazione) ? $this->CodiceAccettazione : null;
    }
    /**
     * Set CodiceAccettazione value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $codiceAccettazione
     * @return \StructType\Sample
     */
    public function setCodiceAccettazione($codiceAccettazione = null)
    {
        // validation for constraint: string
        if (!is_null($codiceAccettazione) && !is_string($codiceAccettazione)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($codiceAccettazione, true), gettype($codiceAccettazione)), __LINE__);
        }
        if (is_null($codiceAccettazione) || (is_array($codiceAccettazione) && empty($codiceAccettazione))) {
            unset($this->CodiceAccettazione);
        } else {
            $this->CodiceAccettazione = $codiceAccettazione;
        }
        return $this;
    }
    /**
     * Get CodiceCampione value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCodiceCampione()
    {
        return isset($this->CodiceCampione) ? $this->CodiceCampione : null;
    }
    /**
     * Set CodiceCampione value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $codiceCampione
     * @return \StructType\Sample
     */
    public function setCodiceCampione($codiceCampione = null)
    {
        // validation for constraint: string
        if (!is_null($codiceCampione) && !is_string($codiceCampione)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($codiceCampione, true), gettype($codiceCampione)), __LINE__);
        }
        if (is_null($codiceCampione) || (is_array($codiceCampione) && empty($codiceCampione))) {
            unset($this->CodiceCampione);
        } else {
            $this->CodiceCampione = $codiceCampione;
        }
        return $this;
    }
    /**
     * Get CodiceCer value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCodiceCer()
    {
        return isset($this->CodiceCer) ? $this->CodiceCer : null;
    }
    /**
     * Set CodiceCer value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $codiceCer
     * @return \StructType\Sample
     */
    public function setCodiceCer($codiceCer = null)
    {
        // validation for constraint: string
        if (!is_null($codiceCer) && !is_string($codiceCer)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($codiceCer, true), gettype($codiceCer)), __LINE__);
        }
        if (is_null($codiceCer) || (is_array($codiceCer) && empty($codiceCer))) {
            unset($this->CodiceCer);
        } else {
            $this->CodiceCer = $codiceCer;
        }
        return $this;
    }
    /**
     * Get CodiceCliente value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCodiceCliente()
    {
        return isset($this->CodiceCliente) ? $this->CodiceCliente : null;
    }
    /**
     * Set CodiceCliente value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $codiceCliente
     * @return \StructType\Sample
     */
    public function setCodiceCliente($codiceCliente = null)
    {
        // validation for constraint: string
        if (!is_null($codiceCliente) && !is_string($codiceCliente)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($codiceCliente, true), gettype($codiceCliente)), __LINE__);
        }
        if (is_null($codiceCliente) || (is_array($codiceCliente) && empty($codiceCliente))) {
            unset($this->CodiceCliente);
        } else {
            $this->CodiceCliente = $codiceCliente;
        }
        return $this;
    }
    /**
     * Get CodiceClienteFatturazione value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCodiceClienteFatturazione()
    {
        return isset($this->CodiceClienteFatturazione) ? $this->CodiceClienteFatturazione : null;
    }
    /**
     * Set CodiceClienteFatturazione value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $codiceClienteFatturazione
     * @return \StructType\Sample
     */
    public function setCodiceClienteFatturazione($codiceClienteFatturazione = null)
    {
        // validation for constraint: string
        if (!is_null($codiceClienteFatturazione) && !is_string($codiceClienteFatturazione)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($codiceClienteFatturazione, true), gettype($codiceClienteFatturazione)), __LINE__);
        }
        if (is_null($codiceClienteFatturazione) || (is_array($codiceClienteFatturazione) && empty($codiceClienteFatturazione))) {
            unset($this->CodiceClienteFatturazione);
        } else {
            $this->CodiceClienteFatturazione = $codiceClienteFatturazione;
        }
        return $this;
    }
    /**
     * Get CodiceClienteRapporto value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCodiceClienteRapporto()
    {
        return isset($this->CodiceClienteRapporto) ? $this->CodiceClienteRapporto : null;
    }
    /**
     * Set CodiceClienteRapporto value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $codiceClienteRapporto
     * @return \StructType\Sample
     */
    public function setCodiceClienteRapporto($codiceClienteRapporto = null)
    {
        // validation for constraint: string
        if (!is_null($codiceClienteRapporto) && !is_string($codiceClienteRapporto)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($codiceClienteRapporto, true), gettype($codiceClienteRapporto)), __LINE__);
        }
        if (is_null($codiceClienteRapporto) || (is_array($codiceClienteRapporto) && empty($codiceClienteRapporto))) {
            unset($this->CodiceClienteRapporto);
        } else {
            $this->CodiceClienteRapporto = $codiceClienteRapporto;
        }
        return $this;
    }
    /**
     * Get CodiceCommessa value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCodiceCommessa()
    {
        return isset($this->CodiceCommessa) ? $this->CodiceCommessa : null;
    }
    /**
     * Set CodiceCommessa value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $codiceCommessa
     * @return \StructType\Sample
     */
    public function setCodiceCommessa($codiceCommessa = null)
    {
        // validation for constraint: string
        if (!is_null($codiceCommessa) && !is_string($codiceCommessa)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($codiceCommessa, true), gettype($codiceCommessa)), __LINE__);
        }
        if (is_null($codiceCommessa) || (is_array($codiceCommessa) && empty($codiceCommessa))) {
            unset($this->CodiceCommessa);
        } else {
            $this->CodiceCommessa = $codiceCommessa;
        }
        return $this;
    }
    /**
     * Get CodiceMatrice value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCodiceMatrice()
    {
        return isset($this->CodiceMatrice) ? $this->CodiceMatrice : null;
    }
    /**
     * Set CodiceMatrice value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $codiceMatrice
     * @return \StructType\Sample
     */
    public function setCodiceMatrice($codiceMatrice = null)
    {
        // validation for constraint: string
        if (!is_null($codiceMatrice) && !is_string($codiceMatrice)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($codiceMatrice, true), gettype($codiceMatrice)), __LINE__);
        }
        if (is_null($codiceMatrice) || (is_array($codiceMatrice) && empty($codiceMatrice))) {
            unset($this->CodiceMatrice);
        } else {
            $this->CodiceMatrice = $codiceMatrice;
        }
        return $this;
    }
    /**
     * Get CodicePrimoRapporto value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCodicePrimoRapporto()
    {
        return isset($this->CodicePrimoRapporto) ? $this->CodicePrimoRapporto : null;
    }
    /**
     * Set CodicePrimoRapporto value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $codicePrimoRapporto
     * @return \StructType\Sample
     */
    public function setCodicePrimoRapporto($codicePrimoRapporto = null)
    {
        // validation for constraint: string
        if (!is_null($codicePrimoRapporto) && !is_string($codicePrimoRapporto)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($codicePrimoRapporto, true), gettype($codicePrimoRapporto)), __LINE__);
        }
        if (is_null($codicePrimoRapporto) || (is_array($codicePrimoRapporto) && empty($codicePrimoRapporto))) {
            unset($this->CodicePrimoRapporto);
        } else {
            $this->CodicePrimoRapporto = $codicePrimoRapporto;
        }
        return $this;
    }
    /**
     * Get CodiceRapporto value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCodiceRapporto()
    {
        return isset($this->CodiceRapporto) ? $this->CodiceRapporto : null;
    }
    /**
     * Set CodiceRapporto value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $codiceRapporto
     * @return \StructType\Sample
     */
    public function setCodiceRapporto($codiceRapporto = null)
    {
        // validation for constraint: string
        if (!is_null($codiceRapporto) && !is_string($codiceRapporto)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($codiceRapporto, true), gettype($codiceRapporto)), __LINE__);
        }
        if (is_null($codiceRapporto) || (is_array($codiceRapporto) && empty($codiceRapporto))) {
            unset($this->CodiceRapporto);
        } else {
            $this->CodiceRapporto = $codiceRapporto;
        }
        return $this;
    }
    /**
     * Get CodiceRapportoPrecedente value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCodiceRapportoPrecedente()
    {
        return isset($this->CodiceRapportoPrecedente) ? $this->CodiceRapportoPrecedente : null;
    }
    /**
     * Set CodiceRapportoPrecedente value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $codiceRapportoPrecedente
     * @return \StructType\Sample
     */
    public function setCodiceRapportoPrecedente($codiceRapportoPrecedente = null)
    {
        // validation for constraint: string
        if (!is_null($codiceRapportoPrecedente) && !is_string($codiceRapportoPrecedente)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($codiceRapportoPrecedente, true), gettype($codiceRapportoPrecedente)), __LINE__);
        }
        if (is_null($codiceRapportoPrecedente) || (is_array($codiceRapportoPrecedente) && empty($codiceRapportoPrecedente))) {
            unset($this->CodiceRapportoPrecedente);
        } else {
            $this->CodiceRapportoPrecedente = $codiceRapportoPrecedente;
        }
        return $this;
    }
    /**
     * Get CodiceSottomatrice value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCodiceSottomatrice()
    {
        return isset($this->CodiceSottomatrice) ? $this->CodiceSottomatrice : null;
    }
    /**
     * Set CodiceSottomatrice value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $codiceSottomatrice
     * @return \StructType\Sample
     */
    public function setCodiceSottomatrice($codiceSottomatrice = null)
    {
        // validation for constraint: string
        if (!is_null($codiceSottomatrice) && !is_string($codiceSottomatrice)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($codiceSottomatrice, true), gettype($codiceSottomatrice)), __LINE__);
        }
        if (is_null($codiceSottomatrice) || (is_array($codiceSottomatrice) && empty($codiceSottomatrice))) {
            unset($this->CodiceSottomatrice);
        } else {
            $this->CodiceSottomatrice = $codiceSottomatrice;
        }
        return $this;
    }
    /**
     * Get CodiceTipoCommessa value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCodiceTipoCommessa()
    {
        return isset($this->CodiceTipoCommessa) ? $this->CodiceTipoCommessa : null;
    }
    /**
     * Set CodiceTipoCommessa value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $codiceTipoCommessa
     * @return \StructType\Sample
     */
    public function setCodiceTipoCommessa($codiceTipoCommessa = null)
    {
        // validation for constraint: string
        if (!is_null($codiceTipoCommessa) && !is_string($codiceTipoCommessa)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($codiceTipoCommessa, true), gettype($codiceTipoCommessa)), __LINE__);
        }
        if (is_null($codiceTipoCommessa) || (is_array($codiceTipoCommessa) && empty($codiceTipoCommessa))) {
            unset($this->CodiceTipoCommessa);
        } else {
            $this->CodiceTipoCommessa = $codiceTipoCommessa;
        }
        return $this;
    }
    /**
     * Get CustomFields value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfSampleCustomField|null
     */
    public function getCustomFields()
    {
        return isset($this->CustomFields) ? $this->CustomFields : null;
    }
    /**
     * Set CustomFields value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfSampleCustomField $customFields
     * @return \StructType\Sample
     */
    public function setCustomFields(\ArrayType\ArrayOfSampleCustomField $customFields = null)
    {
        if (is_null($customFields) || (is_array($customFields) && empty($customFields))) {
            unset($this->CustomFields);
        } else {
            $this->CustomFields = $customFields;
        }
        return $this;
    }
    /**
     * Get DataAccettazione value
     * @return string|null
     */
    public function getDataAccettazione()
    {
        return $this->DataAccettazione;
    }
    /**
     * Set DataAccettazione value
     * @param string $dataAccettazione
     * @return \StructType\Sample
     */
    public function setDataAccettazione($dataAccettazione = null)
    {
        // validation for constraint: string
        if (!is_null($dataAccettazione) && !is_string($dataAccettazione)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dataAccettazione, true), gettype($dataAccettazione)), __LINE__);
        }
        $this->DataAccettazione = $dataAccettazione;
        return $this;
    }
    /**
     * Get DataFineAnalisiCampione value
     * @return string|null
     */
    public function getDataFineAnalisiCampione()
    {
        return $this->DataFineAnalisiCampione;
    }
    /**
     * Set DataFineAnalisiCampione value
     * @param string $dataFineAnalisiCampione
     * @return \StructType\Sample
     */
    public function setDataFineAnalisiCampione($dataFineAnalisiCampione = null)
    {
        // validation for constraint: string
        if (!is_null($dataFineAnalisiCampione) && !is_string($dataFineAnalisiCampione)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dataFineAnalisiCampione, true), gettype($dataFineAnalisiCampione)), __LINE__);
        }
        $this->DataFineAnalisiCampione = $dataFineAnalisiCampione;
        return $this;
    }
    /**
     * Get DataInizioAnalisiCampione value
     * @return string|null
     */
    public function getDataInizioAnalisiCampione()
    {
        return $this->DataInizioAnalisiCampione;
    }
    /**
     * Set DataInizioAnalisiCampione value
     * @param string $dataInizioAnalisiCampione
     * @return \StructType\Sample
     */
    public function setDataInizioAnalisiCampione($dataInizioAnalisiCampione = null)
    {
        // validation for constraint: string
        if (!is_null($dataInizioAnalisiCampione) && !is_string($dataInizioAnalisiCampione)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dataInizioAnalisiCampione, true), gettype($dataInizioAnalisiCampione)), __LINE__);
        }
        $this->DataInizioAnalisiCampione = $dataInizioAnalisiCampione;
        return $this;
    }
    /**
     * Get DataPrimoRapporto value
     * @return string|null
     */
    public function getDataPrimoRapporto()
    {
        return $this->DataPrimoRapporto;
    }
    /**
     * Set DataPrimoRapporto value
     * @param string $dataPrimoRapporto
     * @return \StructType\Sample
     */
    public function setDataPrimoRapporto($dataPrimoRapporto = null)
    {
        // validation for constraint: string
        if (!is_null($dataPrimoRapporto) && !is_string($dataPrimoRapporto)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dataPrimoRapporto, true), gettype($dataPrimoRapporto)), __LINE__);
        }
        $this->DataPrimoRapporto = $dataPrimoRapporto;
        return $this;
    }
    /**
     * Get DataRapporto value
     * @return string|null
     */
    public function getDataRapporto()
    {
        return $this->DataRapporto;
    }
    /**
     * Set DataRapporto value
     * @param string $dataRapporto
     * @return \StructType\Sample
     */
    public function setDataRapporto($dataRapporto = null)
    {
        // validation for constraint: string
        if (!is_null($dataRapporto) && !is_string($dataRapporto)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dataRapporto, true), gettype($dataRapporto)), __LINE__);
        }
        $this->DataRapporto = $dataRapporto;
        return $this;
    }
    /**
     * Get DataRapportoPrecedente value
     * @return string|null
     */
    public function getDataRapportoPrecedente()
    {
        return $this->DataRapportoPrecedente;
    }
    /**
     * Set DataRapportoPrecedente value
     * @param string $dataRapportoPrecedente
     * @return \StructType\Sample
     */
    public function setDataRapportoPrecedente($dataRapportoPrecedente = null)
    {
        // validation for constraint: string
        if (!is_null($dataRapportoPrecedente) && !is_string($dataRapportoPrecedente)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dataRapportoPrecedente, true), gettype($dataRapportoPrecedente)), __LINE__);
        }
        $this->DataRapportoPrecedente = $dataRapportoPrecedente;
        return $this;
    }
    /**
     * Get DataStampa value
     * @return string|null
     */
    public function getDataStampa()
    {
        return $this->DataStampa;
    }
    /**
     * Set DataStampa value
     * @param string $dataStampa
     * @return \StructType\Sample
     */
    public function setDataStampa($dataStampa = null)
    {
        // validation for constraint: string
        if (!is_null($dataStampa) && !is_string($dataStampa)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dataStampa, true), gettype($dataStampa)), __LINE__);
        }
        $this->DataStampa = $dataStampa;
        return $this;
    }
    /**
     * Get Esportato value
     * @return bool|null
     */
    public function getEsportato()
    {
        return $this->Esportato;
    }
    /**
     * Set Esportato value
     * @param bool $esportato
     * @return \StructType\Sample
     */
    public function setEsportato($esportato = null)
    {
        // validation for constraint: boolean
        if (!is_null($esportato) && !is_bool($esportato)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($esportato, true), gettype($esportato)), __LINE__);
        }
        $this->Esportato = $esportato;
        return $this;
    }
    /**
     * Get GiudizioRapporto value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getGiudizioRapporto()
    {
        return isset($this->GiudizioRapporto) ? $this->GiudizioRapporto : null;
    }
    /**
     * Set GiudizioRapporto value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $giudizioRapporto
     * @return \StructType\Sample
     */
    public function setGiudizioRapporto($giudizioRapporto = null)
    {
        // validation for constraint: string
        if (!is_null($giudizioRapporto) && !is_string($giudizioRapporto)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($giudizioRapporto, true), gettype($giudizioRapporto)), __LINE__);
        }
        if (is_null($giudizioRapporto) || (is_array($giudizioRapporto) && empty($giudizioRapporto))) {
            unset($this->GiudizioRapporto);
        } else {
            $this->GiudizioRapporto = $giudizioRapporto;
        }
        return $this;
    }
    /**
     * Get IdCampione value
     * @return int|null
     */
    public function getIdCampione()
    {
        return $this->IdCampione;
    }
    /**
     * Set IdCampione value
     * @param int $idCampione
     * @return \StructType\Sample
     */
    public function setIdCampione($idCampione = null)
    {
        // validation for constraint: int
        if (!is_null($idCampione) && !(is_int($idCampione) || ctype_digit($idCampione))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($idCampione, true), gettype($idCampione)), __LINE__);
        }
        $this->IdCampione = $idCampione;
        return $this;
    }
    /**
     * Get IdCommessa value
     * @return int|null
     */
    public function getIdCommessa()
    {
        return $this->IdCommessa;
    }
    /**
     * Set IdCommessa value
     * @param int $idCommessa
     * @return \StructType\Sample
     */
    public function setIdCommessa($idCommessa = null)
    {
        // validation for constraint: int
        if (!is_null($idCommessa) && !(is_int($idCommessa) || ctype_digit($idCommessa))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($idCommessa, true), gettype($idCommessa)), __LINE__);
        }
        $this->IdCommessa = $idCommessa;
        return $this;
    }
    /**
     * Get IdMatrice value
     * @return int|null
     */
    public function getIdMatrice()
    {
        return $this->IdMatrice;
    }
    /**
     * Set IdMatrice value
     * @param int $idMatrice
     * @return \StructType\Sample
     */
    public function setIdMatrice($idMatrice = null)
    {
        // validation for constraint: int
        if (!is_null($idMatrice) && !(is_int($idMatrice) || ctype_digit($idMatrice))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($idMatrice, true), gettype($idMatrice)), __LINE__);
        }
        $this->IdMatrice = $idMatrice;
        return $this;
    }
    /**
     * Get IdSottomatrice value
     * @return int|null
     */
    public function getIdSottomatrice()
    {
        return $this->IdSottomatrice;
    }
    /**
     * Set IdSottomatrice value
     * @param int $idSottomatrice
     * @return \StructType\Sample
     */
    public function setIdSottomatrice($idSottomatrice = null)
    {
        // validation for constraint: int
        if (!is_null($idSottomatrice) && !(is_int($idSottomatrice) || ctype_digit($idSottomatrice))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($idSottomatrice, true), gettype($idSottomatrice)), __LINE__);
        }
        $this->IdSottomatrice = $idSottomatrice;
        return $this;
    }
    /**
     * Get IdStatoCampione value
     * @return int|null
     */
    public function getIdStatoCampione()
    {
        return $this->IdStatoCampione;
    }
    /**
     * Set IdStatoCampione value
     * @param int $idStatoCampione
     * @return \StructType\Sample
     */
    public function setIdStatoCampione($idStatoCampione = null)
    {
        // validation for constraint: int
        if (!is_null($idStatoCampione) && !(is_int($idStatoCampione) || ctype_digit($idStatoCampione))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($idStatoCampione, true), gettype($idStatoCampione)), __LINE__);
        }
        $this->IdStatoCampione = $idStatoCampione;
        return $this;
    }
    /**
     * Get IdTipoCommessa value
     * @return int|null
     */
    public function getIdTipoCommessa()
    {
        return $this->IdTipoCommessa;
    }
    /**
     * Set IdTipoCommessa value
     * @param int $idTipoCommessa
     * @return \StructType\Sample
     */
    public function setIdTipoCommessa($idTipoCommessa = null)
    {
        // validation for constraint: int
        if (!is_null($idTipoCommessa) && !(is_int($idTipoCommessa) || ctype_digit($idTipoCommessa))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($idTipoCommessa, true), gettype($idTipoCommessa)), __LINE__);
        }
        $this->IdTipoCommessa = $idTipoCommessa;
        return $this;
    }
    /**
     * Get Matrice value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMatrice()
    {
        return isset($this->Matrice) ? $this->Matrice : null;
    }
    /**
     * Set Matrice value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $matrice
     * @return \StructType\Sample
     */
    public function setMatrice($matrice = null)
    {
        // validation for constraint: string
        if (!is_null($matrice) && !is_string($matrice)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($matrice, true), gettype($matrice)), __LINE__);
        }
        if (is_null($matrice) || (is_array($matrice) && empty($matrice))) {
            unset($this->Matrice);
        } else {
            $this->Matrice = $matrice;
        }
        return $this;
    }
    /**
     * Get NominativoCliente value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNominativoCliente()
    {
        return isset($this->NominativoCliente) ? $this->NominativoCliente : null;
    }
    /**
     * Set NominativoCliente value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $nominativoCliente
     * @return \StructType\Sample
     */
    public function setNominativoCliente($nominativoCliente = null)
    {
        // validation for constraint: string
        if (!is_null($nominativoCliente) && !is_string($nominativoCliente)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($nominativoCliente, true), gettype($nominativoCliente)), __LINE__);
        }
        if (is_null($nominativoCliente) || (is_array($nominativoCliente) && empty($nominativoCliente))) {
            unset($this->NominativoCliente);
        } else {
            $this->NominativoCliente = $nominativoCliente;
        }
        return $this;
    }
    /**
     * Get NominativoClienteFatturazione value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNominativoClienteFatturazione()
    {
        return isset($this->NominativoClienteFatturazione) ? $this->NominativoClienteFatturazione : null;
    }
    /**
     * Set NominativoClienteFatturazione value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $nominativoClienteFatturazione
     * @return \StructType\Sample
     */
    public function setNominativoClienteFatturazione($nominativoClienteFatturazione = null)
    {
        // validation for constraint: string
        if (!is_null($nominativoClienteFatturazione) && !is_string($nominativoClienteFatturazione)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($nominativoClienteFatturazione, true), gettype($nominativoClienteFatturazione)), __LINE__);
        }
        if (is_null($nominativoClienteFatturazione) || (is_array($nominativoClienteFatturazione) && empty($nominativoClienteFatturazione))) {
            unset($this->NominativoClienteFatturazione);
        } else {
            $this->NominativoClienteFatturazione = $nominativoClienteFatturazione;
        }
        return $this;
    }
    /**
     * Get NominativoClienteRapporto value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNominativoClienteRapporto()
    {
        return isset($this->NominativoClienteRapporto) ? $this->NominativoClienteRapporto : null;
    }
    /**
     * Set NominativoClienteRapporto value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $nominativoClienteRapporto
     * @return \StructType\Sample
     */
    public function setNominativoClienteRapporto($nominativoClienteRapporto = null)
    {
        // validation for constraint: string
        if (!is_null($nominativoClienteRapporto) && !is_string($nominativoClienteRapporto)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($nominativoClienteRapporto, true), gettype($nominativoClienteRapporto)), __LINE__);
        }
        if (is_null($nominativoClienteRapporto) || (is_array($nominativoClienteRapporto) && empty($nominativoClienteRapporto))) {
            unset($this->NominativoClienteRapporto);
        } else {
            $this->NominativoClienteRapporto = $nominativoClienteRapporto;
        }
        return $this;
    }
    /**
     * Get NotaEmendamento value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNotaEmendamento()
    {
        return isset($this->NotaEmendamento) ? $this->NotaEmendamento : null;
    }
    /**
     * Set NotaEmendamento value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $notaEmendamento
     * @return \StructType\Sample
     */
    public function setNotaEmendamento($notaEmendamento = null)
    {
        // validation for constraint: string
        if (!is_null($notaEmendamento) && !is_string($notaEmendamento)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($notaEmendamento, true), gettype($notaEmendamento)), __LINE__);
        }
        if (is_null($notaEmendamento) || (is_array($notaEmendamento) && empty($notaEmendamento))) {
            unset($this->NotaEmendamento);
        } else {
            $this->NotaEmendamento = $notaEmendamento;
        }
        return $this;
    }
    /**
     * Get NoteRapporto value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNoteRapporto()
    {
        return isset($this->NoteRapporto) ? $this->NoteRapporto : null;
    }
    /**
     * Set NoteRapporto value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $noteRapporto
     * @return \StructType\Sample
     */
    public function setNoteRapporto($noteRapporto = null)
    {
        // validation for constraint: string
        if (!is_null($noteRapporto) && !is_string($noteRapporto)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($noteRapporto, true), gettype($noteRapporto)), __LINE__);
        }
        if (is_null($noteRapporto) || (is_array($noteRapporto) && empty($noteRapporto))) {
            unset($this->NoteRapporto);
        } else {
            $this->NoteRapporto = $noteRapporto;
        }
        return $this;
    }
    /**
     * Get Riferimento value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRiferimento()
    {
        return isset($this->Riferimento) ? $this->Riferimento : null;
    }
    /**
     * Set Riferimento value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $riferimento
     * @return \StructType\Sample
     */
    public function setRiferimento($riferimento = null)
    {
        // validation for constraint: string
        if (!is_null($riferimento) && !is_string($riferimento)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($riferimento, true), gettype($riferimento)), __LINE__);
        }
        if (is_null($riferimento) || (is_array($riferimento) && empty($riferimento))) {
            unset($this->Riferimento);
        } else {
            $this->Riferimento = $riferimento;
        }
        return $this;
    }
    /**
     * Get RisultatiIrregolari value
     * @return bool|null
     */
    public function getRisultatiIrregolari()
    {
        return $this->RisultatiIrregolari;
    }
    /**
     * Set RisultatiIrregolari value
     * @param bool $risultatiIrregolari
     * @return \StructType\Sample
     */
    public function setRisultatiIrregolari($risultatiIrregolari = null)
    {
        // validation for constraint: boolean
        if (!is_null($risultatiIrregolari) && !is_bool($risultatiIrregolari)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($risultatiIrregolari, true), gettype($risultatiIrregolari)), __LINE__);
        }
        $this->RisultatiIrregolari = $risultatiIrregolari;
        return $this;
    }
    /**
     * Get SampleAnalysis value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfSampleAnalysis|null
     */
    public function getSampleAnalysis()
    {
        return isset($this->SampleAnalysis) ? $this->SampleAnalysis : null;
    }
    /**
     * Set SampleAnalysis value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfSampleAnalysis $sampleAnalysis
     * @return \StructType\Sample
     */
    public function setSampleAnalysis(\ArrayType\ArrayOfSampleAnalysis $sampleAnalysis = null)
    {
        if (is_null($sampleAnalysis) || (is_array($sampleAnalysis) && empty($sampleAnalysis))) {
            unset($this->SampleAnalysis);
        } else {
            $this->SampleAnalysis = $sampleAnalysis;
        }
        return $this;
    }
    /**
     * Get Sottomatrice value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSottomatrice()
    {
        return isset($this->Sottomatrice) ? $this->Sottomatrice : null;
    }
    /**
     * Set Sottomatrice value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $sottomatrice
     * @return \StructType\Sample
     */
    public function setSottomatrice($sottomatrice = null)
    {
        // validation for constraint: string
        if (!is_null($sottomatrice) && !is_string($sottomatrice)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sottomatrice, true), gettype($sottomatrice)), __LINE__);
        }
        if (is_null($sottomatrice) || (is_array($sottomatrice) && empty($sottomatrice))) {
            unset($this->Sottomatrice);
        } else {
            $this->Sottomatrice = $sottomatrice;
        }
        return $this;
    }
    /**
     * Get StatoCampione value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getStatoCampione()
    {
        return isset($this->StatoCampione) ? $this->StatoCampione : null;
    }
    /**
     * Set StatoCampione value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $statoCampione
     * @return \StructType\Sample
     */
    public function setStatoCampione($statoCampione = null)
    {
        // validation for constraint: string
        if (!is_null($statoCampione) && !is_string($statoCampione)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($statoCampione, true), gettype($statoCampione)), __LINE__);
        }
        if (is_null($statoCampione) || (is_array($statoCampione) && empty($statoCampione))) {
            unset($this->StatoCampione);
        } else {
            $this->StatoCampione = $statoCampione;
        }
        return $this;
    }
    /**
     * Get TipoCommessa value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTipoCommessa()
    {
        return isset($this->TipoCommessa) ? $this->TipoCommessa : null;
    }
    /**
     * Set TipoCommessa value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $tipoCommessa
     * @return \StructType\Sample
     */
    public function setTipoCommessa($tipoCommessa = null)
    {
        // validation for constraint: string
        if (!is_null($tipoCommessa) && !is_string($tipoCommessa)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($tipoCommessa, true), gettype($tipoCommessa)), __LINE__);
        }
        if (is_null($tipoCommessa) || (is_array($tipoCommessa) && empty($tipoCommessa))) {
            unset($this->TipoCommessa);
        } else {
            $this->TipoCommessa = $tipoCommessa;
        }
        return $this;
    }
    /**
     * Get VersioneRapporto value
     * @return int|null
     */
    public function getVersioneRapporto()
    {
        return $this->VersioneRapporto;
    }
    /**
     * Set VersioneRapporto value
     * @param int $versioneRapporto
     * @return \StructType\Sample
     */
    public function setVersioneRapporto($versioneRapporto = null)
    {
        // validation for constraint: int
        if (!is_null($versioneRapporto) && !(is_int($versioneRapporto) || ctype_digit($versioneRapporto))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($versioneRapporto, true), gettype($versioneRapporto)), __LINE__);
        }
        $this->VersioneRapporto = $versioneRapporto;
        return $this;
    }
    /**
     * Get VersioneRapportoPrecedente value
     * @return int|null
     */
    public function getVersioneRapportoPrecedente()
    {
        return $this->VersioneRapportoPrecedente;
    }
    /**
     * Set VersioneRapportoPrecedente value
     * @param int $versioneRapportoPrecedente
     * @return \StructType\Sample
     */
    public function setVersioneRapportoPrecedente($versioneRapportoPrecedente = null)
    {
        // validation for constraint: int
        if (!is_null($versioneRapportoPrecedente) && !(is_int($versioneRapportoPrecedente) || ctype_digit($versioneRapportoPrecedente))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($versioneRapportoPrecedente, true), gettype($versioneRapportoPrecedente)), __LINE__);
        }
        $this->VersioneRapportoPrecedente = $versioneRapportoPrecedente;
        return $this;
    }
}
