<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Get ServiceType
 * @subpackage Services
 */
class Get extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named GetSamples
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetSamples $parameters
     * @return \StructType\GetSamplesResponse|bool
     */
    public function GetSamples(\StructType\GetSamples $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetSamples($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetSampleAnalysis
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetSampleAnalysis $parameters
     * @return \StructType\GetSampleAnalysisResponse|bool
     */
    public function GetSampleAnalysis(\StructType\GetSampleAnalysis $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetSampleAnalysis($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetAnalysisName
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetAnalysisName $parameters
     * @return \StructType\GetAnalysisNameResponse|bool
     */
    public function GetAnalysisName(\StructType\GetAnalysisName $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetAnalysisName($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetProductsName
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetProductsName $parameters
     * @return \StructType\GetProductsNameResponse|bool
     */
    public function GetProductsName(\StructType\GetProductsName $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetProductsName($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetSampleReports
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetSampleReports $parameters
     * @return \StructType\GetSampleReportsResponse|bool
     */
    public function GetSampleReports(\StructType\GetSampleReports $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetSampleReports($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\GetAnalysisNameResponse|\StructType\GetProductsNameResponse|\StructType\GetSampleAnalysisResponse|\StructType\GetSampleReportsResponse|\StructType\GetSamplesResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
