<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SampleCustomFieldValue StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:SampleCustomFieldValue
 * @subpackage Structs
 */
class SampleCustomFieldValue extends AbstractStructBase
{
    /**
     * The IdCustomField
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $IdCustomField;
    /**
     * The Valore
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Valore;
    /**
     * Constructor method for SampleCustomFieldValue
     * @uses SampleCustomFieldValue::setIdCustomField()
     * @uses SampleCustomFieldValue::setValore()
     * @param int $idCustomField
     * @param string $valore
     */
    public function __construct($idCustomField = null, $valore = null)
    {
        $this
            ->setIdCustomField($idCustomField)
            ->setValore($valore);
    }
    /**
     * Get IdCustomField value
     * @return int|null
     */
    public function getIdCustomField()
    {
        return $this->IdCustomField;
    }
    /**
     * Set IdCustomField value
     * @param int $idCustomField
     * @return \StructType\SampleCustomFieldValue
     */
    public function setIdCustomField($idCustomField = null)
    {
        // validation for constraint: int
        if (!is_null($idCustomField) && !(is_int($idCustomField) || ctype_digit($idCustomField))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($idCustomField, true), gettype($idCustomField)), __LINE__);
        }
        $this->IdCustomField = $idCustomField;
        return $this;
    }
    /**
     * Get Valore value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getValore()
    {
        return isset($this->Valore) ? $this->Valore : null;
    }
    /**
     * Set Valore value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $valore
     * @return \StructType\SampleCustomFieldValue
     */
    public function setValore($valore = null)
    {
        // validation for constraint: string
        if (!is_null($valore) && !is_string($valore)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($valore, true), gettype($valore)), __LINE__);
        }
        if (is_null($valore) || (is_array($valore) && empty($valore))) {
            unset($this->Valore);
        } else {
            $this->Valore = $valore;
        }
        return $this;
    }
}
