<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AnalysisName StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:AnalysisName
 * @subpackage Structs
 */
class AnalysisName extends AbstractStructBase
{
    /**
     * The IdNomeParametro
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $IdNomeParametro;
    /**
     * The Parametro
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Parametro;
    /**
     * Constructor method for AnalysisName
     * @uses AnalysisName::setIdNomeParametro()
     * @uses AnalysisName::setParametro()
     * @param int $idNomeParametro
     * @param string $parametro
     */
    public function __construct($idNomeParametro = null, $parametro = null)
    {
        $this
            ->setIdNomeParametro($idNomeParametro)
            ->setParametro($parametro);
    }
    /**
     * Get IdNomeParametro value
     * @return int|null
     */
    public function getIdNomeParametro()
    {
        return $this->IdNomeParametro;
    }
    /**
     * Set IdNomeParametro value
     * @param int $idNomeParametro
     * @return \StructType\AnalysisName
     */
    public function setIdNomeParametro($idNomeParametro = null)
    {
        // validation for constraint: int
        if (!is_null($idNomeParametro) && !(is_int($idNomeParametro) || ctype_digit($idNomeParametro))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($idNomeParametro, true), gettype($idNomeParametro)), __LINE__);
        }
        $this->IdNomeParametro = $idNomeParametro;
        return $this;
    }
    /**
     * Get Parametro value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getParametro()
    {
        return isset($this->Parametro) ? $this->Parametro : null;
    }
    /**
     * Set Parametro value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $parametro
     * @return \StructType\AnalysisName
     */
    public function setParametro($parametro = null)
    {
        // validation for constraint: string
        if (!is_null($parametro) && !is_string($parametro)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($parametro, true), gettype($parametro)), __LINE__);
        }
        if (is_null($parametro) || (is_array($parametro) && empty($parametro))) {
            unset($this->Parametro);
        } else {
            $this->Parametro = $parametro;
        }
        return $this;
    }
}
