<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for MultiplyResponse StructType
 * @subpackage Structs
 */
class MultiplyResponse extends AbstractStructBase
{
    /**
     * The MultiplyResult
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $MultiplyResult;
    /**
     * Constructor method for MultiplyResponse
     * @uses MultiplyResponse::setMultiplyResult()
     * @param int $multiplyResult
     */
    public function __construct($multiplyResult = null)
    {
        $this
            ->setMultiplyResult($multiplyResult);
    }
    /**
     * Get MultiplyResult value
     * @return int
     */
    public function getMultiplyResult()
    {
        return $this->MultiplyResult;
    }
    /**
     * Set MultiplyResult value
     * @param int $multiplyResult
     * @return \StructType\MultiplyResponse
     */
    public function setMultiplyResult($multiplyResult = null)
    {
        // validation for constraint: int
        if (!is_null($multiplyResult) && !(is_int($multiplyResult) || ctype_digit($multiplyResult))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($multiplyResult, true), gettype($multiplyResult)), __LINE__);
        }
        $this->MultiplyResult = $multiplyResult;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\MultiplyResponse
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
