<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Multiply StructType
 * @subpackage Structs
 */
class Multiply extends AbstractStructBase
{
    /**
     * The intA
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $intA;
    /**
     * The intB
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $intB;
    /**
     * Constructor method for Multiply
     * @uses Multiply::setIntA()
     * @uses Multiply::setIntB()
     * @param int $intA
     * @param int $intB
     */
    public function __construct($intA = null, $intB = null)
    {
        $this
            ->setIntA($intA)
            ->setIntB($intB);
    }
    /**
     * Get intA value
     * @return int
     */
    public function getIntA()
    {
        return $this->intA;
    }
    /**
     * Set intA value
     * @param int $intA
     * @return \StructType\Multiply
     */
    public function setIntA($intA = null)
    {
        // validation for constraint: int
        if (!is_null($intA) && !(is_int($intA) || ctype_digit($intA))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($intA, true), gettype($intA)), __LINE__);
        }
        $this->intA = $intA;
        return $this;
    }
    /**
     * Get intB value
     * @return int
     */
    public function getIntB()
    {
        return $this->intB;
    }
    /**
     * Set intB value
     * @param int $intB
     * @return \StructType\Multiply
     */
    public function setIntB($intB = null)
    {
        // validation for constraint: int
        if (!is_null($intB) && !(is_int($intB) || ctype_digit($intB))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($intB, true), gettype($intB)), __LINE__);
        }
        $this->intB = $intB;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Multiply
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
