<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for WebKampanyaKosul StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:WebKampanyaKosul
 * @subpackage Structs
 */
class WebKampanyaKosul extends AbstractStructBase
{
    /**
     * The Bankalar
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfWebKampanyaIDTanim
     */
    public $Bankalar;
    /**
     * The BinNumaralari
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfstring
     */
    public $BinNumaralari;
    /**
     * The BirlestirilebilirKampanyalar
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfWebKampanyaIDTanim
     */
    public $BirlestirilebilirKampanyalar;
    /**
     * The Etiketler
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfWebKampanyaIDTanim
     */
    public $Etiketler;
    /**
     * The HediyeCekiIleKullanilabilir
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $HediyeCekiIleKullanilabilir;
    /**
     * The IndirimliUrunlerdeGecerli
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $IndirimliUrunlerdeGecerli;
    /**
     * The Kategoriler
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfWebKampanyaIDTanim
     */
    public $Kategoriler;
    /**
     * The Markalar
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfWebKampanyaIDTanim
     */
    public $Markalar;
    /**
     * The OdemeTipleri
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfWebKampanyaIDTanim
     */
    public $OdemeTipleri;
    /**
     * The Taksitler
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfint
     */
    public $Taksitler;
    /**
     * The Tedarikciler
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfWebKampanyaIDTanim
     */
    public $Tedarikciler;
    /**
     * The Tip
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $Tip;
    /**
     * The Urunler
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfWebKampanyaKosulUrun
     */
    public $Urunler;
    /**
     * The UyeGruplari
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfWebKampanyaIDTanim
     */
    public $UyeGruplari;
    /**
     * Constructor method for WebKampanyaKosul
     * @uses WebKampanyaKosul::setBankalar()
     * @uses WebKampanyaKosul::setBinNumaralari()
     * @uses WebKampanyaKosul::setBirlestirilebilirKampanyalar()
     * @uses WebKampanyaKosul::setEtiketler()
     * @uses WebKampanyaKosul::setHediyeCekiIleKullanilabilir()
     * @uses WebKampanyaKosul::setIndirimliUrunlerdeGecerli()
     * @uses WebKampanyaKosul::setKategoriler()
     * @uses WebKampanyaKosul::setMarkalar()
     * @uses WebKampanyaKosul::setOdemeTipleri()
     * @uses WebKampanyaKosul::setTaksitler()
     * @uses WebKampanyaKosul::setTedarikciler()
     * @uses WebKampanyaKosul::setTip()
     * @uses WebKampanyaKosul::setUrunler()
     * @uses WebKampanyaKosul::setUyeGruplari()
     * @param \ArrayType\ArrayOfWebKampanyaIDTanim $bankalar
     * @param \ArrayType\ArrayOfstring $binNumaralari
     * @param \ArrayType\ArrayOfWebKampanyaIDTanim $birlestirilebilirKampanyalar
     * @param \ArrayType\ArrayOfWebKampanyaIDTanim $etiketler
     * @param bool $hediyeCekiIleKullanilabilir
     * @param bool $indirimliUrunlerdeGecerli
     * @param \ArrayType\ArrayOfWebKampanyaIDTanim $kategoriler
     * @param \ArrayType\ArrayOfWebKampanyaIDTanim $markalar
     * @param \ArrayType\ArrayOfWebKampanyaIDTanim $odemeTipleri
     * @param \ArrayType\ArrayOfint $taksitler
     * @param \ArrayType\ArrayOfWebKampanyaIDTanim $tedarikciler
     * @param int $tip
     * @param \ArrayType\ArrayOfWebKampanyaKosulUrun $urunler
     * @param \ArrayType\ArrayOfWebKampanyaIDTanim $uyeGruplari
     */
    public function __construct(\ArrayType\ArrayOfWebKampanyaIDTanim $bankalar = null, \ArrayType\ArrayOfstring $binNumaralari = null, \ArrayType\ArrayOfWebKampanyaIDTanim $birlestirilebilirKampanyalar = null, \ArrayType\ArrayOfWebKampanyaIDTanim $etiketler = null, $hediyeCekiIleKullanilabilir = null, $indirimliUrunlerdeGecerli = null, \ArrayType\ArrayOfWebKampanyaIDTanim $kategoriler = null, \ArrayType\ArrayOfWebKampanyaIDTanim $markalar = null, \ArrayType\ArrayOfWebKampanyaIDTanim $odemeTipleri = null, \ArrayType\ArrayOfint $taksitler = null, \ArrayType\ArrayOfWebKampanyaIDTanim $tedarikciler = null, $tip = null, \ArrayType\ArrayOfWebKampanyaKosulUrun $urunler = null, \ArrayType\ArrayOfWebKampanyaIDTanim $uyeGruplari = null)
    {
        $this
            ->setBankalar($bankalar)
            ->setBinNumaralari($binNumaralari)
            ->setBirlestirilebilirKampanyalar($birlestirilebilirKampanyalar)
            ->setEtiketler($etiketler)
            ->setHediyeCekiIleKullanilabilir($hediyeCekiIleKullanilabilir)
            ->setIndirimliUrunlerdeGecerli($indirimliUrunlerdeGecerli)
            ->setKategoriler($kategoriler)
            ->setMarkalar($markalar)
            ->setOdemeTipleri($odemeTipleri)
            ->setTaksitler($taksitler)
            ->setTedarikciler($tedarikciler)
            ->setTip($tip)
            ->setUrunler($urunler)
            ->setUyeGruplari($uyeGruplari);
    }
    /**
     * Get Bankalar value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfWebKampanyaIDTanim|null
     */
    public function getBankalar()
    {
        return isset($this->Bankalar) ? $this->Bankalar : null;
    }
    /**
     * Set Bankalar value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfWebKampanyaIDTanim $bankalar
     * @return \StructType\WebKampanyaKosul
     */
    public function setBankalar(\ArrayType\ArrayOfWebKampanyaIDTanim $bankalar = null)
    {
        if (is_null($bankalar) || (is_array($bankalar) && empty($bankalar))) {
            unset($this->Bankalar);
        } else {
            $this->Bankalar = $bankalar;
        }
        return $this;
    }
    /**
     * Get BinNumaralari value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfstring|null
     */
    public function getBinNumaralari()
    {
        return isset($this->BinNumaralari) ? $this->BinNumaralari : null;
    }
    /**
     * Set BinNumaralari value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfstring $binNumaralari
     * @return \StructType\WebKampanyaKosul
     */
    public function setBinNumaralari(\ArrayType\ArrayOfstring $binNumaralari = null)
    {
        if (is_null($binNumaralari) || (is_array($binNumaralari) && empty($binNumaralari))) {
            unset($this->BinNumaralari);
        } else {
            $this->BinNumaralari = $binNumaralari;
        }
        return $this;
    }
    /**
     * Get BirlestirilebilirKampanyalar value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfWebKampanyaIDTanim|null
     */
    public function getBirlestirilebilirKampanyalar()
    {
        return isset($this->BirlestirilebilirKampanyalar) ? $this->BirlestirilebilirKampanyalar : null;
    }
    /**
     * Set BirlestirilebilirKampanyalar value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfWebKampanyaIDTanim $birlestirilebilirKampanyalar
     * @return \StructType\WebKampanyaKosul
     */
    public function setBirlestirilebilirKampanyalar(\ArrayType\ArrayOfWebKampanyaIDTanim $birlestirilebilirKampanyalar = null)
    {
        if (is_null($birlestirilebilirKampanyalar) || (is_array($birlestirilebilirKampanyalar) && empty($birlestirilebilirKampanyalar))) {
            unset($this->BirlestirilebilirKampanyalar);
        } else {
            $this->BirlestirilebilirKampanyalar = $birlestirilebilirKampanyalar;
        }
        return $this;
    }
    /**
     * Get Etiketler value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfWebKampanyaIDTanim|null
     */
    public function getEtiketler()
    {
        return isset($this->Etiketler) ? $this->Etiketler : null;
    }
    /**
     * Set Etiketler value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfWebKampanyaIDTanim $etiketler
     * @return \StructType\WebKampanyaKosul
     */
    public function setEtiketler(\ArrayType\ArrayOfWebKampanyaIDTanim $etiketler = null)
    {
        if (is_null($etiketler) || (is_array($etiketler) && empty($etiketler))) {
            unset($this->Etiketler);
        } else {
            $this->Etiketler = $etiketler;
        }
        return $this;
    }
    /**
     * Get HediyeCekiIleKullanilabilir value
     * @return bool|null
     */
    public function getHediyeCekiIleKullanilabilir()
    {
        return $this->HediyeCekiIleKullanilabilir;
    }
    /**
     * Set HediyeCekiIleKullanilabilir value
     * @param bool $hediyeCekiIleKullanilabilir
     * @return \StructType\WebKampanyaKosul
     */
    public function setHediyeCekiIleKullanilabilir($hediyeCekiIleKullanilabilir = null)
    {
        // validation for constraint: boolean
        if (!is_null($hediyeCekiIleKullanilabilir) && !is_bool($hediyeCekiIleKullanilabilir)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($hediyeCekiIleKullanilabilir, true), gettype($hediyeCekiIleKullanilabilir)), __LINE__);
        }
        $this->HediyeCekiIleKullanilabilir = $hediyeCekiIleKullanilabilir;
        return $this;
    }
    /**
     * Get IndirimliUrunlerdeGecerli value
     * @return bool|null
     */
    public function getIndirimliUrunlerdeGecerli()
    {
        return $this->IndirimliUrunlerdeGecerli;
    }
    /**
     * Set IndirimliUrunlerdeGecerli value
     * @param bool $indirimliUrunlerdeGecerli
     * @return \StructType\WebKampanyaKosul
     */
    public function setIndirimliUrunlerdeGecerli($indirimliUrunlerdeGecerli = null)
    {
        // validation for constraint: boolean
        if (!is_null($indirimliUrunlerdeGecerli) && !is_bool($indirimliUrunlerdeGecerli)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($indirimliUrunlerdeGecerli, true), gettype($indirimliUrunlerdeGecerli)), __LINE__);
        }
        $this->IndirimliUrunlerdeGecerli = $indirimliUrunlerdeGecerli;
        return $this;
    }
    /**
     * Get Kategoriler value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfWebKampanyaIDTanim|null
     */
    public function getKategoriler()
    {
        return isset($this->Kategoriler) ? $this->Kategoriler : null;
    }
    /**
     * Set Kategoriler value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfWebKampanyaIDTanim $kategoriler
     * @return \StructType\WebKampanyaKosul
     */
    public function setKategoriler(\ArrayType\ArrayOfWebKampanyaIDTanim $kategoriler = null)
    {
        if (is_null($kategoriler) || (is_array($kategoriler) && empty($kategoriler))) {
            unset($this->Kategoriler);
        } else {
            $this->Kategoriler = $kategoriler;
        }
        return $this;
    }
    /**
     * Get Markalar value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfWebKampanyaIDTanim|null
     */
    public function getMarkalar()
    {
        return isset($this->Markalar) ? $this->Markalar : null;
    }
    /**
     * Set Markalar value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfWebKampanyaIDTanim $markalar
     * @return \StructType\WebKampanyaKosul
     */
    public function setMarkalar(\ArrayType\ArrayOfWebKampanyaIDTanim $markalar = null)
    {
        if (is_null($markalar) || (is_array($markalar) && empty($markalar))) {
            unset($this->Markalar);
        } else {
            $this->Markalar = $markalar;
        }
        return $this;
    }
    /**
     * Get OdemeTipleri value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfWebKampanyaIDTanim|null
     */
    public function getOdemeTipleri()
    {
        return isset($this->OdemeTipleri) ? $this->OdemeTipleri : null;
    }
    /**
     * Set OdemeTipleri value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfWebKampanyaIDTanim $odemeTipleri
     * @return \StructType\WebKampanyaKosul
     */
    public function setOdemeTipleri(\ArrayType\ArrayOfWebKampanyaIDTanim $odemeTipleri = null)
    {
        if (is_null($odemeTipleri) || (is_array($odemeTipleri) && empty($odemeTipleri))) {
            unset($this->OdemeTipleri);
        } else {
            $this->OdemeTipleri = $odemeTipleri;
        }
        return $this;
    }
    /**
     * Get Taksitler value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfint|null
     */
    public function getTaksitler()
    {
        return isset($this->Taksitler) ? $this->Taksitler : null;
    }
    /**
     * Set Taksitler value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfint $taksitler
     * @return \StructType\WebKampanyaKosul
     */
    public function setTaksitler(\ArrayType\ArrayOfint $taksitler = null)
    {
        if (is_null($taksitler) || (is_array($taksitler) && empty($taksitler))) {
            unset($this->Taksitler);
        } else {
            $this->Taksitler = $taksitler;
        }
        return $this;
    }
    /**
     * Get Tedarikciler value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfWebKampanyaIDTanim|null
     */
    public function getTedarikciler()
    {
        return isset($this->Tedarikciler) ? $this->Tedarikciler : null;
    }
    /**
     * Set Tedarikciler value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfWebKampanyaIDTanim $tedarikciler
     * @return \StructType\WebKampanyaKosul
     */
    public function setTedarikciler(\ArrayType\ArrayOfWebKampanyaIDTanim $tedarikciler = null)
    {
        if (is_null($tedarikciler) || (is_array($tedarikciler) && empty($tedarikciler))) {
            unset($this->Tedarikciler);
        } else {
            $this->Tedarikciler = $tedarikciler;
        }
        return $this;
    }
    /**
     * Get Tip value
     * @return int|null
     */
    public function getTip()
    {
        return $this->Tip;
    }
    /**
     * Set Tip value
     * @param int $tip
     * @return \StructType\WebKampanyaKosul
     */
    public function setTip($tip = null)
    {
        // validation for constraint: int
        if (!is_null($tip) && !(is_int($tip) || ctype_digit($tip))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($tip, true), gettype($tip)), __LINE__);
        }
        $this->Tip = $tip;
        return $this;
    }
    /**
     * Get Urunler value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfWebKampanyaKosulUrun|null
     */
    public function getUrunler()
    {
        return isset($this->Urunler) ? $this->Urunler : null;
    }
    /**
     * Set Urunler value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfWebKampanyaKosulUrun $urunler
     * @return \StructType\WebKampanyaKosul
     */
    public function setUrunler(\ArrayType\ArrayOfWebKampanyaKosulUrun $urunler = null)
    {
        if (is_null($urunler) || (is_array($urunler) && empty($urunler))) {
            unset($this->Urunler);
        } else {
            $this->Urunler = $urunler;
        }
        return $this;
    }
    /**
     * Get UyeGruplari value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfWebKampanyaIDTanim|null
     */
    public function getUyeGruplari()
    {
        return isset($this->UyeGruplari) ? $this->UyeGruplari : null;
    }
    /**
     * Set UyeGruplari value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfWebKampanyaIDTanim $uyeGruplari
     * @return \StructType\WebKampanyaKosul
     */
    public function setUyeGruplari(\ArrayType\ArrayOfWebKampanyaIDTanim $uyeGruplari = null)
    {
        if (is_null($uyeGruplari) || (is_array($uyeGruplari) && empty($uyeGruplari))) {
            unset($this->UyeGruplari);
        } else {
            $this->UyeGruplari = $uyeGruplari;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\WebKampanyaKosul
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
