<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for WebKampanyaHediyeUrun StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:WebKampanyaHediyeUrun
 * @subpackage Structs
 */
class WebKampanyaHediyeUrun extends AbstractStructBase
{
    /**
     * The Adet
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $Adet;
    /**
     * The IslemDegeri
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $IslemDegeri;
    /**
     * The IslemTipi
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $IslemTipi;
    /**
     * The Resim
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Resim;
    /**
     * The UrunAdi
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $UrunAdi;
    /**
     * The UrunId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $UrunId;
    /**
     * Constructor method for WebKampanyaHediyeUrun
     * @uses WebKampanyaHediyeUrun::setAdet()
     * @uses WebKampanyaHediyeUrun::setIslemDegeri()
     * @uses WebKampanyaHediyeUrun::setIslemTipi()
     * @uses WebKampanyaHediyeUrun::setResim()
     * @uses WebKampanyaHediyeUrun::setUrunAdi()
     * @uses WebKampanyaHediyeUrun::setUrunId()
     * @param float $adet
     * @param float $islemDegeri
     * @param int $islemTipi
     * @param string $resim
     * @param string $urunAdi
     * @param int $urunId
     */
    public function __construct($adet = null, $islemDegeri = null, $islemTipi = null, $resim = null, $urunAdi = null, $urunId = null)
    {
        $this
            ->setAdet($adet)
            ->setIslemDegeri($islemDegeri)
            ->setIslemTipi($islemTipi)
            ->setResim($resim)
            ->setUrunAdi($urunAdi)
            ->setUrunId($urunId);
    }
    /**
     * Get Adet value
     * @return float|null
     */
    public function getAdet()
    {
        return $this->Adet;
    }
    /**
     * Set Adet value
     * @param float $adet
     * @return \StructType\WebKampanyaHediyeUrun
     */
    public function setAdet($adet = null)
    {
        // validation for constraint: float
        if (!is_null($adet) && !(is_float($adet) || is_numeric($adet))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($adet, true), gettype($adet)), __LINE__);
        }
        $this->Adet = $adet;
        return $this;
    }
    /**
     * Get IslemDegeri value
     * @return float|null
     */
    public function getIslemDegeri()
    {
        return $this->IslemDegeri;
    }
    /**
     * Set IslemDegeri value
     * @param float $islemDegeri
     * @return \StructType\WebKampanyaHediyeUrun
     */
    public function setIslemDegeri($islemDegeri = null)
    {
        // validation for constraint: float
        if (!is_null($islemDegeri) && !(is_float($islemDegeri) || is_numeric($islemDegeri))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($islemDegeri, true), gettype($islemDegeri)), __LINE__);
        }
        $this->IslemDegeri = $islemDegeri;
        return $this;
    }
    /**
     * Get IslemTipi value
     * @return int|null
     */
    public function getIslemTipi()
    {
        return $this->IslemTipi;
    }
    /**
     * Set IslemTipi value
     * @param int $islemTipi
     * @return \StructType\WebKampanyaHediyeUrun
     */
    public function setIslemTipi($islemTipi = null)
    {
        // validation for constraint: int
        if (!is_null($islemTipi) && !(is_int($islemTipi) || ctype_digit($islemTipi))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($islemTipi, true), gettype($islemTipi)), __LINE__);
        }
        $this->IslemTipi = $islemTipi;
        return $this;
    }
    /**
     * Get Resim value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getResim()
    {
        return isset($this->Resim) ? $this->Resim : null;
    }
    /**
     * Set Resim value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $resim
     * @return \StructType\WebKampanyaHediyeUrun
     */
    public function setResim($resim = null)
    {
        // validation for constraint: string
        if (!is_null($resim) && !is_string($resim)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($resim, true), gettype($resim)), __LINE__);
        }
        if (is_null($resim) || (is_array($resim) && empty($resim))) {
            unset($this->Resim);
        } else {
            $this->Resim = $resim;
        }
        return $this;
    }
    /**
     * Get UrunAdi value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getUrunAdi()
    {
        return isset($this->UrunAdi) ? $this->UrunAdi : null;
    }
    /**
     * Set UrunAdi value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $urunAdi
     * @return \StructType\WebKampanyaHediyeUrun
     */
    public function setUrunAdi($urunAdi = null)
    {
        // validation for constraint: string
        if (!is_null($urunAdi) && !is_string($urunAdi)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($urunAdi, true), gettype($urunAdi)), __LINE__);
        }
        if (is_null($urunAdi) || (is_array($urunAdi) && empty($urunAdi))) {
            unset($this->UrunAdi);
        } else {
            $this->UrunAdi = $urunAdi;
        }
        return $this;
    }
    /**
     * Get UrunId value
     * @return int|null
     */
    public function getUrunId()
    {
        return $this->UrunId;
    }
    /**
     * Set UrunId value
     * @param int $urunId
     * @return \StructType\WebKampanyaHediyeUrun
     */
    public function setUrunId($urunId = null)
    {
        // validation for constraint: int
        if (!is_null($urunId) && !(is_int($urunId) || ctype_digit($urunId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($urunId, true), gettype($urunId)), __LINE__);
        }
        $this->UrunId = $urunId;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\WebKampanyaHediyeUrun
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
