<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for WebTaksitSecenek StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:WebTaksitSecenek
 * @subpackage Structs
 */
class WebTaksitSecenek extends AbstractStructBase
{
    /**
     * The TaksitSayisi
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $TaksitSayisi;
    /**
     * The TaksitTanim
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $TaksitTanim;
    /**
     * The TaksitTutari
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $TaksitTutari;
    /**
     * The ToplamTutar
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $ToplamTutar;
    /**
     * Constructor method for WebTaksitSecenek
     * @uses WebTaksitSecenek::setTaksitSayisi()
     * @uses WebTaksitSecenek::setTaksitTanim()
     * @uses WebTaksitSecenek::setTaksitTutari()
     * @uses WebTaksitSecenek::setToplamTutar()
     * @param int $taksitSayisi
     * @param string $taksitTanim
     * @param float $taksitTutari
     * @param float $toplamTutar
     */
    public function __construct($taksitSayisi = null, $taksitTanim = null, $taksitTutari = null, $toplamTutar = null)
    {
        $this
            ->setTaksitSayisi($taksitSayisi)
            ->setTaksitTanim($taksitTanim)
            ->setTaksitTutari($taksitTutari)
            ->setToplamTutar($toplamTutar);
    }
    /**
     * Get TaksitSayisi value
     * @return int|null
     */
    public function getTaksitSayisi()
    {
        return $this->TaksitSayisi;
    }
    /**
     * Set TaksitSayisi value
     * @param int $taksitSayisi
     * @return \StructType\WebTaksitSecenek
     */
    public function setTaksitSayisi($taksitSayisi = null)
    {
        // validation for constraint: int
        if (!is_null($taksitSayisi) && !(is_int($taksitSayisi) || ctype_digit($taksitSayisi))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($taksitSayisi, true), gettype($taksitSayisi)), __LINE__);
        }
        $this->TaksitSayisi = $taksitSayisi;
        return $this;
    }
    /**
     * Get TaksitTanim value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTaksitTanim()
    {
        return isset($this->TaksitTanim) ? $this->TaksitTanim : null;
    }
    /**
     * Set TaksitTanim value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $taksitTanim
     * @return \StructType\WebTaksitSecenek
     */
    public function setTaksitTanim($taksitTanim = null)
    {
        // validation for constraint: string
        if (!is_null($taksitTanim) && !is_string($taksitTanim)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($taksitTanim, true), gettype($taksitTanim)), __LINE__);
        }
        if (is_null($taksitTanim) || (is_array($taksitTanim) && empty($taksitTanim))) {
            unset($this->TaksitTanim);
        } else {
            $this->TaksitTanim = $taksitTanim;
        }
        return $this;
    }
    /**
     * Get TaksitTutari value
     * @return float|null
     */
    public function getTaksitTutari()
    {
        return $this->TaksitTutari;
    }
    /**
     * Set TaksitTutari value
     * @param float $taksitTutari
     * @return \StructType\WebTaksitSecenek
     */
    public function setTaksitTutari($taksitTutari = null)
    {
        // validation for constraint: float
        if (!is_null($taksitTutari) && !(is_float($taksitTutari) || is_numeric($taksitTutari))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($taksitTutari, true), gettype($taksitTutari)), __LINE__);
        }
        $this->TaksitTutari = $taksitTutari;
        return $this;
    }
    /**
     * Get ToplamTutar value
     * @return float|null
     */
    public function getToplamTutar()
    {
        return $this->ToplamTutar;
    }
    /**
     * Set ToplamTutar value
     * @param float $toplamTutar
     * @return \StructType\WebTaksitSecenek
     */
    public function setToplamTutar($toplamTutar = null)
    {
        // validation for constraint: float
        if (!is_null($toplamTutar) && !(is_float($toplamTutar) || is_numeric($toplamTutar))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($toplamTutar, true), gettype($toplamTutar)), __LINE__);
        }
        $this->ToplamTutar = $toplamTutar;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\WebTaksitSecenek
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
