<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Remove ServiceType
 * @subpackage Services
 */
class Remove extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named RemoveFavoriUrun
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\RemoveFavoriUrun $parameters
     * @return \StructType\RemoveFavoriUrunResponse|bool
     */
    public function RemoveFavoriUrun(\StructType\RemoveFavoriUrun $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->RemoveFavoriUrun($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named RemoveFiyatAlarmUrun
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\RemoveFiyatAlarmUrun $parameters
     * @return \StructType\RemoveFiyatAlarmUrunResponse|bool
     */
    public function RemoveFiyatAlarmUrun(\StructType\RemoveFiyatAlarmUrun $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->RemoveFiyatAlarmUrun($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named RemoveStokAlarmUrun
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\RemoveStokAlarmUrun $parameters
     * @return \StructType\RemoveStokAlarmUrunResponse|bool
     */
    public function RemoveStokAlarmUrun(\StructType\RemoveStokAlarmUrun $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->RemoveStokAlarmUrun($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\RemoveFavoriUrunResponse|\StructType\RemoveFiyatAlarmUrunResponse|\StructType\RemoveStokAlarmUrunResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
