<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfMailList ArrayType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:ArrayOfMailList
 * @subpackage Arrays
 */
class ArrayOfMailList extends AbstractStructArrayBase
{
    /**
     * The MailList
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\MailList[]
     */
    public $MailList;
    /**
     * Constructor method for ArrayOfMailList
     * @uses ArrayOfMailList::setMailList()
     * @param \StructType\MailList[] $mailList
     */
    public function __construct(array $mailList = array())
    {
        $this
            ->setMailList($mailList);
    }
    /**
     * Get MailList value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\MailList[]|null
     */
    public function getMailList()
    {
        return isset($this->MailList) ? $this->MailList : null;
    }
    /**
     * This method is responsible for validating the values passed to the setMailList method
     * This method is willingly generated in order to preserve the one-line inline validation within the setMailList method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateMailListForArrayConstraintsFromSetMailList(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfMailListMailListItem) {
            // validation for constraint: itemType
            if (!$arrayOfMailListMailListItem instanceof \StructType\MailList) {
                $invalidValues[] = is_object($arrayOfMailListMailListItem) ? get_class($arrayOfMailListMailListItem) : sprintf('%s(%s)', gettype($arrayOfMailListMailListItem), var_export($arrayOfMailListMailListItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The MailList property can only contain items of type \StructType\MailList, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set MailList value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\MailList[] $mailList
     * @return \ArrayType\ArrayOfMailList
     */
    public function setMailList(array $mailList = array())
    {
        // validation for constraint: array
        if ('' !== ($mailListArrayErrorMessage = self::validateMailListForArrayConstraintsFromSetMailList($mailList))) {
            throw new \InvalidArgumentException($mailListArrayErrorMessage, __LINE__);
        }
        if (is_null($mailList) || (is_array($mailList) && empty($mailList))) {
            unset($this->MailList);
        } else {
            $this->MailList = $mailList;
        }
        return $this;
    }
    /**
     * Add item to MailList value
     * @throws \InvalidArgumentException
     * @param \StructType\MailList $item
     * @return \ArrayType\ArrayOfMailList
     */
    public function addToMailList(\StructType\MailList $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\MailList) {
            throw new \InvalidArgumentException(sprintf('The MailList property can only contain items of type \StructType\MailList, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->MailList[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\MailList|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\MailList|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\MailList|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\MailList|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\MailList|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string MailList
     */
    public function getAttributeName()
    {
        return 'MailList';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfMailList
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
