<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for WebIadeTalepGuncelleRequest StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:WebIadeTalepGuncelleRequest
 * @subpackage Structs
 */
class WebIadeTalepGuncelleRequest extends AbstractStructBase
{
    /**
     * The MailGonder
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $MailGonder;
    /**
     * The Talep
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\IadeTalep
     */
    public $Talep;
    /**
     * Constructor method for WebIadeTalepGuncelleRequest
     * @uses WebIadeTalepGuncelleRequest::setMailGonder()
     * @uses WebIadeTalepGuncelleRequest::setTalep()
     * @param bool $mailGonder
     * @param \StructType\IadeTalep $talep
     */
    public function __construct($mailGonder = null, \StructType\IadeTalep $talep = null)
    {
        $this
            ->setMailGonder($mailGonder)
            ->setTalep($talep);
    }
    /**
     * Get MailGonder value
     * @return bool|null
     */
    public function getMailGonder()
    {
        return $this->MailGonder;
    }
    /**
     * Set MailGonder value
     * @param bool $mailGonder
     * @return \StructType\WebIadeTalepGuncelleRequest
     */
    public function setMailGonder($mailGonder = null)
    {
        // validation for constraint: boolean
        if (!is_null($mailGonder) && !is_bool($mailGonder)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($mailGonder, true), gettype($mailGonder)), __LINE__);
        }
        $this->MailGonder = $mailGonder;
        return $this;
    }
    /**
     * Get Talep value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\IadeTalep|null
     */
    public function getTalep()
    {
        return isset($this->Talep) ? $this->Talep : null;
    }
    /**
     * Set Talep value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\IadeTalep $talep
     * @return \StructType\WebIadeTalepGuncelleRequest
     */
    public function setTalep(\StructType\IadeTalep $talep = null)
    {
        if (is_null($talep) || (is_array($talep) && empty($talep))) {
            unset($this->Talep);
        } else {
            $this->Talep = $talep;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\WebIadeTalepGuncelleRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
