<?php
/**
 * This file aims to show you how to use this generated package.
 * In addition, the goal is to show which methods are available and the fist needed parameter(s)
 * You have to use an associative array such as:
 * - the key must be a constant beginning with WSDL_ from AbstractSoapClientbase class each generated ServiceType class extends this class
 * - the value must be the corresponding key value (each option matches a {@link http://www.php.net/manual/en/soapclient.soapclient.php} option)
 * $options = array(
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'https://www.nofilterbutik.com/Servis/CustomServis.svc?wsdl',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_TRACE => true,
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_LOGIN => 'you_secret_login',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_PASSWORD => 'you_secret_password',
 * );
 * etc....
 */
require_once __DIR__ . '/vendor/autoload.php';
/**
 * Minimal options
 */
$options = array(
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'https://www.nofilterbutik.com/Servis/CustomServis.svc?wsdl',
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_CLASSMAP => ClassMap::get(),
);
/**
 * Samples for Save ServiceType
 */
$save = new \ServiceType\Save($options);
/**
 * Sample call for SaveEntegrasyonId operation/method
 */
if ($save->SaveEntegrasyonId(new \StructType\SaveEntegrasyonId()) !== false) {
    print_r($save->getResult());
} else {
    print_r($save->getLastError());
}
/**
 * Sample call for SaveMenu operation/method
 */
if ($save->SaveMenu(new \StructType\SaveMenu()) !== false) {
    print_r($save->getResult());
} else {
    print_r($save->getLastError());
}
/**
 * Sample call for SaveSupportTicket operation/method
 */
if ($save->SaveSupportTicket(new \StructType\SaveSupportTicket()) !== false) {
    print_r($save->getResult());
} else {
    print_r($save->getLastError());
}
/**
 * Sample call for SaveSupportTicketAnswer operation/method
 */
if ($save->SaveSupportTicketAnswer(new \StructType\SaveSupportTicketAnswer()) !== false) {
    print_r($save->getResult());
} else {
    print_r($save->getLastError());
}
/**
 * Samples for Select ServiceType
 */
$select = new \ServiceType\Select($options);
/**
 * Sample call for SelectEntegrasyonId operation/method
 */
if ($select->SelectEntegrasyonId(new \StructType\SelectEntegrasyonId()) !== false) {
    print_r($select->getResult());
} else {
    print_r($select->getLastError());
}
/**
 * Sample call for SelectMailList operation/method
 */
if ($select->SelectMailList(new \StructType\SelectMailList()) !== false) {
    print_r($select->getResult());
} else {
    print_r($select->getLastError());
}
/**
 * Sample call for SelectEntegrasyon operation/method
 */
if ($select->SelectEntegrasyon(new \StructType\SelectEntegrasyon()) !== false) {
    print_r($select->getResult());
} else {
    print_r($select->getLastError());
}
/**
 * Sample call for SelectKargoDesiFiyat operation/method
 */
if ($select->SelectKargoDesiFiyat(new \StructType\SelectKargoDesiFiyat()) !== false) {
    print_r($select->getResult());
} else {
    print_r($select->getLastError());
}
/**
 * Sample call for SelectUlkeler operation/method
 */
if ($select->SelectUlkeler(new \StructType\SelectUlkeler()) !== false) {
    print_r($select->getResult());
} else {
    print_r($select->getLastError());
}
/**
 * Sample call for SelectIller operation/method
 */
if ($select->SelectIller(new \StructType\SelectIller()) !== false) {
    print_r($select->getResult());
} else {
    print_r($select->getLastError());
}
/**
 * Sample call for SelectIlceler operation/method
 */
if ($select->SelectIlceler(new \StructType\SelectIlceler()) !== false) {
    print_r($select->getResult());
} else {
    print_r($select->getLastError());
}
/**
 * Sample call for SelectKargoFirmalari operation/method
 */
if ($select->SelectKargoFirmalari(new \StructType\SelectKargoFirmalari()) !== false) {
    print_r($select->getResult());
} else {
    print_r($select->getLastError());
}
/**
 * Sample call for SelectIadeTalebi operation/method
 */
if ($select->SelectIadeTalebi(new \StructType\SelectIadeTalebi()) !== false) {
    print_r($select->getResult());
} else {
    print_r($select->getLastError());
}
/**
 * Samples for Delete ServiceType
 */
$delete = new \ServiceType\Delete($options);
/**
 * Sample call for DeleteEntegrasyonId operation/method
 */
if ($delete->DeleteEntegrasyonId(new \StructType\DeleteEntegrasyonId()) !== false) {
    print_r($delete->getResult());
} else {
    print_r($delete->getLastError());
}
/**
 * Sample call for DeleteMenu operation/method
 */
if ($delete->DeleteMenu(new \StructType\DeleteMenu()) !== false) {
    print_r($delete->getResult());
} else {
    print_r($delete->getLastError());
}
/**
 * Samples for Guncelle ServiceType
 */
$guncelle = new \ServiceType\Guncelle($options);
/**
 * Sample call for GuncelleKargoDesiFiyat operation/method
 */
if ($guncelle->GuncelleKargoDesiFiyat(new \StructType\GuncelleKargoDesiFiyat()) !== false) {
    print_r($guncelle->getResult());
} else {
    print_r($guncelle->getLastError());
}
/**
 * Samples for Update ServiceType
 */
$update = new \ServiceType\Update($options);
/**
 * Sample call for UpdateIadeTalebi operation/method
 */
if ($update->UpdateIadeTalebi(new \StructType\UpdateIadeTalebi()) !== false) {
    print_r($update->getResult());
} else {
    print_r($update->getLastError());
}
/**
 * Samples for Get ServiceType
 */
$get = new \ServiceType\Get($options);
/**
 * Sample call for GetTaksitSecenek operation/method
 */
if ($get->GetTaksitSecenek(new \StructType\GetTaksitSecenek()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetKampanya operation/method
 */
if ($get->GetKampanya(new \StructType\GetKampanya()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetFavoriUrunler operation/method
 */
if ($get->GetFavoriUrunler(new \StructType\GetFavoriUrunler()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetFiyatAlarmUrunler operation/method
 */
if ($get->GetFiyatAlarmUrunler(new \StructType\GetFiyatAlarmUrunler()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetStokAlarmUrunler operation/method
 */
if ($get->GetStokAlarmUrunler(new \StructType\GetStokAlarmUrunler()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetMenu operation/method
 */
if ($get->GetMenu(new \StructType\GetMenu()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetSupportTicketSubject operation/method
 */
if ($get->GetSupportTicketSubject(new \StructType\GetSupportTicketSubject()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetSupportTickets operation/method
 */
if ($get->GetSupportTickets(new \StructType\GetSupportTickets()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetSupportTicketMessages operation/method
 */
if ($get->GetSupportTicketMessages(new \StructType\GetSupportTicketMessages()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetCampaingBanners operation/method
 */
if ($get->GetCampaingBanners(new \StructType\GetCampaingBanners()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetKampanyaV2 operation/method
 */
if ($get->GetKampanyaV2(new \StructType\GetKampanyaV2()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Samples for Add ServiceType
 */
$add = new \ServiceType\Add($options);
/**
 * Sample call for AddFavoriUrun operation/method
 */
if ($add->AddFavoriUrun(new \StructType\AddFavoriUrun()) !== false) {
    print_r($add->getResult());
} else {
    print_r($add->getLastError());
}
/**
 * Sample call for AddFiyatAlarmUrun operation/method
 */
if ($add->AddFiyatAlarmUrun(new \StructType\AddFiyatAlarmUrun()) !== false) {
    print_r($add->getResult());
} else {
    print_r($add->getLastError());
}
/**
 * Sample call for AddStokAlarmUrun operation/method
 */
if ($add->AddStokAlarmUrun(new \StructType\AddStokAlarmUrun()) !== false) {
    print_r($add->getResult());
} else {
    print_r($add->getLastError());
}
/**
 * Samples for Remove ServiceType
 */
$remove = new \ServiceType\Remove($options);
/**
 * Sample call for RemoveFavoriUrun operation/method
 */
if ($remove->RemoveFavoriUrun(new \StructType\RemoveFavoriUrun()) !== false) {
    print_r($remove->getResult());
} else {
    print_r($remove->getLastError());
}
/**
 * Sample call for RemoveFiyatAlarmUrun operation/method
 */
if ($remove->RemoveFiyatAlarmUrun(new \StructType\RemoveFiyatAlarmUrun()) !== false) {
    print_r($remove->getResult());
} else {
    print_r($remove->getLastError());
}
/**
 * Sample call for RemoveStokAlarmUrun operation/method
 */
if ($remove->RemoveStokAlarmUrun(new \StructType\RemoveStokAlarmUrun()) !== false) {
    print_r($remove->getResult());
} else {
    print_r($remove->getLastError());
}
