<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for productos StructType
 * @subpackage Structs
 */
class Productos extends AbstractStructBase
{
    /**
     * The producto
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Notificacion_oferta_producto[]
     */
    public $producto;
    /**
     * Constructor method for productos
     * @uses Productos::setProducto()
     * @param \StructType\Notificacion_oferta_producto[] $producto
     */
    public function __construct(array $producto = array())
    {
        $this
            ->setProducto($producto);
    }
    /**
     * Get producto value
     * @return \StructType\Notificacion_oferta_producto[]|null
     */
    public function getProducto()
    {
        return $this->producto;
    }
    /**
     * This method is responsible for validating the values passed to the setProducto method
     * This method is willingly generated in order to preserve the one-line inline validation within the setProducto method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateProductoForArrayConstraintsFromSetProducto(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $productosProductoItem) {
            // validation for constraint: itemType
            if (!$productosProductoItem instanceof \StructType\Notificacion_oferta_producto) {
                $invalidValues[] = is_object($productosProductoItem) ? get_class($productosProductoItem) : sprintf('%s(%s)', gettype($productosProductoItem), var_export($productosProductoItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The producto property can only contain items of type \StructType\Notificacion_oferta_producto, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set producto value
     * @throws \InvalidArgumentException
     * @param \StructType\Notificacion_oferta_producto[] $producto
     * @return \StructType\Productos
     */
    public function setProducto(array $producto = array())
    {
        // validation for constraint: array
        if ('' !== ($productoArrayErrorMessage = self::validateProductoForArrayConstraintsFromSetProducto($producto))) {
            throw new \InvalidArgumentException($productoArrayErrorMessage, __LINE__);
        }
        $this->producto = $producto;
        return $this;
    }
    /**
     * Add item to producto value
     * @throws \InvalidArgumentException
     * @param \StructType\Notificacion_oferta_producto $item
     * @return \StructType\Productos
     */
    public function addToProducto(\StructType\Notificacion_oferta_producto $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Notificacion_oferta_producto) {
            throw new \InvalidArgumentException(sprintf('The producto property can only contain items of type \StructType\Notificacion_oferta_producto, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->producto[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Productos
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
