<?php

namespace EnumType;

/**
 * This class stands for tipo-atributo EnumType
 * @subpackage Enumerations
 */
class Tipo_atributo
{
    /**
     * Constant for value 'TIPO_ENTERO'
     * @return string 'TIPO_ENTERO'
     */
    const VALUE_TIPO_ENTERO = 'TIPO_ENTERO';
    /**
     * Constant for value 'TIPO_DECIMAL'
     * @return string 'TIPO_DECIMAL'
     */
    const VALUE_TIPO_DECIMAL = 'TIPO_DECIMAL';
    /**
     * Constant for value 'TIPO_FECHA'
     * @return string 'TIPO_FECHA'
     */
    const VALUE_TIPO_FECHA = 'TIPO_FECHA';
    /**
     * Constant for value 'TIPO_BOOLEANO'
     * @return string 'TIPO_BOOLEANO'
     */
    const VALUE_TIPO_BOOLEANO = 'TIPO_BOOLEANO';
    /**
     * Constant for value 'TIPO_TEXTO'
     * @return string 'TIPO_TEXTO'
     */
    const VALUE_TIPO_TEXTO = 'TIPO_TEXTO';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_TIPO_ENTERO
     * @uses self::VALUE_TIPO_DECIMAL
     * @uses self::VALUE_TIPO_FECHA
     * @uses self::VALUE_TIPO_BOOLEANO
     * @uses self::VALUE_TIPO_TEXTO
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_TIPO_ENTERO,
            self::VALUE_TIPO_DECIMAL,
            self::VALUE_TIPO_FECHA,
            self::VALUE_TIPO_BOOLEANO,
            self::VALUE_TIPO_TEXTO,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
