<?php

namespace EnumType;

/**
 * This class stands for tipoNotificacion EnumType
 * @subpackage Enumerations
 */
class TipoNotificacion
{
    /**
     * Constant for value 'OK'
     * @return string 'OK'
     */
    const VALUE_OK = 'OK';
    /**
     * Constant for value 'RECHAZO'
     * @return string 'RECHAZO'
     */
    const VALUE_RECHAZO = 'RECHAZO';
    /**
     * Constant for value 'ERROR'
     * @return string 'ERROR'
     */
    const VALUE_ERROR = 'ERROR';
    /**
     * Constant for value 'PENDIENTE_PAGO'
     * @return string 'PENDIENTE_PAGO'
     */
    const VALUE_PENDIENTE_PAGO = 'PENDIENTE_PAGO';
    /**
     * Constant for value 'INFO'
     * @return string 'INFO'
     */
    const VALUE_INFO = 'INFO';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_OK
     * @uses self::VALUE_RECHAZO
     * @uses self::VALUE_ERROR
     * @uses self::VALUE_PENDIENTE_PAGO
     * @uses self::VALUE_INFO
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_OK,
            self::VALUE_RECHAZO,
            self::VALUE_ERROR,
            self::VALUE_PENDIENTE_PAGO,
            self::VALUE_INFO,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
