<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for conceptos StructType
 * @subpackage Structs
 */
class Conceptos extends AbstractStructBase
{
    /**
     * The concepto
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Notificacion_concepto[]
     */
    public $concepto;
    /**
     * Constructor method for conceptos
     * @uses Conceptos::setConcepto()
     * @param \StructType\Notificacion_concepto[] $concepto
     */
    public function __construct(array $concepto = array())
    {
        $this
            ->setConcepto($concepto);
    }
    /**
     * Get concepto value
     * @return \StructType\Notificacion_concepto[]|null
     */
    public function getConcepto()
    {
        return $this->concepto;
    }
    /**
     * This method is responsible for validating the values passed to the setConcepto method
     * This method is willingly generated in order to preserve the one-line inline validation within the setConcepto method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateConceptoForArrayConstraintsFromSetConcepto(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $conceptosConceptoItem) {
            // validation for constraint: itemType
            if (!$conceptosConceptoItem instanceof \StructType\Notificacion_concepto) {
                $invalidValues[] = is_object($conceptosConceptoItem) ? get_class($conceptosConceptoItem) : sprintf('%s(%s)', gettype($conceptosConceptoItem), var_export($conceptosConceptoItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The concepto property can only contain items of type \StructType\Notificacion_concepto, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set concepto value
     * @throws \InvalidArgumentException
     * @param \StructType\Notificacion_concepto[] $concepto
     * @return \StructType\Conceptos
     */
    public function setConcepto(array $concepto = array())
    {
        // validation for constraint: array
        if ('' !== ($conceptoArrayErrorMessage = self::validateConceptoForArrayConstraintsFromSetConcepto($concepto))) {
            throw new \InvalidArgumentException($conceptoArrayErrorMessage, __LINE__);
        }
        $this->concepto = $concepto;
        return $this;
    }
    /**
     * Add item to concepto value
     * @throws \InvalidArgumentException
     * @param \StructType\Notificacion_concepto $item
     * @return \StructType\Conceptos
     */
    public function addToConcepto(\StructType\Notificacion_concepto $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Notificacion_concepto) {
            throw new \InvalidArgumentException(sprintf('The concepto property can only contain items of type \StructType\Notificacion_concepto, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->concepto[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Conceptos
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
