<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for notificacion-medio-de-pago StructType
 * @subpackage Structs
 */
class Notificacion_medio_de_pago extends AbstractStructBase
{
    /**
     * The codigo_medio_de_pago
     * @var string
     */
    public $codigo_medio_de_pago;
    /**
     * The codigo_forma_de_pago
     * @var string
     */
    public $codigo_forma_de_pago;
    /**
     * The codigo_procesador
     * @var string
     */
    public $codigo_procesador;
    /**
     * The descuento
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $descuento;
    /**
     * The cuotas
     * @var int
     */
    public $cuotas;
    /**
     * The fecha_hora_confirmacion_medio_de_pago
     * @var string
     */
    public $fecha_hora_confirmacion_medio_de_pago;
    /**
     * The estado
     * @var string
     */
    public $estado;
    /**
     * The importes_tasas
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Importes_tasas
     */
    public $importes_tasas;
    /**
     * Constructor method for notificacion-medio-de-pago
     * @uses Notificacion_medio_de_pago::setCodigo_medio_de_pago()
     * @uses Notificacion_medio_de_pago::setCodigo_forma_de_pago()
     * @uses Notificacion_medio_de_pago::setCodigo_procesador()
     * @uses Notificacion_medio_de_pago::setDescuento()
     * @uses Notificacion_medio_de_pago::setCuotas()
     * @uses Notificacion_medio_de_pago::setFecha_hora_confirmacion_medio_de_pago()
     * @uses Notificacion_medio_de_pago::setEstado()
     * @uses Notificacion_medio_de_pago::setImportes_tasas()
     * @param string $codigo_medio_de_pago
     * @param string $codigo_forma_de_pago
     * @param string $codigo_procesador
     * @param float $descuento
     * @param int $cuotas
     * @param string $fecha_hora_confirmacion_medio_de_pago
     * @param string $estado
     * @param \StructType\Importes_tasas $importes_tasas
     */
    public function __construct($codigo_medio_de_pago = null, $codigo_forma_de_pago = null, $codigo_procesador = null, $descuento = null, $cuotas = null, $fecha_hora_confirmacion_medio_de_pago = null, $estado = null, \StructType\Importes_tasas $importes_tasas = null)
    {
        $this
            ->setCodigo_medio_de_pago($codigo_medio_de_pago)
            ->setCodigo_forma_de_pago($codigo_forma_de_pago)
            ->setCodigo_procesador($codigo_procesador)
            ->setDescuento($descuento)
            ->setCuotas($cuotas)
            ->setFecha_hora_confirmacion_medio_de_pago($fecha_hora_confirmacion_medio_de_pago)
            ->setEstado($estado)
            ->setImportes_tasas($importes_tasas);
    }
    /**
     * Get codigo_medio_de_pago value
     * @return string|null
     */
    public function getCodigo_medio_de_pago()
    {
        return $this->{'codigo-medio-de-pago'};
    }
    /**
     * Set codigo_medio_de_pago value
     * @param string $codigo_medio_de_pago
     * @return \StructType\Notificacion_medio_de_pago
     */
    public function setCodigo_medio_de_pago($codigo_medio_de_pago = null)
    {
        // validation for constraint: string
        if (!is_null($codigo_medio_de_pago) && !is_string($codigo_medio_de_pago)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($codigo_medio_de_pago, true), gettype($codigo_medio_de_pago)), __LINE__);
        }
        $this->codigo_medio_de_pago = $this->{'codigo-medio-de-pago'} = $codigo_medio_de_pago;
        return $this;
    }
    /**
     * Get codigo_forma_de_pago value
     * @return string|null
     */
    public function getCodigo_forma_de_pago()
    {
        return $this->{'codigo-forma-de-pago'};
    }
    /**
     * Set codigo_forma_de_pago value
     * @param string $codigo_forma_de_pago
     * @return \StructType\Notificacion_medio_de_pago
     */
    public function setCodigo_forma_de_pago($codigo_forma_de_pago = null)
    {
        // validation for constraint: string
        if (!is_null($codigo_forma_de_pago) && !is_string($codigo_forma_de_pago)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($codigo_forma_de_pago, true), gettype($codigo_forma_de_pago)), __LINE__);
        }
        $this->codigo_forma_de_pago = $this->{'codigo-forma-de-pago'} = $codigo_forma_de_pago;
        return $this;
    }
    /**
     * Get codigo_procesador value
     * @return string|null
     */
    public function getCodigo_procesador()
    {
        return $this->{'codigo-procesador'};
    }
    /**
     * Set codigo_procesador value
     * @param string $codigo_procesador
     * @return \StructType\Notificacion_medio_de_pago
     */
    public function setCodigo_procesador($codigo_procesador = null)
    {
        // validation for constraint: string
        if (!is_null($codigo_procesador) && !is_string($codigo_procesador)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($codigo_procesador, true), gettype($codigo_procesador)), __LINE__);
        }
        $this->codigo_procesador = $this->{'codigo-procesador'} = $codigo_procesador;
        return $this;
    }
    /**
     * Get descuento value
     * @return float|null
     */
    public function getDescuento()
    {
        return $this->descuento;
    }
    /**
     * Set descuento value
     * @param float $descuento
     * @return \StructType\Notificacion_medio_de_pago
     */
    public function setDescuento($descuento = null)
    {
        // validation for constraint: float
        if (!is_null($descuento) && !(is_float($descuento) || is_numeric($descuento))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($descuento, true), gettype($descuento)), __LINE__);
        }
        $this->descuento = $descuento;
        return $this;
    }
    /**
     * Get cuotas value
     * @return int|null
     */
    public function getCuotas()
    {
        return $this->cuotas;
    }
    /**
     * Set cuotas value
     * @param int $cuotas
     * @return \StructType\Notificacion_medio_de_pago
     */
    public function setCuotas($cuotas = null)
    {
        // validation for constraint: int
        if (!is_null($cuotas) && !(is_int($cuotas) || ctype_digit($cuotas))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($cuotas, true), gettype($cuotas)), __LINE__);
        }
        $this->cuotas = $cuotas;
        return $this;
    }
    /**
     * Get fecha_hora_confirmacion_medio_de_pago value
     * @return string|null
     */
    public function getFecha_hora_confirmacion_medio_de_pago()
    {
        return $this->{'fecha-hora-confirmacion-medio-de-pago'};
    }
    /**
     * Set fecha_hora_confirmacion_medio_de_pago value
     * @param string $fecha_hora_confirmacion_medio_de_pago
     * @return \StructType\Notificacion_medio_de_pago
     */
    public function setFecha_hora_confirmacion_medio_de_pago($fecha_hora_confirmacion_medio_de_pago = null)
    {
        // validation for constraint: string
        if (!is_null($fecha_hora_confirmacion_medio_de_pago) && !is_string($fecha_hora_confirmacion_medio_de_pago)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fecha_hora_confirmacion_medio_de_pago, true), gettype($fecha_hora_confirmacion_medio_de_pago)), __LINE__);
        }
        $this->fecha_hora_confirmacion_medio_de_pago = $this->{'fecha-hora-confirmacion-medio-de-pago'} = $fecha_hora_confirmacion_medio_de_pago;
        return $this;
    }
    /**
     * Get estado value
     * @return string|null
     */
    public function getEstado()
    {
        return $this->estado;
    }
    /**
     * Set estado value
     * @uses \EnumType\Estado_transaccion::valueIsValid()
     * @uses \EnumType\Estado_transaccion::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $estado
     * @return \StructType\Notificacion_medio_de_pago
     */
    public function setEstado($estado = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\Estado_transaccion::valueIsValid($estado)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\Estado_transaccion', is_array($estado) ? implode(', ', $estado) : var_export($estado, true), implode(', ', \EnumType\Estado_transaccion::getValidValues())), __LINE__);
        }
        $this->estado = $estado;
        return $this;
    }
    /**
     * Get importes_tasas value
     * @return \StructType\Importes_tasas|null
     */
    public function getImportes_tasas()
    {
        return $this->{'importes-tasas'};
    }
    /**
     * Set importes_tasas value
     * @param \StructType\Importes_tasas $importes_tasas
     * @return \StructType\Notificacion_medio_de_pago
     */
    public function setImportes_tasas(\StructType\Importes_tasas $importes_tasas = null)
    {
        $this->importes_tasas = $this->{'importes-tasas'} = $importes_tasas;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Notificacion_medio_de_pago
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
