<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for atributo StructType
 * @subpackage Structs
 */
class Atributo extends AbstractStructBase
{
    /**
     * The nombre
     * @var string
     */
    public $nombre;
    /**
     * The valor
     * @var string
     */
    public $valor;
    /**
     * The tipo
     * @var string
     */
    public $tipo;
    /**
     * The atributos
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Atributos
     */
    public $atributos;
    /**
     * Constructor method for atributo
     * @uses Atributo::setNombre()
     * @uses Atributo::setValor()
     * @uses Atributo::setTipo()
     * @uses Atributo::setAtributos()
     * @param string $nombre
     * @param string $valor
     * @param string $tipo
     * @param \StructType\Atributos $atributos
     */
    public function __construct($nombre = null, $valor = null, $tipo = null, \StructType\Atributos $atributos = null)
    {
        $this
            ->setNombre($nombre)
            ->setValor($valor)
            ->setTipo($tipo)
            ->setAtributos($atributos);
    }
    /**
     * Get nombre value
     * @return string|null
     */
    public function getNombre()
    {
        return $this->nombre;
    }
    /**
     * Set nombre value
     * @param string $nombre
     * @return \StructType\Atributo
     */
    public function setNombre($nombre = null)
    {
        // validation for constraint: string
        if (!is_null($nombre) && !is_string($nombre)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($nombre, true), gettype($nombre)), __LINE__);
        }
        $this->nombre = $nombre;
        return $this;
    }
    /**
     * Get valor value
     * @return string|null
     */
    public function getValor()
    {
        return $this->valor;
    }
    /**
     * Set valor value
     * @param string $valor
     * @return \StructType\Atributo
     */
    public function setValor($valor = null)
    {
        // validation for constraint: string
        if (!is_null($valor) && !is_string($valor)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($valor, true), gettype($valor)), __LINE__);
        }
        $this->valor = $valor;
        return $this;
    }
    /**
     * Get tipo value
     * @return string|null
     */
    public function getTipo()
    {
        return $this->tipo;
    }
    /**
     * Set tipo value
     * @uses \EnumType\Tipo_atributo::valueIsValid()
     * @uses \EnumType\Tipo_atributo::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $tipo
     * @return \StructType\Atributo
     */
    public function setTipo($tipo = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\Tipo_atributo::valueIsValid($tipo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\Tipo_atributo', is_array($tipo) ? implode(', ', $tipo) : var_export($tipo, true), implode(', ', \EnumType\Tipo_atributo::getValidValues())), __LINE__);
        }
        $this->tipo = $tipo;
        return $this;
    }
    /**
     * Get atributos value
     * @return \StructType\Atributos|null
     */
    public function getAtributos()
    {
        return $this->atributos;
    }
    /**
     * Set atributos value
     * @param \StructType\Atributos $atributos
     * @return \StructType\Atributo
     */
    public function setAtributos(\StructType\Atributos $atributos = null)
    {
        $this->atributos = $atributos;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Atributo
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
