<?php

namespace EnumType;

/**
 * This class stands for estado-transaccion EnumType
 * @subpackage Enumerations
 */
class Estado_transaccion
{
    /**
     * Constant for value 'EN_PROCESO'
     * @return string 'EN_PROCESO'
     */
    const VALUE_EN_PROCESO = 'EN_PROCESO';
    /**
     * Constant for value 'AUTORIZADA'
     * @return string 'AUTORIZADA'
     */
    const VALUE_AUTORIZADA = 'AUTORIZADA';
    /**
     * Constant for value 'RECHAZADA'
     * @return string 'RECHAZADA'
     */
    const VALUE_RECHAZADA = 'RECHAZADA';
    /**
     * Constant for value 'CANCELADA'
     * @return string 'CANCELADA'
     */
    const VALUE_CANCELADA = 'CANCELADA';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_EN_PROCESO
     * @uses self::VALUE_AUTORIZADA
     * @uses self::VALUE_RECHAZADA
     * @uses self::VALUE_CANCELADA
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_EN_PROCESO,
            self::VALUE_AUTORIZADA,
            self::VALUE_RECHAZADA,
            self::VALUE_CANCELADA,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
