<?php
/**
 * This file aims to show you how to use this generated package.
 * In addition, the goal is to show which methods are available and the fist needed parameter(s)
 * You have to use an associative array such as:
 * - the key must be a constant beginning with WSDL_ from AbstractSoapClientbase class each generated ServiceType class extends this class
 * - the value must be the corresponding key value (each option matches a {@link http://www.php.net/manual/en/soapclient.soapclient.php} option)
 * $options = array(
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'https://qawebservices.packagingwholesalers.com/TPWXMLService.svc?wsdl',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_TRACE => true,
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_LOGIN => 'you_secret_login',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_PASSWORD => 'you_secret_password',
 * );
 * etc....
 */
require_once __DIR__ . '/vendor/autoload.php';
/**
 * Minimal options
 */
$options = array(
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'https://qawebservices.packagingwholesalers.com/TPWXMLService.svc?wsdl',
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_CLASSMAP => ClassMap::get(),
);
/**
 * Samples for Approve ServiceType
 */
$approve = new \ServiceType\Approve($options);
/**
 * Sample call for Approve operation/method
 */
if ($approve->Approve(new \StructType\Approve()) !== false) {
    print_r($approve->getResult());
} else {
    print_r($approve->getLastError());
}
/**
 * Samples for Create ServiceType
 */
$create = new \ServiceType\Create($options);
/**
 * Sample call for Create operation/method
 */
if ($create->Create(new \StructType\Create()) !== false) {
    print_r($create->getResult());
} else {
    print_r($create->getLastError());
}
/**
 * Samples for Quote ServiceType
 */
$quote = new \ServiceType\Quote($options);
/**
 * Sample call for Quote operation/method
 */
if ($quote->Quote(new \StructType\Quote()) !== false) {
    print_r($quote->getResult());
} else {
    print_r($quote->getLastError());
}
/**
 * Samples for Order ServiceType
 */
$order = new \ServiceType\Order($options);
/**
 * Sample call for OrderStatus operation/method
 */
if ($order->OrderStatus(new \StructType\OrderStatus()) !== false) {
    print_r($order->getResult());
} else {
    print_r($order->getLastError());
}
/**
 * Samples for Get ServiceType
 */
$get = new \ServiceType\Get($options);
/**
 * Sample call for GetCatalogData operation/method
 */
if ($get->GetCatalogData(new \StructType\GetCatalogData()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetDataUsingDataContract operation/method
 */
if ($get->GetDataUsingDataContract(new \StructType\GetDataUsingDataContract()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Samples for Test ServiceType
 */
$test = new \ServiceType\Test($options);
/**
 * Sample call for Test1 operation/method
 */
if ($test->Test1(new \StructType\Test1()) !== false) {
    print_r($test->getResult());
} else {
    print_r($test->getLastError());
}
/**
 * Sample call for TestXmlElement operation/method
 */
if ($test->TestXmlElement(new \StructType\TestXmlElement()) !== false) {
    print_r($test->getResult());
} else {
    print_r($test->getLastError());
}
