<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UpdItmWhsItem StructType
 * @subpackage Structs
 */
class UpdItmWhsItem extends AbstractStructBase
{
    /**
     * The Company
     * Meta information extracted from the WSDL
     * - documentation: Company (CONO)
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $Company;
    /**
     * The Warehouse
     * Meta information extracted from the WSDL
     * - documentation: Warehouse (WHLO)
     * - base: xsd:string
     * - maxLength: 3
     * @var string
     */
    public $Warehouse;
    /**
     * The ItemNumber
     * Meta information extracted from the WSDL
     * - documentation: Item number (ITNO)
     * - base: xsd:string
     * - maxLength: 15
     * @var string
     */
    public $ItemNumber;
    /**
     * The OnhandBalanceApproved
     * Meta information extracted from the WSDL
     * - documentation: On-hand balance approved (STQT)
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $OnhandBalanceApproved;
    /**
     * The OnhandBalanceForInspection
     * Meta information extracted from the WSDL
     * - documentation: On-hand balance for inspection (QUQT)
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $OnhandBalanceForInspection;
    /**
     * The RejectedOnhandBalance
     * Meta information extracted from the WSDL
     * - documentation: Rejected on-hand balance (RJQT)
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $RejectedOnhandBalance;
    /**
     * The AllocatedQuantityBasicUM
     * Meta information extracted from the WSDL
     * - documentation: Allocated quantity - basic U/M (ALQT)
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $AllocatedQuantityBasicUM;
    /**
     * The AllocatableOnhandBalance
     * Meta information extracted from the WSDL
     * - documentation: Allocatable on-hand balance (AVAL)
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $AllocatableOnhandBalance;
    /**
     * The PickingListQuantityBasicUM
     * Meta information extracted from the WSDL
     * - documentation: Picking list quantity - basic U/M (PLQT)
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $PickingListQuantityBasicUM;
    /**
     * The ContainerManagement
     * Meta information extracted from the WSDL
     * - documentation: Container management (COMG)
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $ContainerManagement;
    /**
     * The AllocationMethod
     * Meta information extracted from the WSDL
     * - documentation: Allocation method (ALMT)
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $AllocationMethod;
    /**
     * The StorageMethod
     * Meta information extracted from the WSDL
     * - documentation: Storage method (STMT)
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $StorageMethod;
    /**
     * The IssueMethod
     * Meta information extracted from the WSDL
     * - documentation: Issue method (SPMT)
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $IssueMethod;
    /**
     * The Note
     * Meta information extracted from the WSDL
     * - documentation: Note (STTX)
     * - base: xsd:string
     * - maxLength: 30
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Note;
    /**
     * The OrderedQuantityBasicUM
     * Meta information extracted from the WSDL
     * - documentation: Ordered quantity - basic U/M (ORQT)
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $OrderedQuantityBasicUM;
    /**
     * The ReservedQuantity
     * Meta information extracted from the WSDL
     * - documentation: Reserved quantity (REQT)
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $ReservedQuantity;
    /**
     * The ReservedQuantityToBackorder
     * Meta information extracted from the WSDL
     * - documentation: Reserved quantity to backorder (RLQT)
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $ReservedQuantityToBackorder;
    /**
     * The ReservedQuantityPlannedOrders
     * Meta information extracted from the WSDL
     * - documentation: Reserved quantity - planned orders (REQP)
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $ReservedQuantityPlannedOrders;
    /**
     * The LastReceiptDate
     * Meta information extracted from the WSDL
     * - documentation: Last receipt date (IDDT)
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $LastReceiptDate;
    /**
     * The LastIssueDate
     * Meta information extracted from the WSDL
     * - documentation: Last issue date (ODDT)
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $LastIssueDate;
    /**
     * The LatestPhysicalInventoryDate
     * Meta information extracted from the WSDL
     * - documentation: Latest physical inventory date (INDT)
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $LatestPhysicalInventoryDate;
    /**
     * The PriorityDateSelection
     * Meta information extracted from the WSDL
     * - documentation: Priority date selection (PRDC)
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $PriorityDateSelection;
    /**
     * The PhysicalInventoryCycle
     * Meta information extracted from the WSDL
     * - documentation: Physical inventory cycle (INCD)
     * - base: xsd:string
     * - maxLength: 3
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PhysicalInventoryCycle;
    /**
     * The NumberOfRecordsForPhysicalInventory
     * Meta information extracted from the WSDL
     * - documentation: Number of records for physical inventory (NUIN)
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $NumberOfRecordsForPhysicalInventory;
    /**
     * The AnnualUsage
     * Meta information extracted from the WSDL
     * - documentation: Annual usage (USYE)
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $AnnualUsage;
    /**
     * The AverageOnhandBalance
     * Meta information extracted from the WSDL
     * - documentation: Average on-hand balance (AVST)
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $AverageOnhandBalance;
    /**
     * The ProjectedOnhandAtEndOfLeadTime
     * Meta information extracted from the WSDL
     * - documentation: Projected on-hand at end of lead time (DILE)
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $ProjectedOnhandAtEndOfLeadTime;
    /**
     * The Responsible
     * Meta information extracted from the WSDL
     * - documentation: Responsible (RESP)
     * - base: xsd:string
     * - maxLength: 10
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Responsible;
    /**
     * The Buyer
     * Meta information extracted from the WSDL
     * - documentation: Buyer (BUYE)
     * - base: xsd:string
     * - maxLength: 10
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Buyer;
    /**
     * The SupplierNumber
     * Meta information extracted from the WSDL
     * - documentation: Supplier number (SUNO)
     * - base: xsd:string
     * - maxLength: 10
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SupplierNumber;
    /**
     * The WarehouseType
     * Meta information extracted from the WSDL
     * - documentation: Warehouse type (WHTY)
     * - base: xsd:string
     * - maxLength: 2
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $WarehouseType;
    /**
     * The WarehouseSubtype
     * Meta information extracted from the WSDL
     * - documentation: Warehouse subtype (WHSY)
     * - base: xsd:string
     * - maxLength: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $WarehouseSubtype;
    /**
     * The StatisticsStorageGroup
     * Meta information extracted from the WSDL
     * - documentation: Statistics storage group (INSC)
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $StatisticsStorageGroup;
    /**
     * The DistributionGroup
     * Meta information extracted from the WSDL
     * - documentation: Distribution group (DIGR)
     * - base: xsd:string
     * - maxLength: 2
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DistributionGroup;
    /**
     * The Location
     * Meta information extracted from the WSDL
     * - documentation: Location (WHSL)
     * - base: xsd:string
     * - maxLength: 10
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Location;
    /**
     * The StockZone
     * Meta information extracted from the WSDL
     * - documentation: Stock zone (SLTP)
     * - base: xsd:string
     * - maxLength: 2
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $StockZone;
    /**
     * The NumberOfBalanceIDs
     * Meta information extracted from the WSDL
     * - documentation: Number of balance IDs (NUS7)
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $NumberOfBalanceIDs;
    /**
     * The IssueMultiple
     * Meta information extracted from the WSDL
     * - documentation: Issue multiple (TOMU)
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $IssueMultiple;
    /**
     * The LocationType
     * Meta information extracted from the WSDL
     * - documentation: Location type (WHLT)
     * - base: xsd:string
     * - maxLength: 2
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $LocationType;
    /**
     * The WarehouseEquipment
     * Meta information extracted from the WSDL
     * - documentation: Warehouse equipment (PISE)
     * - base: xsd:string
     * - maxLength: 2
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $WarehouseEquipment;
    /**
     * The PlanningPolicy
     * Meta information extracted from the WSDL
     * - documentation: Planning policy (PLCD)
     * - base: xsd:string
     * - maxLength: 2
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PlanningPolicy;
    /**
     * The ABCClassManual
     * Meta information extracted from the WSDL
     * - documentation: ABC class - manual (MABC)
     * - base: xsd:string
     * - maxLength: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ABCClassManual;
    /**
     * The ABCClassVolume
     * Meta information extracted from the WSDL
     * - documentation: ABC class - volume (ABCD)
     * - base: xsd:string
     * - maxLength: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ABCClassVolume;
    /**
     * The ABCMethodVolume
     * Meta information extracted from the WSDL
     * - documentation: ABC method - volume (ABCM)
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $ABCMethodVolume;
    /**
     * The ABCClassFrequency
     * Meta information extracted from the WSDL
     * - documentation: ABC class - frequency (ABFC)
     * - base: xsd:string
     * - maxLength: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ABCClassFrequency;
    /**
     * The ABCMethodFrequency
     * Meta information extracted from the WSDL
     * - documentation: ABC method - frequency (ABFM)
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $ABCMethodFrequency;
    /**
     * The ABCClassContribution
     * Meta information extracted from the WSDL
     * - documentation: ABC class - contribution (ACOC)
     * - base: xsd:string
     * - maxLength: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ABCClassContribution;
    /**
     * The ABCMethodContribution
     * Meta information extracted from the WSDL
     * - documentation: ABC method - contribution (ACOM)
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $ABCMethodContribution;
    /**
     * The PriorityValue
     * Meta information extracted from the WSDL
     * - documentation: Priority value (PRIF)
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $PriorityValue;
    /**
     * The RunoutTime
     * Meta information extracted from the WSDL
     * - documentation: Run-out time (SODY)
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $RunoutTime;
    /**
     * The ReorderPoint
     * Meta information extracted from the WSDL
     * - documentation: Reorder point (REOP)
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $ReorderPoint;
    /**
     * The ReorderPointMethod
     * Meta information extracted from the WSDL
     * - documentation: Reorder point method (OPOM)
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $ReorderPointMethod;
    /**
     * The SafetyStock
     * Meta information extracted from the WSDL
     * - documentation: Safety stock (SSQT)
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $SafetyStock;
    /**
     * The SafetyStockMethod
     * Meta information extracted from the WSDL
     * - documentation: Safety stock method (SSMT)
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $SafetyStockMethod;
    /**
     * The ManualSafetyStock
     * Meta information extracted from the WSDL
     * - documentation: Manual safety stock (MSSQ)
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $ManualSafetyStock;
    /**
     * The SafetyStockUnit
     * Meta information extracted from the WSDL
     * - documentation: Safety stock unit (SSDA)
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $SafetyStockUnit;
    /**
     * The ServiceLevel
     * Meta information extracted from the WSDL
     * - documentation: Service level (SCGR)
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $ServiceLevel;
    /**
     * The MaximumStock
     * Meta information extracted from the WSDL
     * - documentation: Maximum stock (MXST)
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $MaximumStock;
    /**
     * The MaximumStockMethod
     * Meta information extracted from the WSDL
     * - documentation: Maximum stock method (MXSM)
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $MaximumStockMethod;
    /**
     * The MaximumStockPercentage
     * Meta information extracted from the WSDL
     * - documentation: Maximum stock percentage (MXPC)
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $MaximumStockPercentage;
    /**
     * The OrderQuantity
     * Meta information extracted from the WSDL
     * - documentation: Order quantity (EOQT)
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $OrderQuantity;
    /**
     * The OrderPolicy
     * Meta information extracted from the WSDL
     * - documentation: Order policy (EOQM)
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $OrderPolicy;
    /**
     * The EconomicalOrderQuantityDays
     * Meta information extracted from the WSDL
     * - documentation: Economical order quantity days (EQDA)
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $EconomicalOrderQuantityDays;
    /**
     * The AnnualDemand
     * Meta information extracted from the WSDL
     * - documentation: Annual demand (YEQT)
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $AnnualDemand;
    /**
     * The AnnualDemandMethod
     * Meta information extracted from the WSDL
     * - documentation: Annual demand method (YEQM)
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $AnnualDemandMethod;
    /**
     * The MinimumOrderQuantity
     * Meta information extracted from the WSDL
     * - documentation: Minimum order quantity (LOQT)
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $MinimumOrderQuantity;
    /**
     * The MaximumOrderQuantity
     * Meta information extracted from the WSDL
     * - documentation: Maximum order quantity (MOQT)
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $MaximumOrderQuantity;
    /**
     * The AcquisitionCode
     * Meta information extracted from the WSDL
     * - documentation: Acquisition code (PUIT)
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $AcquisitionCode;
    /**
     * The SupplyingWarehouse
     * Meta information extracted from the WSDL
     * - documentation: Supplying warehouse (SUWH)
     * - base: xsd:string
     * - maxLength: 3
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SupplyingWarehouse;
    /**
     * The PeriodFrame
     * Meta information extracted from the WSDL
     * - documentation: Period frame (DPID)
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $PeriodFrame;
    /**
     * The ForecastMethod
     * Meta information extracted from the WSDL
     * - documentation: Forecast method (PRCD)
     * - base: xsd:string
     * - maxLength: 2
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ForecastMethod;
    /**
     * The ForecastLogic
     * Meta information extracted from the WSDL
     * - documentation: Forecast logic (FCCM)
     * - base: xsd:string
     * - maxLength: 2
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ForecastLogic;
    /**
     * The FixedAnnualDemand
     * Meta information extracted from the WSDL
     * - documentation: Fixed annual demand (LYQT)
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $FixedAnnualDemand;
    /**
     * The FixedAcquisitionRequirement
     * Meta information extracted from the WSDL
     * - documentation: Fixed acquisition requirement (LRYE)
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $FixedAcquisitionRequirement;
    /**
     * The PlanningTimeFence
     * Meta information extracted from the WSDL
     * - documentation: Planning time fence (PFTM)
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $PlanningTimeFence;
    /**
     * The SupplyLeadTime
     * Meta information extracted from the WSDL
     * - documentation: Supply lead time (LEA1)
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $SupplyLeadTime;
    /**
     * The InspectionLeadTime
     * Meta information extracted from the WSDL
     * - documentation: Inspection lead time (LEA2)
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $InspectionLeadTime;
    /**
     * The TransportationLeadTime
     * Meta information extracted from the WSDL
     * - documentation: Transportation lead time (LEA3)
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $TransportationLeadTime;
    /**
     * The LeadTime
     * Meta information extracted from the WSDL
     * - documentation: Lead time (LEAT)
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $LeadTime;
    /**
     * The OrderMultiple
     * Meta information extracted from the WSDL
     * - documentation: Order multiple (UNMU)
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $OrderMultiple;
    /**
     * The MultipleSupply
     * Meta information extracted from the WSDL
     * - documentation: Multiple supply (SVEI)
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $MultipleSupply;
    /**
     * The LowestLevel
     * Meta information extracted from the WSDL
     * - documentation: Lowest level (LEVL)
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $LowestLevel;
    /**
     * The LowestLevelDO
     * Meta information extracted from the WSDL
     * - documentation: Lowest level DO (LEVD)
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $LowestLevelDO;
    /**
     * The PlanningHorizon
     * Meta information extracted from the WSDL
     * - documentation: Planning horizon (PLHZ)
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $PlanningHorizon;
    /**
     * The DemandTimeFence
     * Meta information extracted from the WSDL
     * - documentation: Demand time fence (DMFN)
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $DemandTimeFence;
    /**
     * The OrderType
     * Meta information extracted from the WSDL
     * - documentation: Order type (ORTY)
     * - base: xsd:string
     * - maxLength: 3
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $OrderType;
    /**
     * The ContinuousNetChange
     * Meta information extracted from the WSDL
     * - documentation: Continuous net change (CONC)
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $ContinuousNetChange;
    /**
     * The SafetyTime
     * Meta information extracted from the WSDL
     * - documentation: Safety time (SATD)
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $SafetyTime;
    /**
     * The QuantityControlledAllocation
     * Meta information extracted from the WSDL
     * - documentation: Quantity controlled allocation (ALQC)
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $QuantityControlledAllocation;
    /**
     * The PlanningMethod
     * Meta information extracted from the WSDL
     * - documentation: Planning method (OPLC)
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $PlanningMethod;
    /**
     * The MasterScheduled
     * Meta information extracted from the WSDL
     * - documentation: Master scheduled (MSCH)
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $MasterScheduled;
    /**
     * The DistributionSupplierCalendarCheck
     * Meta information extracted from the WSDL
     * - documentation: Distribution/supplier calendar check (SHCC)
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $DistributionSupplierCalendarCheck;
    /**
     * The ZeroMark
     * Meta information extracted from the WSDL
     * - documentation: Zero mark (ZCAC)
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $ZeroMark;
    /**
     * The InspectionLocation
     * Meta information extracted from the WSDL
     * - documentation: Inspection location (INSL)
     * - base: xsd:string
     * - maxLength: 10
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $InspectionLocation;
    /**
     * The NetChangeCalculationActive
     * Meta information extracted from the WSDL
     * - documentation: Net change calculation active (NCCA)
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $NetChangeCalculationActive;
    /**
     * The Facility
     * Meta information extracted from the WSDL
     * - documentation: Facility (FACI)
     * - base: xsd:string
     * - maxLength: 3
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Facility;
    /**
     * The Division
     * Meta information extracted from the WSDL
     * - documentation: Division (DIVI)
     * - base: xsd:string
     * - maxLength: 3
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Division;
    /**
     * The TimePhasedSafetyStockExists
     * Meta information extracted from the WSDL
     * - documentation: Time phased safety stock exists (DDEX)
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $TimePhasedSafetyStockExists;
    /**
     * The HistoryStorageMethod
     * Meta information extracted from the WSDL
     * - documentation: History storage method (STRL)
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $HistoryStorageMethod;
    /**
     * The PickingListInformationControl
     * Meta information extracted from the WSDL
     * - documentation: Picking list information control (PLIC)
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $PickingListInformationControl;
    /**
     * The PendingPlanningMethodChange
     * Meta information extracted from the WSDL
     * - documentation: Pending planning method change (PPMC)
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $PendingPlanningMethodChange;
    /**
     * The CalculationDateMaterialPlanning
     * Meta information extracted from the WSDL
     * - documentation: Calculation date - material planning (MPCD)
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CalculationDateMaterialPlanning;
    /**
     * The CalculationTimeMaterialPlanning
     * Meta information extracted from the WSDL
     * - documentation: Calculation time - material planning (MPCT)
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $CalculationTimeMaterialPlanning;
    /**
     * The TimePhasedSafetyStock
     * Meta information extracted from the WSDL
     * - documentation: Time phased safety stock (DCSS)
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $TimePhasedSafetyStock;
    /**
     * The ResponsiblePOProposal
     * Meta information extracted from the WSDL
     * - documentation: Responsible - PO proposal (RPOP)
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $ResponsiblePOProposal;
    /**
     * The StandardCostWarehouse
     * Meta information extracted from the WSDL
     * - documentation: Standard cost - warehouse (BCOS)
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $StandardCostWarehouse;
    /**
     * The TextIdentity
     * Meta information extracted from the WSDL
     * - documentation: Text identity (TXID)
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $TextIdentity;
    /**
     * The DataIdentity
     * Meta information extracted from the WSDL
     * - documentation: Data identity (DTID)
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $DataIdentity;
    /**
     * The DefaultPackingLocation
     * Meta information extracted from the WSDL
     * - documentation: Default packing location (DPLO)
     * - base: xsd:string
     * - maxLength: 10
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DefaultPackingLocation;
    /**
     * The DefaultDockingLocation
     * Meta information extracted from the WSDL
     * - documentation: Default docking location (DDLO)
     * - base: xsd:string
     * - maxLength: 10
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DefaultDockingLocation;
    /**
     * The DeliverySplitRule
     * Meta information extracted from the WSDL
     * - documentation: Delivery split rule (SPLC)
     * - base: xsd:string
     * - maxLength: 2
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DeliverySplitRule;
    /**
     * The AllocateNonapprovedBalanceID
     * Meta information extracted from the WSDL
     * - documentation: Allocate non-approved balance ID (ALS1)
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $AllocateNonapprovedBalanceID;
    /**
     * The PointOfTimeTable
     * Meta information extracted from the WSDL
     * - documentation: Point of time table (POOT)
     * - base: xsd:string
     * - maxLength: 3
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PointOfTimeTable;
    /**
     * The Status
     * Meta information extracted from the WSDL
     * - documentation: Status (STAT)
     * - base: xsd:string
     * - maxLength: 2
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Status;
    /**
     * The VATCodePurchase
     * Meta information extracted from the WSDL
     * - documentation: VAT code - purchase (VTCP)
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $VATCodePurchase;
    /**
     * The VATCodeSales
     * Meta information extracted from the WSDL
     * - documentation: VAT code - sales (VTCS)
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $VATCodeSales;
    /**
     * The MainUnitOfCalculation
     * Meta information extracted from the WSDL
     * - documentation: Main unit of calculation (MNUN)
     * - base: xsd:string
     * - maxLength: 3
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $MainUnitOfCalculation;
    /**
     * The DistributionGroupTechnology
     * Meta information extracted from the WSDL
     * - documentation: Distribution group technology (GRTS)
     * - base: xsd:string
     * - maxLength: 5
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DistributionGroupTechnology;
    /**
     * The ShelfLife
     * Meta information extracted from the WSDL
     * - documentation: Shelf life (SLDY)
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $ShelfLife;
    /**
     * The ReinspectionTime
     * Meta information extracted from the WSDL
     * - documentation: Reinspection time (REDY)
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $ReinspectionTime;
    /**
     * The SalesTime
     * Meta information extracted from the WSDL
     * - documentation: Sales time (SAEL)
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $SalesTime;
    /**
     * The CTPPolicy
     * Meta information extracted from the WSDL
     * - documentation: CTP policy (CPCD)
     * - base: xsd:string
     * - maxLength: 3
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CTPPolicy;
    /**
     * The QuarantineLeadtime
     * Meta information extracted from the WSDL
     * - documentation: Quarantine lead-time (LEAQ)
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $QuarantineLeadtime;
    /**
     * The ScheduledReclassificationAllowed
     * Meta information extracted from the WSDL
     * - documentation: Scheduled re-classification allowed (SCHT)
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $ScheduledReclassificationAllowed;
    /**
     * The CatchWeightApprovedOnHandBalance
     * Meta information extracted from the WSDL
     * - documentation: Catch weight approved on hand balance (STCW)
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $CatchWeightApprovedOnHandBalance;
    /**
     * The CatchWeightRejectedOnHandBalance
     * Meta information extracted from the WSDL
     * - documentation: Catch weight rejected on hand balance (RJCW)
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $CatchWeightRejectedOnHandBalance;
    /**
     * The CatchWeightForInspectionOnHandBal
     * Meta information extracted from the WSDL
     * - documentation: Catch weight for inspection on hand bal (QUCW)
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $CatchWeightForInspectionOnHandBal;
    /**
     * The AlternateUM
     * Meta information extracted from the WSDL
     * - documentation: Alternate U/M (CWCP)
     * - base: xsd:string
     * - maxLength: 3
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $AlternateUM;
    /**
     * The StandardCostPriceUnitOfMeasure
     * Meta information extracted from the WSDL
     * - documentation: Standard cost price unit of measure (CPUN)
     * - base: xsd:string
     * - maxLength: 3
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $StandardCostPriceUnitOfMeasure;
    /**
     * The InventoryPlanned
     * Meta information extracted from the WSDL
     * - documentation: Inventory planned (IPLA)
     * - base: xsd:string
     * - maxLength: 2
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $InventoryPlanned;
    /**
     * The BestBeforeTime
     * Meta information extracted from the WSDL
     * - documentation: Best before time (BBTM)
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $BestBeforeTime;
    /**
     * The FrozenSafetyStock
     * Meta information extracted from the WSDL
     * - documentation: Frozen safety stock (FSSQ)
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $FrozenSafetyStock;
    /**
     * The ReturnableNonReturnableIndicator
     * Meta information extracted from the WSDL
     * - documentation: Returnable / non returnable indicator (RNRI)
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $ReturnableNonReturnableIndicator;
    /**
     * The ReturnableMessage
     * Meta information extracted from the WSDL
     * - documentation: Returnable message (RMSG)
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $ReturnableMessage;
    /**
     * The SSReasonCode
     * Meta information extracted from the WSDL
     * - documentation: SS reason code (SSRE)
     * - base: xsd:string
     * - maxLength: 5
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SSReasonCode;
    /**
     * The SecondaryAllocationMethod
     * Meta information extracted from the WSDL
     * - documentation: Secondary allocation method (SALM)
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $SecondaryAllocationMethod;
    /**
     * Constructor method for UpdItmWhsItem
     * @uses UpdItmWhsItem::setCompany()
     * @uses UpdItmWhsItem::setWarehouse()
     * @uses UpdItmWhsItem::setItemNumber()
     * @uses UpdItmWhsItem::setOnhandBalanceApproved()
     * @uses UpdItmWhsItem::setOnhandBalanceForInspection()
     * @uses UpdItmWhsItem::setRejectedOnhandBalance()
     * @uses UpdItmWhsItem::setAllocatedQuantityBasicUM()
     * @uses UpdItmWhsItem::setAllocatableOnhandBalance()
     * @uses UpdItmWhsItem::setPickingListQuantityBasicUM()
     * @uses UpdItmWhsItem::setContainerManagement()
     * @uses UpdItmWhsItem::setAllocationMethod()
     * @uses UpdItmWhsItem::setStorageMethod()
     * @uses UpdItmWhsItem::setIssueMethod()
     * @uses UpdItmWhsItem::setNote()
     * @uses UpdItmWhsItem::setOrderedQuantityBasicUM()
     * @uses UpdItmWhsItem::setReservedQuantity()
     * @uses UpdItmWhsItem::setReservedQuantityToBackorder()
     * @uses UpdItmWhsItem::setReservedQuantityPlannedOrders()
     * @uses UpdItmWhsItem::setLastReceiptDate()
     * @uses UpdItmWhsItem::setLastIssueDate()
     * @uses UpdItmWhsItem::setLatestPhysicalInventoryDate()
     * @uses UpdItmWhsItem::setPriorityDateSelection()
     * @uses UpdItmWhsItem::setPhysicalInventoryCycle()
     * @uses UpdItmWhsItem::setNumberOfRecordsForPhysicalInventory()
     * @uses UpdItmWhsItem::setAnnualUsage()
     * @uses UpdItmWhsItem::setAverageOnhandBalance()
     * @uses UpdItmWhsItem::setProjectedOnhandAtEndOfLeadTime()
     * @uses UpdItmWhsItem::setResponsible()
     * @uses UpdItmWhsItem::setBuyer()
     * @uses UpdItmWhsItem::setSupplierNumber()
     * @uses UpdItmWhsItem::setWarehouseType()
     * @uses UpdItmWhsItem::setWarehouseSubtype()
     * @uses UpdItmWhsItem::setStatisticsStorageGroup()
     * @uses UpdItmWhsItem::setDistributionGroup()
     * @uses UpdItmWhsItem::setLocation()
     * @uses UpdItmWhsItem::setStockZone()
     * @uses UpdItmWhsItem::setNumberOfBalanceIDs()
     * @uses UpdItmWhsItem::setIssueMultiple()
     * @uses UpdItmWhsItem::setLocationType()
     * @uses UpdItmWhsItem::setWarehouseEquipment()
     * @uses UpdItmWhsItem::setPlanningPolicy()
     * @uses UpdItmWhsItem::setABCClassManual()
     * @uses UpdItmWhsItem::setABCClassVolume()
     * @uses UpdItmWhsItem::setABCMethodVolume()
     * @uses UpdItmWhsItem::setABCClassFrequency()
     * @uses UpdItmWhsItem::setABCMethodFrequency()
     * @uses UpdItmWhsItem::setABCClassContribution()
     * @uses UpdItmWhsItem::setABCMethodContribution()
     * @uses UpdItmWhsItem::setPriorityValue()
     * @uses UpdItmWhsItem::setRunoutTime()
     * @uses UpdItmWhsItem::setReorderPoint()
     * @uses UpdItmWhsItem::setReorderPointMethod()
     * @uses UpdItmWhsItem::setSafetyStock()
     * @uses UpdItmWhsItem::setSafetyStockMethod()
     * @uses UpdItmWhsItem::setManualSafetyStock()
     * @uses UpdItmWhsItem::setSafetyStockUnit()
     * @uses UpdItmWhsItem::setServiceLevel()
     * @uses UpdItmWhsItem::setMaximumStock()
     * @uses UpdItmWhsItem::setMaximumStockMethod()
     * @uses UpdItmWhsItem::setMaximumStockPercentage()
     * @uses UpdItmWhsItem::setOrderQuantity()
     * @uses UpdItmWhsItem::setOrderPolicy()
     * @uses UpdItmWhsItem::setEconomicalOrderQuantityDays()
     * @uses UpdItmWhsItem::setAnnualDemand()
     * @uses UpdItmWhsItem::setAnnualDemandMethod()
     * @uses UpdItmWhsItem::setMinimumOrderQuantity()
     * @uses UpdItmWhsItem::setMaximumOrderQuantity()
     * @uses UpdItmWhsItem::setAcquisitionCode()
     * @uses UpdItmWhsItem::setSupplyingWarehouse()
     * @uses UpdItmWhsItem::setPeriodFrame()
     * @uses UpdItmWhsItem::setForecastMethod()
     * @uses UpdItmWhsItem::setForecastLogic()
     * @uses UpdItmWhsItem::setFixedAnnualDemand()
     * @uses UpdItmWhsItem::setFixedAcquisitionRequirement()
     * @uses UpdItmWhsItem::setPlanningTimeFence()
     * @uses UpdItmWhsItem::setSupplyLeadTime()
     * @uses UpdItmWhsItem::setInspectionLeadTime()
     * @uses UpdItmWhsItem::setTransportationLeadTime()
     * @uses UpdItmWhsItem::setLeadTime()
     * @uses UpdItmWhsItem::setOrderMultiple()
     * @uses UpdItmWhsItem::setMultipleSupply()
     * @uses UpdItmWhsItem::setLowestLevel()
     * @uses UpdItmWhsItem::setLowestLevelDO()
     * @uses UpdItmWhsItem::setPlanningHorizon()
     * @uses UpdItmWhsItem::setDemandTimeFence()
     * @uses UpdItmWhsItem::setOrderType()
     * @uses UpdItmWhsItem::setContinuousNetChange()
     * @uses UpdItmWhsItem::setSafetyTime()
     * @uses UpdItmWhsItem::setQuantityControlledAllocation()
     * @uses UpdItmWhsItem::setPlanningMethod()
     * @uses UpdItmWhsItem::setMasterScheduled()
     * @uses UpdItmWhsItem::setDistributionSupplierCalendarCheck()
     * @uses UpdItmWhsItem::setZeroMark()
     * @uses UpdItmWhsItem::setInspectionLocation()
     * @uses UpdItmWhsItem::setNetChangeCalculationActive()
     * @uses UpdItmWhsItem::setFacility()
     * @uses UpdItmWhsItem::setDivision()
     * @uses UpdItmWhsItem::setTimePhasedSafetyStockExists()
     * @uses UpdItmWhsItem::setHistoryStorageMethod()
     * @uses UpdItmWhsItem::setPickingListInformationControl()
     * @uses UpdItmWhsItem::setPendingPlanningMethodChange()
     * @uses UpdItmWhsItem::setCalculationDateMaterialPlanning()
     * @uses UpdItmWhsItem::setCalculationTimeMaterialPlanning()
     * @uses UpdItmWhsItem::setTimePhasedSafetyStock()
     * @uses UpdItmWhsItem::setResponsiblePOProposal()
     * @uses UpdItmWhsItem::setStandardCostWarehouse()
     * @uses UpdItmWhsItem::setTextIdentity()
     * @uses UpdItmWhsItem::setDataIdentity()
     * @uses UpdItmWhsItem::setDefaultPackingLocation()
     * @uses UpdItmWhsItem::setDefaultDockingLocation()
     * @uses UpdItmWhsItem::setDeliverySplitRule()
     * @uses UpdItmWhsItem::setAllocateNonapprovedBalanceID()
     * @uses UpdItmWhsItem::setPointOfTimeTable()
     * @uses UpdItmWhsItem::setStatus()
     * @uses UpdItmWhsItem::setVATCodePurchase()
     * @uses UpdItmWhsItem::setVATCodeSales()
     * @uses UpdItmWhsItem::setMainUnitOfCalculation()
     * @uses UpdItmWhsItem::setDistributionGroupTechnology()
     * @uses UpdItmWhsItem::setShelfLife()
     * @uses UpdItmWhsItem::setReinspectionTime()
     * @uses UpdItmWhsItem::setSalesTime()
     * @uses UpdItmWhsItem::setCTPPolicy()
     * @uses UpdItmWhsItem::setQuarantineLeadtime()
     * @uses UpdItmWhsItem::setScheduledReclassificationAllowed()
     * @uses UpdItmWhsItem::setCatchWeightApprovedOnHandBalance()
     * @uses UpdItmWhsItem::setCatchWeightRejectedOnHandBalance()
     * @uses UpdItmWhsItem::setCatchWeightForInspectionOnHandBal()
     * @uses UpdItmWhsItem::setAlternateUM()
     * @uses UpdItmWhsItem::setStandardCostPriceUnitOfMeasure()
     * @uses UpdItmWhsItem::setInventoryPlanned()
     * @uses UpdItmWhsItem::setBestBeforeTime()
     * @uses UpdItmWhsItem::setFrozenSafetyStock()
     * @uses UpdItmWhsItem::setReturnableNonReturnableIndicator()
     * @uses UpdItmWhsItem::setReturnableMessage()
     * @uses UpdItmWhsItem::setSSReasonCode()
     * @uses UpdItmWhsItem::setSecondaryAllocationMethod()
     * @param float $company
     * @param string $warehouse
     * @param string $itemNumber
     * @param float $onhandBalanceApproved
     * @param float $onhandBalanceForInspection
     * @param float $rejectedOnhandBalance
     * @param float $allocatedQuantityBasicUM
     * @param float $allocatableOnhandBalance
     * @param float $pickingListQuantityBasicUM
     * @param float $containerManagement
     * @param float $allocationMethod
     * @param float $storageMethod
     * @param float $issueMethod
     * @param string $note
     * @param float $orderedQuantityBasicUM
     * @param float $reservedQuantity
     * @param float $reservedQuantityToBackorder
     * @param float $reservedQuantityPlannedOrders
     * @param string $lastReceiptDate
     * @param string $lastIssueDate
     * @param string $latestPhysicalInventoryDate
     * @param float $priorityDateSelection
     * @param string $physicalInventoryCycle
     * @param float $numberOfRecordsForPhysicalInventory
     * @param float $annualUsage
     * @param float $averageOnhandBalance
     * @param float $projectedOnhandAtEndOfLeadTime
     * @param string $responsible
     * @param string $buyer
     * @param string $supplierNumber
     * @param string $warehouseType
     * @param string $warehouseSubtype
     * @param float $statisticsStorageGroup
     * @param string $distributionGroup
     * @param string $location
     * @param string $stockZone
     * @param float $numberOfBalanceIDs
     * @param float $issueMultiple
     * @param string $locationType
     * @param string $warehouseEquipment
     * @param string $planningPolicy
     * @param string $aBCClassManual
     * @param string $aBCClassVolume
     * @param float $aBCMethodVolume
     * @param string $aBCClassFrequency
     * @param float $aBCMethodFrequency
     * @param string $aBCClassContribution
     * @param float $aBCMethodContribution
     * @param float $priorityValue
     * @param float $runoutTime
     * @param float $reorderPoint
     * @param float $reorderPointMethod
     * @param float $safetyStock
     * @param float $safetyStockMethod
     * @param float $manualSafetyStock
     * @param float $safetyStockUnit
     * @param float $serviceLevel
     * @param float $maximumStock
     * @param float $maximumStockMethod
     * @param float $maximumStockPercentage
     * @param float $orderQuantity
     * @param float $orderPolicy
     * @param float $economicalOrderQuantityDays
     * @param float $annualDemand
     * @param float $annualDemandMethod
     * @param float $minimumOrderQuantity
     * @param float $maximumOrderQuantity
     * @param float $acquisitionCode
     * @param string $supplyingWarehouse
     * @param float $periodFrame
     * @param string $forecastMethod
     * @param string $forecastLogic
     * @param float $fixedAnnualDemand
     * @param float $fixedAcquisitionRequirement
     * @param float $planningTimeFence
     * @param float $supplyLeadTime
     * @param float $inspectionLeadTime
     * @param float $transportationLeadTime
     * @param float $leadTime
     * @param float $orderMultiple
     * @param float $multipleSupply
     * @param float $lowestLevel
     * @param float $lowestLevelDO
     * @param float $planningHorizon
     * @param float $demandTimeFence
     * @param string $orderType
     * @param float $continuousNetChange
     * @param float $safetyTime
     * @param float $quantityControlledAllocation
     * @param float $planningMethod
     * @param float $masterScheduled
     * @param float $distributionSupplierCalendarCheck
     * @param float $zeroMark
     * @param string $inspectionLocation
     * @param float $netChangeCalculationActive
     * @param string $facility
     * @param string $division
     * @param float $timePhasedSafetyStockExists
     * @param float $historyStorageMethod
     * @param float $pickingListInformationControl
     * @param float $pendingPlanningMethodChange
     * @param string $calculationDateMaterialPlanning
     * @param float $calculationTimeMaterialPlanning
     * @param float $timePhasedSafetyStock
     * @param float $responsiblePOProposal
     * @param float $standardCostWarehouse
     * @param float $textIdentity
     * @param float $dataIdentity
     * @param string $defaultPackingLocation
     * @param string $defaultDockingLocation
     * @param string $deliverySplitRule
     * @param float $allocateNonapprovedBalanceID
     * @param string $pointOfTimeTable
     * @param string $status
     * @param float $vATCodePurchase
     * @param float $vATCodeSales
     * @param string $mainUnitOfCalculation
     * @param string $distributionGroupTechnology
     * @param float $shelfLife
     * @param float $reinspectionTime
     * @param float $salesTime
     * @param string $cTPPolicy
     * @param float $quarantineLeadtime
     * @param float $scheduledReclassificationAllowed
     * @param float $catchWeightApprovedOnHandBalance
     * @param float $catchWeightRejectedOnHandBalance
     * @param float $catchWeightForInspectionOnHandBal
     * @param string $alternateUM
     * @param string $standardCostPriceUnitOfMeasure
     * @param string $inventoryPlanned
     * @param float $bestBeforeTime
     * @param float $frozenSafetyStock
     * @param float $returnableNonReturnableIndicator
     * @param float $returnableMessage
     * @param string $sSReasonCode
     * @param float $secondaryAllocationMethod
     */
    public function __construct($company = null, $warehouse = null, $itemNumber = null, $onhandBalanceApproved = null, $onhandBalanceForInspection = null, $rejectedOnhandBalance = null, $allocatedQuantityBasicUM = null, $allocatableOnhandBalance = null, $pickingListQuantityBasicUM = null, $containerManagement = null, $allocationMethod = null, $storageMethod = null, $issueMethod = null, $note = null, $orderedQuantityBasicUM = null, $reservedQuantity = null, $reservedQuantityToBackorder = null, $reservedQuantityPlannedOrders = null, $lastReceiptDate = null, $lastIssueDate = null, $latestPhysicalInventoryDate = null, $priorityDateSelection = null, $physicalInventoryCycle = null, $numberOfRecordsForPhysicalInventory = null, $annualUsage = null, $averageOnhandBalance = null, $projectedOnhandAtEndOfLeadTime = null, $responsible = null, $buyer = null, $supplierNumber = null, $warehouseType = null, $warehouseSubtype = null, $statisticsStorageGroup = null, $distributionGroup = null, $location = null, $stockZone = null, $numberOfBalanceIDs = null, $issueMultiple = null, $locationType = null, $warehouseEquipment = null, $planningPolicy = null, $aBCClassManual = null, $aBCClassVolume = null, $aBCMethodVolume = null, $aBCClassFrequency = null, $aBCMethodFrequency = null, $aBCClassContribution = null, $aBCMethodContribution = null, $priorityValue = null, $runoutTime = null, $reorderPoint = null, $reorderPointMethod = null, $safetyStock = null, $safetyStockMethod = null, $manualSafetyStock = null, $safetyStockUnit = null, $serviceLevel = null, $maximumStock = null, $maximumStockMethod = null, $maximumStockPercentage = null, $orderQuantity = null, $orderPolicy = null, $economicalOrderQuantityDays = null, $annualDemand = null, $annualDemandMethod = null, $minimumOrderQuantity = null, $maximumOrderQuantity = null, $acquisitionCode = null, $supplyingWarehouse = null, $periodFrame = null, $forecastMethod = null, $forecastLogic = null, $fixedAnnualDemand = null, $fixedAcquisitionRequirement = null, $planningTimeFence = null, $supplyLeadTime = null, $inspectionLeadTime = null, $transportationLeadTime = null, $leadTime = null, $orderMultiple = null, $multipleSupply = null, $lowestLevel = null, $lowestLevelDO = null, $planningHorizon = null, $demandTimeFence = null, $orderType = null, $continuousNetChange = null, $safetyTime = null, $quantityControlledAllocation = null, $planningMethod = null, $masterScheduled = null, $distributionSupplierCalendarCheck = null, $zeroMark = null, $inspectionLocation = null, $netChangeCalculationActive = null, $facility = null, $division = null, $timePhasedSafetyStockExists = null, $historyStorageMethod = null, $pickingListInformationControl = null, $pendingPlanningMethodChange = null, $calculationDateMaterialPlanning = null, $calculationTimeMaterialPlanning = null, $timePhasedSafetyStock = null, $responsiblePOProposal = null, $standardCostWarehouse = null, $textIdentity = null, $dataIdentity = null, $defaultPackingLocation = null, $defaultDockingLocation = null, $deliverySplitRule = null, $allocateNonapprovedBalanceID = null, $pointOfTimeTable = null, $status = null, $vATCodePurchase = null, $vATCodeSales = null, $mainUnitOfCalculation = null, $distributionGroupTechnology = null, $shelfLife = null, $reinspectionTime = null, $salesTime = null, $cTPPolicy = null, $quarantineLeadtime = null, $scheduledReclassificationAllowed = null, $catchWeightApprovedOnHandBalance = null, $catchWeightRejectedOnHandBalance = null, $catchWeightForInspectionOnHandBal = null, $alternateUM = null, $standardCostPriceUnitOfMeasure = null, $inventoryPlanned = null, $bestBeforeTime = null, $frozenSafetyStock = null, $returnableNonReturnableIndicator = null, $returnableMessage = null, $sSReasonCode = null, $secondaryAllocationMethod = null)
    {
        $this
            ->setCompany($company)
            ->setWarehouse($warehouse)
            ->setItemNumber($itemNumber)
            ->setOnhandBalanceApproved($onhandBalanceApproved)
            ->setOnhandBalanceForInspection($onhandBalanceForInspection)
            ->setRejectedOnhandBalance($rejectedOnhandBalance)
            ->setAllocatedQuantityBasicUM($allocatedQuantityBasicUM)
            ->setAllocatableOnhandBalance($allocatableOnhandBalance)
            ->setPickingListQuantityBasicUM($pickingListQuantityBasicUM)
            ->setContainerManagement($containerManagement)
            ->setAllocationMethod($allocationMethod)
            ->setStorageMethod($storageMethod)
            ->setIssueMethod($issueMethod)
            ->setNote($note)
            ->setOrderedQuantityBasicUM($orderedQuantityBasicUM)
            ->setReservedQuantity($reservedQuantity)
            ->setReservedQuantityToBackorder($reservedQuantityToBackorder)
            ->setReservedQuantityPlannedOrders($reservedQuantityPlannedOrders)
            ->setLastReceiptDate($lastReceiptDate)
            ->setLastIssueDate($lastIssueDate)
            ->setLatestPhysicalInventoryDate($latestPhysicalInventoryDate)
            ->setPriorityDateSelection($priorityDateSelection)
            ->setPhysicalInventoryCycle($physicalInventoryCycle)
            ->setNumberOfRecordsForPhysicalInventory($numberOfRecordsForPhysicalInventory)
            ->setAnnualUsage($annualUsage)
            ->setAverageOnhandBalance($averageOnhandBalance)
            ->setProjectedOnhandAtEndOfLeadTime($projectedOnhandAtEndOfLeadTime)
            ->setResponsible($responsible)
            ->setBuyer($buyer)
            ->setSupplierNumber($supplierNumber)
            ->setWarehouseType($warehouseType)
            ->setWarehouseSubtype($warehouseSubtype)
            ->setStatisticsStorageGroup($statisticsStorageGroup)
            ->setDistributionGroup($distributionGroup)
            ->setLocation($location)
            ->setStockZone($stockZone)
            ->setNumberOfBalanceIDs($numberOfBalanceIDs)
            ->setIssueMultiple($issueMultiple)
            ->setLocationType($locationType)
            ->setWarehouseEquipment($warehouseEquipment)
            ->setPlanningPolicy($planningPolicy)
            ->setABCClassManual($aBCClassManual)
            ->setABCClassVolume($aBCClassVolume)
            ->setABCMethodVolume($aBCMethodVolume)
            ->setABCClassFrequency($aBCClassFrequency)
            ->setABCMethodFrequency($aBCMethodFrequency)
            ->setABCClassContribution($aBCClassContribution)
            ->setABCMethodContribution($aBCMethodContribution)
            ->setPriorityValue($priorityValue)
            ->setRunoutTime($runoutTime)
            ->setReorderPoint($reorderPoint)
            ->setReorderPointMethod($reorderPointMethod)
            ->setSafetyStock($safetyStock)
            ->setSafetyStockMethod($safetyStockMethod)
            ->setManualSafetyStock($manualSafetyStock)
            ->setSafetyStockUnit($safetyStockUnit)
            ->setServiceLevel($serviceLevel)
            ->setMaximumStock($maximumStock)
            ->setMaximumStockMethod($maximumStockMethod)
            ->setMaximumStockPercentage($maximumStockPercentage)
            ->setOrderQuantity($orderQuantity)
            ->setOrderPolicy($orderPolicy)
            ->setEconomicalOrderQuantityDays($economicalOrderQuantityDays)
            ->setAnnualDemand($annualDemand)
            ->setAnnualDemandMethod($annualDemandMethod)
            ->setMinimumOrderQuantity($minimumOrderQuantity)
            ->setMaximumOrderQuantity($maximumOrderQuantity)
            ->setAcquisitionCode($acquisitionCode)
            ->setSupplyingWarehouse($supplyingWarehouse)
            ->setPeriodFrame($periodFrame)
            ->setForecastMethod($forecastMethod)
            ->setForecastLogic($forecastLogic)
            ->setFixedAnnualDemand($fixedAnnualDemand)
            ->setFixedAcquisitionRequirement($fixedAcquisitionRequirement)
            ->setPlanningTimeFence($planningTimeFence)
            ->setSupplyLeadTime($supplyLeadTime)
            ->setInspectionLeadTime($inspectionLeadTime)
            ->setTransportationLeadTime($transportationLeadTime)
            ->setLeadTime($leadTime)
            ->setOrderMultiple($orderMultiple)
            ->setMultipleSupply($multipleSupply)
            ->setLowestLevel($lowestLevel)
            ->setLowestLevelDO($lowestLevelDO)
            ->setPlanningHorizon($planningHorizon)
            ->setDemandTimeFence($demandTimeFence)
            ->setOrderType($orderType)
            ->setContinuousNetChange($continuousNetChange)
            ->setSafetyTime($safetyTime)
            ->setQuantityControlledAllocation($quantityControlledAllocation)
            ->setPlanningMethod($planningMethod)
            ->setMasterScheduled($masterScheduled)
            ->setDistributionSupplierCalendarCheck($distributionSupplierCalendarCheck)
            ->setZeroMark($zeroMark)
            ->setInspectionLocation($inspectionLocation)
            ->setNetChangeCalculationActive($netChangeCalculationActive)
            ->setFacility($facility)
            ->setDivision($division)
            ->setTimePhasedSafetyStockExists($timePhasedSafetyStockExists)
            ->setHistoryStorageMethod($historyStorageMethod)
            ->setPickingListInformationControl($pickingListInformationControl)
            ->setPendingPlanningMethodChange($pendingPlanningMethodChange)
            ->setCalculationDateMaterialPlanning($calculationDateMaterialPlanning)
            ->setCalculationTimeMaterialPlanning($calculationTimeMaterialPlanning)
            ->setTimePhasedSafetyStock($timePhasedSafetyStock)
            ->setResponsiblePOProposal($responsiblePOProposal)
            ->setStandardCostWarehouse($standardCostWarehouse)
            ->setTextIdentity($textIdentity)
            ->setDataIdentity($dataIdentity)
            ->setDefaultPackingLocation($defaultPackingLocation)
            ->setDefaultDockingLocation($defaultDockingLocation)
            ->setDeliverySplitRule($deliverySplitRule)
            ->setAllocateNonapprovedBalanceID($allocateNonapprovedBalanceID)
            ->setPointOfTimeTable($pointOfTimeTable)
            ->setStatus($status)
            ->setVATCodePurchase($vATCodePurchase)
            ->setVATCodeSales($vATCodeSales)
            ->setMainUnitOfCalculation($mainUnitOfCalculation)
            ->setDistributionGroupTechnology($distributionGroupTechnology)
            ->setShelfLife($shelfLife)
            ->setReinspectionTime($reinspectionTime)
            ->setSalesTime($salesTime)
            ->setCTPPolicy($cTPPolicy)
            ->setQuarantineLeadtime($quarantineLeadtime)
            ->setScheduledReclassificationAllowed($scheduledReclassificationAllowed)
            ->setCatchWeightApprovedOnHandBalance($catchWeightApprovedOnHandBalance)
            ->setCatchWeightRejectedOnHandBalance($catchWeightRejectedOnHandBalance)
            ->setCatchWeightForInspectionOnHandBal($catchWeightForInspectionOnHandBal)
            ->setAlternateUM($alternateUM)
            ->setStandardCostPriceUnitOfMeasure($standardCostPriceUnitOfMeasure)
            ->setInventoryPlanned($inventoryPlanned)
            ->setBestBeforeTime($bestBeforeTime)
            ->setFrozenSafetyStock($frozenSafetyStock)
            ->setReturnableNonReturnableIndicator($returnableNonReturnableIndicator)
            ->setReturnableMessage($returnableMessage)
            ->setSSReasonCode($sSReasonCode)
            ->setSecondaryAllocationMethod($secondaryAllocationMethod);
    }
    /**
     * Get Company value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getCompany()
    {
        return isset($this->Company) ? $this->Company : null;
    }
    /**
     * Set Company value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $company
     * @return \StructType\UpdItmWhsItem
     */
    public function setCompany($company = null)
    {
        // validation for constraint: float
        if (!is_null($company) && !(is_float($company) || is_numeric($company))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($company, true), gettype($company)), __LINE__);
        }
        if (is_null($company) || (is_array($company) && empty($company))) {
            unset($this->Company);
        } else {
            $this->Company = $company;
        }
        return $this;
    }
    /**
     * Get Warehouse value
     * @return string|null
     */
    public function getWarehouse()
    {
        return $this->Warehouse;
    }
    /**
     * Set Warehouse value
     * @param string $warehouse
     * @return \StructType\UpdItmWhsItem
     */
    public function setWarehouse($warehouse = null)
    {
        // validation for constraint: string
        if (!is_null($warehouse) && !is_string($warehouse)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($warehouse, true), gettype($warehouse)), __LINE__);
        }
        // validation for constraint: maxLength(3)
        if (!is_null($warehouse) && mb_strlen($warehouse) > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 3', mb_strlen($warehouse)), __LINE__);
        }
        $this->Warehouse = $warehouse;
        return $this;
    }
    /**
     * Get ItemNumber value
     * @return string|null
     */
    public function getItemNumber()
    {
        return $this->ItemNumber;
    }
    /**
     * Set ItemNumber value
     * @param string $itemNumber
     * @return \StructType\UpdItmWhsItem
     */
    public function setItemNumber($itemNumber = null)
    {
        // validation for constraint: string
        if (!is_null($itemNumber) && !is_string($itemNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($itemNumber, true), gettype($itemNumber)), __LINE__);
        }
        // validation for constraint: maxLength(15)
        if (!is_null($itemNumber) && mb_strlen($itemNumber) > 15) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 15', mb_strlen($itemNumber)), __LINE__);
        }
        $this->ItemNumber = $itemNumber;
        return $this;
    }
    /**
     * Get OnhandBalanceApproved value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getOnhandBalanceApproved()
    {
        return isset($this->OnhandBalanceApproved) ? $this->OnhandBalanceApproved : null;
    }
    /**
     * Set OnhandBalanceApproved value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $onhandBalanceApproved
     * @return \StructType\UpdItmWhsItem
     */
    public function setOnhandBalanceApproved($onhandBalanceApproved = null)
    {
        // validation for constraint: float
        if (!is_null($onhandBalanceApproved) && !(is_float($onhandBalanceApproved) || is_numeric($onhandBalanceApproved))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($onhandBalanceApproved, true), gettype($onhandBalanceApproved)), __LINE__);
        }
        if (is_null($onhandBalanceApproved) || (is_array($onhandBalanceApproved) && empty($onhandBalanceApproved))) {
            unset($this->OnhandBalanceApproved);
        } else {
            $this->OnhandBalanceApproved = $onhandBalanceApproved;
        }
        return $this;
    }
    /**
     * Get OnhandBalanceForInspection value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getOnhandBalanceForInspection()
    {
        return isset($this->OnhandBalanceForInspection) ? $this->OnhandBalanceForInspection : null;
    }
    /**
     * Set OnhandBalanceForInspection value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $onhandBalanceForInspection
     * @return \StructType\UpdItmWhsItem
     */
    public function setOnhandBalanceForInspection($onhandBalanceForInspection = null)
    {
        // validation for constraint: float
        if (!is_null($onhandBalanceForInspection) && !(is_float($onhandBalanceForInspection) || is_numeric($onhandBalanceForInspection))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($onhandBalanceForInspection, true), gettype($onhandBalanceForInspection)), __LINE__);
        }
        if (is_null($onhandBalanceForInspection) || (is_array($onhandBalanceForInspection) && empty($onhandBalanceForInspection))) {
            unset($this->OnhandBalanceForInspection);
        } else {
            $this->OnhandBalanceForInspection = $onhandBalanceForInspection;
        }
        return $this;
    }
    /**
     * Get RejectedOnhandBalance value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getRejectedOnhandBalance()
    {
        return isset($this->RejectedOnhandBalance) ? $this->RejectedOnhandBalance : null;
    }
    /**
     * Set RejectedOnhandBalance value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $rejectedOnhandBalance
     * @return \StructType\UpdItmWhsItem
     */
    public function setRejectedOnhandBalance($rejectedOnhandBalance = null)
    {
        // validation for constraint: float
        if (!is_null($rejectedOnhandBalance) && !(is_float($rejectedOnhandBalance) || is_numeric($rejectedOnhandBalance))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($rejectedOnhandBalance, true), gettype($rejectedOnhandBalance)), __LINE__);
        }
        if (is_null($rejectedOnhandBalance) || (is_array($rejectedOnhandBalance) && empty($rejectedOnhandBalance))) {
            unset($this->RejectedOnhandBalance);
        } else {
            $this->RejectedOnhandBalance = $rejectedOnhandBalance;
        }
        return $this;
    }
    /**
     * Get AllocatedQuantityBasicUM value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getAllocatedQuantityBasicUM()
    {
        return isset($this->AllocatedQuantityBasicUM) ? $this->AllocatedQuantityBasicUM : null;
    }
    /**
     * Set AllocatedQuantityBasicUM value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $allocatedQuantityBasicUM
     * @return \StructType\UpdItmWhsItem
     */
    public function setAllocatedQuantityBasicUM($allocatedQuantityBasicUM = null)
    {
        // validation for constraint: float
        if (!is_null($allocatedQuantityBasicUM) && !(is_float($allocatedQuantityBasicUM) || is_numeric($allocatedQuantityBasicUM))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($allocatedQuantityBasicUM, true), gettype($allocatedQuantityBasicUM)), __LINE__);
        }
        if (is_null($allocatedQuantityBasicUM) || (is_array($allocatedQuantityBasicUM) && empty($allocatedQuantityBasicUM))) {
            unset($this->AllocatedQuantityBasicUM);
        } else {
            $this->AllocatedQuantityBasicUM = $allocatedQuantityBasicUM;
        }
        return $this;
    }
    /**
     * Get AllocatableOnhandBalance value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getAllocatableOnhandBalance()
    {
        return isset($this->AllocatableOnhandBalance) ? $this->AllocatableOnhandBalance : null;
    }
    /**
     * Set AllocatableOnhandBalance value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $allocatableOnhandBalance
     * @return \StructType\UpdItmWhsItem
     */
    public function setAllocatableOnhandBalance($allocatableOnhandBalance = null)
    {
        // validation for constraint: float
        if (!is_null($allocatableOnhandBalance) && !(is_float($allocatableOnhandBalance) || is_numeric($allocatableOnhandBalance))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($allocatableOnhandBalance, true), gettype($allocatableOnhandBalance)), __LINE__);
        }
        if (is_null($allocatableOnhandBalance) || (is_array($allocatableOnhandBalance) && empty($allocatableOnhandBalance))) {
            unset($this->AllocatableOnhandBalance);
        } else {
            $this->AllocatableOnhandBalance = $allocatableOnhandBalance;
        }
        return $this;
    }
    /**
     * Get PickingListQuantityBasicUM value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getPickingListQuantityBasicUM()
    {
        return isset($this->PickingListQuantityBasicUM) ? $this->PickingListQuantityBasicUM : null;
    }
    /**
     * Set PickingListQuantityBasicUM value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $pickingListQuantityBasicUM
     * @return \StructType\UpdItmWhsItem
     */
    public function setPickingListQuantityBasicUM($pickingListQuantityBasicUM = null)
    {
        // validation for constraint: float
        if (!is_null($pickingListQuantityBasicUM) && !(is_float($pickingListQuantityBasicUM) || is_numeric($pickingListQuantityBasicUM))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($pickingListQuantityBasicUM, true), gettype($pickingListQuantityBasicUM)), __LINE__);
        }
        if (is_null($pickingListQuantityBasicUM) || (is_array($pickingListQuantityBasicUM) && empty($pickingListQuantityBasicUM))) {
            unset($this->PickingListQuantityBasicUM);
        } else {
            $this->PickingListQuantityBasicUM = $pickingListQuantityBasicUM;
        }
        return $this;
    }
    /**
     * Get ContainerManagement value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getContainerManagement()
    {
        return isset($this->ContainerManagement) ? $this->ContainerManagement : null;
    }
    /**
     * Set ContainerManagement value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $containerManagement
     * @return \StructType\UpdItmWhsItem
     */
    public function setContainerManagement($containerManagement = null)
    {
        // validation for constraint: float
        if (!is_null($containerManagement) && !(is_float($containerManagement) || is_numeric($containerManagement))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($containerManagement, true), gettype($containerManagement)), __LINE__);
        }
        if (is_null($containerManagement) || (is_array($containerManagement) && empty($containerManagement))) {
            unset($this->ContainerManagement);
        } else {
            $this->ContainerManagement = $containerManagement;
        }
        return $this;
    }
    /**
     * Get AllocationMethod value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getAllocationMethod()
    {
        return isset($this->AllocationMethod) ? $this->AllocationMethod : null;
    }
    /**
     * Set AllocationMethod value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $allocationMethod
     * @return \StructType\UpdItmWhsItem
     */
    public function setAllocationMethod($allocationMethod = null)
    {
        // validation for constraint: float
        if (!is_null($allocationMethod) && !(is_float($allocationMethod) || is_numeric($allocationMethod))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($allocationMethod, true), gettype($allocationMethod)), __LINE__);
        }
        if (is_null($allocationMethod) || (is_array($allocationMethod) && empty($allocationMethod))) {
            unset($this->AllocationMethod);
        } else {
            $this->AllocationMethod = $allocationMethod;
        }
        return $this;
    }
    /**
     * Get StorageMethod value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getStorageMethod()
    {
        return isset($this->StorageMethod) ? $this->StorageMethod : null;
    }
    /**
     * Set StorageMethod value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $storageMethod
     * @return \StructType\UpdItmWhsItem
     */
    public function setStorageMethod($storageMethod = null)
    {
        // validation for constraint: float
        if (!is_null($storageMethod) && !(is_float($storageMethod) || is_numeric($storageMethod))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($storageMethod, true), gettype($storageMethod)), __LINE__);
        }
        if (is_null($storageMethod) || (is_array($storageMethod) && empty($storageMethod))) {
            unset($this->StorageMethod);
        } else {
            $this->StorageMethod = $storageMethod;
        }
        return $this;
    }
    /**
     * Get IssueMethod value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getIssueMethod()
    {
        return isset($this->IssueMethod) ? $this->IssueMethod : null;
    }
    /**
     * Set IssueMethod value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $issueMethod
     * @return \StructType\UpdItmWhsItem
     */
    public function setIssueMethod($issueMethod = null)
    {
        // validation for constraint: float
        if (!is_null($issueMethod) && !(is_float($issueMethod) || is_numeric($issueMethod))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($issueMethod, true), gettype($issueMethod)), __LINE__);
        }
        if (is_null($issueMethod) || (is_array($issueMethod) && empty($issueMethod))) {
            unset($this->IssueMethod);
        } else {
            $this->IssueMethod = $issueMethod;
        }
        return $this;
    }
    /**
     * Get Note value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNote()
    {
        return isset($this->Note) ? $this->Note : null;
    }
    /**
     * Set Note value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $note
     * @return \StructType\UpdItmWhsItem
     */
    public function setNote($note = null)
    {
        // validation for constraint: string
        if (!is_null($note) && !is_string($note)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($note, true), gettype($note)), __LINE__);
        }
        // validation for constraint: maxLength(30)
        if (!is_null($note) && mb_strlen($note) > 30) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 30', mb_strlen($note)), __LINE__);
        }
        if (is_null($note) || (is_array($note) && empty($note))) {
            unset($this->Note);
        } else {
            $this->Note = $note;
        }
        return $this;
    }
    /**
     * Get OrderedQuantityBasicUM value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getOrderedQuantityBasicUM()
    {
        return isset($this->OrderedQuantityBasicUM) ? $this->OrderedQuantityBasicUM : null;
    }
    /**
     * Set OrderedQuantityBasicUM value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $orderedQuantityBasicUM
     * @return \StructType\UpdItmWhsItem
     */
    public function setOrderedQuantityBasicUM($orderedQuantityBasicUM = null)
    {
        // validation for constraint: float
        if (!is_null($orderedQuantityBasicUM) && !(is_float($orderedQuantityBasicUM) || is_numeric($orderedQuantityBasicUM))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($orderedQuantityBasicUM, true), gettype($orderedQuantityBasicUM)), __LINE__);
        }
        if (is_null($orderedQuantityBasicUM) || (is_array($orderedQuantityBasicUM) && empty($orderedQuantityBasicUM))) {
            unset($this->OrderedQuantityBasicUM);
        } else {
            $this->OrderedQuantityBasicUM = $orderedQuantityBasicUM;
        }
        return $this;
    }
    /**
     * Get ReservedQuantity value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getReservedQuantity()
    {
        return isset($this->ReservedQuantity) ? $this->ReservedQuantity : null;
    }
    /**
     * Set ReservedQuantity value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $reservedQuantity
     * @return \StructType\UpdItmWhsItem
     */
    public function setReservedQuantity($reservedQuantity = null)
    {
        // validation for constraint: float
        if (!is_null($reservedQuantity) && !(is_float($reservedQuantity) || is_numeric($reservedQuantity))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($reservedQuantity, true), gettype($reservedQuantity)), __LINE__);
        }
        if (is_null($reservedQuantity) || (is_array($reservedQuantity) && empty($reservedQuantity))) {
            unset($this->ReservedQuantity);
        } else {
            $this->ReservedQuantity = $reservedQuantity;
        }
        return $this;
    }
    /**
     * Get ReservedQuantityToBackorder value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getReservedQuantityToBackorder()
    {
        return isset($this->ReservedQuantityToBackorder) ? $this->ReservedQuantityToBackorder : null;
    }
    /**
     * Set ReservedQuantityToBackorder value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $reservedQuantityToBackorder
     * @return \StructType\UpdItmWhsItem
     */
    public function setReservedQuantityToBackorder($reservedQuantityToBackorder = null)
    {
        // validation for constraint: float
        if (!is_null($reservedQuantityToBackorder) && !(is_float($reservedQuantityToBackorder) || is_numeric($reservedQuantityToBackorder))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($reservedQuantityToBackorder, true), gettype($reservedQuantityToBackorder)), __LINE__);
        }
        if (is_null($reservedQuantityToBackorder) || (is_array($reservedQuantityToBackorder) && empty($reservedQuantityToBackorder))) {
            unset($this->ReservedQuantityToBackorder);
        } else {
            $this->ReservedQuantityToBackorder = $reservedQuantityToBackorder;
        }
        return $this;
    }
    /**
     * Get ReservedQuantityPlannedOrders value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getReservedQuantityPlannedOrders()
    {
        return isset($this->ReservedQuantityPlannedOrders) ? $this->ReservedQuantityPlannedOrders : null;
    }
    /**
     * Set ReservedQuantityPlannedOrders value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $reservedQuantityPlannedOrders
     * @return \StructType\UpdItmWhsItem
     */
    public function setReservedQuantityPlannedOrders($reservedQuantityPlannedOrders = null)
    {
        // validation for constraint: float
        if (!is_null($reservedQuantityPlannedOrders) && !(is_float($reservedQuantityPlannedOrders) || is_numeric($reservedQuantityPlannedOrders))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($reservedQuantityPlannedOrders, true), gettype($reservedQuantityPlannedOrders)), __LINE__);
        }
        if (is_null($reservedQuantityPlannedOrders) || (is_array($reservedQuantityPlannedOrders) && empty($reservedQuantityPlannedOrders))) {
            unset($this->ReservedQuantityPlannedOrders);
        } else {
            $this->ReservedQuantityPlannedOrders = $reservedQuantityPlannedOrders;
        }
        return $this;
    }
    /**
     * Get LastReceiptDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLastReceiptDate()
    {
        return isset($this->LastReceiptDate) ? $this->LastReceiptDate : null;
    }
    /**
     * Set LastReceiptDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $lastReceiptDate
     * @return \StructType\UpdItmWhsItem
     */
    public function setLastReceiptDate($lastReceiptDate = null)
    {
        // validation for constraint: string
        if (!is_null($lastReceiptDate) && !is_string($lastReceiptDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastReceiptDate, true), gettype($lastReceiptDate)), __LINE__);
        }
        if (is_null($lastReceiptDate) || (is_array($lastReceiptDate) && empty($lastReceiptDate))) {
            unset($this->LastReceiptDate);
        } else {
            $this->LastReceiptDate = $lastReceiptDate;
        }
        return $this;
    }
    /**
     * Get LastIssueDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLastIssueDate()
    {
        return isset($this->LastIssueDate) ? $this->LastIssueDate : null;
    }
    /**
     * Set LastIssueDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $lastIssueDate
     * @return \StructType\UpdItmWhsItem
     */
    public function setLastIssueDate($lastIssueDate = null)
    {
        // validation for constraint: string
        if (!is_null($lastIssueDate) && !is_string($lastIssueDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastIssueDate, true), gettype($lastIssueDate)), __LINE__);
        }
        if (is_null($lastIssueDate) || (is_array($lastIssueDate) && empty($lastIssueDate))) {
            unset($this->LastIssueDate);
        } else {
            $this->LastIssueDate = $lastIssueDate;
        }
        return $this;
    }
    /**
     * Get LatestPhysicalInventoryDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLatestPhysicalInventoryDate()
    {
        return isset($this->LatestPhysicalInventoryDate) ? $this->LatestPhysicalInventoryDate : null;
    }
    /**
     * Set LatestPhysicalInventoryDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $latestPhysicalInventoryDate
     * @return \StructType\UpdItmWhsItem
     */
    public function setLatestPhysicalInventoryDate($latestPhysicalInventoryDate = null)
    {
        // validation for constraint: string
        if (!is_null($latestPhysicalInventoryDate) && !is_string($latestPhysicalInventoryDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($latestPhysicalInventoryDate, true), gettype($latestPhysicalInventoryDate)), __LINE__);
        }
        if (is_null($latestPhysicalInventoryDate) || (is_array($latestPhysicalInventoryDate) && empty($latestPhysicalInventoryDate))) {
            unset($this->LatestPhysicalInventoryDate);
        } else {
            $this->LatestPhysicalInventoryDate = $latestPhysicalInventoryDate;
        }
        return $this;
    }
    /**
     * Get PriorityDateSelection value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getPriorityDateSelection()
    {
        return isset($this->PriorityDateSelection) ? $this->PriorityDateSelection : null;
    }
    /**
     * Set PriorityDateSelection value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $priorityDateSelection
     * @return \StructType\UpdItmWhsItem
     */
    public function setPriorityDateSelection($priorityDateSelection = null)
    {
        // validation for constraint: float
        if (!is_null($priorityDateSelection) && !(is_float($priorityDateSelection) || is_numeric($priorityDateSelection))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($priorityDateSelection, true), gettype($priorityDateSelection)), __LINE__);
        }
        if (is_null($priorityDateSelection) || (is_array($priorityDateSelection) && empty($priorityDateSelection))) {
            unset($this->PriorityDateSelection);
        } else {
            $this->PriorityDateSelection = $priorityDateSelection;
        }
        return $this;
    }
    /**
     * Get PhysicalInventoryCycle value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPhysicalInventoryCycle()
    {
        return isset($this->PhysicalInventoryCycle) ? $this->PhysicalInventoryCycle : null;
    }
    /**
     * Set PhysicalInventoryCycle value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $physicalInventoryCycle
     * @return \StructType\UpdItmWhsItem
     */
    public function setPhysicalInventoryCycle($physicalInventoryCycle = null)
    {
        // validation for constraint: string
        if (!is_null($physicalInventoryCycle) && !is_string($physicalInventoryCycle)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($physicalInventoryCycle, true), gettype($physicalInventoryCycle)), __LINE__);
        }
        // validation for constraint: maxLength(3)
        if (!is_null($physicalInventoryCycle) && mb_strlen($physicalInventoryCycle) > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 3', mb_strlen($physicalInventoryCycle)), __LINE__);
        }
        if (is_null($physicalInventoryCycle) || (is_array($physicalInventoryCycle) && empty($physicalInventoryCycle))) {
            unset($this->PhysicalInventoryCycle);
        } else {
            $this->PhysicalInventoryCycle = $physicalInventoryCycle;
        }
        return $this;
    }
    /**
     * Get NumberOfRecordsForPhysicalInventory value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getNumberOfRecordsForPhysicalInventory()
    {
        return isset($this->NumberOfRecordsForPhysicalInventory) ? $this->NumberOfRecordsForPhysicalInventory : null;
    }
    /**
     * Set NumberOfRecordsForPhysicalInventory value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $numberOfRecordsForPhysicalInventory
     * @return \StructType\UpdItmWhsItem
     */
    public function setNumberOfRecordsForPhysicalInventory($numberOfRecordsForPhysicalInventory = null)
    {
        // validation for constraint: float
        if (!is_null($numberOfRecordsForPhysicalInventory) && !(is_float($numberOfRecordsForPhysicalInventory) || is_numeric($numberOfRecordsForPhysicalInventory))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($numberOfRecordsForPhysicalInventory, true), gettype($numberOfRecordsForPhysicalInventory)), __LINE__);
        }
        if (is_null($numberOfRecordsForPhysicalInventory) || (is_array($numberOfRecordsForPhysicalInventory) && empty($numberOfRecordsForPhysicalInventory))) {
            unset($this->NumberOfRecordsForPhysicalInventory);
        } else {
            $this->NumberOfRecordsForPhysicalInventory = $numberOfRecordsForPhysicalInventory;
        }
        return $this;
    }
    /**
     * Get AnnualUsage value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getAnnualUsage()
    {
        return isset($this->AnnualUsage) ? $this->AnnualUsage : null;
    }
    /**
     * Set AnnualUsage value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $annualUsage
     * @return \StructType\UpdItmWhsItem
     */
    public function setAnnualUsage($annualUsage = null)
    {
        // validation for constraint: float
        if (!is_null($annualUsage) && !(is_float($annualUsage) || is_numeric($annualUsage))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($annualUsage, true), gettype($annualUsage)), __LINE__);
        }
        if (is_null($annualUsage) || (is_array($annualUsage) && empty($annualUsage))) {
            unset($this->AnnualUsage);
        } else {
            $this->AnnualUsage = $annualUsage;
        }
        return $this;
    }
    /**
     * Get AverageOnhandBalance value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getAverageOnhandBalance()
    {
        return isset($this->AverageOnhandBalance) ? $this->AverageOnhandBalance : null;
    }
    /**
     * Set AverageOnhandBalance value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $averageOnhandBalance
     * @return \StructType\UpdItmWhsItem
     */
    public function setAverageOnhandBalance($averageOnhandBalance = null)
    {
        // validation for constraint: float
        if (!is_null($averageOnhandBalance) && !(is_float($averageOnhandBalance) || is_numeric($averageOnhandBalance))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($averageOnhandBalance, true), gettype($averageOnhandBalance)), __LINE__);
        }
        if (is_null($averageOnhandBalance) || (is_array($averageOnhandBalance) && empty($averageOnhandBalance))) {
            unset($this->AverageOnhandBalance);
        } else {
            $this->AverageOnhandBalance = $averageOnhandBalance;
        }
        return $this;
    }
    /**
     * Get ProjectedOnhandAtEndOfLeadTime value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getProjectedOnhandAtEndOfLeadTime()
    {
        return isset($this->ProjectedOnhandAtEndOfLeadTime) ? $this->ProjectedOnhandAtEndOfLeadTime : null;
    }
    /**
     * Set ProjectedOnhandAtEndOfLeadTime value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $projectedOnhandAtEndOfLeadTime
     * @return \StructType\UpdItmWhsItem
     */
    public function setProjectedOnhandAtEndOfLeadTime($projectedOnhandAtEndOfLeadTime = null)
    {
        // validation for constraint: float
        if (!is_null($projectedOnhandAtEndOfLeadTime) && !(is_float($projectedOnhandAtEndOfLeadTime) || is_numeric($projectedOnhandAtEndOfLeadTime))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($projectedOnhandAtEndOfLeadTime, true), gettype($projectedOnhandAtEndOfLeadTime)), __LINE__);
        }
        if (is_null($projectedOnhandAtEndOfLeadTime) || (is_array($projectedOnhandAtEndOfLeadTime) && empty($projectedOnhandAtEndOfLeadTime))) {
            unset($this->ProjectedOnhandAtEndOfLeadTime);
        } else {
            $this->ProjectedOnhandAtEndOfLeadTime = $projectedOnhandAtEndOfLeadTime;
        }
        return $this;
    }
    /**
     * Get Responsible value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getResponsible()
    {
        return isset($this->Responsible) ? $this->Responsible : null;
    }
    /**
     * Set Responsible value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $responsible
     * @return \StructType\UpdItmWhsItem
     */
    public function setResponsible($responsible = null)
    {
        // validation for constraint: string
        if (!is_null($responsible) && !is_string($responsible)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($responsible, true), gettype($responsible)), __LINE__);
        }
        // validation for constraint: maxLength(10)
        if (!is_null($responsible) && mb_strlen($responsible) > 10) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 10', mb_strlen($responsible)), __LINE__);
        }
        if (is_null($responsible) || (is_array($responsible) && empty($responsible))) {
            unset($this->Responsible);
        } else {
            $this->Responsible = $responsible;
        }
        return $this;
    }
    /**
     * Get Buyer value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBuyer()
    {
        return isset($this->Buyer) ? $this->Buyer : null;
    }
    /**
     * Set Buyer value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $buyer
     * @return \StructType\UpdItmWhsItem
     */
    public function setBuyer($buyer = null)
    {
        // validation for constraint: string
        if (!is_null($buyer) && !is_string($buyer)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($buyer, true), gettype($buyer)), __LINE__);
        }
        // validation for constraint: maxLength(10)
        if (!is_null($buyer) && mb_strlen($buyer) > 10) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 10', mb_strlen($buyer)), __LINE__);
        }
        if (is_null($buyer) || (is_array($buyer) && empty($buyer))) {
            unset($this->Buyer);
        } else {
            $this->Buyer = $buyer;
        }
        return $this;
    }
    /**
     * Get SupplierNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSupplierNumber()
    {
        return isset($this->SupplierNumber) ? $this->SupplierNumber : null;
    }
    /**
     * Set SupplierNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $supplierNumber
     * @return \StructType\UpdItmWhsItem
     */
    public function setSupplierNumber($supplierNumber = null)
    {
        // validation for constraint: string
        if (!is_null($supplierNumber) && !is_string($supplierNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($supplierNumber, true), gettype($supplierNumber)), __LINE__);
        }
        // validation for constraint: maxLength(10)
        if (!is_null($supplierNumber) && mb_strlen($supplierNumber) > 10) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 10', mb_strlen($supplierNumber)), __LINE__);
        }
        if (is_null($supplierNumber) || (is_array($supplierNumber) && empty($supplierNumber))) {
            unset($this->SupplierNumber);
        } else {
            $this->SupplierNumber = $supplierNumber;
        }
        return $this;
    }
    /**
     * Get WarehouseType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getWarehouseType()
    {
        return isset($this->WarehouseType) ? $this->WarehouseType : null;
    }
    /**
     * Set WarehouseType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $warehouseType
     * @return \StructType\UpdItmWhsItem
     */
    public function setWarehouseType($warehouseType = null)
    {
        // validation for constraint: string
        if (!is_null($warehouseType) && !is_string($warehouseType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($warehouseType, true), gettype($warehouseType)), __LINE__);
        }
        // validation for constraint: maxLength(2)
        if (!is_null($warehouseType) && mb_strlen($warehouseType) > 2) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 2', mb_strlen($warehouseType)), __LINE__);
        }
        if (is_null($warehouseType) || (is_array($warehouseType) && empty($warehouseType))) {
            unset($this->WarehouseType);
        } else {
            $this->WarehouseType = $warehouseType;
        }
        return $this;
    }
    /**
     * Get WarehouseSubtype value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getWarehouseSubtype()
    {
        return isset($this->WarehouseSubtype) ? $this->WarehouseSubtype : null;
    }
    /**
     * Set WarehouseSubtype value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $warehouseSubtype
     * @return \StructType\UpdItmWhsItem
     */
    public function setWarehouseSubtype($warehouseSubtype = null)
    {
        // validation for constraint: string
        if (!is_null($warehouseSubtype) && !is_string($warehouseSubtype)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($warehouseSubtype, true), gettype($warehouseSubtype)), __LINE__);
        }
        // validation for constraint: maxLength(1)
        if (!is_null($warehouseSubtype) && mb_strlen($warehouseSubtype) > 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 1', mb_strlen($warehouseSubtype)), __LINE__);
        }
        if (is_null($warehouseSubtype) || (is_array($warehouseSubtype) && empty($warehouseSubtype))) {
            unset($this->WarehouseSubtype);
        } else {
            $this->WarehouseSubtype = $warehouseSubtype;
        }
        return $this;
    }
    /**
     * Get StatisticsStorageGroup value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getStatisticsStorageGroup()
    {
        return isset($this->StatisticsStorageGroup) ? $this->StatisticsStorageGroup : null;
    }
    /**
     * Set StatisticsStorageGroup value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $statisticsStorageGroup
     * @return \StructType\UpdItmWhsItem
     */
    public function setStatisticsStorageGroup($statisticsStorageGroup = null)
    {
        // validation for constraint: float
        if (!is_null($statisticsStorageGroup) && !(is_float($statisticsStorageGroup) || is_numeric($statisticsStorageGroup))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($statisticsStorageGroup, true), gettype($statisticsStorageGroup)), __LINE__);
        }
        if (is_null($statisticsStorageGroup) || (is_array($statisticsStorageGroup) && empty($statisticsStorageGroup))) {
            unset($this->StatisticsStorageGroup);
        } else {
            $this->StatisticsStorageGroup = $statisticsStorageGroup;
        }
        return $this;
    }
    /**
     * Get DistributionGroup value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDistributionGroup()
    {
        return isset($this->DistributionGroup) ? $this->DistributionGroup : null;
    }
    /**
     * Set DistributionGroup value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $distributionGroup
     * @return \StructType\UpdItmWhsItem
     */
    public function setDistributionGroup($distributionGroup = null)
    {
        // validation for constraint: string
        if (!is_null($distributionGroup) && !is_string($distributionGroup)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($distributionGroup, true), gettype($distributionGroup)), __LINE__);
        }
        // validation for constraint: maxLength(2)
        if (!is_null($distributionGroup) && mb_strlen($distributionGroup) > 2) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 2', mb_strlen($distributionGroup)), __LINE__);
        }
        if (is_null($distributionGroup) || (is_array($distributionGroup) && empty($distributionGroup))) {
            unset($this->DistributionGroup);
        } else {
            $this->DistributionGroup = $distributionGroup;
        }
        return $this;
    }
    /**
     * Get Location value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLocation()
    {
        return isset($this->Location) ? $this->Location : null;
    }
    /**
     * Set Location value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $location
     * @return \StructType\UpdItmWhsItem
     */
    public function setLocation($location = null)
    {
        // validation for constraint: string
        if (!is_null($location) && !is_string($location)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($location, true), gettype($location)), __LINE__);
        }
        // validation for constraint: maxLength(10)
        if (!is_null($location) && mb_strlen($location) > 10) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 10', mb_strlen($location)), __LINE__);
        }
        if (is_null($location) || (is_array($location) && empty($location))) {
            unset($this->Location);
        } else {
            $this->Location = $location;
        }
        return $this;
    }
    /**
     * Get StockZone value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getStockZone()
    {
        return isset($this->StockZone) ? $this->StockZone : null;
    }
    /**
     * Set StockZone value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $stockZone
     * @return \StructType\UpdItmWhsItem
     */
    public function setStockZone($stockZone = null)
    {
        // validation for constraint: string
        if (!is_null($stockZone) && !is_string($stockZone)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($stockZone, true), gettype($stockZone)), __LINE__);
        }
        // validation for constraint: maxLength(2)
        if (!is_null($stockZone) && mb_strlen($stockZone) > 2) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 2', mb_strlen($stockZone)), __LINE__);
        }
        if (is_null($stockZone) || (is_array($stockZone) && empty($stockZone))) {
            unset($this->StockZone);
        } else {
            $this->StockZone = $stockZone;
        }
        return $this;
    }
    /**
     * Get NumberOfBalanceIDs value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getNumberOfBalanceIDs()
    {
        return isset($this->NumberOfBalanceIDs) ? $this->NumberOfBalanceIDs : null;
    }
    /**
     * Set NumberOfBalanceIDs value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $numberOfBalanceIDs
     * @return \StructType\UpdItmWhsItem
     */
    public function setNumberOfBalanceIDs($numberOfBalanceIDs = null)
    {
        // validation for constraint: float
        if (!is_null($numberOfBalanceIDs) && !(is_float($numberOfBalanceIDs) || is_numeric($numberOfBalanceIDs))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($numberOfBalanceIDs, true), gettype($numberOfBalanceIDs)), __LINE__);
        }
        if (is_null($numberOfBalanceIDs) || (is_array($numberOfBalanceIDs) && empty($numberOfBalanceIDs))) {
            unset($this->NumberOfBalanceIDs);
        } else {
            $this->NumberOfBalanceIDs = $numberOfBalanceIDs;
        }
        return $this;
    }
    /**
     * Get IssueMultiple value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getIssueMultiple()
    {
        return isset($this->IssueMultiple) ? $this->IssueMultiple : null;
    }
    /**
     * Set IssueMultiple value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $issueMultiple
     * @return \StructType\UpdItmWhsItem
     */
    public function setIssueMultiple($issueMultiple = null)
    {
        // validation for constraint: float
        if (!is_null($issueMultiple) && !(is_float($issueMultiple) || is_numeric($issueMultiple))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($issueMultiple, true), gettype($issueMultiple)), __LINE__);
        }
        if (is_null($issueMultiple) || (is_array($issueMultiple) && empty($issueMultiple))) {
            unset($this->IssueMultiple);
        } else {
            $this->IssueMultiple = $issueMultiple;
        }
        return $this;
    }
    /**
     * Get LocationType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLocationType()
    {
        return isset($this->LocationType) ? $this->LocationType : null;
    }
    /**
     * Set LocationType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $locationType
     * @return \StructType\UpdItmWhsItem
     */
    public function setLocationType($locationType = null)
    {
        // validation for constraint: string
        if (!is_null($locationType) && !is_string($locationType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($locationType, true), gettype($locationType)), __LINE__);
        }
        // validation for constraint: maxLength(2)
        if (!is_null($locationType) && mb_strlen($locationType) > 2) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 2', mb_strlen($locationType)), __LINE__);
        }
        if (is_null($locationType) || (is_array($locationType) && empty($locationType))) {
            unset($this->LocationType);
        } else {
            $this->LocationType = $locationType;
        }
        return $this;
    }
    /**
     * Get WarehouseEquipment value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getWarehouseEquipment()
    {
        return isset($this->WarehouseEquipment) ? $this->WarehouseEquipment : null;
    }
    /**
     * Set WarehouseEquipment value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $warehouseEquipment
     * @return \StructType\UpdItmWhsItem
     */
    public function setWarehouseEquipment($warehouseEquipment = null)
    {
        // validation for constraint: string
        if (!is_null($warehouseEquipment) && !is_string($warehouseEquipment)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($warehouseEquipment, true), gettype($warehouseEquipment)), __LINE__);
        }
        // validation for constraint: maxLength(2)
        if (!is_null($warehouseEquipment) && mb_strlen($warehouseEquipment) > 2) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 2', mb_strlen($warehouseEquipment)), __LINE__);
        }
        if (is_null($warehouseEquipment) || (is_array($warehouseEquipment) && empty($warehouseEquipment))) {
            unset($this->WarehouseEquipment);
        } else {
            $this->WarehouseEquipment = $warehouseEquipment;
        }
        return $this;
    }
    /**
     * Get PlanningPolicy value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPlanningPolicy()
    {
        return isset($this->PlanningPolicy) ? $this->PlanningPolicy : null;
    }
    /**
     * Set PlanningPolicy value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $planningPolicy
     * @return \StructType\UpdItmWhsItem
     */
    public function setPlanningPolicy($planningPolicy = null)
    {
        // validation for constraint: string
        if (!is_null($planningPolicy) && !is_string($planningPolicy)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($planningPolicy, true), gettype($planningPolicy)), __LINE__);
        }
        // validation for constraint: maxLength(2)
        if (!is_null($planningPolicy) && mb_strlen($planningPolicy) > 2) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 2', mb_strlen($planningPolicy)), __LINE__);
        }
        if (is_null($planningPolicy) || (is_array($planningPolicy) && empty($planningPolicy))) {
            unset($this->PlanningPolicy);
        } else {
            $this->PlanningPolicy = $planningPolicy;
        }
        return $this;
    }
    /**
     * Get ABCClassManual value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getABCClassManual()
    {
        return isset($this->ABCClassManual) ? $this->ABCClassManual : null;
    }
    /**
     * Set ABCClassManual value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $aBCClassManual
     * @return \StructType\UpdItmWhsItem
     */
    public function setABCClassManual($aBCClassManual = null)
    {
        // validation for constraint: string
        if (!is_null($aBCClassManual) && !is_string($aBCClassManual)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($aBCClassManual, true), gettype($aBCClassManual)), __LINE__);
        }
        // validation for constraint: maxLength(1)
        if (!is_null($aBCClassManual) && mb_strlen($aBCClassManual) > 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 1', mb_strlen($aBCClassManual)), __LINE__);
        }
        if (is_null($aBCClassManual) || (is_array($aBCClassManual) && empty($aBCClassManual))) {
            unset($this->ABCClassManual);
        } else {
            $this->ABCClassManual = $aBCClassManual;
        }
        return $this;
    }
    /**
     * Get ABCClassVolume value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getABCClassVolume()
    {
        return isset($this->ABCClassVolume) ? $this->ABCClassVolume : null;
    }
    /**
     * Set ABCClassVolume value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $aBCClassVolume
     * @return \StructType\UpdItmWhsItem
     */
    public function setABCClassVolume($aBCClassVolume = null)
    {
        // validation for constraint: string
        if (!is_null($aBCClassVolume) && !is_string($aBCClassVolume)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($aBCClassVolume, true), gettype($aBCClassVolume)), __LINE__);
        }
        // validation for constraint: maxLength(1)
        if (!is_null($aBCClassVolume) && mb_strlen($aBCClassVolume) > 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 1', mb_strlen($aBCClassVolume)), __LINE__);
        }
        if (is_null($aBCClassVolume) || (is_array($aBCClassVolume) && empty($aBCClassVolume))) {
            unset($this->ABCClassVolume);
        } else {
            $this->ABCClassVolume = $aBCClassVolume;
        }
        return $this;
    }
    /**
     * Get ABCMethodVolume value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getABCMethodVolume()
    {
        return isset($this->ABCMethodVolume) ? $this->ABCMethodVolume : null;
    }
    /**
     * Set ABCMethodVolume value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $aBCMethodVolume
     * @return \StructType\UpdItmWhsItem
     */
    public function setABCMethodVolume($aBCMethodVolume = null)
    {
        // validation for constraint: float
        if (!is_null($aBCMethodVolume) && !(is_float($aBCMethodVolume) || is_numeric($aBCMethodVolume))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($aBCMethodVolume, true), gettype($aBCMethodVolume)), __LINE__);
        }
        if (is_null($aBCMethodVolume) || (is_array($aBCMethodVolume) && empty($aBCMethodVolume))) {
            unset($this->ABCMethodVolume);
        } else {
            $this->ABCMethodVolume = $aBCMethodVolume;
        }
        return $this;
    }
    /**
     * Get ABCClassFrequency value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getABCClassFrequency()
    {
        return isset($this->ABCClassFrequency) ? $this->ABCClassFrequency : null;
    }
    /**
     * Set ABCClassFrequency value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $aBCClassFrequency
     * @return \StructType\UpdItmWhsItem
     */
    public function setABCClassFrequency($aBCClassFrequency = null)
    {
        // validation for constraint: string
        if (!is_null($aBCClassFrequency) && !is_string($aBCClassFrequency)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($aBCClassFrequency, true), gettype($aBCClassFrequency)), __LINE__);
        }
        // validation for constraint: maxLength(1)
        if (!is_null($aBCClassFrequency) && mb_strlen($aBCClassFrequency) > 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 1', mb_strlen($aBCClassFrequency)), __LINE__);
        }
        if (is_null($aBCClassFrequency) || (is_array($aBCClassFrequency) && empty($aBCClassFrequency))) {
            unset($this->ABCClassFrequency);
        } else {
            $this->ABCClassFrequency = $aBCClassFrequency;
        }
        return $this;
    }
    /**
     * Get ABCMethodFrequency value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getABCMethodFrequency()
    {
        return isset($this->ABCMethodFrequency) ? $this->ABCMethodFrequency : null;
    }
    /**
     * Set ABCMethodFrequency value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $aBCMethodFrequency
     * @return \StructType\UpdItmWhsItem
     */
    public function setABCMethodFrequency($aBCMethodFrequency = null)
    {
        // validation for constraint: float
        if (!is_null($aBCMethodFrequency) && !(is_float($aBCMethodFrequency) || is_numeric($aBCMethodFrequency))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($aBCMethodFrequency, true), gettype($aBCMethodFrequency)), __LINE__);
        }
        if (is_null($aBCMethodFrequency) || (is_array($aBCMethodFrequency) && empty($aBCMethodFrequency))) {
            unset($this->ABCMethodFrequency);
        } else {
            $this->ABCMethodFrequency = $aBCMethodFrequency;
        }
        return $this;
    }
    /**
     * Get ABCClassContribution value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getABCClassContribution()
    {
        return isset($this->ABCClassContribution) ? $this->ABCClassContribution : null;
    }
    /**
     * Set ABCClassContribution value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $aBCClassContribution
     * @return \StructType\UpdItmWhsItem
     */
    public function setABCClassContribution($aBCClassContribution = null)
    {
        // validation for constraint: string
        if (!is_null($aBCClassContribution) && !is_string($aBCClassContribution)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($aBCClassContribution, true), gettype($aBCClassContribution)), __LINE__);
        }
        // validation for constraint: maxLength(1)
        if (!is_null($aBCClassContribution) && mb_strlen($aBCClassContribution) > 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 1', mb_strlen($aBCClassContribution)), __LINE__);
        }
        if (is_null($aBCClassContribution) || (is_array($aBCClassContribution) && empty($aBCClassContribution))) {
            unset($this->ABCClassContribution);
        } else {
            $this->ABCClassContribution = $aBCClassContribution;
        }
        return $this;
    }
    /**
     * Get ABCMethodContribution value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getABCMethodContribution()
    {
        return isset($this->ABCMethodContribution) ? $this->ABCMethodContribution : null;
    }
    /**
     * Set ABCMethodContribution value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $aBCMethodContribution
     * @return \StructType\UpdItmWhsItem
     */
    public function setABCMethodContribution($aBCMethodContribution = null)
    {
        // validation for constraint: float
        if (!is_null($aBCMethodContribution) && !(is_float($aBCMethodContribution) || is_numeric($aBCMethodContribution))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($aBCMethodContribution, true), gettype($aBCMethodContribution)), __LINE__);
        }
        if (is_null($aBCMethodContribution) || (is_array($aBCMethodContribution) && empty($aBCMethodContribution))) {
            unset($this->ABCMethodContribution);
        } else {
            $this->ABCMethodContribution = $aBCMethodContribution;
        }
        return $this;
    }
    /**
     * Get PriorityValue value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getPriorityValue()
    {
        return isset($this->PriorityValue) ? $this->PriorityValue : null;
    }
    /**
     * Set PriorityValue value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $priorityValue
     * @return \StructType\UpdItmWhsItem
     */
    public function setPriorityValue($priorityValue = null)
    {
        // validation for constraint: float
        if (!is_null($priorityValue) && !(is_float($priorityValue) || is_numeric($priorityValue))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($priorityValue, true), gettype($priorityValue)), __LINE__);
        }
        if (is_null($priorityValue) || (is_array($priorityValue) && empty($priorityValue))) {
            unset($this->PriorityValue);
        } else {
            $this->PriorityValue = $priorityValue;
        }
        return $this;
    }
    /**
     * Get RunoutTime value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getRunoutTime()
    {
        return isset($this->RunoutTime) ? $this->RunoutTime : null;
    }
    /**
     * Set RunoutTime value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $runoutTime
     * @return \StructType\UpdItmWhsItem
     */
    public function setRunoutTime($runoutTime = null)
    {
        // validation for constraint: float
        if (!is_null($runoutTime) && !(is_float($runoutTime) || is_numeric($runoutTime))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($runoutTime, true), gettype($runoutTime)), __LINE__);
        }
        if (is_null($runoutTime) || (is_array($runoutTime) && empty($runoutTime))) {
            unset($this->RunoutTime);
        } else {
            $this->RunoutTime = $runoutTime;
        }
        return $this;
    }
    /**
     * Get ReorderPoint value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getReorderPoint()
    {
        return isset($this->ReorderPoint) ? $this->ReorderPoint : null;
    }
    /**
     * Set ReorderPoint value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $reorderPoint
     * @return \StructType\UpdItmWhsItem
     */
    public function setReorderPoint($reorderPoint = null)
    {
        // validation for constraint: float
        if (!is_null($reorderPoint) && !(is_float($reorderPoint) || is_numeric($reorderPoint))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($reorderPoint, true), gettype($reorderPoint)), __LINE__);
        }
        if (is_null($reorderPoint) || (is_array($reorderPoint) && empty($reorderPoint))) {
            unset($this->ReorderPoint);
        } else {
            $this->ReorderPoint = $reorderPoint;
        }
        return $this;
    }
    /**
     * Get ReorderPointMethod value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getReorderPointMethod()
    {
        return isset($this->ReorderPointMethod) ? $this->ReorderPointMethod : null;
    }
    /**
     * Set ReorderPointMethod value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $reorderPointMethod
     * @return \StructType\UpdItmWhsItem
     */
    public function setReorderPointMethod($reorderPointMethod = null)
    {
        // validation for constraint: float
        if (!is_null($reorderPointMethod) && !(is_float($reorderPointMethod) || is_numeric($reorderPointMethod))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($reorderPointMethod, true), gettype($reorderPointMethod)), __LINE__);
        }
        if (is_null($reorderPointMethod) || (is_array($reorderPointMethod) && empty($reorderPointMethod))) {
            unset($this->ReorderPointMethod);
        } else {
            $this->ReorderPointMethod = $reorderPointMethod;
        }
        return $this;
    }
    /**
     * Get SafetyStock value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getSafetyStock()
    {
        return isset($this->SafetyStock) ? $this->SafetyStock : null;
    }
    /**
     * Set SafetyStock value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $safetyStock
     * @return \StructType\UpdItmWhsItem
     */
    public function setSafetyStock($safetyStock = null)
    {
        // validation for constraint: float
        if (!is_null($safetyStock) && !(is_float($safetyStock) || is_numeric($safetyStock))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($safetyStock, true), gettype($safetyStock)), __LINE__);
        }
        if (is_null($safetyStock) || (is_array($safetyStock) && empty($safetyStock))) {
            unset($this->SafetyStock);
        } else {
            $this->SafetyStock = $safetyStock;
        }
        return $this;
    }
    /**
     * Get SafetyStockMethod value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getSafetyStockMethod()
    {
        return isset($this->SafetyStockMethod) ? $this->SafetyStockMethod : null;
    }
    /**
     * Set SafetyStockMethod value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $safetyStockMethod
     * @return \StructType\UpdItmWhsItem
     */
    public function setSafetyStockMethod($safetyStockMethod = null)
    {
        // validation for constraint: float
        if (!is_null($safetyStockMethod) && !(is_float($safetyStockMethod) || is_numeric($safetyStockMethod))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($safetyStockMethod, true), gettype($safetyStockMethod)), __LINE__);
        }
        if (is_null($safetyStockMethod) || (is_array($safetyStockMethod) && empty($safetyStockMethod))) {
            unset($this->SafetyStockMethod);
        } else {
            $this->SafetyStockMethod = $safetyStockMethod;
        }
        return $this;
    }
    /**
     * Get ManualSafetyStock value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getManualSafetyStock()
    {
        return isset($this->ManualSafetyStock) ? $this->ManualSafetyStock : null;
    }
    /**
     * Set ManualSafetyStock value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $manualSafetyStock
     * @return \StructType\UpdItmWhsItem
     */
    public function setManualSafetyStock($manualSafetyStock = null)
    {
        // validation for constraint: float
        if (!is_null($manualSafetyStock) && !(is_float($manualSafetyStock) || is_numeric($manualSafetyStock))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($manualSafetyStock, true), gettype($manualSafetyStock)), __LINE__);
        }
        if (is_null($manualSafetyStock) || (is_array($manualSafetyStock) && empty($manualSafetyStock))) {
            unset($this->ManualSafetyStock);
        } else {
            $this->ManualSafetyStock = $manualSafetyStock;
        }
        return $this;
    }
    /**
     * Get SafetyStockUnit value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getSafetyStockUnit()
    {
        return isset($this->SafetyStockUnit) ? $this->SafetyStockUnit : null;
    }
    /**
     * Set SafetyStockUnit value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $safetyStockUnit
     * @return \StructType\UpdItmWhsItem
     */
    public function setSafetyStockUnit($safetyStockUnit = null)
    {
        // validation for constraint: float
        if (!is_null($safetyStockUnit) && !(is_float($safetyStockUnit) || is_numeric($safetyStockUnit))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($safetyStockUnit, true), gettype($safetyStockUnit)), __LINE__);
        }
        if (is_null($safetyStockUnit) || (is_array($safetyStockUnit) && empty($safetyStockUnit))) {
            unset($this->SafetyStockUnit);
        } else {
            $this->SafetyStockUnit = $safetyStockUnit;
        }
        return $this;
    }
    /**
     * Get ServiceLevel value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getServiceLevel()
    {
        return isset($this->ServiceLevel) ? $this->ServiceLevel : null;
    }
    /**
     * Set ServiceLevel value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $serviceLevel
     * @return \StructType\UpdItmWhsItem
     */
    public function setServiceLevel($serviceLevel = null)
    {
        // validation for constraint: float
        if (!is_null($serviceLevel) && !(is_float($serviceLevel) || is_numeric($serviceLevel))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($serviceLevel, true), gettype($serviceLevel)), __LINE__);
        }
        if (is_null($serviceLevel) || (is_array($serviceLevel) && empty($serviceLevel))) {
            unset($this->ServiceLevel);
        } else {
            $this->ServiceLevel = $serviceLevel;
        }
        return $this;
    }
    /**
     * Get MaximumStock value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getMaximumStock()
    {
        return isset($this->MaximumStock) ? $this->MaximumStock : null;
    }
    /**
     * Set MaximumStock value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $maximumStock
     * @return \StructType\UpdItmWhsItem
     */
    public function setMaximumStock($maximumStock = null)
    {
        // validation for constraint: float
        if (!is_null($maximumStock) && !(is_float($maximumStock) || is_numeric($maximumStock))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($maximumStock, true), gettype($maximumStock)), __LINE__);
        }
        if (is_null($maximumStock) || (is_array($maximumStock) && empty($maximumStock))) {
            unset($this->MaximumStock);
        } else {
            $this->MaximumStock = $maximumStock;
        }
        return $this;
    }
    /**
     * Get MaximumStockMethod value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getMaximumStockMethod()
    {
        return isset($this->MaximumStockMethod) ? $this->MaximumStockMethod : null;
    }
    /**
     * Set MaximumStockMethod value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $maximumStockMethod
     * @return \StructType\UpdItmWhsItem
     */
    public function setMaximumStockMethod($maximumStockMethod = null)
    {
        // validation for constraint: float
        if (!is_null($maximumStockMethod) && !(is_float($maximumStockMethod) || is_numeric($maximumStockMethod))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($maximumStockMethod, true), gettype($maximumStockMethod)), __LINE__);
        }
        if (is_null($maximumStockMethod) || (is_array($maximumStockMethod) && empty($maximumStockMethod))) {
            unset($this->MaximumStockMethod);
        } else {
            $this->MaximumStockMethod = $maximumStockMethod;
        }
        return $this;
    }
    /**
     * Get MaximumStockPercentage value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getMaximumStockPercentage()
    {
        return isset($this->MaximumStockPercentage) ? $this->MaximumStockPercentage : null;
    }
    /**
     * Set MaximumStockPercentage value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $maximumStockPercentage
     * @return \StructType\UpdItmWhsItem
     */
    public function setMaximumStockPercentage($maximumStockPercentage = null)
    {
        // validation for constraint: float
        if (!is_null($maximumStockPercentage) && !(is_float($maximumStockPercentage) || is_numeric($maximumStockPercentage))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($maximumStockPercentage, true), gettype($maximumStockPercentage)), __LINE__);
        }
        if (is_null($maximumStockPercentage) || (is_array($maximumStockPercentage) && empty($maximumStockPercentage))) {
            unset($this->MaximumStockPercentage);
        } else {
            $this->MaximumStockPercentage = $maximumStockPercentage;
        }
        return $this;
    }
    /**
     * Get OrderQuantity value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getOrderQuantity()
    {
        return isset($this->OrderQuantity) ? $this->OrderQuantity : null;
    }
    /**
     * Set OrderQuantity value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $orderQuantity
     * @return \StructType\UpdItmWhsItem
     */
    public function setOrderQuantity($orderQuantity = null)
    {
        // validation for constraint: float
        if (!is_null($orderQuantity) && !(is_float($orderQuantity) || is_numeric($orderQuantity))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($orderQuantity, true), gettype($orderQuantity)), __LINE__);
        }
        if (is_null($orderQuantity) || (is_array($orderQuantity) && empty($orderQuantity))) {
            unset($this->OrderQuantity);
        } else {
            $this->OrderQuantity = $orderQuantity;
        }
        return $this;
    }
    /**
     * Get OrderPolicy value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getOrderPolicy()
    {
        return isset($this->OrderPolicy) ? $this->OrderPolicy : null;
    }
    /**
     * Set OrderPolicy value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $orderPolicy
     * @return \StructType\UpdItmWhsItem
     */
    public function setOrderPolicy($orderPolicy = null)
    {
        // validation for constraint: float
        if (!is_null($orderPolicy) && !(is_float($orderPolicy) || is_numeric($orderPolicy))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($orderPolicy, true), gettype($orderPolicy)), __LINE__);
        }
        if (is_null($orderPolicy) || (is_array($orderPolicy) && empty($orderPolicy))) {
            unset($this->OrderPolicy);
        } else {
            $this->OrderPolicy = $orderPolicy;
        }
        return $this;
    }
    /**
     * Get EconomicalOrderQuantityDays value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getEconomicalOrderQuantityDays()
    {
        return isset($this->EconomicalOrderQuantityDays) ? $this->EconomicalOrderQuantityDays : null;
    }
    /**
     * Set EconomicalOrderQuantityDays value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $economicalOrderQuantityDays
     * @return \StructType\UpdItmWhsItem
     */
    public function setEconomicalOrderQuantityDays($economicalOrderQuantityDays = null)
    {
        // validation for constraint: float
        if (!is_null($economicalOrderQuantityDays) && !(is_float($economicalOrderQuantityDays) || is_numeric($economicalOrderQuantityDays))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($economicalOrderQuantityDays, true), gettype($economicalOrderQuantityDays)), __LINE__);
        }
        if (is_null($economicalOrderQuantityDays) || (is_array($economicalOrderQuantityDays) && empty($economicalOrderQuantityDays))) {
            unset($this->EconomicalOrderQuantityDays);
        } else {
            $this->EconomicalOrderQuantityDays = $economicalOrderQuantityDays;
        }
        return $this;
    }
    /**
     * Get AnnualDemand value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getAnnualDemand()
    {
        return isset($this->AnnualDemand) ? $this->AnnualDemand : null;
    }
    /**
     * Set AnnualDemand value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $annualDemand
     * @return \StructType\UpdItmWhsItem
     */
    public function setAnnualDemand($annualDemand = null)
    {
        // validation for constraint: float
        if (!is_null($annualDemand) && !(is_float($annualDemand) || is_numeric($annualDemand))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($annualDemand, true), gettype($annualDemand)), __LINE__);
        }
        if (is_null($annualDemand) || (is_array($annualDemand) && empty($annualDemand))) {
            unset($this->AnnualDemand);
        } else {
            $this->AnnualDemand = $annualDemand;
        }
        return $this;
    }
    /**
     * Get AnnualDemandMethod value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getAnnualDemandMethod()
    {
        return isset($this->AnnualDemandMethod) ? $this->AnnualDemandMethod : null;
    }
    /**
     * Set AnnualDemandMethod value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $annualDemandMethod
     * @return \StructType\UpdItmWhsItem
     */
    public function setAnnualDemandMethod($annualDemandMethod = null)
    {
        // validation for constraint: float
        if (!is_null($annualDemandMethod) && !(is_float($annualDemandMethod) || is_numeric($annualDemandMethod))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($annualDemandMethod, true), gettype($annualDemandMethod)), __LINE__);
        }
        if (is_null($annualDemandMethod) || (is_array($annualDemandMethod) && empty($annualDemandMethod))) {
            unset($this->AnnualDemandMethod);
        } else {
            $this->AnnualDemandMethod = $annualDemandMethod;
        }
        return $this;
    }
    /**
     * Get MinimumOrderQuantity value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getMinimumOrderQuantity()
    {
        return isset($this->MinimumOrderQuantity) ? $this->MinimumOrderQuantity : null;
    }
    /**
     * Set MinimumOrderQuantity value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $minimumOrderQuantity
     * @return \StructType\UpdItmWhsItem
     */
    public function setMinimumOrderQuantity($minimumOrderQuantity = null)
    {
        // validation for constraint: float
        if (!is_null($minimumOrderQuantity) && !(is_float($minimumOrderQuantity) || is_numeric($minimumOrderQuantity))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($minimumOrderQuantity, true), gettype($minimumOrderQuantity)), __LINE__);
        }
        if (is_null($minimumOrderQuantity) || (is_array($minimumOrderQuantity) && empty($minimumOrderQuantity))) {
            unset($this->MinimumOrderQuantity);
        } else {
            $this->MinimumOrderQuantity = $minimumOrderQuantity;
        }
        return $this;
    }
    /**
     * Get MaximumOrderQuantity value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getMaximumOrderQuantity()
    {
        return isset($this->MaximumOrderQuantity) ? $this->MaximumOrderQuantity : null;
    }
    /**
     * Set MaximumOrderQuantity value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $maximumOrderQuantity
     * @return \StructType\UpdItmWhsItem
     */
    public function setMaximumOrderQuantity($maximumOrderQuantity = null)
    {
        // validation for constraint: float
        if (!is_null($maximumOrderQuantity) && !(is_float($maximumOrderQuantity) || is_numeric($maximumOrderQuantity))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($maximumOrderQuantity, true), gettype($maximumOrderQuantity)), __LINE__);
        }
        if (is_null($maximumOrderQuantity) || (is_array($maximumOrderQuantity) && empty($maximumOrderQuantity))) {
            unset($this->MaximumOrderQuantity);
        } else {
            $this->MaximumOrderQuantity = $maximumOrderQuantity;
        }
        return $this;
    }
    /**
     * Get AcquisitionCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getAcquisitionCode()
    {
        return isset($this->AcquisitionCode) ? $this->AcquisitionCode : null;
    }
    /**
     * Set AcquisitionCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $acquisitionCode
     * @return \StructType\UpdItmWhsItem
     */
    public function setAcquisitionCode($acquisitionCode = null)
    {
        // validation for constraint: float
        if (!is_null($acquisitionCode) && !(is_float($acquisitionCode) || is_numeric($acquisitionCode))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($acquisitionCode, true), gettype($acquisitionCode)), __LINE__);
        }
        if (is_null($acquisitionCode) || (is_array($acquisitionCode) && empty($acquisitionCode))) {
            unset($this->AcquisitionCode);
        } else {
            $this->AcquisitionCode = $acquisitionCode;
        }
        return $this;
    }
    /**
     * Get SupplyingWarehouse value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSupplyingWarehouse()
    {
        return isset($this->SupplyingWarehouse) ? $this->SupplyingWarehouse : null;
    }
    /**
     * Set SupplyingWarehouse value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $supplyingWarehouse
     * @return \StructType\UpdItmWhsItem
     */
    public function setSupplyingWarehouse($supplyingWarehouse = null)
    {
        // validation for constraint: string
        if (!is_null($supplyingWarehouse) && !is_string($supplyingWarehouse)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($supplyingWarehouse, true), gettype($supplyingWarehouse)), __LINE__);
        }
        // validation for constraint: maxLength(3)
        if (!is_null($supplyingWarehouse) && mb_strlen($supplyingWarehouse) > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 3', mb_strlen($supplyingWarehouse)), __LINE__);
        }
        if (is_null($supplyingWarehouse) || (is_array($supplyingWarehouse) && empty($supplyingWarehouse))) {
            unset($this->SupplyingWarehouse);
        } else {
            $this->SupplyingWarehouse = $supplyingWarehouse;
        }
        return $this;
    }
    /**
     * Get PeriodFrame value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getPeriodFrame()
    {
        return isset($this->PeriodFrame) ? $this->PeriodFrame : null;
    }
    /**
     * Set PeriodFrame value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $periodFrame
     * @return \StructType\UpdItmWhsItem
     */
    public function setPeriodFrame($periodFrame = null)
    {
        // validation for constraint: float
        if (!is_null($periodFrame) && !(is_float($periodFrame) || is_numeric($periodFrame))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($periodFrame, true), gettype($periodFrame)), __LINE__);
        }
        if (is_null($periodFrame) || (is_array($periodFrame) && empty($periodFrame))) {
            unset($this->PeriodFrame);
        } else {
            $this->PeriodFrame = $periodFrame;
        }
        return $this;
    }
    /**
     * Get ForecastMethod value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getForecastMethod()
    {
        return isset($this->ForecastMethod) ? $this->ForecastMethod : null;
    }
    /**
     * Set ForecastMethod value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $forecastMethod
     * @return \StructType\UpdItmWhsItem
     */
    public function setForecastMethod($forecastMethod = null)
    {
        // validation for constraint: string
        if (!is_null($forecastMethod) && !is_string($forecastMethod)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($forecastMethod, true), gettype($forecastMethod)), __LINE__);
        }
        // validation for constraint: maxLength(2)
        if (!is_null($forecastMethod) && mb_strlen($forecastMethod) > 2) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 2', mb_strlen($forecastMethod)), __LINE__);
        }
        if (is_null($forecastMethod) || (is_array($forecastMethod) && empty($forecastMethod))) {
            unset($this->ForecastMethod);
        } else {
            $this->ForecastMethod = $forecastMethod;
        }
        return $this;
    }
    /**
     * Get ForecastLogic value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getForecastLogic()
    {
        return isset($this->ForecastLogic) ? $this->ForecastLogic : null;
    }
    /**
     * Set ForecastLogic value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $forecastLogic
     * @return \StructType\UpdItmWhsItem
     */
    public function setForecastLogic($forecastLogic = null)
    {
        // validation for constraint: string
        if (!is_null($forecastLogic) && !is_string($forecastLogic)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($forecastLogic, true), gettype($forecastLogic)), __LINE__);
        }
        // validation for constraint: maxLength(2)
        if (!is_null($forecastLogic) && mb_strlen($forecastLogic) > 2) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 2', mb_strlen($forecastLogic)), __LINE__);
        }
        if (is_null($forecastLogic) || (is_array($forecastLogic) && empty($forecastLogic))) {
            unset($this->ForecastLogic);
        } else {
            $this->ForecastLogic = $forecastLogic;
        }
        return $this;
    }
    /**
     * Get FixedAnnualDemand value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getFixedAnnualDemand()
    {
        return isset($this->FixedAnnualDemand) ? $this->FixedAnnualDemand : null;
    }
    /**
     * Set FixedAnnualDemand value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $fixedAnnualDemand
     * @return \StructType\UpdItmWhsItem
     */
    public function setFixedAnnualDemand($fixedAnnualDemand = null)
    {
        // validation for constraint: float
        if (!is_null($fixedAnnualDemand) && !(is_float($fixedAnnualDemand) || is_numeric($fixedAnnualDemand))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($fixedAnnualDemand, true), gettype($fixedAnnualDemand)), __LINE__);
        }
        if (is_null($fixedAnnualDemand) || (is_array($fixedAnnualDemand) && empty($fixedAnnualDemand))) {
            unset($this->FixedAnnualDemand);
        } else {
            $this->FixedAnnualDemand = $fixedAnnualDemand;
        }
        return $this;
    }
    /**
     * Get FixedAcquisitionRequirement value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getFixedAcquisitionRequirement()
    {
        return isset($this->FixedAcquisitionRequirement) ? $this->FixedAcquisitionRequirement : null;
    }
    /**
     * Set FixedAcquisitionRequirement value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $fixedAcquisitionRequirement
     * @return \StructType\UpdItmWhsItem
     */
    public function setFixedAcquisitionRequirement($fixedAcquisitionRequirement = null)
    {
        // validation for constraint: float
        if (!is_null($fixedAcquisitionRequirement) && !(is_float($fixedAcquisitionRequirement) || is_numeric($fixedAcquisitionRequirement))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($fixedAcquisitionRequirement, true), gettype($fixedAcquisitionRequirement)), __LINE__);
        }
        if (is_null($fixedAcquisitionRequirement) || (is_array($fixedAcquisitionRequirement) && empty($fixedAcquisitionRequirement))) {
            unset($this->FixedAcquisitionRequirement);
        } else {
            $this->FixedAcquisitionRequirement = $fixedAcquisitionRequirement;
        }
        return $this;
    }
    /**
     * Get PlanningTimeFence value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getPlanningTimeFence()
    {
        return isset($this->PlanningTimeFence) ? $this->PlanningTimeFence : null;
    }
    /**
     * Set PlanningTimeFence value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $planningTimeFence
     * @return \StructType\UpdItmWhsItem
     */
    public function setPlanningTimeFence($planningTimeFence = null)
    {
        // validation for constraint: float
        if (!is_null($planningTimeFence) && !(is_float($planningTimeFence) || is_numeric($planningTimeFence))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($planningTimeFence, true), gettype($planningTimeFence)), __LINE__);
        }
        if (is_null($planningTimeFence) || (is_array($planningTimeFence) && empty($planningTimeFence))) {
            unset($this->PlanningTimeFence);
        } else {
            $this->PlanningTimeFence = $planningTimeFence;
        }
        return $this;
    }
    /**
     * Get SupplyLeadTime value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getSupplyLeadTime()
    {
        return isset($this->SupplyLeadTime) ? $this->SupplyLeadTime : null;
    }
    /**
     * Set SupplyLeadTime value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $supplyLeadTime
     * @return \StructType\UpdItmWhsItem
     */
    public function setSupplyLeadTime($supplyLeadTime = null)
    {
        // validation for constraint: float
        if (!is_null($supplyLeadTime) && !(is_float($supplyLeadTime) || is_numeric($supplyLeadTime))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($supplyLeadTime, true), gettype($supplyLeadTime)), __LINE__);
        }
        if (is_null($supplyLeadTime) || (is_array($supplyLeadTime) && empty($supplyLeadTime))) {
            unset($this->SupplyLeadTime);
        } else {
            $this->SupplyLeadTime = $supplyLeadTime;
        }
        return $this;
    }
    /**
     * Get InspectionLeadTime value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getInspectionLeadTime()
    {
        return isset($this->InspectionLeadTime) ? $this->InspectionLeadTime : null;
    }
    /**
     * Set InspectionLeadTime value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $inspectionLeadTime
     * @return \StructType\UpdItmWhsItem
     */
    public function setInspectionLeadTime($inspectionLeadTime = null)
    {
        // validation for constraint: float
        if (!is_null($inspectionLeadTime) && !(is_float($inspectionLeadTime) || is_numeric($inspectionLeadTime))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($inspectionLeadTime, true), gettype($inspectionLeadTime)), __LINE__);
        }
        if (is_null($inspectionLeadTime) || (is_array($inspectionLeadTime) && empty($inspectionLeadTime))) {
            unset($this->InspectionLeadTime);
        } else {
            $this->InspectionLeadTime = $inspectionLeadTime;
        }
        return $this;
    }
    /**
     * Get TransportationLeadTime value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getTransportationLeadTime()
    {
        return isset($this->TransportationLeadTime) ? $this->TransportationLeadTime : null;
    }
    /**
     * Set TransportationLeadTime value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $transportationLeadTime
     * @return \StructType\UpdItmWhsItem
     */
    public function setTransportationLeadTime($transportationLeadTime = null)
    {
        // validation for constraint: float
        if (!is_null($transportationLeadTime) && !(is_float($transportationLeadTime) || is_numeric($transportationLeadTime))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($transportationLeadTime, true), gettype($transportationLeadTime)), __LINE__);
        }
        if (is_null($transportationLeadTime) || (is_array($transportationLeadTime) && empty($transportationLeadTime))) {
            unset($this->TransportationLeadTime);
        } else {
            $this->TransportationLeadTime = $transportationLeadTime;
        }
        return $this;
    }
    /**
     * Get LeadTime value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getLeadTime()
    {
        return isset($this->LeadTime) ? $this->LeadTime : null;
    }
    /**
     * Set LeadTime value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $leadTime
     * @return \StructType\UpdItmWhsItem
     */
    public function setLeadTime($leadTime = null)
    {
        // validation for constraint: float
        if (!is_null($leadTime) && !(is_float($leadTime) || is_numeric($leadTime))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($leadTime, true), gettype($leadTime)), __LINE__);
        }
        if (is_null($leadTime) || (is_array($leadTime) && empty($leadTime))) {
            unset($this->LeadTime);
        } else {
            $this->LeadTime = $leadTime;
        }
        return $this;
    }
    /**
     * Get OrderMultiple value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getOrderMultiple()
    {
        return isset($this->OrderMultiple) ? $this->OrderMultiple : null;
    }
    /**
     * Set OrderMultiple value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $orderMultiple
     * @return \StructType\UpdItmWhsItem
     */
    public function setOrderMultiple($orderMultiple = null)
    {
        // validation for constraint: float
        if (!is_null($orderMultiple) && !(is_float($orderMultiple) || is_numeric($orderMultiple))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($orderMultiple, true), gettype($orderMultiple)), __LINE__);
        }
        if (is_null($orderMultiple) || (is_array($orderMultiple) && empty($orderMultiple))) {
            unset($this->OrderMultiple);
        } else {
            $this->OrderMultiple = $orderMultiple;
        }
        return $this;
    }
    /**
     * Get MultipleSupply value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getMultipleSupply()
    {
        return isset($this->MultipleSupply) ? $this->MultipleSupply : null;
    }
    /**
     * Set MultipleSupply value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $multipleSupply
     * @return \StructType\UpdItmWhsItem
     */
    public function setMultipleSupply($multipleSupply = null)
    {
        // validation for constraint: float
        if (!is_null($multipleSupply) && !(is_float($multipleSupply) || is_numeric($multipleSupply))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($multipleSupply, true), gettype($multipleSupply)), __LINE__);
        }
        if (is_null($multipleSupply) || (is_array($multipleSupply) && empty($multipleSupply))) {
            unset($this->MultipleSupply);
        } else {
            $this->MultipleSupply = $multipleSupply;
        }
        return $this;
    }
    /**
     * Get LowestLevel value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getLowestLevel()
    {
        return isset($this->LowestLevel) ? $this->LowestLevel : null;
    }
    /**
     * Set LowestLevel value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $lowestLevel
     * @return \StructType\UpdItmWhsItem
     */
    public function setLowestLevel($lowestLevel = null)
    {
        // validation for constraint: float
        if (!is_null($lowestLevel) && !(is_float($lowestLevel) || is_numeric($lowestLevel))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($lowestLevel, true), gettype($lowestLevel)), __LINE__);
        }
        if (is_null($lowestLevel) || (is_array($lowestLevel) && empty($lowestLevel))) {
            unset($this->LowestLevel);
        } else {
            $this->LowestLevel = $lowestLevel;
        }
        return $this;
    }
    /**
     * Get LowestLevelDO value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getLowestLevelDO()
    {
        return isset($this->LowestLevelDO) ? $this->LowestLevelDO : null;
    }
    /**
     * Set LowestLevelDO value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $lowestLevelDO
     * @return \StructType\UpdItmWhsItem
     */
    public function setLowestLevelDO($lowestLevelDO = null)
    {
        // validation for constraint: float
        if (!is_null($lowestLevelDO) && !(is_float($lowestLevelDO) || is_numeric($lowestLevelDO))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($lowestLevelDO, true), gettype($lowestLevelDO)), __LINE__);
        }
        if (is_null($lowestLevelDO) || (is_array($lowestLevelDO) && empty($lowestLevelDO))) {
            unset($this->LowestLevelDO);
        } else {
            $this->LowestLevelDO = $lowestLevelDO;
        }
        return $this;
    }
    /**
     * Get PlanningHorizon value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getPlanningHorizon()
    {
        return isset($this->PlanningHorizon) ? $this->PlanningHorizon : null;
    }
    /**
     * Set PlanningHorizon value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $planningHorizon
     * @return \StructType\UpdItmWhsItem
     */
    public function setPlanningHorizon($planningHorizon = null)
    {
        // validation for constraint: float
        if (!is_null($planningHorizon) && !(is_float($planningHorizon) || is_numeric($planningHorizon))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($planningHorizon, true), gettype($planningHorizon)), __LINE__);
        }
        if (is_null($planningHorizon) || (is_array($planningHorizon) && empty($planningHorizon))) {
            unset($this->PlanningHorizon);
        } else {
            $this->PlanningHorizon = $planningHorizon;
        }
        return $this;
    }
    /**
     * Get DemandTimeFence value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getDemandTimeFence()
    {
        return isset($this->DemandTimeFence) ? $this->DemandTimeFence : null;
    }
    /**
     * Set DemandTimeFence value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $demandTimeFence
     * @return \StructType\UpdItmWhsItem
     */
    public function setDemandTimeFence($demandTimeFence = null)
    {
        // validation for constraint: float
        if (!is_null($demandTimeFence) && !(is_float($demandTimeFence) || is_numeric($demandTimeFence))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($demandTimeFence, true), gettype($demandTimeFence)), __LINE__);
        }
        if (is_null($demandTimeFence) || (is_array($demandTimeFence) && empty($demandTimeFence))) {
            unset($this->DemandTimeFence);
        } else {
            $this->DemandTimeFence = $demandTimeFence;
        }
        return $this;
    }
    /**
     * Get OrderType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOrderType()
    {
        return isset($this->OrderType) ? $this->OrderType : null;
    }
    /**
     * Set OrderType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $orderType
     * @return \StructType\UpdItmWhsItem
     */
    public function setOrderType($orderType = null)
    {
        // validation for constraint: string
        if (!is_null($orderType) && !is_string($orderType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($orderType, true), gettype($orderType)), __LINE__);
        }
        // validation for constraint: maxLength(3)
        if (!is_null($orderType) && mb_strlen($orderType) > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 3', mb_strlen($orderType)), __LINE__);
        }
        if (is_null($orderType) || (is_array($orderType) && empty($orderType))) {
            unset($this->OrderType);
        } else {
            $this->OrderType = $orderType;
        }
        return $this;
    }
    /**
     * Get ContinuousNetChange value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getContinuousNetChange()
    {
        return isset($this->ContinuousNetChange) ? $this->ContinuousNetChange : null;
    }
    /**
     * Set ContinuousNetChange value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $continuousNetChange
     * @return \StructType\UpdItmWhsItem
     */
    public function setContinuousNetChange($continuousNetChange = null)
    {
        // validation for constraint: float
        if (!is_null($continuousNetChange) && !(is_float($continuousNetChange) || is_numeric($continuousNetChange))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($continuousNetChange, true), gettype($continuousNetChange)), __LINE__);
        }
        if (is_null($continuousNetChange) || (is_array($continuousNetChange) && empty($continuousNetChange))) {
            unset($this->ContinuousNetChange);
        } else {
            $this->ContinuousNetChange = $continuousNetChange;
        }
        return $this;
    }
    /**
     * Get SafetyTime value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getSafetyTime()
    {
        return isset($this->SafetyTime) ? $this->SafetyTime : null;
    }
    /**
     * Set SafetyTime value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $safetyTime
     * @return \StructType\UpdItmWhsItem
     */
    public function setSafetyTime($safetyTime = null)
    {
        // validation for constraint: float
        if (!is_null($safetyTime) && !(is_float($safetyTime) || is_numeric($safetyTime))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($safetyTime, true), gettype($safetyTime)), __LINE__);
        }
        if (is_null($safetyTime) || (is_array($safetyTime) && empty($safetyTime))) {
            unset($this->SafetyTime);
        } else {
            $this->SafetyTime = $safetyTime;
        }
        return $this;
    }
    /**
     * Get QuantityControlledAllocation value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getQuantityControlledAllocation()
    {
        return isset($this->QuantityControlledAllocation) ? $this->QuantityControlledAllocation : null;
    }
    /**
     * Set QuantityControlledAllocation value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $quantityControlledAllocation
     * @return \StructType\UpdItmWhsItem
     */
    public function setQuantityControlledAllocation($quantityControlledAllocation = null)
    {
        // validation for constraint: float
        if (!is_null($quantityControlledAllocation) && !(is_float($quantityControlledAllocation) || is_numeric($quantityControlledAllocation))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($quantityControlledAllocation, true), gettype($quantityControlledAllocation)), __LINE__);
        }
        if (is_null($quantityControlledAllocation) || (is_array($quantityControlledAllocation) && empty($quantityControlledAllocation))) {
            unset($this->QuantityControlledAllocation);
        } else {
            $this->QuantityControlledAllocation = $quantityControlledAllocation;
        }
        return $this;
    }
    /**
     * Get PlanningMethod value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getPlanningMethod()
    {
        return isset($this->PlanningMethod) ? $this->PlanningMethod : null;
    }
    /**
     * Set PlanningMethod value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $planningMethod
     * @return \StructType\UpdItmWhsItem
     */
    public function setPlanningMethod($planningMethod = null)
    {
        // validation for constraint: float
        if (!is_null($planningMethod) && !(is_float($planningMethod) || is_numeric($planningMethod))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($planningMethod, true), gettype($planningMethod)), __LINE__);
        }
        if (is_null($planningMethod) || (is_array($planningMethod) && empty($planningMethod))) {
            unset($this->PlanningMethod);
        } else {
            $this->PlanningMethod = $planningMethod;
        }
        return $this;
    }
    /**
     * Get MasterScheduled value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getMasterScheduled()
    {
        return isset($this->MasterScheduled) ? $this->MasterScheduled : null;
    }
    /**
     * Set MasterScheduled value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $masterScheduled
     * @return \StructType\UpdItmWhsItem
     */
    public function setMasterScheduled($masterScheduled = null)
    {
        // validation for constraint: float
        if (!is_null($masterScheduled) && !(is_float($masterScheduled) || is_numeric($masterScheduled))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($masterScheduled, true), gettype($masterScheduled)), __LINE__);
        }
        if (is_null($masterScheduled) || (is_array($masterScheduled) && empty($masterScheduled))) {
            unset($this->MasterScheduled);
        } else {
            $this->MasterScheduled = $masterScheduled;
        }
        return $this;
    }
    /**
     * Get DistributionSupplierCalendarCheck value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getDistributionSupplierCalendarCheck()
    {
        return isset($this->DistributionSupplierCalendarCheck) ? $this->DistributionSupplierCalendarCheck : null;
    }
    /**
     * Set DistributionSupplierCalendarCheck value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $distributionSupplierCalendarCheck
     * @return \StructType\UpdItmWhsItem
     */
    public function setDistributionSupplierCalendarCheck($distributionSupplierCalendarCheck = null)
    {
        // validation for constraint: float
        if (!is_null($distributionSupplierCalendarCheck) && !(is_float($distributionSupplierCalendarCheck) || is_numeric($distributionSupplierCalendarCheck))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($distributionSupplierCalendarCheck, true), gettype($distributionSupplierCalendarCheck)), __LINE__);
        }
        if (is_null($distributionSupplierCalendarCheck) || (is_array($distributionSupplierCalendarCheck) && empty($distributionSupplierCalendarCheck))) {
            unset($this->DistributionSupplierCalendarCheck);
        } else {
            $this->DistributionSupplierCalendarCheck = $distributionSupplierCalendarCheck;
        }
        return $this;
    }
    /**
     * Get ZeroMark value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getZeroMark()
    {
        return isset($this->ZeroMark) ? $this->ZeroMark : null;
    }
    /**
     * Set ZeroMark value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $zeroMark
     * @return \StructType\UpdItmWhsItem
     */
    public function setZeroMark($zeroMark = null)
    {
        // validation for constraint: float
        if (!is_null($zeroMark) && !(is_float($zeroMark) || is_numeric($zeroMark))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($zeroMark, true), gettype($zeroMark)), __LINE__);
        }
        if (is_null($zeroMark) || (is_array($zeroMark) && empty($zeroMark))) {
            unset($this->ZeroMark);
        } else {
            $this->ZeroMark = $zeroMark;
        }
        return $this;
    }
    /**
     * Get InspectionLocation value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getInspectionLocation()
    {
        return isset($this->InspectionLocation) ? $this->InspectionLocation : null;
    }
    /**
     * Set InspectionLocation value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $inspectionLocation
     * @return \StructType\UpdItmWhsItem
     */
    public function setInspectionLocation($inspectionLocation = null)
    {
        // validation for constraint: string
        if (!is_null($inspectionLocation) && !is_string($inspectionLocation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($inspectionLocation, true), gettype($inspectionLocation)), __LINE__);
        }
        // validation for constraint: maxLength(10)
        if (!is_null($inspectionLocation) && mb_strlen($inspectionLocation) > 10) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 10', mb_strlen($inspectionLocation)), __LINE__);
        }
        if (is_null($inspectionLocation) || (is_array($inspectionLocation) && empty($inspectionLocation))) {
            unset($this->InspectionLocation);
        } else {
            $this->InspectionLocation = $inspectionLocation;
        }
        return $this;
    }
    /**
     * Get NetChangeCalculationActive value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getNetChangeCalculationActive()
    {
        return isset($this->NetChangeCalculationActive) ? $this->NetChangeCalculationActive : null;
    }
    /**
     * Set NetChangeCalculationActive value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $netChangeCalculationActive
     * @return \StructType\UpdItmWhsItem
     */
    public function setNetChangeCalculationActive($netChangeCalculationActive = null)
    {
        // validation for constraint: float
        if (!is_null($netChangeCalculationActive) && !(is_float($netChangeCalculationActive) || is_numeric($netChangeCalculationActive))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($netChangeCalculationActive, true), gettype($netChangeCalculationActive)), __LINE__);
        }
        if (is_null($netChangeCalculationActive) || (is_array($netChangeCalculationActive) && empty($netChangeCalculationActive))) {
            unset($this->NetChangeCalculationActive);
        } else {
            $this->NetChangeCalculationActive = $netChangeCalculationActive;
        }
        return $this;
    }
    /**
     * Get Facility value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFacility()
    {
        return isset($this->Facility) ? $this->Facility : null;
    }
    /**
     * Set Facility value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $facility
     * @return \StructType\UpdItmWhsItem
     */
    public function setFacility($facility = null)
    {
        // validation for constraint: string
        if (!is_null($facility) && !is_string($facility)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($facility, true), gettype($facility)), __LINE__);
        }
        // validation for constraint: maxLength(3)
        if (!is_null($facility) && mb_strlen($facility) > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 3', mb_strlen($facility)), __LINE__);
        }
        if (is_null($facility) || (is_array($facility) && empty($facility))) {
            unset($this->Facility);
        } else {
            $this->Facility = $facility;
        }
        return $this;
    }
    /**
     * Get Division value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDivision()
    {
        return isset($this->Division) ? $this->Division : null;
    }
    /**
     * Set Division value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $division
     * @return \StructType\UpdItmWhsItem
     */
    public function setDivision($division = null)
    {
        // validation for constraint: string
        if (!is_null($division) && !is_string($division)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($division, true), gettype($division)), __LINE__);
        }
        // validation for constraint: maxLength(3)
        if (!is_null($division) && mb_strlen($division) > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 3', mb_strlen($division)), __LINE__);
        }
        if (is_null($division) || (is_array($division) && empty($division))) {
            unset($this->Division);
        } else {
            $this->Division = $division;
        }
        return $this;
    }
    /**
     * Get TimePhasedSafetyStockExists value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getTimePhasedSafetyStockExists()
    {
        return isset($this->TimePhasedSafetyStockExists) ? $this->TimePhasedSafetyStockExists : null;
    }
    /**
     * Set TimePhasedSafetyStockExists value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $timePhasedSafetyStockExists
     * @return \StructType\UpdItmWhsItem
     */
    public function setTimePhasedSafetyStockExists($timePhasedSafetyStockExists = null)
    {
        // validation for constraint: float
        if (!is_null($timePhasedSafetyStockExists) && !(is_float($timePhasedSafetyStockExists) || is_numeric($timePhasedSafetyStockExists))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($timePhasedSafetyStockExists, true), gettype($timePhasedSafetyStockExists)), __LINE__);
        }
        if (is_null($timePhasedSafetyStockExists) || (is_array($timePhasedSafetyStockExists) && empty($timePhasedSafetyStockExists))) {
            unset($this->TimePhasedSafetyStockExists);
        } else {
            $this->TimePhasedSafetyStockExists = $timePhasedSafetyStockExists;
        }
        return $this;
    }
    /**
     * Get HistoryStorageMethod value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getHistoryStorageMethod()
    {
        return isset($this->HistoryStorageMethod) ? $this->HistoryStorageMethod : null;
    }
    /**
     * Set HistoryStorageMethod value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $historyStorageMethod
     * @return \StructType\UpdItmWhsItem
     */
    public function setHistoryStorageMethod($historyStorageMethod = null)
    {
        // validation for constraint: float
        if (!is_null($historyStorageMethod) && !(is_float($historyStorageMethod) || is_numeric($historyStorageMethod))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($historyStorageMethod, true), gettype($historyStorageMethod)), __LINE__);
        }
        if (is_null($historyStorageMethod) || (is_array($historyStorageMethod) && empty($historyStorageMethod))) {
            unset($this->HistoryStorageMethod);
        } else {
            $this->HistoryStorageMethod = $historyStorageMethod;
        }
        return $this;
    }
    /**
     * Get PickingListInformationControl value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getPickingListInformationControl()
    {
        return isset($this->PickingListInformationControl) ? $this->PickingListInformationControl : null;
    }
    /**
     * Set PickingListInformationControl value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $pickingListInformationControl
     * @return \StructType\UpdItmWhsItem
     */
    public function setPickingListInformationControl($pickingListInformationControl = null)
    {
        // validation for constraint: float
        if (!is_null($pickingListInformationControl) && !(is_float($pickingListInformationControl) || is_numeric($pickingListInformationControl))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($pickingListInformationControl, true), gettype($pickingListInformationControl)), __LINE__);
        }
        if (is_null($pickingListInformationControl) || (is_array($pickingListInformationControl) && empty($pickingListInformationControl))) {
            unset($this->PickingListInformationControl);
        } else {
            $this->PickingListInformationControl = $pickingListInformationControl;
        }
        return $this;
    }
    /**
     * Get PendingPlanningMethodChange value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getPendingPlanningMethodChange()
    {
        return isset($this->PendingPlanningMethodChange) ? $this->PendingPlanningMethodChange : null;
    }
    /**
     * Set PendingPlanningMethodChange value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $pendingPlanningMethodChange
     * @return \StructType\UpdItmWhsItem
     */
    public function setPendingPlanningMethodChange($pendingPlanningMethodChange = null)
    {
        // validation for constraint: float
        if (!is_null($pendingPlanningMethodChange) && !(is_float($pendingPlanningMethodChange) || is_numeric($pendingPlanningMethodChange))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($pendingPlanningMethodChange, true), gettype($pendingPlanningMethodChange)), __LINE__);
        }
        if (is_null($pendingPlanningMethodChange) || (is_array($pendingPlanningMethodChange) && empty($pendingPlanningMethodChange))) {
            unset($this->PendingPlanningMethodChange);
        } else {
            $this->PendingPlanningMethodChange = $pendingPlanningMethodChange;
        }
        return $this;
    }
    /**
     * Get CalculationDateMaterialPlanning value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCalculationDateMaterialPlanning()
    {
        return isset($this->CalculationDateMaterialPlanning) ? $this->CalculationDateMaterialPlanning : null;
    }
    /**
     * Set CalculationDateMaterialPlanning value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $calculationDateMaterialPlanning
     * @return \StructType\UpdItmWhsItem
     */
    public function setCalculationDateMaterialPlanning($calculationDateMaterialPlanning = null)
    {
        // validation for constraint: string
        if (!is_null($calculationDateMaterialPlanning) && !is_string($calculationDateMaterialPlanning)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($calculationDateMaterialPlanning, true), gettype($calculationDateMaterialPlanning)), __LINE__);
        }
        if (is_null($calculationDateMaterialPlanning) || (is_array($calculationDateMaterialPlanning) && empty($calculationDateMaterialPlanning))) {
            unset($this->CalculationDateMaterialPlanning);
        } else {
            $this->CalculationDateMaterialPlanning = $calculationDateMaterialPlanning;
        }
        return $this;
    }
    /**
     * Get CalculationTimeMaterialPlanning value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getCalculationTimeMaterialPlanning()
    {
        return isset($this->CalculationTimeMaterialPlanning) ? $this->CalculationTimeMaterialPlanning : null;
    }
    /**
     * Set CalculationTimeMaterialPlanning value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $calculationTimeMaterialPlanning
     * @return \StructType\UpdItmWhsItem
     */
    public function setCalculationTimeMaterialPlanning($calculationTimeMaterialPlanning = null)
    {
        // validation for constraint: float
        if (!is_null($calculationTimeMaterialPlanning) && !(is_float($calculationTimeMaterialPlanning) || is_numeric($calculationTimeMaterialPlanning))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($calculationTimeMaterialPlanning, true), gettype($calculationTimeMaterialPlanning)), __LINE__);
        }
        if (is_null($calculationTimeMaterialPlanning) || (is_array($calculationTimeMaterialPlanning) && empty($calculationTimeMaterialPlanning))) {
            unset($this->CalculationTimeMaterialPlanning);
        } else {
            $this->CalculationTimeMaterialPlanning = $calculationTimeMaterialPlanning;
        }
        return $this;
    }
    /**
     * Get TimePhasedSafetyStock value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getTimePhasedSafetyStock()
    {
        return isset($this->TimePhasedSafetyStock) ? $this->TimePhasedSafetyStock : null;
    }
    /**
     * Set TimePhasedSafetyStock value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $timePhasedSafetyStock
     * @return \StructType\UpdItmWhsItem
     */
    public function setTimePhasedSafetyStock($timePhasedSafetyStock = null)
    {
        // validation for constraint: float
        if (!is_null($timePhasedSafetyStock) && !(is_float($timePhasedSafetyStock) || is_numeric($timePhasedSafetyStock))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($timePhasedSafetyStock, true), gettype($timePhasedSafetyStock)), __LINE__);
        }
        if (is_null($timePhasedSafetyStock) || (is_array($timePhasedSafetyStock) && empty($timePhasedSafetyStock))) {
            unset($this->TimePhasedSafetyStock);
        } else {
            $this->TimePhasedSafetyStock = $timePhasedSafetyStock;
        }
        return $this;
    }
    /**
     * Get ResponsiblePOProposal value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getResponsiblePOProposal()
    {
        return isset($this->ResponsiblePOProposal) ? $this->ResponsiblePOProposal : null;
    }
    /**
     * Set ResponsiblePOProposal value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $responsiblePOProposal
     * @return \StructType\UpdItmWhsItem
     */
    public function setResponsiblePOProposal($responsiblePOProposal = null)
    {
        // validation for constraint: float
        if (!is_null($responsiblePOProposal) && !(is_float($responsiblePOProposal) || is_numeric($responsiblePOProposal))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($responsiblePOProposal, true), gettype($responsiblePOProposal)), __LINE__);
        }
        if (is_null($responsiblePOProposal) || (is_array($responsiblePOProposal) && empty($responsiblePOProposal))) {
            unset($this->ResponsiblePOProposal);
        } else {
            $this->ResponsiblePOProposal = $responsiblePOProposal;
        }
        return $this;
    }
    /**
     * Get StandardCostWarehouse value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getStandardCostWarehouse()
    {
        return isset($this->StandardCostWarehouse) ? $this->StandardCostWarehouse : null;
    }
    /**
     * Set StandardCostWarehouse value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $standardCostWarehouse
     * @return \StructType\UpdItmWhsItem
     */
    public function setStandardCostWarehouse($standardCostWarehouse = null)
    {
        // validation for constraint: float
        if (!is_null($standardCostWarehouse) && !(is_float($standardCostWarehouse) || is_numeric($standardCostWarehouse))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($standardCostWarehouse, true), gettype($standardCostWarehouse)), __LINE__);
        }
        if (is_null($standardCostWarehouse) || (is_array($standardCostWarehouse) && empty($standardCostWarehouse))) {
            unset($this->StandardCostWarehouse);
        } else {
            $this->StandardCostWarehouse = $standardCostWarehouse;
        }
        return $this;
    }
    /**
     * Get TextIdentity value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getTextIdentity()
    {
        return isset($this->TextIdentity) ? $this->TextIdentity : null;
    }
    /**
     * Set TextIdentity value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $textIdentity
     * @return \StructType\UpdItmWhsItem
     */
    public function setTextIdentity($textIdentity = null)
    {
        // validation for constraint: float
        if (!is_null($textIdentity) && !(is_float($textIdentity) || is_numeric($textIdentity))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($textIdentity, true), gettype($textIdentity)), __LINE__);
        }
        if (is_null($textIdentity) || (is_array($textIdentity) && empty($textIdentity))) {
            unset($this->TextIdentity);
        } else {
            $this->TextIdentity = $textIdentity;
        }
        return $this;
    }
    /**
     * Get DataIdentity value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getDataIdentity()
    {
        return isset($this->DataIdentity) ? $this->DataIdentity : null;
    }
    /**
     * Set DataIdentity value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $dataIdentity
     * @return \StructType\UpdItmWhsItem
     */
    public function setDataIdentity($dataIdentity = null)
    {
        // validation for constraint: float
        if (!is_null($dataIdentity) && !(is_float($dataIdentity) || is_numeric($dataIdentity))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($dataIdentity, true), gettype($dataIdentity)), __LINE__);
        }
        if (is_null($dataIdentity) || (is_array($dataIdentity) && empty($dataIdentity))) {
            unset($this->DataIdentity);
        } else {
            $this->DataIdentity = $dataIdentity;
        }
        return $this;
    }
    /**
     * Get DefaultPackingLocation value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDefaultPackingLocation()
    {
        return isset($this->DefaultPackingLocation) ? $this->DefaultPackingLocation : null;
    }
    /**
     * Set DefaultPackingLocation value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $defaultPackingLocation
     * @return \StructType\UpdItmWhsItem
     */
    public function setDefaultPackingLocation($defaultPackingLocation = null)
    {
        // validation for constraint: string
        if (!is_null($defaultPackingLocation) && !is_string($defaultPackingLocation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($defaultPackingLocation, true), gettype($defaultPackingLocation)), __LINE__);
        }
        // validation for constraint: maxLength(10)
        if (!is_null($defaultPackingLocation) && mb_strlen($defaultPackingLocation) > 10) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 10', mb_strlen($defaultPackingLocation)), __LINE__);
        }
        if (is_null($defaultPackingLocation) || (is_array($defaultPackingLocation) && empty($defaultPackingLocation))) {
            unset($this->DefaultPackingLocation);
        } else {
            $this->DefaultPackingLocation = $defaultPackingLocation;
        }
        return $this;
    }
    /**
     * Get DefaultDockingLocation value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDefaultDockingLocation()
    {
        return isset($this->DefaultDockingLocation) ? $this->DefaultDockingLocation : null;
    }
    /**
     * Set DefaultDockingLocation value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $defaultDockingLocation
     * @return \StructType\UpdItmWhsItem
     */
    public function setDefaultDockingLocation($defaultDockingLocation = null)
    {
        // validation for constraint: string
        if (!is_null($defaultDockingLocation) && !is_string($defaultDockingLocation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($defaultDockingLocation, true), gettype($defaultDockingLocation)), __LINE__);
        }
        // validation for constraint: maxLength(10)
        if (!is_null($defaultDockingLocation) && mb_strlen($defaultDockingLocation) > 10) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 10', mb_strlen($defaultDockingLocation)), __LINE__);
        }
        if (is_null($defaultDockingLocation) || (is_array($defaultDockingLocation) && empty($defaultDockingLocation))) {
            unset($this->DefaultDockingLocation);
        } else {
            $this->DefaultDockingLocation = $defaultDockingLocation;
        }
        return $this;
    }
    /**
     * Get DeliverySplitRule value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDeliverySplitRule()
    {
        return isset($this->DeliverySplitRule) ? $this->DeliverySplitRule : null;
    }
    /**
     * Set DeliverySplitRule value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $deliverySplitRule
     * @return \StructType\UpdItmWhsItem
     */
    public function setDeliverySplitRule($deliverySplitRule = null)
    {
        // validation for constraint: string
        if (!is_null($deliverySplitRule) && !is_string($deliverySplitRule)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($deliverySplitRule, true), gettype($deliverySplitRule)), __LINE__);
        }
        // validation for constraint: maxLength(2)
        if (!is_null($deliverySplitRule) && mb_strlen($deliverySplitRule) > 2) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 2', mb_strlen($deliverySplitRule)), __LINE__);
        }
        if (is_null($deliverySplitRule) || (is_array($deliverySplitRule) && empty($deliverySplitRule))) {
            unset($this->DeliverySplitRule);
        } else {
            $this->DeliverySplitRule = $deliverySplitRule;
        }
        return $this;
    }
    /**
     * Get AllocateNonapprovedBalanceID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getAllocateNonapprovedBalanceID()
    {
        return isset($this->AllocateNonapprovedBalanceID) ? $this->AllocateNonapprovedBalanceID : null;
    }
    /**
     * Set AllocateNonapprovedBalanceID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $allocateNonapprovedBalanceID
     * @return \StructType\UpdItmWhsItem
     */
    public function setAllocateNonapprovedBalanceID($allocateNonapprovedBalanceID = null)
    {
        // validation for constraint: float
        if (!is_null($allocateNonapprovedBalanceID) && !(is_float($allocateNonapprovedBalanceID) || is_numeric($allocateNonapprovedBalanceID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($allocateNonapprovedBalanceID, true), gettype($allocateNonapprovedBalanceID)), __LINE__);
        }
        if (is_null($allocateNonapprovedBalanceID) || (is_array($allocateNonapprovedBalanceID) && empty($allocateNonapprovedBalanceID))) {
            unset($this->AllocateNonapprovedBalanceID);
        } else {
            $this->AllocateNonapprovedBalanceID = $allocateNonapprovedBalanceID;
        }
        return $this;
    }
    /**
     * Get PointOfTimeTable value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPointOfTimeTable()
    {
        return isset($this->PointOfTimeTable) ? $this->PointOfTimeTable : null;
    }
    /**
     * Set PointOfTimeTable value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $pointOfTimeTable
     * @return \StructType\UpdItmWhsItem
     */
    public function setPointOfTimeTable($pointOfTimeTable = null)
    {
        // validation for constraint: string
        if (!is_null($pointOfTimeTable) && !is_string($pointOfTimeTable)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pointOfTimeTable, true), gettype($pointOfTimeTable)), __LINE__);
        }
        // validation for constraint: maxLength(3)
        if (!is_null($pointOfTimeTable) && mb_strlen($pointOfTimeTable) > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 3', mb_strlen($pointOfTimeTable)), __LINE__);
        }
        if (is_null($pointOfTimeTable) || (is_array($pointOfTimeTable) && empty($pointOfTimeTable))) {
            unset($this->PointOfTimeTable);
        } else {
            $this->PointOfTimeTable = $pointOfTimeTable;
        }
        return $this;
    }
    /**
     * Get Status value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getStatus()
    {
        return isset($this->Status) ? $this->Status : null;
    }
    /**
     * Set Status value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $status
     * @return \StructType\UpdItmWhsItem
     */
    public function setStatus($status = null)
    {
        // validation for constraint: string
        if (!is_null($status) && !is_string($status)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($status, true), gettype($status)), __LINE__);
        }
        // validation for constraint: maxLength(2)
        if (!is_null($status) && mb_strlen($status) > 2) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 2', mb_strlen($status)), __LINE__);
        }
        if (is_null($status) || (is_array($status) && empty($status))) {
            unset($this->Status);
        } else {
            $this->Status = $status;
        }
        return $this;
    }
    /**
     * Get VATCodePurchase value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getVATCodePurchase()
    {
        return isset($this->VATCodePurchase) ? $this->VATCodePurchase : null;
    }
    /**
     * Set VATCodePurchase value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $vATCodePurchase
     * @return \StructType\UpdItmWhsItem
     */
    public function setVATCodePurchase($vATCodePurchase = null)
    {
        // validation for constraint: float
        if (!is_null($vATCodePurchase) && !(is_float($vATCodePurchase) || is_numeric($vATCodePurchase))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($vATCodePurchase, true), gettype($vATCodePurchase)), __LINE__);
        }
        if (is_null($vATCodePurchase) || (is_array($vATCodePurchase) && empty($vATCodePurchase))) {
            unset($this->VATCodePurchase);
        } else {
            $this->VATCodePurchase = $vATCodePurchase;
        }
        return $this;
    }
    /**
     * Get VATCodeSales value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getVATCodeSales()
    {
        return isset($this->VATCodeSales) ? $this->VATCodeSales : null;
    }
    /**
     * Set VATCodeSales value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $vATCodeSales
     * @return \StructType\UpdItmWhsItem
     */
    public function setVATCodeSales($vATCodeSales = null)
    {
        // validation for constraint: float
        if (!is_null($vATCodeSales) && !(is_float($vATCodeSales) || is_numeric($vATCodeSales))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($vATCodeSales, true), gettype($vATCodeSales)), __LINE__);
        }
        if (is_null($vATCodeSales) || (is_array($vATCodeSales) && empty($vATCodeSales))) {
            unset($this->VATCodeSales);
        } else {
            $this->VATCodeSales = $vATCodeSales;
        }
        return $this;
    }
    /**
     * Get MainUnitOfCalculation value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMainUnitOfCalculation()
    {
        return isset($this->MainUnitOfCalculation) ? $this->MainUnitOfCalculation : null;
    }
    /**
     * Set MainUnitOfCalculation value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $mainUnitOfCalculation
     * @return \StructType\UpdItmWhsItem
     */
    public function setMainUnitOfCalculation($mainUnitOfCalculation = null)
    {
        // validation for constraint: string
        if (!is_null($mainUnitOfCalculation) && !is_string($mainUnitOfCalculation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mainUnitOfCalculation, true), gettype($mainUnitOfCalculation)), __LINE__);
        }
        // validation for constraint: maxLength(3)
        if (!is_null($mainUnitOfCalculation) && mb_strlen($mainUnitOfCalculation) > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 3', mb_strlen($mainUnitOfCalculation)), __LINE__);
        }
        if (is_null($mainUnitOfCalculation) || (is_array($mainUnitOfCalculation) && empty($mainUnitOfCalculation))) {
            unset($this->MainUnitOfCalculation);
        } else {
            $this->MainUnitOfCalculation = $mainUnitOfCalculation;
        }
        return $this;
    }
    /**
     * Get DistributionGroupTechnology value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDistributionGroupTechnology()
    {
        return isset($this->DistributionGroupTechnology) ? $this->DistributionGroupTechnology : null;
    }
    /**
     * Set DistributionGroupTechnology value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $distributionGroupTechnology
     * @return \StructType\UpdItmWhsItem
     */
    public function setDistributionGroupTechnology($distributionGroupTechnology = null)
    {
        // validation for constraint: string
        if (!is_null($distributionGroupTechnology) && !is_string($distributionGroupTechnology)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($distributionGroupTechnology, true), gettype($distributionGroupTechnology)), __LINE__);
        }
        // validation for constraint: maxLength(5)
        if (!is_null($distributionGroupTechnology) && mb_strlen($distributionGroupTechnology) > 5) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 5', mb_strlen($distributionGroupTechnology)), __LINE__);
        }
        if (is_null($distributionGroupTechnology) || (is_array($distributionGroupTechnology) && empty($distributionGroupTechnology))) {
            unset($this->DistributionGroupTechnology);
        } else {
            $this->DistributionGroupTechnology = $distributionGroupTechnology;
        }
        return $this;
    }
    /**
     * Get ShelfLife value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getShelfLife()
    {
        return isset($this->ShelfLife) ? $this->ShelfLife : null;
    }
    /**
     * Set ShelfLife value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $shelfLife
     * @return \StructType\UpdItmWhsItem
     */
    public function setShelfLife($shelfLife = null)
    {
        // validation for constraint: float
        if (!is_null($shelfLife) && !(is_float($shelfLife) || is_numeric($shelfLife))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($shelfLife, true), gettype($shelfLife)), __LINE__);
        }
        if (is_null($shelfLife) || (is_array($shelfLife) && empty($shelfLife))) {
            unset($this->ShelfLife);
        } else {
            $this->ShelfLife = $shelfLife;
        }
        return $this;
    }
    /**
     * Get ReinspectionTime value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getReinspectionTime()
    {
        return isset($this->ReinspectionTime) ? $this->ReinspectionTime : null;
    }
    /**
     * Set ReinspectionTime value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $reinspectionTime
     * @return \StructType\UpdItmWhsItem
     */
    public function setReinspectionTime($reinspectionTime = null)
    {
        // validation for constraint: float
        if (!is_null($reinspectionTime) && !(is_float($reinspectionTime) || is_numeric($reinspectionTime))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($reinspectionTime, true), gettype($reinspectionTime)), __LINE__);
        }
        if (is_null($reinspectionTime) || (is_array($reinspectionTime) && empty($reinspectionTime))) {
            unset($this->ReinspectionTime);
        } else {
            $this->ReinspectionTime = $reinspectionTime;
        }
        return $this;
    }
    /**
     * Get SalesTime value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getSalesTime()
    {
        return isset($this->SalesTime) ? $this->SalesTime : null;
    }
    /**
     * Set SalesTime value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $salesTime
     * @return \StructType\UpdItmWhsItem
     */
    public function setSalesTime($salesTime = null)
    {
        // validation for constraint: float
        if (!is_null($salesTime) && !(is_float($salesTime) || is_numeric($salesTime))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($salesTime, true), gettype($salesTime)), __LINE__);
        }
        if (is_null($salesTime) || (is_array($salesTime) && empty($salesTime))) {
            unset($this->SalesTime);
        } else {
            $this->SalesTime = $salesTime;
        }
        return $this;
    }
    /**
     * Get CTPPolicy value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCTPPolicy()
    {
        return isset($this->CTPPolicy) ? $this->CTPPolicy : null;
    }
    /**
     * Set CTPPolicy value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cTPPolicy
     * @return \StructType\UpdItmWhsItem
     */
    public function setCTPPolicy($cTPPolicy = null)
    {
        // validation for constraint: string
        if (!is_null($cTPPolicy) && !is_string($cTPPolicy)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cTPPolicy, true), gettype($cTPPolicy)), __LINE__);
        }
        // validation for constraint: maxLength(3)
        if (!is_null($cTPPolicy) && mb_strlen($cTPPolicy) > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 3', mb_strlen($cTPPolicy)), __LINE__);
        }
        if (is_null($cTPPolicy) || (is_array($cTPPolicy) && empty($cTPPolicy))) {
            unset($this->CTPPolicy);
        } else {
            $this->CTPPolicy = $cTPPolicy;
        }
        return $this;
    }
    /**
     * Get QuarantineLeadtime value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getQuarantineLeadtime()
    {
        return isset($this->QuarantineLeadtime) ? $this->QuarantineLeadtime : null;
    }
    /**
     * Set QuarantineLeadtime value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $quarantineLeadtime
     * @return \StructType\UpdItmWhsItem
     */
    public function setQuarantineLeadtime($quarantineLeadtime = null)
    {
        // validation for constraint: float
        if (!is_null($quarantineLeadtime) && !(is_float($quarantineLeadtime) || is_numeric($quarantineLeadtime))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($quarantineLeadtime, true), gettype($quarantineLeadtime)), __LINE__);
        }
        if (is_null($quarantineLeadtime) || (is_array($quarantineLeadtime) && empty($quarantineLeadtime))) {
            unset($this->QuarantineLeadtime);
        } else {
            $this->QuarantineLeadtime = $quarantineLeadtime;
        }
        return $this;
    }
    /**
     * Get ScheduledReclassificationAllowed value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getScheduledReclassificationAllowed()
    {
        return isset($this->ScheduledReclassificationAllowed) ? $this->ScheduledReclassificationAllowed : null;
    }
    /**
     * Set ScheduledReclassificationAllowed value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $scheduledReclassificationAllowed
     * @return \StructType\UpdItmWhsItem
     */
    public function setScheduledReclassificationAllowed($scheduledReclassificationAllowed = null)
    {
        // validation for constraint: float
        if (!is_null($scheduledReclassificationAllowed) && !(is_float($scheduledReclassificationAllowed) || is_numeric($scheduledReclassificationAllowed))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($scheduledReclassificationAllowed, true), gettype($scheduledReclassificationAllowed)), __LINE__);
        }
        if (is_null($scheduledReclassificationAllowed) || (is_array($scheduledReclassificationAllowed) && empty($scheduledReclassificationAllowed))) {
            unset($this->ScheduledReclassificationAllowed);
        } else {
            $this->ScheduledReclassificationAllowed = $scheduledReclassificationAllowed;
        }
        return $this;
    }
    /**
     * Get CatchWeightApprovedOnHandBalance value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getCatchWeightApprovedOnHandBalance()
    {
        return isset($this->CatchWeightApprovedOnHandBalance) ? $this->CatchWeightApprovedOnHandBalance : null;
    }
    /**
     * Set CatchWeightApprovedOnHandBalance value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $catchWeightApprovedOnHandBalance
     * @return \StructType\UpdItmWhsItem
     */
    public function setCatchWeightApprovedOnHandBalance($catchWeightApprovedOnHandBalance = null)
    {
        // validation for constraint: float
        if (!is_null($catchWeightApprovedOnHandBalance) && !(is_float($catchWeightApprovedOnHandBalance) || is_numeric($catchWeightApprovedOnHandBalance))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($catchWeightApprovedOnHandBalance, true), gettype($catchWeightApprovedOnHandBalance)), __LINE__);
        }
        if (is_null($catchWeightApprovedOnHandBalance) || (is_array($catchWeightApprovedOnHandBalance) && empty($catchWeightApprovedOnHandBalance))) {
            unset($this->CatchWeightApprovedOnHandBalance);
        } else {
            $this->CatchWeightApprovedOnHandBalance = $catchWeightApprovedOnHandBalance;
        }
        return $this;
    }
    /**
     * Get CatchWeightRejectedOnHandBalance value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getCatchWeightRejectedOnHandBalance()
    {
        return isset($this->CatchWeightRejectedOnHandBalance) ? $this->CatchWeightRejectedOnHandBalance : null;
    }
    /**
     * Set CatchWeightRejectedOnHandBalance value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $catchWeightRejectedOnHandBalance
     * @return \StructType\UpdItmWhsItem
     */
    public function setCatchWeightRejectedOnHandBalance($catchWeightRejectedOnHandBalance = null)
    {
        // validation for constraint: float
        if (!is_null($catchWeightRejectedOnHandBalance) && !(is_float($catchWeightRejectedOnHandBalance) || is_numeric($catchWeightRejectedOnHandBalance))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($catchWeightRejectedOnHandBalance, true), gettype($catchWeightRejectedOnHandBalance)), __LINE__);
        }
        if (is_null($catchWeightRejectedOnHandBalance) || (is_array($catchWeightRejectedOnHandBalance) && empty($catchWeightRejectedOnHandBalance))) {
            unset($this->CatchWeightRejectedOnHandBalance);
        } else {
            $this->CatchWeightRejectedOnHandBalance = $catchWeightRejectedOnHandBalance;
        }
        return $this;
    }
    /**
     * Get CatchWeightForInspectionOnHandBal value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getCatchWeightForInspectionOnHandBal()
    {
        return isset($this->CatchWeightForInspectionOnHandBal) ? $this->CatchWeightForInspectionOnHandBal : null;
    }
    /**
     * Set CatchWeightForInspectionOnHandBal value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $catchWeightForInspectionOnHandBal
     * @return \StructType\UpdItmWhsItem
     */
    public function setCatchWeightForInspectionOnHandBal($catchWeightForInspectionOnHandBal = null)
    {
        // validation for constraint: float
        if (!is_null($catchWeightForInspectionOnHandBal) && !(is_float($catchWeightForInspectionOnHandBal) || is_numeric($catchWeightForInspectionOnHandBal))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($catchWeightForInspectionOnHandBal, true), gettype($catchWeightForInspectionOnHandBal)), __LINE__);
        }
        if (is_null($catchWeightForInspectionOnHandBal) || (is_array($catchWeightForInspectionOnHandBal) && empty($catchWeightForInspectionOnHandBal))) {
            unset($this->CatchWeightForInspectionOnHandBal);
        } else {
            $this->CatchWeightForInspectionOnHandBal = $catchWeightForInspectionOnHandBal;
        }
        return $this;
    }
    /**
     * Get AlternateUM value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAlternateUM()
    {
        return isset($this->AlternateUM) ? $this->AlternateUM : null;
    }
    /**
     * Set AlternateUM value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $alternateUM
     * @return \StructType\UpdItmWhsItem
     */
    public function setAlternateUM($alternateUM = null)
    {
        // validation for constraint: string
        if (!is_null($alternateUM) && !is_string($alternateUM)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($alternateUM, true), gettype($alternateUM)), __LINE__);
        }
        // validation for constraint: maxLength(3)
        if (!is_null($alternateUM) && mb_strlen($alternateUM) > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 3', mb_strlen($alternateUM)), __LINE__);
        }
        if (is_null($alternateUM) || (is_array($alternateUM) && empty($alternateUM))) {
            unset($this->AlternateUM);
        } else {
            $this->AlternateUM = $alternateUM;
        }
        return $this;
    }
    /**
     * Get StandardCostPriceUnitOfMeasure value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getStandardCostPriceUnitOfMeasure()
    {
        return isset($this->StandardCostPriceUnitOfMeasure) ? $this->StandardCostPriceUnitOfMeasure : null;
    }
    /**
     * Set StandardCostPriceUnitOfMeasure value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $standardCostPriceUnitOfMeasure
     * @return \StructType\UpdItmWhsItem
     */
    public function setStandardCostPriceUnitOfMeasure($standardCostPriceUnitOfMeasure = null)
    {
        // validation for constraint: string
        if (!is_null($standardCostPriceUnitOfMeasure) && !is_string($standardCostPriceUnitOfMeasure)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($standardCostPriceUnitOfMeasure, true), gettype($standardCostPriceUnitOfMeasure)), __LINE__);
        }
        // validation for constraint: maxLength(3)
        if (!is_null($standardCostPriceUnitOfMeasure) && mb_strlen($standardCostPriceUnitOfMeasure) > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 3', mb_strlen($standardCostPriceUnitOfMeasure)), __LINE__);
        }
        if (is_null($standardCostPriceUnitOfMeasure) || (is_array($standardCostPriceUnitOfMeasure) && empty($standardCostPriceUnitOfMeasure))) {
            unset($this->StandardCostPriceUnitOfMeasure);
        } else {
            $this->StandardCostPriceUnitOfMeasure = $standardCostPriceUnitOfMeasure;
        }
        return $this;
    }
    /**
     * Get InventoryPlanned value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getInventoryPlanned()
    {
        return isset($this->InventoryPlanned) ? $this->InventoryPlanned : null;
    }
    /**
     * Set InventoryPlanned value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $inventoryPlanned
     * @return \StructType\UpdItmWhsItem
     */
    public function setInventoryPlanned($inventoryPlanned = null)
    {
        // validation for constraint: string
        if (!is_null($inventoryPlanned) && !is_string($inventoryPlanned)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($inventoryPlanned, true), gettype($inventoryPlanned)), __LINE__);
        }
        // validation for constraint: maxLength(2)
        if (!is_null($inventoryPlanned) && mb_strlen($inventoryPlanned) > 2) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 2', mb_strlen($inventoryPlanned)), __LINE__);
        }
        if (is_null($inventoryPlanned) || (is_array($inventoryPlanned) && empty($inventoryPlanned))) {
            unset($this->InventoryPlanned);
        } else {
            $this->InventoryPlanned = $inventoryPlanned;
        }
        return $this;
    }
    /**
     * Get BestBeforeTime value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getBestBeforeTime()
    {
        return isset($this->BestBeforeTime) ? $this->BestBeforeTime : null;
    }
    /**
     * Set BestBeforeTime value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $bestBeforeTime
     * @return \StructType\UpdItmWhsItem
     */
    public function setBestBeforeTime($bestBeforeTime = null)
    {
        // validation for constraint: float
        if (!is_null($bestBeforeTime) && !(is_float($bestBeforeTime) || is_numeric($bestBeforeTime))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($bestBeforeTime, true), gettype($bestBeforeTime)), __LINE__);
        }
        if (is_null($bestBeforeTime) || (is_array($bestBeforeTime) && empty($bestBeforeTime))) {
            unset($this->BestBeforeTime);
        } else {
            $this->BestBeforeTime = $bestBeforeTime;
        }
        return $this;
    }
    /**
     * Get FrozenSafetyStock value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getFrozenSafetyStock()
    {
        return isset($this->FrozenSafetyStock) ? $this->FrozenSafetyStock : null;
    }
    /**
     * Set FrozenSafetyStock value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $frozenSafetyStock
     * @return \StructType\UpdItmWhsItem
     */
    public function setFrozenSafetyStock($frozenSafetyStock = null)
    {
        // validation for constraint: float
        if (!is_null($frozenSafetyStock) && !(is_float($frozenSafetyStock) || is_numeric($frozenSafetyStock))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($frozenSafetyStock, true), gettype($frozenSafetyStock)), __LINE__);
        }
        if (is_null($frozenSafetyStock) || (is_array($frozenSafetyStock) && empty($frozenSafetyStock))) {
            unset($this->FrozenSafetyStock);
        } else {
            $this->FrozenSafetyStock = $frozenSafetyStock;
        }
        return $this;
    }
    /**
     * Get ReturnableNonReturnableIndicator value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getReturnableNonReturnableIndicator()
    {
        return isset($this->ReturnableNonReturnableIndicator) ? $this->ReturnableNonReturnableIndicator : null;
    }
    /**
     * Set ReturnableNonReturnableIndicator value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $returnableNonReturnableIndicator
     * @return \StructType\UpdItmWhsItem
     */
    public function setReturnableNonReturnableIndicator($returnableNonReturnableIndicator = null)
    {
        // validation for constraint: float
        if (!is_null($returnableNonReturnableIndicator) && !(is_float($returnableNonReturnableIndicator) || is_numeric($returnableNonReturnableIndicator))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($returnableNonReturnableIndicator, true), gettype($returnableNonReturnableIndicator)), __LINE__);
        }
        if (is_null($returnableNonReturnableIndicator) || (is_array($returnableNonReturnableIndicator) && empty($returnableNonReturnableIndicator))) {
            unset($this->ReturnableNonReturnableIndicator);
        } else {
            $this->ReturnableNonReturnableIndicator = $returnableNonReturnableIndicator;
        }
        return $this;
    }
    /**
     * Get ReturnableMessage value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getReturnableMessage()
    {
        return isset($this->ReturnableMessage) ? $this->ReturnableMessage : null;
    }
    /**
     * Set ReturnableMessage value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $returnableMessage
     * @return \StructType\UpdItmWhsItem
     */
    public function setReturnableMessage($returnableMessage = null)
    {
        // validation for constraint: float
        if (!is_null($returnableMessage) && !(is_float($returnableMessage) || is_numeric($returnableMessage))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($returnableMessage, true), gettype($returnableMessage)), __LINE__);
        }
        if (is_null($returnableMessage) || (is_array($returnableMessage) && empty($returnableMessage))) {
            unset($this->ReturnableMessage);
        } else {
            $this->ReturnableMessage = $returnableMessage;
        }
        return $this;
    }
    /**
     * Get SSReasonCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSSReasonCode()
    {
        return isset($this->SSReasonCode) ? $this->SSReasonCode : null;
    }
    /**
     * Set SSReasonCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $sSReasonCode
     * @return \StructType\UpdItmWhsItem
     */
    public function setSSReasonCode($sSReasonCode = null)
    {
        // validation for constraint: string
        if (!is_null($sSReasonCode) && !is_string($sSReasonCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sSReasonCode, true), gettype($sSReasonCode)), __LINE__);
        }
        // validation for constraint: maxLength(5)
        if (!is_null($sSReasonCode) && mb_strlen($sSReasonCode) > 5) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 5', mb_strlen($sSReasonCode)), __LINE__);
        }
        if (is_null($sSReasonCode) || (is_array($sSReasonCode) && empty($sSReasonCode))) {
            unset($this->SSReasonCode);
        } else {
            $this->SSReasonCode = $sSReasonCode;
        }
        return $this;
    }
    /**
     * Get SecondaryAllocationMethod value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getSecondaryAllocationMethod()
    {
        return isset($this->SecondaryAllocationMethod) ? $this->SecondaryAllocationMethod : null;
    }
    /**
     * Set SecondaryAllocationMethod value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $secondaryAllocationMethod
     * @return \StructType\UpdItmWhsItem
     */
    public function setSecondaryAllocationMethod($secondaryAllocationMethod = null)
    {
        // validation for constraint: float
        if (!is_null($secondaryAllocationMethod) && !(is_float($secondaryAllocationMethod) || is_numeric($secondaryAllocationMethod))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($secondaryAllocationMethod, true), gettype($secondaryAllocationMethod)), __LINE__);
        }
        if (is_null($secondaryAllocationMethod) || (is_array($secondaryAllocationMethod) && empty($secondaryAllocationMethod))) {
            unset($this->SecondaryAllocationMethod);
        } else {
            $this->SecondaryAllocationMethod = $secondaryAllocationMethod;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\UpdItmWhsItem
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
